/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.client.internal.namespace.IConfigurationWrapper;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.internal.filesystem.ui.util.ItemPermissionUtil;
import com.ibm.team.process.client.IAccessGroupClientService;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IAccessGroupHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.Messages;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import com.ibm.team.scm.common.dto.IVersionablePermissionsReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class AbstractFilesystemQuery
extends RepositoryQuery {
    private final ItemNamespace workspace;
    private IItemContext context;
    private boolean allocated = false;
    private boolean permissionScope;
    private final VersionDisplayMode versionDisplayMode;
    private IChangeListener listener = new IChangeListener(){

        public void changed(Object source, Object property) {
            if (property == IItemContext.PROP_HISTORY) {
                AbstractFilesystemQuery.this.update();
            }
        }
    };
    private boolean foldersOnly;

    protected AbstractFilesystemQuery(Realm theDisplay, ItemNamespace workspace, VersionDisplayMode versionDisplayMode, IOperationRunner runner) {
        super(theDisplay, workspace.getRepository(), runner);
        this.versionDisplayMode = versionDisplayMode == null ? new VersionDisplayMode() : versionDisplayMode;
        this.workspace = workspace;
        this.permissionScope = false;
    }

    public AbstractFilesystemQuery(Realm theDisplay, ItemNamespace workspace, IOperationRunner runner) {
        this(theDisplay, workspace, null, runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attachListeners() {
        AbstractFilesystemQuery abstractFilesystemQuery = this;
        synchronized (abstractFilesystemQuery) {
            if (this.context != null) {
                this.context.addHistoryListener(this.listener);
            }
            this.allocated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detachListeners() {
        AbstractFilesystemQuery abstractFilesystemQuery = this;
        synchronized (abstractFilesystemQuery) {
            if (this.context != null) {
                this.context.removeHistoryListener(this.listener);
            }
            this.allocated = false;
        }
    }

    protected final IConfigurationWrapper getSnapshotProvider(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getContext(monitor).getVersionableTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IItemContext getContext(IProgressMonitor monitor) throws TeamRepositoryException {
        AbstractFilesystemQuery abstractFilesystemQuery = this;
        synchronized (abstractFilesystemQuery) {
            if (this.context != null) {
                return this.context;
            }
        }
        IItemContext c = this.workspace.getContext(monitor);
        AbstractFilesystemQuery abstractFilesystemQuery2 = this;
        synchronized (abstractFilesystemQuery2) {
            this.context = c;
            if (this.allocated) {
                c.addHistoryListener(this.listener);
            }
            return c;
        }
    }

    protected abstract Map<String, ItemId<IVersionable>> fetchChildren(IProgressMonitor var1) throws TeamRepositoryException;

    protected final Map<String, ItemId<IVersionable>> computeChildren(IConfigurationWrapper configuration, boolean shouldRefresh, IProgressMonitor mon) throws TeamRepositoryException {
        try {
            return this.fetchChildren(mon);
        }
        catch (ItemNotFoundException e) {
            return NewCollection.hashMap();
        }
    }

    public final List fetchResult(boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository login = this.getRepository();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)110);
        if (login == null || !login.loggedIn()) {
            return Collections.EMPTY_LIST;
        }
        IConfigurationWrapper configuration = this.getSnapshotProvider((IProgressMonitor)progress.newChild(10));
        String parentPath = this.getParentName();
        Map<String, ItemId<IVersionable>> mapNamesToItemIds = this.computeChildren(configuration, shouldRefresh, (IProgressMonitor)progress.newChild(30));
        ArrayList<ItemId<IVersionable>> handles = new ArrayList<ItemId<IVersionable>>();
        handles.addAll(mapNamesToItemIds.values());
        Map mapItemIdsToStates = configuration.getContext().getStates(handles, shouldRefresh, (IProgressMonitor)progress.newChild(30));
        HashMap<UUID, Object> mapItemToPermission = null;
        HashMap<UUID, Object> mapToFetchedAuditables = null;
        if (this.permissionScope) {
            IVersionableHandle[] versionables = new IVersionableHandle[handles.size()];
            mapItemToPermission = new HashMap<UUID, Object>();
            int i = 0;
            while (i < handles.size()) {
                ItemId itemId = (ItemId)handles.get(i);
                versionables[i] = (IVersionableHandle)itemId.toHandle();
                ++i;
            }
            IConfiguration snapshotConfiguration = configuration.getConfiguration();
            if (versionables.length > 0 && snapshotConfiguration != null) {
                List fetchedAuditables;
                IVersionablePermissionsReport[] permissions = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).getPermissions(versionables, snapshotConfiguration.component(), (IProgressMonitor)progress.newChild(10));
                ArrayList<IAuditableHandle> auditableHandles = permissions.length == 0 ? null : new ArrayList<IAuditableHandle>();
                ArrayList<IAccessGroupHandle> accessGroupHandles = permissions.length == 0 ? null : new ArrayList<IAccessGroupHandle>();
                int i2 = 0;
                while (i2 < permissions.length) {
                    IVersionablePermissionsReport report = permissions[i2];
                    if (report.getContext() != null) {
                        IAuditableHandle scopeHandle = report.getContext().getReadContext();
                        if (scopeHandle instanceof IAccessGroupHandle) {
                            accessGroupHandles.add((IAccessGroupHandle)scopeHandle);
                        } else if (scopeHandle != null) {
                            auditableHandles.add(scopeHandle);
                        }
                        for (Object itemId : report.getItemsIds()) {
                            UUID id = (UUID)itemId;
                            mapItemToPermission.put(id, scopeHandle);
                        }
                    }
                    ++i2;
                }
                if (auditableHandles != null && !auditableHandles.isEmpty() && (fetchedAuditables = this.getRepository().itemManager().fetchCompleteItems(auditableHandles, 0, (IProgressMonitor)progress.newChild(10))) != null && !fetchedAuditables.isEmpty()) {
                    mapToFetchedAuditables = new HashMap(fetchedAuditables.size());
                    for (Object o : fetchedAuditables) {
                        if (o == null || !(o instanceof IAuditable)) continue;
                        IAuditable auditable = (IAuditable)o;
                        mapToFetchedAuditables.put(auditable.getItemId(), auditable);
                    }
                }
                if (accessGroupHandles != null && !accessGroupHandles.isEmpty()) {
                    if (mapToFetchedAuditables == null) {
                        mapToFetchedAuditables = new HashMap<UUID, Object>(accessGroupHandles.size());
                    }
                    IAccessGroupClientService accessGroupService = (IAccessGroupClientService)this.getRepository().getClientLibrary(IAccessGroupClientService.class);
                    SubMonitor loopProgress = progress.newChild(10).setWorkRemaining(accessGroupHandles.size());
                    for (IAccessGroupHandle accessGroupHandle : accessGroupHandles) {
                        IAccessGroup accessGroup = accessGroupService.getAccessGroupForGroupContextId(accessGroupHandle.getItemId(), (IProgressMonitor)loopProgress.newChild(1));
                        if (accessGroup == null) continue;
                        mapToFetchedAuditables.put(accessGroupHandle.getItemId(), accessGroup);
                    }
                }
            }
        }
        AbstractFileSystemItemWrapper.VersionDisplayOption option = this.versionDisplayMode.getVersionDisplayOpt();
        progress.setWorkRemaining(10);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)login);
        ArrayList<Object> result = new ArrayList<Object>();
        HashMap<UUID, IVersionableIdentifier> map = new HashMap<UUID, IVersionableIdentifier>();
        if (!option.equals((Object)AbstractFileSystemItemWrapper.VersionDisplayOption.DO_NOT_SHOW_VERSION_INFO)) {
            IVersionableHandle[] versionableStates = new IVersionableHandle[mapItemIdsToStates.size()];
            int idx = 0;
            for (StateId state : mapItemIdsToStates.values()) {
                versionableStates[idx] = (IVersionableHandle)state.toHandle();
                ++idx;
            }
            IVersionableIdentifier[] identifiers = workspaceManager.getVersionableIdentifiers(versionableStates, (IProgressMonitor)progress.newChild(10));
            int i = 0;
            while (i < versionableStates.length) {
                if (identifiers[i] != null) {
                    map.put(versionableStates[i].getStateId(), identifiers[i]);
                }
                ++i;
            }
        }
        for (Map.Entry<String, ItemId<IVersionable>> entry : mapNamesToItemIds.entrySet()) {
            Object wrapper;
            String name = entry.getKey();
            ItemId<IVersionable> child = entry.getValue();
            StateId childState = (StateId)mapItemIdsToStates.get(child);
            IAuditableHandle scope = null;
            String scopeDescription = null;
            String itemPath = PathUtils.appendPath((String)parentPath, (String)name);
            if (this.foldersOnly && child.getItemType() != IFolder.ITEM_TYPE) continue;
            if (this.permissionScope && mapToFetchedAuditables != null && (scope = (IAuditableHandle)mapItemToPermission.get(child.getItemUUID())) != null) {
                IAuditable auditable = (IAuditable)mapToFetchedAuditables.get(scope.getItemId());
                scopeDescription = auditable != null ? ItemPermissionUtil.getPermissionContextName(auditable) : Messages.Visibility_3;
            }
            if ((wrapper = this.createWrapper(configuration.getContext().getNamespace(), childState, itemPath, (IComponentHandle)this.context.getComponent().toHandle(), scopeDescription)) instanceof AbstractFileSystemItemWrapper && !(wrapper instanceof FolderItemWrapper)) {
                AbstractFileSystemItemWrapper itemWrapper = (AbstractFileSystemItemWrapper)((Object)wrapper);
                if (option.equals((Object)AbstractFileSystemItemWrapper.VersionDisplayOption.DO_NOT_SHOW_VERSION_INFO)) {
                    itemWrapper.setDisplayOption(AbstractFileSystemItemWrapper.VersionDisplayOption.DO_NOT_SHOW_VERSION_INFO);
                } else {
                    IVersionableIdentifier identifier = (IVersionableIdentifier)map.get(childState.getStateUUID());
                    if (identifier != null) {
                        if (option.equals((Object)AbstractFileSystemItemWrapper.VersionDisplayOption.SHOW_VERSION_ID)) {
                            itemWrapper.setVersionId(identifier.getLongVersionId());
                            itemWrapper.setDisplayOption(AbstractFileSystemItemWrapper.VersionDisplayOption.SHOW_VERSION_ID);
                        } else if (option.equals((Object)AbstractFileSystemItemWrapper.VersionDisplayOption.SHOW_VERSION_NUMBER)) {
                            itemWrapper.setVersionNumber(identifier.getShortVersionId());
                            itemWrapper.setDisplayOption(AbstractFileSystemItemWrapper.VersionDisplayOption.SHOW_VERSION_NUMBER);
                        }
                    }
                }
            }
            Assert.isNotNull((Object)wrapper);
            if (wrapper == null) continue;
            result.add(wrapper);
        }
        return result;
    }

    protected Object createWrapper(ItemNamespace namespace, StateId state, String itemName, IComponentHandle component) {
        return AbstractFileSystemItemWrapper.newWrapper(state, itemName, namespace);
    }

    protected Object createWrapper(ItemNamespace namespace, StateId state, String itemName, IComponentHandle component, String scope) {
        return AbstractFileSystemItemWrapper.newWrapper(state, itemName, namespace, scope);
    }

    protected abstract String getParentName();

    public void setFoldersOnly(boolean foldersOnly) {
        this.foldersOnly = foldersOnly;
    }

    public void showPermissionScope(boolean showPermissionScope) {
        this.permissionScope = showPermissionScope;
    }

    public static class VersionDisplayMode {
        private AbstractFileSystemItemWrapper.VersionDisplayOption versionDisplayOpt = AbstractFileSystemItemWrapper.VersionDisplayOption.DO_NOT_SHOW_VERSION_INFO;

        public AbstractFileSystemItemWrapper.VersionDisplayOption getVersionDisplayOpt() {
            return this.versionDisplayOpt;
        }

        public void setVersionDisplayOpt(AbstractFileSystemItemWrapper.VersionDisplayOption versionDisplayOpt) {
            this.versionDisplayOpt = versionDisplayOpt;
        }
    }
}

