/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.query.PagedQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentInfo;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class AbstractBaselineQuery<T>
extends PagedQuery<T> {
    private List<T> baselines = new ArrayList<T>();
    private List<WorkspaceRecord> workspaces = new ArrayList<WorkspaceRecord>();

    public AbstractBaselineQuery(WorkspaceNamespace namespace, IOperationRunner runner) {
        super(namespace.getRepository(), runner);
        this.workspaces.add(new WorkspaceRecord(namespace));
    }

    public AbstractBaselineQuery(ItemLocator<IComponent> component, Collection<ItemId<IWorkspace>> sourceWorkspaces, IOperationRunner runner) {
        super(component.getRepository(), runner);
        for (ItemId<IWorkspace> workspace : sourceWorkspaces) {
            this.workspaces.add(new WorkspaceRecord(WorkspaceNamespace.create((ITeamRepository)component.getRepository(), workspace, (ItemId)component.getItemId())));
        }
    }

    protected void doFlushCache(IProgressMonitor monitor) throws TeamRepositoryException {
        super.doFlushCache(monitor);
        this.baselines.clear();
    }

    protected PagedQuery.QueryResult<T> fetchNextPage(int pageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + 2 * this.workspaces.size()));
        boolean hasMore = false;
        Collection result = new TreeSet();
        for (WorkspaceRecord wr : this.workspaces) {
            try {
                List baselines = wr.findBaselines(pageSize, (IProgressMonitor)progress.newChild(2));
                hasMore |= wr.hasMore();
                result = this.processPage(baselines, wr, result);
            }
            catch (ItemNotFoundException e) {
                hasMore = false;
            }
            catch (ComponentNotInWorkspaceException e) {
                hasMore = false;
            }
        }
        this.baselines = this.addPage(this.baselines, result);
        return new PagedQuery.QueryResult(this.baselines, 0L, hasMore);
    }

    protected abstract Collection processPage(List<IBaseline> var1, WorkspaceRecord var2, Collection var3);

    protected abstract List<T> addPage(List<T> var1, Collection var2);

    public void setPageSize(int pageSize) {
        if (pageSize % 100 != 0) {
            pageSize = pageSize / 100 * 100 + 100;
        }
        super.setPageSize(pageSize);
    }

    protected static class WorkspaceRecord {
        private WorkspaceNamespace namespace;
        private IItemContext dynamicContext;
        private IComponent component;
        private long baselinesFetched = 0L;
        private boolean hasMoreInWSContext = true;

        public WorkspaceRecord(WorkspaceNamespace namespace) {
            this.namespace = namespace;
        }

        private List<IBaseline> findBaselines(int pageSize, IProgressMonitor monitor) throws TeamRepositoryException {
            IConnection connection;
            if (!this.hasMore()) {
                return Collections.emptyList();
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (this.dynamicContext == null) {
                this.dynamicContext = this.namespace.createContext((IProgressMonitor)progress.newChild(20));
                progress.setWorkRemaining(100);
            }
            if (this.component == null) {
                this.component = (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)this.namespace.getRepository(), (ItemId)this.dynamicContext.getComponent(), (IProgressMonitor)progress.newChild(1));
            }
            if (!((connection = this.dynamicContext.getConnection()) instanceof IWorkspaceConnection)) {
                return Collections.emptyList();
            }
            IWorkspaceConnection wc = (IWorkspaceConnection)connection;
            IComponentHandle componentHandle = (IComponentHandle)this.namespace.getComponentId().toHandle();
            long totalNumberOfBaselines = ConnectionUtil.getNumBasisInHistory((IWorkspaceConnection)wc, (ItemId)this.namespace.getComponentId(), (IProgressMonitor)progress.newChild(10));
            long baselinesPending = totalNumberOfBaselines - this.baselinesFetched;
            if (baselinesPending <= 0L) {
                this.hasMoreInWSContext = false;
                return Collections.emptyList();
            }
            long itemsToFetch = Math.min(baselinesPending, (long)pageSize);
            long queryStart = baselinesPending - itemsToFetch;
            List componentInfo = new ArrayList();
            if (queryStart >= 0L) {
                componentInfo = wc.getComponentAuditTrail(componentHandle, queryStart, itemsToFetch, (IProgressMonitor)progress.newChild(1));
            }
            ArrayList<IBaselineHandle> baselineHandles = new ArrayList<IBaselineHandle>();
            for (IComponentInfo comp : componentInfo) {
                if (comp.basis() == null) continue;
                IBaselineHandle baselineHandle = (IBaselineHandle)new ItemId(IBaseline.ITEM_TYPE, comp.basis().getItemId()).toHandle();
                baselineHandles.add(baselineHandle);
            }
            List resultantBaselines = connection.teamRepository().itemManager().fetchCompleteItems(baselineHandles, 0, (IProgressMonitor)progress.newChild(20));
            this.baselinesFetched += (long)resultantBaselines.size();
            if (totalNumberOfBaselines <= this.baselinesFetched) {
                this.hasMoreInWSContext = false;
            }
            return resultantBaselines;
        }

        public boolean hasMore() {
            return this.hasMoreInWSContext;
        }

        public ITeamRepository teamRepository() {
            return this.namespace.getRepository();
        }

        public IComponent getComponent() {
            return this.component;
        }

        public IItemContext getDynamicContext() {
            return this.dynamicContext;
        }
    }
}

