/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.operations.query;

import com.ibm.team.filesystem.ide.ui.internal.editors.query.ScmQueryWorkingCopy;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.dto.IItemSearchCriteria;
import com.ibm.team.scm.common.dto.IReadScope;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class EditQueryItemOperation
extends RepositoryOperation {
    private ScmQueryWorkingCopy fWorkingCopy;

    public EditQueryItemOperation(ScmQueryWorkingCopy workingCopy) {
        Assert.isNotNull((Object)((Object)workingCopy));
        Assert.isNotNull((Object)((Object)workingCopy.getQueryItemWrapper()));
        this.fWorkingCopy = workingCopy;
    }

    public ScmQueryWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    protected abstract IItemSearchCriteria getSearchCriteria();

    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.EditScmQueryOperation_EDIT_QUERY_JOB_NAME, (int)100);
        try {
            QueryItemWrapper wrapper = this.fWorkingCopy.getQueryItemWrapper();
            ITeamRepository repo = wrapper.getRepository();
            IQueryItem query = wrapper.getQueryItem();
            String name = this.fWorkingCopy.getQueryName();
            String description = this.fWorkingCopy.getQueryDescription();
            IAuditable owner = this.fWorkingCopy.getQueryOwner();
            IReadScope readScope = this.fWorkingCopy.getQueryReadScope();
            IItemSearchCriteria searchCriteria = this.getSearchCriteria();
            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            IQueryItem savedQuery = wm.updateQueryItem(query, name, description, (IAuditableHandle)owner, readScope, searchCriteria, (IProgressMonitor)progress.newChild(80));
            this.fWorkingCopy.setQueryItemWrapper(QueryItemWrapper.newWrapper(repo, savedQuery));
            repo.itemManager().refreshSharedItems(Collections.unmodifiableList(Arrays.asList(savedQuery)), (IProgressMonitor)progress.newChild(20));
        }
        finally {
            progress.done();
        }
    }
}

