/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.operations.query;

import com.ibm.team.filesystem.ide.ui.internal.editors.query.ScmQueryWorkingCopy;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.operations.AddToFolderOperation;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.dto.IItemSearchCriteria;
import com.ibm.team.scm.common.dto.IReadScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class CreateQueryItemOperation
extends RepositoryOperation {
    private final ScmQueryWorkingCopy fWorkingCopy;

    public CreateQueryItemOperation(ScmQueryWorkingCopy workingCopy) {
        Assert.isNotNull((Object)((Object)workingCopy));
        this.fWorkingCopy = workingCopy;
    }

    public ScmQueryWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    protected abstract IItemSearchCriteria getSearchCriteria();

    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
        ITeamRepository repo;
        String name = this.fWorkingCopy.getQueryName();
        String description = this.fWorkingCopy.getQueryDescription();
        IAuditable owner = this.fWorkingCopy.getQueryOwner();
        IReadScope readScope = this.fWorkingCopy.getQueryReadScope();
        IItemSearchCriteria searchCriteria = this.getSearchCriteria();
        ITeamRepository iTeamRepository = repo = owner == null ? null : (ITeamRepository)owner.getOrigin();
        if (repo != null) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NewScmQueryOperation_NEW_QUERY_JOB_NAME, (int)100);
            boolean shouldAddToFolder = repo.equals(this.fWorkingCopy.getOriginalRepository()) && (this.fWorkingCopy.shouldAddToRootFolder() || this.fWorkingCopy.getParentFolder() != null);
            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            IQueryItem savedQuery = wm.createQueryItem(name, description, (IAuditableHandle)owner, readScope, searchCriteria, (IProgressMonitor)progress.newChild(shouldAddToFolder ? 60 : 100));
            this.fWorkingCopy.setQueryItemWrapper(QueryItemWrapper.newWrapper(repo, savedQuery));
            if (shouldAddToFolder) {
                try {
                    AddToFolderOperation addChildrenOperation = new AddToFolderOperation();
                    IAuditable folderOwner = this.fWorkingCopy.getFolderOwner() != null ? this.fWorkingCopy.getFolderOwner() : (owner instanceof ITeamArea ? this.fWorkingCopy.getQueryParentOwner() : owner);
                    addChildrenOperation.add((IItemHandle)folderOwner, this.fWorkingCopy.getParentFolder(), this.fWorkingCopy.getQueryItemWrapper().getItem());
                    addChildrenOperation.run((IProgressMonitor)progress.newChild(40), problems);
                }
                catch (Exception e) {
                    String message = NLS.bind((String)Messages.CreateQueryItemOperation_noFolderPermissionMessage, (Object)this.fWorkingCopy.getQueryName());
                    DialogUtil.openError(this.fWorkingCopy.getShell(), Messages.CreateQueryItemOperation_noFolderPermissionTitle, message);
                    throw e;
                }
            }
        }
    }
}

