/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.operations.merge;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.compare.IStreamMerger;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.mapping.IStorageMerger;

public class StreamMergerWrapper
implements IStorageMerger {
    private IStreamMerger streamMerger;

    public StreamMergerWrapper(IStreamMerger streamMerger) {
        this.streamMerger = streamMerger;
    }

    public boolean canMergeWithoutAncestor() {
        return false;
    }

    public IStatus merge(OutputStream output, String outputEncoding, IStorage ancestor, IStorage target, IStorage other, IProgressMonitor monitor) throws CoreException {
        IStatus result;
        BufferedInputStream tStream;
        BufferedInputStream oStream;
        BufferedInputStream aStream;
        block3: {
            aStream = null;
            oStream = null;
            tStream = null;
            try {
                aStream = new BufferedInputStream(ancestor.getContents());
                oStream = new BufferedInputStream(other.getContents());
                tStream = new BufferedInputStream(target.getContents());
                result = this.streamMerger.merge(output, outputEncoding, (InputStream)aStream, this.getEncoding(ancestor, outputEncoding), (InputStream)tStream, this.getEncoding(target, outputEncoding), (InputStream)oStream, this.getEncoding(other, outputEncoding), monitor);
                if (result.isOK() || result.getCode() != 1) break block3;
                Status status = new Status(result.getSeverity(), result.getPlugin(), 1, result.getMessage(), result.getException());
                this.ensureClosed(aStream);
                this.ensureClosed(oStream);
                this.ensureClosed(tStream);
                return status;
            }
            catch (Throwable throwable) {
                this.ensureClosed(aStream);
                this.ensureClosed(oStream);
                this.ensureClosed(tStream);
                throw throwable;
            }
        }
        IStatus iStatus = result;
        this.ensureClosed(aStream);
        this.ensureClosed(oStream);
        this.ensureClosed(tStream);
        return iStatus;
    }

    private void ensureClosed(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getEncoding(IStorage storage, String defaultEncoding) {
        if (storage instanceof IEncodedStorage) {
            IEncodedStorage es = (IEncodedStorage)storage;
            try {
                String charset = es.getCharset();
                if (charset != null) {
                    return charset;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return defaultEncoding;
    }
}

