/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.operations;

import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NicknameComputer {
    private static final int MAX_NAME_CHARS = 4;

    private static <T> Map<T, String> computeInitials(Map<T, String> contributorNames) {
        HashMap result = NewCollection.hashMap();
        for (Map.Entry<T, String> next : contributorNames.entrySet()) {
            result.put(next.getKey(), NicknameComputer.computeInitials(next.getValue()));
        }
        return result;
    }

    private static String computeInitials(String value) {
        int lastNameStart = 0;
        int lastNameLength = 0;
        boolean parsingWhitespace = true;
        boolean everFoundWhitespace = false;
        int idx = 0;
        while (idx < value.length()) {
            char nextChar = value.charAt(idx);
            if (Character.isWhitespace(nextChar)) {
                parsingWhitespace = true;
                everFoundWhitespace = true;
            } else {
                if (parsingWhitespace) {
                    lastNameStart = idx;
                    lastNameLength = 1;
                } else {
                    ++lastNameLength;
                }
                parsingWhitespace = false;
            }
            ++idx;
        }
        StringBuffer result = new StringBuffer(5);
        if (value.length() > 0) {
            if (everFoundWhitespace) {
                result.append(value.charAt(0));
            }
            int availableForLastname = 4;
            if (everFoundWhitespace) {
                --availableForLastname;
            }
            int usedLength = Math.min(lastNameLength, availableForLastname);
            result.append(value.substring(lastNameStart, lastNameStart + usedLength));
        }
        return result.toString();
    }

    public static <T> Map<T, String> computeNicknames(Map<T, String> contributorNames) {
        Map<T, String> work = NicknameComputer.computeInitials(contributorNames);
        NicknameComputer.disambiguateDuplicates(work);
        return work;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Map<T, String> computeShortform(Map<T, String> strings) {
        void var3_4;
        int longestString = 0;
        for (Map.Entry<T, String> next : strings.entrySet()) {
            String nextString = next.getValue();
            if (nextString.length() <= longestString) continue;
            longestString = nextString.length();
        }
        Map[] map = new Map[longestString];
        boolean bl = false;
        while (var3_4 < map.length) {
            map[var3_4] = new HashMap();
            ++var3_4;
        }
        for (Map.Entry entry : strings.entrySet()) {
            String nextString = (String)entry.getValue();
            int idx2 = 0;
            while (idx2 < nextString.length()) {
                char nextChar = nextString.charAt(idx2);
                int value = NicknameComputer.getInt(map[idx2], nextChar);
                map[idx2].put(Character.valueOf(nextChar), value + 1);
                ++idx2;
            }
        }
        HashMap hashMap = NewCollection.hashMap();
        for (Map.Entry<T, String> next : strings.entrySet()) {
            StringBuffer nextBuf = new StringBuffer();
            String nextString = next.getValue();
            int used = 0;
            int idx3 = 0;
            while (used < 4 && idx3 < nextString.length()) {
                int occurs;
                char nextChar = nextString.charAt(idx3);
                if (!Character.isWhitespace(nextChar) && (occurs = NicknameComputer.getInt(map[idx3], nextChar)) - 1 <= strings.size() / 3) {
                    nextBuf.append(nextChar);
                    ++used;
                }
                ++idx3;
            }
            hashMap.put(next.getKey(), nextBuf.toString());
        }
        NicknameComputer.disambiguateDuplicates(hashMap);
        return hashMap;
    }

    private static int getInt(Map<Character, Integer> map, char nextChar) {
        if (map.containsKey(Character.valueOf(nextChar))) {
            return map.get(Character.valueOf(nextChar));
        }
        return 0;
    }

    private static <T> void disambiguateDuplicates(Map<T, String> work) {
        Map duplicates = CollectionUtil.invertMap(work);
        HashSet generatedNames = NewCollection.hashSet();
        for (Map.Entry next : duplicates.entrySet()) {
            if (((List)next.getValue()).size() < 2) continue;
            int counter = 0;
            for (Object dupe : (List)next.getValue()) {
                String proposal;
                while (duplicates.containsKey(proposal = String.valueOf((String)next.getKey()) + counter++) || generatedNames.contains(proposal)) {
                }
                generatedNames.add(proposal);
                work.put(dupe, proposal);
            }
        }
    }

    public static <T> Map<T, String> computeShortform(Map<T, String> strings, int maxLength) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Map.Entry<T, String> next : strings.entrySet()) {
            Object nextString = next.getValue();
            if (nextString != null) {
                nextString = ((String)nextString).replaceAll("\\s", "");
                if (((String)(nextString = ((String)nextString).replaceAll("\\t", ""))).length() > maxLength) {
                    nextString = ((String)nextString).substring(0, maxLength);
                }
            }
            result.put(next.getKey(), nextString);
        }
        HashMap<String, Integer> occurrenceMap = new HashMap<String, Integer>();
        for (Map.Entry entry : result.entrySet()) {
            String resultString = (String)entry.getValue();
            if (resultString == null) continue;
            Integer occurenceCount = (Integer)occurrenceMap.get(resultString);
            occurenceCount = occurenceCount != null ? occurenceCount + 1 : 1;
            occurrenceMap.put(resultString, occurenceCount);
        }
        Set set = occurrenceMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if ((Integer)entry.getValue() != 1) continue;
            iterator.remove();
        }
        if (occurrenceMap.size() > 0) {
            HashMap<String, Integer> duplicatesMap = new HashMap<String, Integer>(occurrenceMap);
            for (Map.Entry next : result.entrySet()) {
                Integer occurrenceCount;
                String resultString = (String)next.getValue();
                if (resultString == null || (occurrenceCount = (Integer)occurrenceMap.get(resultString)) == null) continue;
                Integer duplicateCount = (Integer)duplicatesMap.get(resultString);
                String suffix = "-" + duplicateCount.toString();
                int suffixLength = occurrenceCount.toString().length() + 1;
                int length = resultString.length();
                String updatedString = length - suffixLength > 1 ? resultString.substring(0, length - suffixLength) : resultString.substring(0, length > 2 ? 2 : length);
                updatedString = String.valueOf(updatedString) + suffix;
                result.put(next.getKey(), updatedString);
                duplicatesMap.put(resultString, duplicateCount - 1);
            }
        }
        if (occurrenceMap.size() > 0) {
            NicknameComputer.disambiguateDuplicates(result);
        }
        return result;
    }
}

