/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.ui.operations.EditWorkspaceOperation;
import com.ibm.team.filesystem.ui.views.CollaborationEntry;
import com.ibm.team.filesystem.ui.views.ComponentEntry;
import com.ibm.team.filesystem.ui.views.TeamPlaceWorkingCopy;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.operations.AddToFolderOperation;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IReadScope;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class NewWorkspaceOperation
extends RepositoryOperation {
    private final TeamPlaceWorkingCopy workingCopy;

    public NewWorkspaceOperation(TeamPlaceWorkingCopy workingCopy) {
        this.workingCopy = workingCopy;
    }

    private void createComponents(IWorkspaceConnection workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<ComponentEntry> componentsToAdd = new ArrayList<ComponentEntry>(this.workingCopy.getComponentsToAdd());
        if (componentsToAdd.isEmpty()) {
            return;
        }
        ITeamRepository repo = workspace.teamRepository();
        ArrayList<IFlowNodeConnection.IComponentOp> addOps = new ArrayList<IFlowNodeConnection.IComponentOp>();
        SubMonitor collectOpsProgress = progress.newChild(25).setWorkRemaining(componentsToAdd.size());
        IAuditable customOwnerHandle = null;
        if (this.workingCopy != null && this.workingCopy.getOwner() instanceof IContributorHandle || this.workingCopy.getOwner() instanceof IProcessAreaHandle) {
            customOwnerHandle = this.workingCopy.getOwner();
        }
        for (ComponentEntry entry : componentsToAdd) {
            addOps.add(EditWorkspaceOperation.getAdditionOp(workspace, (IAuditableHandle)customOwnerHandle, entry, collectOpsProgress.newChild(1)));
        }
        workspace.applyComponentOperations(addOps, (IProgressMonitor)progress.newChild(75));
        int i = 0;
        while (i < componentsToAdd.size()) {
            ComponentEntry entry = (ComponentEntry)componentsToAdd.get(i);
            IFlowNodeConnection.IComponentOp op = (IFlowNodeConnection.IComponentOp)addOps.get(i);
            entry.setComponent(new ComponentWrapper(repo, (IComponent)op.getComponent()));
            ++i;
        }
    }

    private IWorkspaceConnection createWorkspace(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = this.workingCopy.getRepository();
        IContributor loggedinContributorHandle = repo.loggedInContributor();
        IContributorHandle owner = (IContributorHandle)this.workingCopy.getOwner();
        boolean ownerIsUser = owner.sameItemId((IItemHandle)loggedinContributorHandle);
        String name = this.workingCopy.getPlaceName();
        String description = this.workingCopy.getDescription();
        IReadScope readScope = this.workingCopy.getReadScope();
        IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).createWorkspace((IContributorHandle)loggedinContributorHandle, name, description, (IProgressMonitor)progress.newChild(75));
        connection.setOwnerAndVisibility((IAuditableHandle)(ownerIsUser ? IScmService.NOOP_OWNER : owner), readScope, (IProgressMonitor)progress.newChild(25));
        progress.setWorkRemaining(0);
        this.workingCopy.setWorkspaceWrapper(WorkspaceUtil.toWrapper(connection));
        this.workingCopy.setWorkspaceConnection(connection);
        return connection;
    }

    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NewWorkspaceOperation_creating, (int)100);
        IWorkspaceConnection workspace = this.createWorkspace((IProgressMonitor)progress.newChild(14));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite((IConnection)workspace, (IProgressMonitor)progress.newChild(1));
        try {
            this.createComponents(workspace, (IProgressMonitor)progress.newChild(70));
            NewWorkspaceOperation.setFlowTable(workspace, this.workingCopy, (IProgressMonitor)progress.newChild(10));
            ITeamRepository repo = this.workingCopy.getRepository();
            IAuditable owner = this.workingCopy.getOwner();
            if (repo.equals(this.workingCopy.getFolderRepo()) && owner.sameItemId((IItemHandle)repo.loggedInContributor()) && (this.workingCopy.shouldAddToRootFolder() || this.workingCopy.getParentFolder() != null)) {
                try {
                    AddToFolderOperation addChildrenOperation = new AddToFolderOperation();
                    IAuditable folderOwner = owner instanceof ITeamArea ? this.workingCopy.getParentOwner() : owner;
                    addChildrenOperation.add((IItemHandle)folderOwner, this.workingCopy.getParentFolder(), (IItem)workspace.getResolvedWorkspace());
                    addChildrenOperation.run((IProgressMonitor)progress.newChild(10), problems);
                }
                catch (Exception e) {
                    StatusUtil.log((Object)((Object)this), (Throwable)e);
                }
            }
            this.track(workspace);
        }
        finally {
            progress.done();
            WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
        }
    }

    private void track(IWorkspaceConnection workspace) {
        if (workspace.getOwner().sameItemId((IItemHandle)workspace.teamRepository().loggedInContributor())) {
            FileSystemResourcesPlugin.getActiveWorkspaceManager().activate((IWorkspaceHandle)workspace.getResolvedWorkspace());
        }
    }

    public static void setFlowTable(IWorkspaceConnection workspace, TeamPlaceWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        List<CollaborationEntry> collaborationsToAdd = workingCopy.getCollaborationsToAdd();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)collaborationsToAdd.size());
        if (!collaborationsToAdd.isEmpty()) {
            IWorkspaceHandle currentWorkspaceHandle;
            CollaborationEntry currentEntry;
            IWorkspaceHandle defaultWorkspaceHandle;
            IFlowTable flowTable = workspace.getFlowTable().getWorkingCopy();
            for (CollaborationEntry entry : collaborationsToAdd) {
                SubMonitor conditionalProgress = progress.newChild(1).setWorkRemaining(1);
                if (!entry.isDeleted()) {
                    IWorkspaceConnection remote = entry.getCollaboration().getWorkspaceConnection((IProgressMonitor)conditionalProgress.newChild(1));
                    if ((entry.getFlowDirection() & 0xF) == 3) {
                        FlowTableUtil.addCollaboration((IFlowTable)flowTable, (IWorkspaceConnection)workspace, (IWorkspaceConnection)remote);
                    } else {
                        if ((entry.getFlowDirection() & 0xF) == 1) {
                            FlowTableUtil.addIncomingCollaboration((IFlowTable)flowTable, (IWorkspaceConnection)workspace, (IWorkspaceConnection)remote);
                        }
                        if ((entry.getFlowDirection() & 0xF) == 2) {
                            FlowTableUtil.addOutgoingCollaboration((IFlowTable)flowTable, (IWorkspaceConnection)workspace, (IWorkspaceConnection)remote);
                        }
                    }
                    flowTable.setComponentScopes((IFlowNodeHandle)entry.getCollaboration().getWorkspace(), entry.getComponentScopes());
                }
                conditionalProgress.done();
            }
            CollaborationEntry defaultEntry = workingCopy.getDefaultIncomingCollaboration();
            if (defaultEntry != null && !defaultEntry.isDeleted()) {
                defaultWorkspaceHandle = (IWorkspaceHandle)defaultEntry.getCollaboration().getWorkspace().getItemHandle();
                FlowTableUtil.setDefaultIncomingCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)defaultWorkspaceHandle);
            }
            if ((defaultEntry = workingCopy.getDefaultOutgoingCollaboration()) != null && !defaultEntry.isDeleted()) {
                defaultWorkspaceHandle = (IWorkspaceHandle)defaultEntry.getCollaboration().getWorkspace().getItemHandle();
                FlowTableUtil.setDefaultOutgoingCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)defaultWorkspaceHandle);
            }
            if ((currentEntry = workingCopy.getCurrentIncomingCollaboration()) != null && !currentEntry.isDeleted()) {
                currentWorkspaceHandle = (IWorkspaceHandle)currentEntry.getCollaboration().getWorkspace().getItemHandle();
                FlowTableUtil.setCurrentIncomingCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)currentWorkspaceHandle);
            }
            if ((currentEntry = workingCopy.getCurrentOutgoingCollaboration()) != null && !currentEntry.isDeleted()) {
                currentWorkspaceHandle = (IWorkspaceHandle)currentEntry.getCollaboration().getWorkspace().getItemHandle();
                FlowTableUtil.setCurrentOutgoingCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)currentWorkspaceHandle);
            }
            workspace.setFlowTable(flowTable, (IProgressMonitor)progress.newChild(30));
        }
    }
}

