/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.operations;

import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.operations.EditWorkspaceOperation;
import com.ibm.team.filesystem.ui.operations.NewWorkspaceOperation;
import com.ibm.team.filesystem.ui.views.ComponentEntry;
import com.ibm.team.filesystem.ui.views.TeamPlaceWorkingCopy;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.operations.AddToFolderOperation;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentDetails;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentDetailsFunction;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class NewStreamOperation
extends RepositoryOperation {
    private final TeamPlaceWorkingCopy workingCopy;

    public NewStreamOperation(TeamPlaceWorkingCopy workingCopy) {
        this.workingCopy = workingCopy;
    }

    private FlowNodeLock obtainLocks(IWorkspaceConnection newStream, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ArrayList<Object> writeLocksNeeded = new ArrayList<Object>(2);
        writeLocksNeeded.add(newStream.getContextHandle());
        if (this.shouldAddFlowToNewStream()) {
            writeLocksNeeded.add(this.workingCopy.getOriginalPlace().getWorkspace());
        }
        Collection<ConfigurationFacade> srcComponents = EditWorkspaceOperation.getComponentSources(this.workingCopy.getComponentsToAdd(), (IProgressMonitor)monitor.newChild(90));
        ArrayList<IConfigurationDescriptor> readLocksNeeded = new ArrayList<IConfigurationDescriptor>(srcComponents.size());
        for (IConfigurationDescriptor iConfigurationDescriptor : srcComponents) {
            readLocksNeeded.add(iConfigurationDescriptor);
        }
        return WorkspaceLockUtil.acquireLocks(Collections.emptyList(), writeLocksNeeded, readLocksNeeded, Collections.emptyList(), (IProgressMonitor)monitor.newChild(10));
    }

    private void createComponents(IWorkspaceConnection workspace, SubMonitor progress) throws TeamRepositoryException {
        ArrayList<ComponentEntry> componentsToAdd = new ArrayList<ComponentEntry>(this.workingCopy.getComponentsToAdd());
        if (componentsToAdd.isEmpty()) {
            return;
        }
        progress.setWorkRemaining(100);
        SubMonitor collectOpsProgress = progress.newChild(25);
        collectOpsProgress.setWorkRemaining(componentsToAdd.size());
        ITeamRepository repo = workspace.teamRepository();
        ArrayList<IFlowNodeConnection.IComponentOp> addOps = new ArrayList<IFlowNodeConnection.IComponentOp>();
        IAuditable customOwnerHandle = null;
        if (this.workingCopy != null && this.workingCopy.getOwner() instanceof IContributorHandle || this.workingCopy.getOwner() instanceof IProcessAreaHandle) {
            customOwnerHandle = this.workingCopy.getOwner();
        }
        for (ComponentEntry entry : componentsToAdd) {
            addOps.add(EditWorkspaceOperation.getAdditionOp(workspace, (IAuditableHandle)customOwnerHandle, entry, collectOpsProgress.newChild(1)));
        }
        workspace.applyComponentOperations(addOps, (IProgressMonitor)progress.newChild(75));
        ArrayList<ComponentWrapper> wrappers = new ArrayList<ComponentWrapper>(componentsToAdd.size());
        int i = 0;
        while (i < componentsToAdd.size()) {
            ComponentEntry entry = (ComponentEntry)componentsToAdd.get(i);
            IFlowNodeConnection.IComponentOp op = (IFlowNodeConnection.IComponentOp)addOps.get(i);
            ComponentWrapper componentWrapper = new ComponentWrapper(repo, (IComponent)op.getComponent());
            entry.setComponent(componentWrapper);
            wrappers.add(componentWrapper);
            ++i;
        }
        Map<ComponentWrapper, ComponentDetails> componentDetails = ComponentDetailsFunction.fetchComponentDetails(wrappers, (IProgressMonitor)progress.newChild(10));
        int i2 = 0;
        while (i2 < componentsToAdd.size()) {
            ComponentEntry entry = (ComponentEntry)componentsToAdd.get(i2);
            ComponentDetails details = componentDetails.get((Object)entry.getComponent());
            if (details != null) {
                entry.setDetails(details);
            }
            ++i2;
        }
    }

    private IWorkspaceConnection createStream(ITeamRepository repo, IProcessAreaHandle owner, String name, String description, String autoLockPatterns, Map<String, Object> customAttributes, SubMonitor progress) throws TeamRepositoryException {
        progress.setWorkRemaining(4);
        IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).createStream(owner, name, description, (IProgressMonitor)progress.newChild(1));
        connection.setOwnerAndVisibility(IScmService.NOOP_OWNER, this.workingCopy.getReadScope(), (IProgressMonitor)progress.newChild(1));
        connection.setExclusiveFileLockPatterns(autoLockPatterns, (IProgressMonitor)progress.newChild(1));
        if (!customAttributes.isEmpty()) {
            connection.setCustomAttributes(customAttributes, null, (IProgressMonitor)progress.newChild(1));
        }
        progress.setWorkRemaining(0);
        this.workingCopy.setWorkspaceWrapper(WorkspaceUtil.toWrapper(connection));
        this.workingCopy.setWorkspaceConnection(connection);
        return connection;
    }

    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NewStreamOperation_creating, (int)100);
        ITeamRepository repo = this.workingCopy.getRepository();
        IAuditable owner = this.workingCopy.getOwner();
        String name = this.workingCopy.getPlaceName();
        String description = this.workingCopy.getDescription();
        String autoLockPatterns = this.workingCopy.getAutoLockPatterns();
        Map<String, Object> customAttributes = this.workingCopy.getCustomAttributesToAdd();
        IWorkspaceConnection stream = this.createStream(repo, (IProcessAreaHandle)owner, name, description, autoLockPatterns, customAttributes, progress.newChild(10));
        FlowNodeLock flowNodeLocks = this.obtainLocks(stream, (IProgressMonitor)progress.newChild(5));
        try {
            this.createComponents(stream, progress.newChild(30));
            NewWorkspaceOperation.setFlowTable(stream, this.workingCopy, (IProgressMonitor)progress.newChild(10));
            if (this.shouldAddFlowToNewStream()) {
                boolean setCurrentCollaboration;
                IWorkspaceConnection originalConnection = this.workingCopy.getOriginalPlace().getWorkspaceConnection((IProgressMonitor)progress.newChild(25));
                FlowTableUtil.addCollaboration((IWorkspaceConnection)originalConnection, (IWorkspaceConnection)stream, (IProgressMonitor)progress.newChild(5));
                IFlowTable flowTable = originalConnection.getFlowTable();
                IFlowEntry currentAcceptFlow = flowTable.getCurrentAcceptFlow();
                boolean bl = setCurrentCollaboration = currentAcceptFlow == null ? true : currentAcceptFlow.getFlowNode().sameItemId(stream.getResolvedWorkspace().getItemHandle());
                if (setCurrentCollaboration) {
                    IActiveWorkspaceManager awm = FileSystemResourcesPlugin.getActiveWorkspaceManager();
                    awm.setWorkspaceCollaboration((IWorkspaceHandle)originalConnection.getResolvedWorkspace(), stream, true, (IProgressMonitor)progress.newChild(5));
                }
            }
        }
        finally {
            flowNodeLocks.release();
        }
        progress.setWorkRemaining(10);
        if (repo.equals(this.workingCopy.getFolderRepo()) && (this.workingCopy.shouldAddToRootFolder() || this.workingCopy.getParentFolder() != null)) {
            try {
                AddToFolderOperation addChildrenOperation = new AddToFolderOperation();
                IAuditable folderOwner = this.workingCopy.getFolderOwner() != null ? this.workingCopy.getFolderOwner() : (owner instanceof ITeamArea ? this.workingCopy.getParentOwner() : owner);
                addChildrenOperation.add((IItemHandle)folderOwner, this.workingCopy.getParentFolder(), (IItem)stream.getResolvedWorkspace());
                addChildrenOperation.run((IProgressMonitor)progress.newChild(10), problems);
            }
            catch (Exception e) {
                String message = NLS.bind((String)Messages.NewStreamOperation_noFolderPermissionMessage, (Object)this.workingCopy.getPlaceName());
                DialogUtil.openError(this.workingCopy.getShell(), Messages.NewStreamOperation_noFolderPermissionTitle, message);
            }
        }
        progress.done();
    }

    private boolean shouldAddFlowToNewStream() {
        AbstractPlaceWrapper originalPlace = this.workingCopy.getOriginalPlace();
        return originalPlace != null && !originalPlace.getWorkspace().isStream();
    }
}

