/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.operations;

import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.namespace.IContextHistory;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.DescriptionRecord;
import com.ibm.team.filesystem.client.internal.namespace.impl.EraCache;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.ui.LocationResolvedBrowserInformationControl;
import com.ibm.team.filesystem.ui.configuration.AuditableFetcher;
import com.ibm.team.filesystem.ui.operations.NicknameComputer;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.internal.tooltip.Tooltip;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.jface.tooltip.EditorTooltipSupport;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkHandle;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LiveAnnotateUtil {
    private static boolean computeTooltipInJob(final Tooltip tooltip, final Object element) {
        tooltip.setText(Messages.LiveAnnotateUtil_2);
        final Display d = Display.getCurrent();
        Job updatorJob = new Job(Messages.LiveAnnotateUtil_3){

            protected IStatus run(IProgressMonitor monitor) {
                if (element instanceof TeamRevision) {
                    TeamRevision tr = (TeamRevision)((Object)element);
                    final String hoverString = tr.computeHoverString(monitor);
                    d.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            tooltip.setText(hoverString);
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        updatorJob.schedule();
        return true;
    }

    public static RevisionInformation computeRevisions(ItemNamespace namespace, StateId<IFileItem> remote, ItemId<IChangeSet> changeSet, IProgressMonitor mon) throws TeamRepositoryException {
        SubMonitor reporter = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        ITeamRepository teamServer = namespace.getRepository();
        IItemContext context = namespace.getContext((IProgressMonitor)reporter.newChild(10));
        IContextHistory history = context.getHistory();
        if (history == null) {
            throw new TeamRepositoryException("This context does not support annotations");
        }
        LiveAnnotateUtil.checkCancelled((IProgressMonitor)reporter);
        List handles = history.getBlame(remote, changeSet, (IProgressMonitor)reporter.newChild(40));
        return LiveAnnotateUtil.combineChangeSetRanges2(teamServer, handles, (IProgressMonitor)reporter.newChild(50));
    }

    private static void checkCancelled(IProgressMonitor reporter) {
        if (reporter.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private static RevisionInformation combineChangeSetRanges2(ITeamRepository repoHandle, List<ItemId<IChangeSet>> changeSets, IProgressMonitor mon) throws TeamRepositoryException {
        SubMonitor reporter = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        Map fetchedChanges = RepoFetcher.fetchCurrents((ITeamRepository)repoHandle, changeSets, (IProgressMonitor)reporter.newChild(25));
        ArrayList contributorIds = NewCollection.arrayList();
        AuditableFetcher prefetcher = new AuditableFetcher(repoHandle);
        for (IChangeSet change : fetchedChanges.values()) {
            ItemId contributorId = ChangeSetUtil.getAuthor((IChangeSet)change);
            prefetcher.add(contributorId);
            contributorIds.add(contributorId);
        }
        prefetcher.prefetch((IProgressMonitor)reporter.newChild(25));
        Map<Object, Object> contributorNicknames = NewCollection.hashMap();
        HashMap contributorNames = NewCollection.hashMap();
        for (ItemId next : contributorIds) {
            IContributor nextContributor = (IContributor)prefetcher.getFetched(next);
            if (nextContributor != null) {
                contributorNames.put(next, nextContributor.getName());
                continue;
            }
            contributorNames.put(next, "");
        }
        contributorNicknames = NicknameComputer.computeNicknames(contributorNames);
        HashMap contributorColours = NewCollection.hashMap();
        int idx = 0;
        for (ItemId next : contributorIds) {
            RGB nextRGB = new RGB(360.0f * (float)idx / (float)contributorIds.size(), 1.0f, 0.5f);
            contributorColours.put(next, nextRGB);
            ++idx;
        }
        RGB changeSetNotFoundColour = LiveAnnotateUtil.prefRGB("org.eclipse.ui.editors", "infoIndicationColor");
        contributorColours.put(ItemId.getNullItem((IItemType)ItemId.getNullItemType()), changeSetNotFoundColour);
        Map descriptions = EraCache.fetchDescriptions((ITeamRepository)repoHandle, fetchedChanges.values(), (IRepositoryResolver)IRepositoryResolver.EXISTING_SHARED, (IProgressMonitor)reporter.newChild(25));
        Map<Object, Object> changeSetNicknames = NewCollection.hashMap();
        for (Map.Entry next : descriptions.entrySet()) {
            changeSetNicknames.put((ItemId)next.getKey(), ((DescriptionRecord)next.getValue()).getDescription());
        }
        changeSetNicknames = NicknameComputer.computeShortform(changeSetNicknames, 10);
        ItemId<IChangeSet> lastSet = null;
        HashMap<UUID, Revision> revisionByChangeSetId = new HashMap<UUID, Revision>();
        int line = 0;
        int acc = 0;
        RevisionInformation info = new RevisionInformation();
        SubMonitor progress = reporter.newChild(24);
        progress.setWorkRemaining(changeSets.size());
        for (ItemId<IChangeSet> set : changeSets) {
            SubMonitor iterationProgress = progress.newChild(1);
            if (set.equals(lastSet)) {
                ++acc;
            } else {
                if (acc > 0) {
                    LiveAnnotateUtil.addRevisionHunk(repoHandle, fetchedChanges, prefetcher, contributorNicknames, contributorColours, descriptions, changeSetNicknames, lastSet, revisionByChangeSetId, line, acc, info, iterationProgress);
                }
                acc = 1;
            }
            lastSet = set;
            ++line;
        }
        if (acc > 0) {
            LiveAnnotateUtil.addRevisionHunk(repoHandle, fetchedChanges, prefetcher, contributorNicknames, contributorColours, descriptions, changeSetNicknames, lastSet, revisionByChangeSetId, line, acc, info, reporter.newChild(1));
        }
        info.setHoverControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new AnnotateTooltipSupport(parent, true, false);
            }
        });
        info.setInformationPresenterControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new ResolvedAnnotateTooltipSupport(parent);
            }
        });
        return info;
    }

    private static void addRevisionHunk(ITeamRepository repoHandle, Map<ItemId<IChangeSet>, IChangeSet> fetchedChanges, AuditableFetcher prefetcher, Map<ItemId<IContributor>, String> contributorNicknames, Map<ItemId<IContributor>, RGB> contributorColours, Map<ItemId<IChangeSet>, DescriptionRecord> descriptions, Map<ItemId<IChangeSet>, String> changeSetNicknames, ItemId<IChangeSet> lastSet, Map<UUID, Revision> revisionByChangeSetId, int line, int acc, RevisionInformation info, SubMonitor iterationProgress) throws TeamRepositoryException {
        Revision rev = revisionByChangeSetId.get(lastSet.getItemUUID());
        if (rev == null) {
            IChangeSet fetchedSet = fetchedChanges.get(lastSet);
            if (fetchedSet != null) {
                RGB colour;
                DescriptionRecord desc = descriptions.get(ItemId.create((IItemHandle)fetchedSet));
                ItemId author = ChangeSetUtil.getAuthor((IChangeSet)fetchedSet);
                String nickname = contributorNicknames.get(author);
                if (nickname == null) {
                    nickname = Messages.LiveAnnotateUtil_23;
                }
                ItemId changeSetId = ItemId.forItem((IItem)fetchedSet);
                String changeSetComment = fetchedSet.getComment();
                String changeSetNickname = changeSetNicknames.get(changeSetId);
                if (changeSetNickname == null) {
                    changeSetNickname = changeSetId.getItemUUID().getUuidValue();
                }
                if ((colour = contributorColours.get(author)) == null) {
                    colour = new RGB(0, 0, 0);
                }
                IContributor contributor = (IContributor)prefetcher.getFetched(author);
                rev = LiveAnnotateUtil.createRevision(repoHandle, fetchedSet, contributor, nickname, changeSetNickname, changeSetComment, desc.getChangeSetLinkSummary().getLinks(), colour, (IProgressMonitor)iterationProgress);
            } else {
                RGB colour = contributorColours.get(ItemId.getNullItem((IItemType)ItemId.getNullItemType()));
                rev = new NullTeamRevision(colour);
            }
            revisionByChangeSetId.put(lastSet.getItemUUID(), rev);
            info.addRevision(rev);
        }
        rev.addRange((ILineRange)new LineRange(line - acc, acc));
    }

    private static RGB prefRGB(String qualifier, String key) {
        String rgbString = Platform.getPreferencesService().getString(qualifier, key, "0,0,0", null);
        String[] valStrings = rgbString.split(",");
        RGB result = new RGB(0, 0, 0);
        try {
            if (valStrings.length == 3) {
                int r = Integer.parseInt(valStrings[0]);
                int g = Integer.parseInt(valStrings[1]);
                int b = Integer.parseInt(valStrings[2]);
                result = new RGB(r, g, b);
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    private static Revision createRevision(ITeamRepository repoHandle, IChangeSet set, IContributor contributor, String nickname, String id, String comment, List<ILinkHandle> links, RGB authorColour, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IChangeSet cs = (IChangeSet)set.getFullState();
        ContributorWrapper author = new ContributorWrapper(repoHandle, contributor);
        comment = LiveAnnotateUtil.getComment(comment);
        List fetchedLinks = repoHandle.itemManager().fetchCompleteItems(links, 0, (IProgressMonitor)progress.newChild(1));
        ArrayList<IItemHandle> reasonHandles = new ArrayList<IItemHandle>();
        ArrayList<IURIReference> uriReferences = new ArrayList<IURIReference>();
        for (ILink link : fetchedLinks) {
            IReference ref = link.getTargetRef();
            if (ref.isItemReference() && "com.ibm.team.filesystem.workitems.change_set".equals(link.getLinkTypeId())) {
                reasonHandles.add(((IItemReference)ref).getReferencedItem());
                continue;
            }
            if (!ref.isURIReference() || !"com.ibm.team.filesystem.oslc_cm.change_request.change_set".equals(link.getLinkTypeId())) continue;
            uriReferences.add((IURIReference)ref);
        }
        List reasons = repoHandle.itemManager().fetchCompleteItems(reasonHandles, 0, (IProgressMonitor)progress.newChild(1));
        return new TeamRevision(cs, reasons, uriReferences, author, nickname, comment, id, authorColour);
    }

    private static String getComment(String comment) throws TeamRepositoryException {
        if (comment.equals("")) {
            return "";
        }
        return comment;
    }

    public static final class AnnotateTooltipSupport
    extends EditorTooltipSupport
    implements IInformationControlExtension2 {
        public AnnotateTooltipSupport(Shell parent, boolean isFocusable, boolean isOpenable) {
            super(parent, isFocusable, isOpenable);
        }

        protected String getMarkup(Object element, boolean isFocus) {
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof TeamRevision) {
                TeamRevision tr = (TeamRevision)((Object)element);
                return tr.computeHoverString(null);
            }
            return super.getMarkup(element, isFocus);
        }

        protected boolean getMarkupInJob(Tooltip tooltip, Object element, boolean isFocus) {
            return LiveAnnotateUtil.computeTooltipInJob(tooltip, element);
        }
    }

    public static class NullTeamRevision
    extends TeamRevision {
        private Date date = new Date(Long.MIN_VALUE);

        protected NullTeamRevision(RGB authorColour) {
            super(null, Collections.emptyList(), Collections.emptyList(), null, Messages.LiveAnnotateUtil_Unknown_Author, Messages.LiveAnnotateUtil_Unknown_Changeset, ItemId.getNullItem((IItemType)ItemId.getNullItemType()).getItemUUID().getUuidValue(), authorColour);
        }

        @Override
        public Date getDate() {
            return this.date;
        }

        @Override
        protected void appendWorkItemSection(HashMap definitions, StringBuffer body, IDomainAdapter.Info info) {
            body.append(Messages.LiveAnnotateUtil_Unknown_Changeset_Comment);
            body.append("<br>");
        }
    }

    public static final class ResolvedAnnotateTooltipSupport
    extends LocationResolvedBrowserInformationControl
    implements IInformationControlExtension2 {
        public ResolvedAnnotateTooltipSupport(Shell parent) {
            super(parent);
        }

        public void setInput(final Object element) {
            this.setInformation(Messages.LiveAnnotateUtil_0);
            final Display d = Display.getCurrent();
            Job updatorJob = new Job(Messages.LiveAnnotateUtil_1){

                protected IStatus run(IProgressMonitor monitor) {
                    if (element instanceof TeamRevision) {
                        TeamRevision tr = (TeamRevision)((Object)element);
                        final String hoverString = tr.computeHoverString(monitor);
                        d.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                this.setInformation(hoverString);
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
            updatorJob.schedule();
        }
    }

    public static class TeamRevision
    extends Revision {
        private final IChangeSet fSet;
        private final String fComment;
        private final ContributorWrapper fAuthor;
        private String fHoverInfo = null;
        private String fAuthorName;
        private RGB rgb;
        private final List<? extends Object> fReasons;
        private final List<IURIReference> oslcReferences;
        private String id;

        protected TeamRevision(IChangeSet set, List<? extends Object> reasons, List<IURIReference> oslcReferences, ContributorWrapper author, String nickname, String comment, String id, RGB authorColour) {
            this.fSet = set;
            this.fReasons = reasons;
            this.oslcReferences = oslcReferences;
            this.fAuthor = author;
            this.fComment = comment;
            this.fAuthorName = nickname;
            this.rgb = authorColour;
            this.id = id;
        }

        public String getAuthor() {
            return this.fAuthorName;
        }

        public IChangeSet getChangeSet() {
            return this.fSet;
        }

        public Object getHoverInfo() {
            return this;
        }

        public synchronized String computeHoverString(IProgressMonitor monitor) {
            if (this.fHoverInfo == null) {
                HashMap definitions = new HashMap();
                StringBuffer body = this.assembleHoverBody(definitions);
                StringBuffer html = new StringBuffer();
                html.append("<html><head>");
                HTMLGenerator.getHeadDefinitions((StringBuffer)html, definitions);
                html.append("</head><body>");
                html.append(body);
                html.append("</body></html>");
                this.fHoverInfo = html.toString();
            }
            return this.fHoverInfo;
        }

        private StringBuffer assembleHoverBody(HashMap definitions) {
            StringBuffer body = new StringBuffer();
            IDomainAdapter.Info info = new IDomainAdapter.Info();
            info.isEmbeddeble = true;
            info.isHoverTooltip = false;
            this.generateHead(definitions, info);
            this.appendWorkItemSection(definitions, body, info);
            return body;
        }

        protected void appendWorkItemSection(HashMap definitions, StringBuffer body, IDomainAdapter.Info info) {
            body.append(NLS.bind((String)Messages.LiveAnnotateUtil_4, (Object)XMLString.createFromPlainText((String)this.fAuthor.getContributor().getName()).getXMLText()));
            body.append(NLS.bind((String)Messages.LiveAnnotateUtil_5, (Object)DateFormat.getDateTimeInstance(2, 3).format(this.getDate())));
            body.append(NLS.bind((String)Messages.LiveAnnotateUtil_6, (Object)(this.fComment.equals("") ? Messages.LiveAnnotateUtil_8 : XMLString.createFromPlainText((String)this.fComment).getXMLText())));
            body.append(Messages.LiveAnnotateUtil_9);
            for (Object object : this.fReasons) {
                IDomainAdapter itemAdapter = DomainAdapterUtils.getDomainAdapter((Object)object);
                if (itemAdapter == null) continue;
                String link = Location.itemLocation((IItemHandle)((IItemHandle)object), (String)this.fAuthor.getRepository().getRepositoryURI()).toAbsoluteUri().toString();
                String generateTitle = XMLString.createFromPlainText((String)itemAdapter.generateTitle(object)).getXMLText();
                body.append("<br>");
                body.append("<a href='" + link + "'>" + generateTitle + "</a>");
            }
            for (IURIReference iURIReference : this.oslcReferences) {
                body.append("<br>");
                body.append("<a href='" + iURIReference.getURI().toString() + "'>" + iURIReference.getComment() + "</a>");
            }
            body.append("<br>");
        }

        private void generateHead(HashMap map, IDomainAdapter.Info info) {
            FontData font = JFaceResources.getDefaultFont().getFontData()[0];
            StringBuffer css = new StringBuffer();
            css.append("<style type=\"text/css\">\n");
            css.append("body { overflow: auto; ").append(MarkupUtil.getFont((String)font.getName(), (int)font.getHeight())).append(" }\n");
            if (info.isHoverTooltip) {
                css.append("a:link { text-decoration: none; color: black; }\n");
                css.append("a:visited { color: black; text-decoration: none; }\n");
            } else {
                css.append("a:link { color: #0000FF; text-decoration: none; }\n");
                css.append("a:visited { color: #0000FF; text-decoration: none; }\n");
            }
            css.append("a:hover { color: #000080; text-decoration: underline; }\n");
            css.append("</style>\n");
            map.put("css", css.toString());
        }

        public RGB getColor() {
            return this.rgb;
        }

        public String getId() {
            return this.id;
        }

        public Date getDate() {
            return this.fSet.getLastChangeDate();
        }
    }
}

