/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.ide.ui.internal.actions.load.LoadAction;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JoinOperation
extends RepositoryOperation {
    private Display display;
    private Shell shell;
    private ITeamRepository streamRepo;
    private ItemId<IWorkspace> streamId;
    private ITeamRepository repo;
    private String workspaceName;
    private String description;
    private List componentsToAdd;
    private Boolean allComponentsChosen;
    private Boolean loadWorkspace;
    private IPartResult<AbstractPlaceWrapper> partResult;
    private final IReadScope scope;

    public static IWorkspaceConnection createWorkspace(ITeamRepository repo, IWorkspaceConnection stream, String workspaceName, String description, IReadScope scope, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceManager wsManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IWorkspaceConnection workspace = wsManager.createWorkspace((IContributorHandle)repo.loggedInContributor(), workspaceName, description, stream, stream, (IProgressMonitor)progress.newChild(90));
        workspace.setOwnerAndVisibility(IScmService.NOOP_OWNER, scope, (IProgressMonitor)progress.newChild(3));
        JoinOperation.addTemplateFlows(workspace, stream, (IProgressMonitor)progress.newChild(7));
        return workspace;
    }

    private static void addTemplateFlows(IWorkspaceConnection workspace, IWorkspaceConnection stream, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = workspace.getFlowTable().getWorkingCopy();
        FlowTableUtil.addCollaboration((IFlowTable)flowTable, (IWorkspaceConnection)workspace, (IWorkspaceConnection)stream);
        workspace.setFlowTable(flowTable, monitor);
    }

    public static IWorkspaceConnection createWorkspace(ITeamRepository repo, IWorkspaceConnection stream, String workspaceName, String description, IReadScope scope, List components, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceManager wsManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        ArrayList<IWorkspace> parentFlow = new ArrayList<IWorkspace>();
        parentFlow.add(stream.getResolvedWorkspace());
        IWorkspaceConnection workspace = wsManager.createWorkspace((IContributorHandle)repo.loggedInContributor(), workspaceName, description, stream, null, (IProgressMonitor)progress.newChild(10));
        SubMonitor componentsProgress = progress.newChild(80);
        componentsProgress.setWorkRemaining(components.size());
        IFlowNodeConnection.IComponentOpFactory factory = workspace.componentOpFactory();
        ArrayList<IFlowNodeConnection.IComponentAdditionOp> compAdds = new ArrayList<IFlowNodeConnection.IComponentAdditionOp>();
        for (IComponentHandle handle : components) {
            compAdds.add(factory.addComponent(handle, (IConnection)stream, false));
        }
        workspace.applyComponentOperations(compAdds, (IProgressMonitor)componentsProgress.newChild(1));
        workspace.setOwnerAndVisibility(IScmService.NOOP_OWNER, scope, (IProgressMonitor)progress.newChild(3));
        JoinOperation.addTemplateFlows(workspace, stream, (IProgressMonitor)progress.newChild(7));
        return workspace;
    }

    public JoinOperation(Shell shell, ITeamRepository repo, ITeamRepository streamRepo, ItemId<IWorkspace> streamId, String workspaceName, String description, IReadScope scope, List componentsToAdd, Boolean allComponentsChosen, Boolean loadWorkspace) {
        super(JoinOperation.createRepoSet(repo, streamRepo));
        this.shell = shell;
        this.display = shell.getDisplay();
        this.streamRepo = streamRepo;
        this.streamId = streamId;
        this.repo = repo;
        this.workspaceName = workspaceName;
        this.description = description;
        this.componentsToAdd = componentsToAdd;
        this.allComponentsChosen = allComponentsChosen;
        this.loadWorkspace = loadWorkspace;
        this.scope = scope;
    }

    private static HashSet<ITeamRepository> createRepoSet(ITeamRepository repo, ITeamRepository streamRepo) {
        HashSet<ITeamRepository> set = new HashSet<ITeamRepository>();
        set.add(repo);
        set.add(streamRepo);
        return set;
    }

    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.JoinOperation_1, (Object)this.workspaceName), (int)100);
        IWorkspaceConnection stream = SCMPlatform.getWorkspaceManager((ITeamRepository)this.streamRepo).getWorkspaceConnection((IWorkspaceHandle)this.streamId.toHandle(), (IProgressMonitor)progress.newChild(20));
        progress.setWorkRemaining(100);
        final IWorkspaceConnection workspace = this.allComponentsChosen != false ? JoinOperation.createWorkspace(this.repo, stream, this.workspaceName, this.description, this.scope, (IProgressMonitor)progress.newChild(90)) : JoinOperation.createWorkspace(this.repo, stream, this.workspaceName, this.description, this.scope, this.componentsToAdd, (IProgressMonitor)progress.newChild(90));
        if (this.partResult != null) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    JoinOperation.this.partResult.setResult((Object)AbstractPlaceWrapper.newWrapper(workspace.getResolvedWorkspace()));
                }
            });
        }
        if (this.loadWorkspace.booleanValue()) {
            LoadAction.checkout(this.display, this.shell, workspace, workspace.getComponents(), (IOperationRunner)new JobRunner(true), (IProgressMonitor)progress.newChild(10));
        }
        progress.done();
    }

    public void setPartResult(IPartResult<AbstractPlaceWrapper> partResult) {
        this.partResult = partResult;
    }
}

