/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.load.LoadAction;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.ui.actions.teamplace.UnloadAction;
import com.ibm.team.filesystem.ui.views.CollaborationEntry;
import com.ibm.team.filesystem.ui.views.ComponentEntry;
import com.ibm.team.filesystem.ui.views.TeamPlaceWorkingCopy;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.IgnoreOutOfSyncOnUpdate;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentDetails;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentDetailsFunction;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ReadScopeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class EditWorkspaceOperation
extends RepositoryOperation {
    private TeamPlaceWorkingCopy workingCopy;
    private List<IUpdateReport> updateReports = new ArrayList<IUpdateReport>();
    private IVerifyInSyncOperation verifyOp;
    private UpdateDilemmaHandler updateProblemHandler;
    private List<ComponentEntry> componentAdditions;
    private List<ComponentEntry> componentRemovals;
    private List<ComponentEntry> componentReplacements;
    private List<ComponentEntry> componentUpdates;

    public static IFlowNodeConnection.IComponentOp getAdditionOp(IWorkspaceConnection workspace, IAuditableHandle customOwnerHandle, ComponentEntry entry, SubMonitor progress) throws TeamRepositoryException {
        progress.setWorkRemaining(2);
        IComponent component = EditWorkspaceOperation.getSourceComponent(entry);
        if (component != null) {
            IConnection seed = EditWorkspaceOperation.getSeed(entry, progress.newChild(1));
            return workspace.componentOpFactory().addComponent((IComponentHandle)component, seed, false);
        }
        progress.setWorkRemaining(1);
        ITeamRepository repo = workspace.teamRepository();
        IAuditableHandle ownerHandle = customOwnerHandle != null ? customOwnerHandle : WorkspaceUtil.getComponentOwner(workspace);
        component = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).createComponent(entry.getName(), ownerHandle, (IProgressMonitor)progress.newChild(1));
        return workspace.componentOpFactory().addComponent((IComponentHandle)component, false);
    }

    private static IFlowNodeConnection.IComponentOp getComponentRemovalOp(IWorkspaceConnection connection, ComponentEntry entry) {
        return connection.componentOpFactory().removeComponent((IComponentHandle)entry.getComponent().getComponent(), false);
    }

    private static IFlowNodeConnection.IComponentOp getComponentReplacementOp(IWorkspaceConnection connection, ComponentEntry entry, SubMonitor progress) throws TeamRepositoryException {
        IComponent component = EditWorkspaceOperation.getSourceComponent(entry);
        Assert.isNotNull((Object)component);
        IConnection seed = EditWorkspaceOperation.getSeed(entry, progress);
        return connection.componentOpFactory().replaceComponent((IComponentHandle)component, seed, true);
    }

    public static IConnection getSeed(ComponentEntry entry, SubMonitor progress) throws TeamRepositoryException {
        if (entry.getSourceBaseline() != null) {
            return entry.getSourceBaseline().getBaselineConnection((IProgressMonitor)progress);
        }
        if (entry.getSourceComponent() != null) {
            return entry.getSourceComponent().getWorkspaceConnection();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static IComponent getSourceComponent(ComponentEntry entry) {
        if (entry.getSourceBaseline() != null) {
            return entry.getSourceBaseline().getComponent();
        }
        if (entry.getSourceComponent() != null) {
            return entry.getSourceComponent().getComponent();
        }
        return null;
    }

    public EditWorkspaceOperation(TeamPlaceWorkingCopy workingCopy, UpdateDilemmaHandler updateProblemHandler) {
        this.workingCopy = workingCopy;
        this.updateProblemHandler = updateProblemHandler == null ? UpdateDilemmaHandler.getDefault() : updateProblemHandler;
        Assert.isNotNull((Object)((Object)workingCopy.getWorkspaceWrapper()));
        this.verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.updateProblemHandler.getOutOfSyncDilemmaHandler());
    }

    private void partitionEntries() {
        this.componentUpdates = new ArrayList<ComponentEntry>(this.workingCopy.getComponentsToUpdate());
        this.componentAdditions = new ArrayList<ComponentEntry>();
        this.componentRemovals = new ArrayList<ComponentEntry>();
        this.componentReplacements = new ArrayList<ComponentEntry>();
        HashSet<IComponent> replacedComponents = new HashSet<IComponent>();
        for (ComponentEntry entry : this.workingCopy.getComponentsToAdd()) {
            IComponent sourceComponent = EditWorkspaceOperation.getSourceComponent(entry);
            if (sourceComponent != null && this.workingCopy.isReplacement(sourceComponent)) {
                this.componentReplacements.add(entry);
                replacedComponents.add(sourceComponent);
                continue;
            }
            this.componentAdditions.add(entry);
        }
        for (ComponentEntry entry : this.workingCopy.getComponentsToRemove()) {
            if (replacedComponents.contains(entry.getComponent().getComponent())) continue;
            this.componentRemovals.add(entry);
        }
    }

    private void doComponentOps(boolean preflight, IWorkspaceConnection connection, SubMonitor progress) throws FileSystemException, TeamRepositoryException {
        if (preflight) {
            for (ComponentEntry entry : this.componentReplacements) {
                this.verifyOp.addToVerify((IConnection)connection, (IComponentHandle)EditWorkspaceOperation.getSourceComponent(entry));
            }
            return;
        }
        progress.setWorkRemaining(100);
        SubMonitor collectProgress = progress.newChild(50);
        collectProgress.setWorkRemaining(this.componentAdditions.size() + this.componentReplacements.size());
        LinkedHashMap<ComponentEntry, IFlowNodeConnection.IComponentOp> opMap = new LinkedHashMap<ComponentEntry, IFlowNodeConnection.IComponentOp>();
        IAuditable customOwnerHandle = null;
        if (this.workingCopy != null && this.workingCopy.getOwner() instanceof IContributorHandle || this.workingCopy.getOwner() instanceof IProcessAreaHandle) {
            customOwnerHandle = this.workingCopy.getOwner();
        }
        for (ComponentEntry entry : this.componentAdditions) {
            opMap.put(entry, EditWorkspaceOperation.getAdditionOp(connection, (IAuditableHandle)customOwnerHandle, entry, collectProgress.newChild(1)));
        }
        for (ComponentEntry entry : this.componentRemovals) {
            opMap.put(entry, EditWorkspaceOperation.getComponentRemovalOp(connection, entry));
        }
        for (ComponentEntry entry : this.componentReplacements) {
            opMap.put(entry, EditWorkspaceOperation.getComponentReplacementOp(connection, entry, collectProgress.newChild(1)));
        }
        IUpdateReport report = this.applyComponentOps(connection, opMap, progress.newChild(50));
        if (report != null) {
            this.updateReports.add(report);
        }
    }

    private void loadComponentsIfNeeded(IWorkspaceConnection connection, List<ComponentEntry> entriesToLoad, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (entriesToLoad.isEmpty()) {
            return;
        }
        ArrayList<IComponent> componentHandles = new ArrayList<IComponent>();
        for (ComponentEntry entry : entriesToLoad) {
            componentHandles.add(entry.getComponent().getComponent());
        }
        if (this.workingCopy.getLoadOnSave()) {
            LoadAction.checkout(this.workingCopy.getShell().getDisplay(), this.workingCopy.getShell(), connection, componentHandles, this.workingCopy.getOperationRunner(), monitor);
        }
    }

    private IUpdateReport applyComponentOps(IWorkspaceConnection connection, Map<ComponentEntry, IFlowNodeConnection.IComponentOp> opMap, SubMonitor progress) throws TeamRepositoryException {
        if (!opMap.isEmpty()) {
            progress.setWorkRemaining(20);
            ArrayList<IFlowNodeConnection.IComponentOp> ops = new ArrayList<IFlowNodeConnection.IComponentOp>(opMap.values());
            IUpdateReport report = connection.applyComponentOperations(ops, true, (IProgressMonitor)progress.newChild(10));
            ArrayList<ComponentWrapper> wrappers = new ArrayList<ComponentWrapper>();
            for (Map.Entry<ComponentEntry, IFlowNodeConnection.IComponentOp> e : opMap.entrySet()) {
                ComponentEntry entry = e.getKey();
                IFlowNodeConnection.IComponentOp op = e.getValue();
                if (!(op instanceof IFlowNodeConnection.IComponentAdditionOp) && !(op instanceof IFlowNodeConnection.IComponentReplacementOp)) continue;
                IComponent component = (IComponent)op.getComponent();
                ComponentWrapper wrapper = new ComponentWrapper(connection.teamRepository(), component);
                entry.setComponent(wrapper);
                wrappers.add(wrapper);
            }
            if (wrappers.size() > 0) {
                Map<ComponentWrapper, ComponentDetails> componentDetails = ComponentDetailsFunction.fetchComponentDetails(wrappers, (IProgressMonitor)progress.newChild(10));
                for (Map.Entry<ComponentEntry, IFlowNodeConnection.IComponentOp> e : opMap.entrySet()) {
                    ComponentEntry entry = e.getKey();
                    ComponentDetails details = componentDetails.get((Object)entry.getComponent());
                    if (details == null) continue;
                    entry.setDetails(details);
                }
            }
            progress.done();
            return report;
        }
        return null;
    }

    private void doComponentPropertyUpdate(IWorkspaceConnection connection, ComponentEntry entry, SubMonitor progress) throws TeamRepositoryException {
        ComponentDetails details;
        IComponent component = entry.getComponent().getComponent();
        String oldName = component.getName();
        String name = entry.getName();
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)connection.teamRepository());
        if (!name.equals(oldName)) {
            mgr.renameComponent((IComponentHandle)component, name, (IProgressMonitor)progress);
        }
        if ((details = entry.getDetails()).getOwner() != null && details.hasOwnerChanged()) {
            mgr.setComponentOwner((IComponentHandle)entry.getBackingComponentItem(), (IAuditableHandle)details.getOwner().getItem(), (IProgressMonitor)progress);
            details.reset();
        }
    }

    private void doWorkspaceRename(IWorkspaceConnection connection, SubMonitor progress) throws TeamRepositoryException {
        String oldName = connection.getName();
        String name = this.workingCopy.getPlaceName();
        if (name != null && !name.equals(oldName)) {
            connection.setName(name, (IProgressMonitor)progress);
        }
    }

    private void doDescriptionChange(IWorkspaceConnection connection, SubMonitor progress) throws TeamRepositoryException {
        String desc;
        String oldDesc = connection.getDescription();
        if (oldDesc == null) {
            oldDesc = "";
        }
        if ((desc = this.workingCopy.getDescription()) != null && !desc.equals(oldDesc)) {
            connection.setDescription(desc, (IProgressMonitor)progress);
        }
    }

    private void doUpdateWorkspaceOwnerAndVisibility(IWorkspaceConnection connection, SubMonitor progress) throws TeamRepositoryException {
        ItemId oldOwner = new ItemId((IItemHandle)connection.getOwner());
        ItemId newOwner = new ItemId((IItemHandle)this.workingCopy.getOwner());
        IReadScope oldReadScope = connection.getReadScope();
        IReadScope newReadScope = this.workingCopy.getReadScope();
        if (!oldOwner.equals((Object)newOwner) || !ReadScopeUtils.equals((IReadScope)newReadScope, (IReadScope)oldReadScope)) {
            connection.setOwnerAndVisibility((IAuditableHandle)this.workingCopy.getOwner(), newReadScope, (IProgressMonitor)progress);
        }
    }

    private void doAutoLockPatternsChange(IWorkspaceConnection connection, SubMonitor progress) throws TeamRepositoryException {
        String pattern;
        String oldPattern = connection.getExclusiveFileLockPatterns();
        if (oldPattern == null) {
            oldPattern = "";
        }
        if ((pattern = this.workingCopy.getAutoLockPatterns()) != null && !pattern.equals(oldPattern)) {
            connection.setExclusiveFileLockPatterns(pattern, (IProgressMonitor)progress);
        }
    }

    private void doUpdateCollaborations(IWorkspaceConnection connection, SubMonitor progress) throws TeamRepositoryException {
        boolean currentOutgoingChanged;
        boolean currentIncomingChanged;
        ConnectionDescriptor oldCurrentConnection;
        IWorkspaceHandle defaultWorkspaceHandle;
        IWorkspace defaultCollabWorkspace;
        List<CollaborationEntry> collaborationsToUpdate;
        List<CollaborationEntry> collaborationsToAdd;
        progress.setWorkRemaining(100);
        IFlowTable flowTable = connection.getFlowTable().getWorkingCopy();
        boolean changed = false;
        List<CollaborationEntry> collaborationsToRemove = this.workingCopy.getCollaborationsToRemove();
        if (collaborationsToRemove.size() > 0) {
            for (CollaborationEntry entry : collaborationsToRemove) {
                FlowTableUtil.removeCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)entry.getHandle());
            }
            changed = true;
        }
        if ((collaborationsToAdd = this.workingCopy.getCollaborationsToAdd()).size() > 0) {
            SubMonitor addProgress = progress.newChild(55);
            addProgress.setWorkRemaining(collaborationsToAdd.size());
            for (CollaborationEntry entry : collaborationsToAdd) {
                if (entry.isDeleted()) continue;
                IWorkspaceConnection remote = entry.getCollaboration().getWorkspaceConnection((IProgressMonitor)addProgress.newChild(1));
                if ((entry.getFlowDirection() & 0xF) == 3) {
                    FlowTableUtil.addCollaboration((IFlowTable)flowTable, (IWorkspaceConnection)connection, (IWorkspaceConnection)remote);
                } else {
                    if ((entry.getFlowDirection() & 0xF) == 1) {
                        FlowTableUtil.addIncomingCollaboration((IFlowTable)flowTable, (IWorkspaceConnection)connection, (IWorkspaceConnection)remote);
                    }
                    if ((entry.getFlowDirection() & 0xF) == 2) {
                        FlowTableUtil.addOutgoingCollaboration((IFlowTable)flowTable, (IWorkspaceConnection)connection, (IWorkspaceConnection)remote);
                    }
                }
                flowTable.setComponentScopes((IFlowNodeHandle)entry.getCollaboration().getWorkspace(), entry.getComponentScopes());
                changed = true;
            }
        }
        if ((collaborationsToUpdate = this.workingCopy.getCollaborationsToUpdate()).size() > 0) {
            for (CollaborationEntry entry : collaborationsToUpdate) {
                if (entry.isDeleted()) continue;
                IFlowEntry acceptFlowEntry = flowTable.getAcceptFlow((IFlowNodeHandle)entry.getCollaboration().getWorkspace());
                IFlowEntry deliverFlowEntry = flowTable.getDeliverFlow((IFlowNodeHandle)entry.getCollaboration().getWorkspace());
                if ((entry.getFlowDirection() & 0xF) == 3) {
                    if (acceptFlowEntry == null) {
                        flowTable.addAcceptFlow((IFlowNodeHandle)entry.getCollaboration().getWorkspace(), entry.getCollaboration().getRepository().getId(), entry.getCollaboration().getRepository().getRepositoryURI(), entry.getComponentScopes(), null);
                    }
                    if (deliverFlowEntry == null) {
                        flowTable.addDeliverFlow((IFlowNodeHandle)entry.getCollaboration().getWorkspace(), entry.getCollaboration().getRepository().getId(), entry.getCollaboration().getRepository().getRepositoryURI(), entry.getComponentScopes(), null);
                    }
                } else if ((entry.getFlowDirection() & 0xF) == 1) {
                    if (acceptFlowEntry == null) {
                        flowTable.addAcceptFlow((IFlowNodeHandle)entry.getCollaboration().getWorkspace(), entry.getCollaboration().getRepository().getId(), entry.getCollaboration().getRepository().getRepositoryURI(), entry.getComponentScopes(), null);
                    }
                    if (deliverFlowEntry != null) {
                        FlowTableUtil.removeOutgoingCollaboration((IFlowTable)flowTable, (IFlowNodeHandle)entry.getCollaboration().getWorkspace(), (IProgressMonitor)progress.newChild(5));
                    }
                } else if ((entry.getFlowDirection() & 0xF) == 2) {
                    if (deliverFlowEntry == null) {
                        flowTable.addDeliverFlow((IFlowNodeHandle)entry.getCollaboration().getWorkspace(), entry.getCollaboration().getRepository().getId(), entry.getCollaboration().getRepository().getRepositoryURI(), entry.getComponentScopes(), null);
                    }
                    if (acceptFlowEntry != null) {
                        FlowTableUtil.removeIncomingCollaboration((IFlowTable)flowTable, (IFlowNodeHandle)entry.getCollaboration().getWorkspace(), (IProgressMonitor)progress.newChild(5));
                    }
                }
                flowTable.setComponentScopes((IFlowNodeHandle)entry.getCollaboration().getWorkspace(), entry.getComponentScopes());
                changed = true;
            }
        }
        CollaborationEntry defaultCollabEntry = this.workingCopy.getDefaultIncomingCollaboration();
        ConnectionDescriptor defaultFlowTarget = FlowTableUtil.getDefaultIncomingCollaborationDescriptor((IFlowTable)flowTable, (ITeamRepository)connection.teamRepository());
        if (defaultCollabEntry != null && !defaultCollabEntry.isDeleted()) {
            defaultCollabWorkspace = defaultCollabEntry.getCollaboration().getWorkspace();
            if (!defaultCollabWorkspace.sameItemId((IItemHandle)(defaultFlowTarget == null ? null : defaultFlowTarget.connectionHandle))) {
                defaultWorkspaceHandle = (IWorkspaceHandle)defaultCollabWorkspace.getItemHandle();
                FlowTableUtil.setDefaultIncomingCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)defaultWorkspaceHandle);
                changed = true;
            }
        } else if (defaultCollabEntry == null && defaultFlowTarget != null) {
            FlowTableUtil.setDefaultIncomingCollaboration((IFlowTable)flowTable, null);
            changed = true;
        }
        defaultCollabEntry = this.workingCopy.getDefaultOutgoingCollaboration();
        defaultFlowTarget = FlowTableUtil.getDefaultOutgoingCollaborationDescriptor((IFlowTable)flowTable, (ITeamRepository)connection.teamRepository());
        if (defaultCollabEntry != null && !defaultCollabEntry.isDeleted()) {
            defaultCollabWorkspace = defaultCollabEntry.getCollaboration().getWorkspace();
            if (!defaultCollabWorkspace.sameItemId((IItemHandle)(defaultFlowTarget == null ? null : defaultFlowTarget.connectionHandle))) {
                defaultWorkspaceHandle = (IWorkspaceHandle)defaultCollabWorkspace.getItemHandle();
                FlowTableUtil.setDefaultOutgoingCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)defaultWorkspaceHandle);
                changed = true;
            }
        } else if (defaultCollabEntry == null && defaultFlowTarget != null) {
            FlowTableUtil.setDefaultOutgoingCollaboration((IFlowTable)flowTable, null);
            changed = true;
        }
        IWorkspace newCurrentIncomingWorkspace = null;
        CollaborationEntry currentIncomingCollabEntry = this.workingCopy.getCurrentIncomingCollaboration();
        if (currentIncomingCollabEntry != null && !currentIncomingCollabEntry.isDeleted()) {
            newCurrentIncomingWorkspace = currentIncomingCollabEntry.getCollaboration().getWorkspace();
        }
        boolean bl = ((oldCurrentConnection = FlowTableUtil.getCurrentIncomingCollaborationDescriptor((IWorkspaceConnection)connection)) == null ? newCurrentIncomingWorkspace == null : oldCurrentConnection.connectionHandle.sameItemId((IItemHandle)newCurrentIncomingWorkspace)) ? false : (currentIncomingChanged = true);
        if (currentIncomingChanged) {
            FlowTableUtil.setCurrentIncomingCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)newCurrentIncomingWorkspace);
            changed = true;
        }
        IWorkspace newCurrentOutgoingWorkspace = null;
        CollaborationEntry currentOutgoingCollabEntry = this.workingCopy.getCurrentOutgoingCollaboration();
        if (currentOutgoingCollabEntry != null && !currentOutgoingCollabEntry.isDeleted()) {
            newCurrentOutgoingWorkspace = currentOutgoingCollabEntry.getCollaboration().getWorkspace();
        }
        boolean bl2 = ((oldCurrentConnection = FlowTableUtil.getCurrentOutgoingCollaborationDescriptor((IWorkspaceConnection)connection)) == null ? newCurrentOutgoingWorkspace == null : oldCurrentConnection.connectionHandle.sameItemId((IItemHandle)newCurrentOutgoingWorkspace)) ? false : (currentOutgoingChanged = true);
        if (currentOutgoingChanged) {
            FlowTableUtil.setCurrentOutgoingCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)newCurrentOutgoingWorkspace);
            changed = true;
        }
        if (changed) {
            connection.setFlowTable(flowTable, (IProgressMonitor)progress.newChild(25));
        }
        if (currentIncomingChanged) {
            IWorkspaceConnection newCurrentIncomingConnection = newCurrentIncomingWorkspace == null ? null : currentIncomingCollabEntry.getCollaboration().getWorkspaceConnection((IProgressMonitor)progress.newChild(5));
            FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceIncomingCollaboration((IWorkspaceHandle)connection.getResolvedWorkspace(), newCurrentIncomingConnection, false, (IProgressMonitor)progress.newChild(5));
        }
        if (currentOutgoingChanged) {
            IWorkspaceConnection newCurrentOutgoingConnection = newCurrentOutgoingWorkspace == null ? null : currentOutgoingCollabEntry.getCollaboration().getWorkspaceConnection((IProgressMonitor)progress.newChild(5));
            FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceOutgoingCollaboration((IWorkspaceHandle)connection.getResolvedWorkspace(), newCurrentOutgoingConnection, false, (IProgressMonitor)progress.newChild(5));
        }
    }

    private void doComponentPropertyUpdates(IWorkspaceConnection connection, SubMonitor progress) throws FileSystemException, TeamRepositoryException {
        progress.setWorkRemaining(this.componentUpdates.size());
        for (ComponentEntry entry : this.componentUpdates) {
            this.doComponentPropertyUpdate(connection, entry, progress.newChild(1));
        }
    }

    private void doProjectUnshares(IWorkspaceConnection connection, SubMonitor progress) throws FileSystemException, TeamRepositoryException {
        progress.setWorkRemaining(100);
        ArrayList<ConfigurationFacade> configurationsToUnshare = new ArrayList<ConfigurationFacade>();
        for (ComponentEntry entry : this.componentRemovals) {
            configurationsToUnshare.add(new ConfigurationFacade((IConnection)connection, (IComponentHandle)entry.getBackingComponentItem()));
        }
        if (!configurationsToUnshare.isEmpty()) {
            IUnshareOperation op = IOperationFactory.instance.getUnshareOperation(UnloadAction.getUnshareDilemmaHandler(), IRepositoryResolver.EXISTING_SHARED);
            op.requestUnshare(configurationsToUnshare);
            op.setDeleteContent(false);
            op.run((IProgressMonitor)progress.newChild(100));
        } else {
            progress.worked(100);
        }
    }

    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException {
        IWorkspaceConnection connection = this.workingCopy.getWorkspaceConnection();
        Assert.isNotNull((Object)connection);
        String jobName = connection.isStream() ? Messages.EditWorkspaceOperation_savingStream : Messages.EditWorkspaceOperation_saving;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)jobName, (int)100);
        boolean refresh = connection.getComponents().size() == 0;
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite((IConnection)connection, (IProgressMonitor)progress.newChild(5));
        try {
            this.partitionEntries();
            this.editWorkspace(true, progress.newChild(15), connection);
            this.verifyOp.run((IProgressMonitor)progress.newChild(10));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.editWorkspace(false, progress.newChild(55), connection);
            connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)connection.getResolvedWorkspace(), 1, (IProgressMonitor)progress.newChild(5));
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
            progress.setWorkRemaining(10);
        }
        if (refresh) {
            FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncManager().update((IProgressMonitor)progress.newChild(10));
        }
        progress.done();
    }

    private void editWorkspace(boolean preflight, SubMonitor progress, IWorkspaceConnection connection) throws TeamRepositoryException, FileSystemException {
        boolean isWorkspace;
        progress.setWorkRemaining(preflight ? 20 : 60);
        if (!preflight) {
            this.doWorkspaceRename(connection, progress.newChild(3));
            this.doDescriptionChange(connection, progress.newChild(2));
            this.doAutoLockPatternsChange(connection, progress.newChild(2));
        }
        this.doComponentOps(preflight, connection, progress.newChild(20));
        if (!preflight) {
            this.doComponentPropertyUpdates(connection, progress.newChild(5));
        }
        if ((isWorkspace = this.workingCopy.isInMode(TeamPlaceWorkingCopy.MODE.EDIT_WORKSPACE)) && !preflight) {
            this.doProjectUnshares(connection, progress.newChild(10));
        }
        if (!preflight) {
            this.doUpdateCollaborations(connection, progress.newChild(5));
        }
        if (isWorkspace && !preflight) {
            this.doEclipseWorkspaceUpdate(connection, (IProgressMonitor)progress.newChild(7));
            this.loadComponentsIfNeeded(connection, this.componentAdditions, (IProgressMonitor)progress.newChild(3));
        }
        if (!isWorkspace && !preflight) {
            this.doUpdateCustomAttributes(connection, progress.newChild(1));
        }
        if (!preflight) {
            this.doUpdateWorkspaceOwnerAndVisibility(connection, progress.newChild(3));
        }
        progress.done();
    }

    private void doUpdateCustomAttributes(IWorkspaceConnection connection, SubMonitor monitor) throws TeamRepositoryException {
        if (this.workingCopy.isCustomAttributesChanged()) {
            connection.setCustomAttributes(this.workingCopy.getCustomAttributesToAdd(), this.workingCopy.getCustomAttributesToRemove(), (IProgressMonitor)monitor);
        }
    }

    private void doEclipseWorkspaceUpdate(IWorkspaceConnection connection, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (!this.updateReports.isEmpty()) {
            try {
                ArrayList<IComponent> toExclude = new ArrayList<IComponent>();
                for (ComponentEntry entry : this.componentAdditions) {
                    toExclude.add(entry.getComponent().getComponent());
                }
                for (ComponentEntry entry : this.componentRemovals) {
                    toExclude.add(entry.getComponent().getComponent());
                }
                IgnoreOutOfSyncOnUpdate ignoreSyncs = new IgnoreOutOfSyncOnUpdate(this.updateProblemHandler);
                ArrayList<IUpdateReport> reportsToApply = new ArrayList<IUpdateReport>(this.updateReports);
                this.updateReports.clear();
                UpdateOperation op = new UpdateOperation(connection, reportsToApply, toExclude, 3, (UpdateDilemmaHandler)ignoreSyncs, null);
                op.run(monitor);
            }
            catch (FileSystemStatusException e) {
                if (e.getStatus().getSeverity() <= 2) {
                    StatusUtil.log((Object)((Object)this), (String)Messages.EditWorkspaceOperation_updateWarning, (Throwable)e);
                }
                throw e;
            }
        }
    }

    public static Collection<ConfigurationFacade> getComponentSources(List<ComponentEntry> componentEntries, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)componentEntries.size());
        ArrayList<ConfigurationFacade> descriptors = new ArrayList<ConfigurationFacade>(componentEntries.size());
        for (ComponentEntry entry : componentEntries) {
            IComponent component = EditWorkspaceOperation.getSourceComponent(entry);
            if (component != null) {
                IConnection seed = EditWorkspaceOperation.getSeed(entry, progress.newChild(1));
                if (seed instanceof IWorkspaceConnection) {
                    descriptors.add(new ConfigurationFacade(seed, (IComponentHandle)component));
                    continue;
                }
                if (!(seed instanceof IBaselineConnection)) continue;
                descriptors.add(new ConfigurationFacade((IBaselineConnection)seed));
                continue;
            }
            progress.worked(1);
        }
        return descriptors;
    }
}

