/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.operations;

import com.ibm.team.filesystem.ui.views.TeamPlaceWorkingCopy;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class EditSnapshotOperation
implements Operation {
    private TeamPlaceWorkingCopy workingCopy;

    public EditSnapshotOperation(TeamPlaceWorkingCopy workingCopy) {
        this.workingCopy = workingCopy;
        Assert.isNotNull((Object)workingCopy.getOriginalSnapshot());
    }

    private void doSnapshotRename(IBaselineSet snapshot, IProgressMonitor monitor) throws TeamRepositoryException {
        String oldName = this.workingCopy.getOriginalPlaceName();
        String newName = this.workingCopy.getPlaceName();
        if (newName != null && !newName.equals(oldName)) {
            IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)this.workingCopy.getRepository());
            mgr.setName((IBaselineSetHandle)snapshot, newName, monitor);
        }
    }

    private void doSnapshotDescriptionChange(IBaselineSet snapshot, IProgressMonitor monitor) throws TeamRepositoryException {
        String oldDesc = this.workingCopy.getOriginalDescription();
        String newDesc = this.workingCopy.getDescription();
        if (newDesc != null && !newDesc.equals(oldDesc)) {
            IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)this.workingCopy.getRepository());
            mgr.setComment((IBaselineSetHandle)snapshot, newDesc, monitor);
        }
    }

    private void doSnapshotOwnerChange(IBaselineSet snapshot, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection connection;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspace oldOwner = this.workingCopy.getOriginalSnapshotOwner();
        IWorkspace newOwner = this.workingCopy.getSnapshotOwner();
        if (newOwner != null && !newOwner.sameItemId((IItemHandle)oldOwner) && (connection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.workingCopy.getRepository()).getWorkspaceConnection((IWorkspaceHandle)newOwner, (IProgressMonitor)progress.newChild(50))) != null) {
            connection.addBaselineSet((IBaselineSetHandle)snapshot, (IProgressMonitor)progress.newChild(50));
        }
        progress.done();
    }

    private void doUpdateCustomAttributes(IBaselineSet snapshot, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.workingCopy.isCustomAttributesChanged() && this.workingCopy.getSnapshotOwner() != null && this.workingCopy.getSnapshotOwner().isStream()) {
            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)this.workingCopy.getRepository());
            wm.setCustomAttributes((IBaselineSetHandle)snapshot, this.workingCopy.getCustomAttributesToAdd(), this.workingCopy.getCustomAttributesToRemove(), monitor);
        }
    }

    public void run(IProgressMonitor monitor, IStatusCollector collector) throws OperationFailedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.EditSnapshotOperation_0, (int)100);
        IBaselineSet snapshot = this.workingCopy.getOriginalSnapshot();
        try {
            this.doSnapshotRename(snapshot, (IProgressMonitor)progress.newChild(25));
            this.doSnapshotDescriptionChange(snapshot, (IProgressMonitor)progress.newChild(25));
            this.doSnapshotOwnerChange(snapshot, (IProgressMonitor)progress.newChild(25));
            this.doUpdateCustomAttributes(snapshot, (IProgressMonitor)progress.newChild(25));
        }
        catch (TeamRepositoryException e) {
            throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }
}

