/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.operations;

import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentWorkingCopy;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.util.ReadScopeUtils;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class EditComponentOperation
extends RepositoryOperation {
    private ComponentWorkingCopy fWorkingCopy;

    public EditComponentOperation(ComponentWorkingCopy workingCopy) {
        Assert.isNotNull((Object)((Object)workingCopy.getComponentWrapper()));
        this.fWorkingCopy = workingCopy;
    }

    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
        if (this.fWorkingCopy.getComponentWrapper() != null) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.EditComponentOperation_SavingComponent, (int)100);
            ITeamRepository repo = this.fWorkingCopy.getComponentWrapper().getRepository();
            IComponent component = this.fWorkingCopy.getComponentWrapper().getComponent();
            IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            String oldName = this.fWorkingCopy.getOriginalComponentName();
            String newName = this.fWorkingCopy.getComponentName();
            if (newName != null && !newName.equals(oldName)) {
                mgr.renameComponent((IComponentHandle)component, newName, (IProgressMonitor)progress.newChild(30));
            }
            progress.setWorkRemaining(70);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            boolean needsOwnerUpdate = false;
            IAuditable oldOwner = this.fWorkingCopy.getOriginalComponentOwner();
            IAuditable newOwner = this.fWorkingCopy.getComponentOwner();
            if (newOwner != null && !newOwner.sameItemId((IItemHandle)oldOwner)) {
                needsOwnerUpdate = true;
            }
            boolean needsVisibilityUpdate = false;
            IReadScope newReadScope = this.fWorkingCopy.getComponentReadScope();
            IReadScope oldReadScope = this.fWorkingCopy.getOriginalComponentReadScope();
            if (newReadScope != null && !ReadScopeUtils.equals((IReadScope)newReadScope, (IReadScope)oldReadScope)) {
                needsVisibilityUpdate = true;
            } else if (needsOwnerUpdate && newReadScope == null) {
                newReadScope = oldReadScope;
            }
            if (needsOwnerUpdate) {
                mgr.setComponentOwnerAndVisibility((IComponentHandle)component, (IAuditableHandle)newOwner, newReadScope, (IProgressMonitor)progress.newChild(30));
            } else if (needsVisibilityUpdate) {
                mgr.setComponentOwnerAndVisibility((IComponentHandle)component, IScmService.NOOP_OWNER, newReadScope, (IProgressMonitor)progress.newChild(30));
            }
            progress.setWorkRemaining(40);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            repo.itemManager().refreshSharedItems(Collections.unmodifiableList(Arrays.asList(component)), (IProgressMonitor)progress.newChild(40));
            progress.setWorkRemaining(0);
        }
    }
}

