/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.operations;

import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineEditorWorkingCopy;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class EditBaselineOperation
extends RepositoryOperation {
    private BaselineEditorWorkingCopy fWorkingCopy;

    public EditBaselineOperation(BaselineEditorWorkingCopy workingCopy) {
        Assert.isNotNull((Object)workingCopy.getBaselineWrapper());
        this.fWorkingCopy = workingCopy;
    }

    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
        BaselineWrapper wrapper = this.fWorkingCopy.getBaselineWrapper();
        if (wrapper != null) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.EditBaselineOperation_JobName, (int)105);
            ITeamRepository repo = wrapper.getRepository();
            if (!repo.loggedIn()) {
                repo.login((IProgressMonitor)progress.newChild(5));
            }
            progress.setWorkRemaining(100);
            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            IBaseline baseline = wrapper.getBaseline();
            IBaselineConnection connection = wm.getBaselineConnection(baseline, (IProgressMonitor)progress.newChild(20));
            String oldName = this.fWorkingCopy.getOriginalBaselineName();
            String newName = this.fWorkingCopy.getBaselineName();
            if (newName != null && !NullUtil.equals((Object)oldName, (Object)newName)) {
                connection.setName(newName, (IProgressMonitor)progress.newChild(20));
            }
            progress.setWorkRemaining(60);
            String oldDescription = this.fWorkingCopy.getOriginalDescription();
            String newDescription = this.fWorkingCopy.getDescription();
            if (newDescription != null && !NullUtil.equals((Object)oldDescription, (Object)newDescription)) {
                connection.setComment(newDescription, (IProgressMonitor)progress.newChild(20));
            }
            progress.setWorkRemaining(40);
            if (this.fWorkingCopy.isCustomAttributesChanged()) {
                connection.setCustomAttributes(this.fWorkingCopy.getCustomAttributesToAdd(), this.fWorkingCopy.getCustomAttributesToRemove(), (IProgressMonitor)progress.newChild(20));
            }
            progress.setWorkRemaining(20);
            String oldTags = this.fWorkingCopy.getOriginalTags();
            String newTags = this.fWorkingCopy.getTags();
            if (newTags != null && !NullUtil.equals((Object)oldTags, (Object)newTags)) {
                connection.setTags(newTags, (IProgressMonitor)progress.newChild(10));
            }
            progress.setWorkRemaining(10);
            repo.itemManager().refreshSharedItems(Collections.unmodifiableList(Arrays.asList(baseline)), (IProgressMonitor)progress.newChild(10));
            progress.done();
        }
    }
}

