/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAutoResolveConflictsOperation;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class AutoResolveOperation
extends RepositoryOperation {
    private int conflictsResolvedCount;
    private Collection<IConflictItem> items;
    private final AutoResolveConflictsDilemmaHandler problemHandler;

    public AutoResolveOperation(Collection<IConflictItem> items, AutoResolveConflictsDilemmaHandler problemHandler) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        if (problemHandler == null) {
            throw new IllegalArgumentException();
        }
        this.items = items;
        this.problemHandler = problemHandler;
    }

    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.items.size());
        IAutoResolveConflictsOperation autoResolveConflictsOperation = IOperationFactory.instance.getAutoResolveConflictsOperation(this.problemHandler, IRepositoryResolver.EXISTING_SHARED);
        autoResolveConflictsOperation.setFileContentMerger(FileSystemResourcesPlugin.getConfiguredExternalFileContentMerger());
        for (IConflictItem conflict : this.items) {
            IComponentSyncContext context = conflict.getOutgoingActivitySource().getModel();
            IWorkspaceConnection connection = context.getWorkspaceSyncContext().getLocal();
            ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
            autoResolveConflictsOperation.autoResolveConflict(connection, conflictReport, conflict.getLogicalChange());
        }
        autoResolveConflictsOperation.run((IProgressMonitor)progress.newChild(this.items.size()));
        this.conflictsResolvedCount += autoResolveConflictsOperation.numberOfConflictsResolved();
        TeamRepositoryException[] teamRepositoryExceptions = new TeamRepositoryException[1];
        if (teamRepositoryExceptions[0] != null) {
            throw teamRepositoryExceptions[0];
        }
    }

    public int numberOfConflictsResolved() {
        return this.conflictsResolvedCount;
    }
}

