/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalConflict;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.LocalConflictDescriptor;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAutoResolveLocalConflictsOperation;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalConflictItem;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class AutoResolveLocalOperation
extends RepositoryOperation {
    private int conflictsResolvedCount;
    private Collection<ILocalConflictItem> items;
    private final BackupDilemmaHandler problemHandler;

    public AutoResolveLocalOperation(Collection<ILocalConflictItem> items, BackupDilemmaHandler problemHandler) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        if (problemHandler == null) {
            throw new IllegalArgumentException();
        }
        this.items = items;
        this.problemHandler = problemHandler;
    }

    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
        ITeamRepository repository;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.items.size());
        HashMap<UUID, ITeamRepository> repositories = new HashMap<UUID, ITeamRepository>();
        HashMap<UUID, IContextHandle> contextHandles = new HashMap<UUID, IContextHandle>();
        HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
        HashMap<ILocation, ISandbox> sandboxes = new HashMap<ILocation, ISandbox>();
        HashMap localConflictItems = new HashMap();
        for (ILocalConflictItem iLocalConflictItem : this.items) {
            ArrayList<IVersionableHandle> items;
            IComponent component;
            UUID componentItemId;
            HashMap<UUID, ArrayList<IVersionableHandle>> componentMap;
            IContextHandle contextHandle;
            HashMap contextMap;
            ISandbox sandbox;
            HashMap sandboxesMap;
            if (!iLocalConflictItem.isModificationChange(4)) continue;
            repository = iLocalConflictItem.getComponentSyncContext().getRemoteIncomingTeamRepository();
            if (repositories.get(repository.getId()) == null) {
                repositories.put(repository.getId(), repository);
            }
            if ((sandboxesMap = (HashMap)localConflictItems.get(repository.getId())) == null) {
                sandboxesMap = new HashMap();
                localConflictItems.put(repository.getId(), sandboxesMap);
            }
            if (sandboxes.get((sandbox = iLocalConflictItem.getSandbox()).getRoot()) == null) {
                sandboxes.put(sandbox.getRoot(), sandbox);
            }
            if ((contextMap = (HashMap)sandboxesMap.get(sandbox.getRoot())) == null) {
                contextMap = new HashMap();
                sandboxesMap.put(sandbox.getRoot(), contextMap);
            }
            if (contextHandles.get((contextHandle = iLocalConflictItem.getComponentSyncContext().getOutgoingActivitySource().getContextHandle()).getItemId()) == null) {
                contextHandles.put(contextHandle.getItemId(), contextHandle);
            }
            if ((componentMap = (HashMap<UUID, ArrayList<IVersionableHandle>>)contextMap.get(contextHandle.getItemId())) == null) {
                componentMap = new HashMap<UUID, ArrayList<IVersionableHandle>>();
                contextMap.put(contextHandle.getItemId(), componentMap);
            }
            if (components.get(componentItemId = (component = iLocalConflictItem.getComponentSyncContext().getComponent()).getItemId()) == null) {
                components.put(componentItemId, component);
            }
            if ((items = (ArrayList<IVersionableHandle>)componentMap.get(componentItemId)) == null) {
                items = new ArrayList<IVersionableHandle>();
                componentMap.put(componentItemId, items);
            }
            items.add(iLocalConflictItem.getItem());
        }
        for (Map.Entry entry : localConflictItems.entrySet()) {
            repository = (ITeamRepository)repositories.get(entry.getKey());
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                ISandbox sandbox = (ISandbox)sandboxes.get(entry2.getKey());
                IAutoResolveLocalConflictsOperation autoResolveConflictsOperation = IOperationFactory.instance.getAutoResolveLocalConflictsOperation(this.problemHandler);
                autoResolveConflictsOperation.setFileContentMerger(FileSystemResourcesPlugin.getConfiguredExternalFileContentMerger());
                autoResolveConflictsOperation.setTeamRepository(repository);
                autoResolveConflictsOperation.setSandbox(sandbox);
                for (Map.Entry entry3 : ((Map)entry2.getValue()).entrySet()) {
                    IContextHandle contextHandle = (IContextHandle)contextHandles.get(entry3.getKey());
                    for (Map.Entry entry4 : ((Map)entry3.getValue()).entrySet()) {
                        IComponentHandle componentHandle = (IComponentHandle)components.get(entry4.getKey());
                        for (IVersionableHandle item : (List)entry4.getValue()) {
                            autoResolveConflictsOperation.addConflictToResolve((ILocalConflict)new LocalConflictDescriptor(contextHandle, componentHandle, sandbox, item.getItemId()));
                        }
                    }
                }
                autoResolveConflictsOperation.run((IProgressMonitor)progress.newChild(this.items.size()));
                this.conflictsResolvedCount += autoResolveConflictsOperation.numberOfConflictsResolved();
            }
        }
    }

    public int numberOfConflictsResolved() {
        return this.conflictsResolvedCount;
    }
}

