/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.item;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.client.internal.namespace.IConfigurationWrapper;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.OperationManager;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;

public class Repositories {
    private Repositories() {
    }

    public static ITeamRepository getDefaultRepository() {
        return ClientRepositoryUtil.getDefaultRepository();
    }

    public static ITeamRepository getRepository(IItemHandle sharedItem) throws IllegalArgumentException {
        return ClientRepositoryUtil.getRepository((IItemHandle)sharedItem);
    }

    public static ITeamRepository getRepository(IConfigurationWrapper snapshot) {
        return snapshot.getContext().getNamespace().getRepository();
    }

    public static ITeamRepository getRepository(IConnection connection) {
        return connection.teamRepository();
    }

    public static ITeamRepository getRepository(ITeamRepository repo) {
        return repo;
    }

    public static ITeamRepository getRepository(String URI2) {
        return RepositoryUtils.getTeamRepository((String)URI2, (int)4);
    }

    public static ITeamRepository getRepository(IComponentSyncContext next) {
        return next.localTeamRepository();
    }

    public static ITeamRepository getRepository(IRemoteActivity ra) {
        return ra.getActivitySource().getModel().localTeamRepository();
    }

    public static ItemId<IContributor> getLoggedInContributor(ITeamRepository repository) {
        IContributor contributor = repository.loggedInContributor();
        return ItemUtil.getContributor((IContributor)contributor);
    }

    public static <T extends IItem> void refresh(ITeamRepository repo, ItemId<T> item, IProgressMonitor monitor) throws TeamRepositoryException {
        OperationManager.checkCanceled((IProgressMonitor)monitor);
        IItemManager manager = repo.itemManager();
        IItem knownItem = manager.getSharedItemIfKnown(item.toHandle());
        if (knownItem != null) {
            repo.itemManager().refreshSharedItems(Collections.singletonList(knownItem), monitor);
        }
    }

    public static boolean isSharedItem(ITeamRepository repo, IItem toTest) {
        return ClientRepositoryUtil.isSharedItem((ITeamRepository)repo, (IItem)toTest);
    }

    public static void assertShared(IItem toTest) {
        ITeamRepository repo = ClientRepositoryUtil.getRepository((IItemHandle)toTest);
        if (!Repositories.isSharedItem(repo, toTest)) {
            throw new IllegalArgumentException("Argument is not a shared item");
        }
    }

    public static String getPublicURI(ITeamRepository repo) {
        String uri = repo.publicUriRoot();
        if (uri == null) {
            uri = repo.getRepositoryURI();
        }
        return uri;
    }
}

