/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.item;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ItemListenerUtil {
    public static void addListener(IItem item, Adapter listener) {
        ((EObject)item).eAdapters().add((Object)listener);
    }

    public static void removeListener(IItem item, Adapter listener) {
        ((EObject)item).eAdapters().remove((Object)listener);
    }

    public static void merge(IAuditable target, IAuditable source) {
        ItemListenerUtil.merge((EObject)target, (EObject)source);
    }

    public static void revert(IItemManager manager, IAuditable auditable, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditable sharedItem = (IAuditable)manager.fetchCompleteItem((IItemHandle)auditable, 0, monitor);
        IAuditable workingCopy = (IAuditable)sharedItem.getWorkingCopy();
        ItemListenerUtil.merge((EObject)auditable, (EObject)workingCopy);
    }

    private static void merge(EObject eTarget, EObject eSource) {
        eSource = EcoreUtil.copy((EObject)eSource);
        for (EStructuralFeature feature : eSource.eClass().getEAllStructuralFeatures()) {
            if (!feature.isChangeable() || feature.isDerived()) continue;
            if (eSource.eIsSet(feature)) {
                Object newValue = eSource.eGet(feature);
                if (eTarget.eIsSet(feature)) {
                    Object oldValue = eTarget.eGet(feature);
                    if (oldValue == newValue) continue;
                    if (newValue == null) {
                        eTarget.eSet(feature, null);
                        continue;
                    }
                    if (newValue.equals(oldValue)) continue;
                    eTarget.eSet(feature, newValue);
                    continue;
                }
                eTarget.eSet(feature, newValue);
                continue;
            }
            if (!eTarget.eIsSet(feature)) continue;
            eTarget.eUnset(feature);
        }
    }

    public static void addListener(IItem sharedItem, ISharedItemChangeListener listener) {
        ClientRepositoryUtil.getRepository((IItemHandle)sharedItem).itemManager().addItemChangeListener(sharedItem, listener);
    }

    public static void removeListener(IItem sharedItem, ISharedItemChangeListener listener) {
        ClientRepositoryUtil.getRepository((IItemHandle)sharedItem).itemManager().removeItemChangeListener(sharedItem, listener);
    }
}

