/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.handlers;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.ui.actions.teamplace.CommitAction;
import com.ibm.team.foundation.common.util.Adapters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CommitHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        List<Object> adapted = new ArrayList();
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IWorkbenchSite activeSite = HandlerUtil.getActiveSite((ExecutionEvent)event);
        if (activePart instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)activePart).getEditorInput();
            IResource resource = (IResource)Adapters.getAdapter((Object)input, IResource.class);
            adapted = this.adaptToResource(Collections.singletonList(resource));
        } else if (currentSelection instanceof ITreeSelection) {
            List paths = ((ITreeSelection)currentSelection).toList();
            adapted = this.adaptToResource(paths);
        } else if (activeSite != null) {
            ISelectionProvider selectionProvider = activeSite.getSelectionProvider();
            selection = null;
            if (selectionProvider != null) {
                selection = selectionProvider.getSelection();
            }
            if (selection instanceof ITreeSelection) {
                adapted = this.adaptToResource(((ITreeSelection)selection).toList());
            }
        }
        if (adapted.size() > 0) {
            CommitAction action = new CommitAction();
            selection = new StructuredSelection(adapted);
            IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
            action.run(activeWorkbenchWindow.getShell(), activeWorkbenchWindow.getActivePage(), (IStructuredSelection)selection);
        }
        return null;
    }

    private List<IResource> adaptToResource(List toAdapt) {
        ArrayList<IResource> adapted = new ArrayList<IResource>();
        for (Object obj : toAdapt) {
            IResource resource = (IResource)Adapters.getAdapter(obj, IResource.class);
            if (resource == null || Adapters.getAdapter(obj, IShareable.class) == null) continue;
            adapted.add(resource);
        }
        return adapted;
    }
}

