/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.framework.geometry;

import com.ibm.team.filesystem.ui.framework.geometry.RationalAffineMatrix;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public final class Units {
    private static RationalAffineMatrix dluToPixels = null;
    private static RationalAffineMatrix charsToPixels = null;

    private Units() {
    }

    public static RationalAffineMatrix getCharsToPixels() {
        if (charsToPixels == null) {
            GC gc = new GC((Drawable)Display.getCurrent());
            gc.setFont(JFaceResources.getDialogFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            gc.dispose();
            charsToPixels = Units.getCharsToPixels(fontMetrics);
        }
        return charsToPixels;
    }

    public static RationalAffineMatrix getDLUToPixels() {
        if (dluToPixels == null) {
            dluToPixels = Units.getCharsToPixels().multiply(RationalAffineMatrix.shrink(4, 8));
        }
        return dluToPixels;
    }

    public static RationalAffineMatrix getCharsToPixels(FontMetrics fm) {
        return RationalAffineMatrix.scale(fm.getAverageCharWidth(), fm.getHeight());
    }
}

