/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.framework.geometry;

import com.ibm.team.filesystem.ui.framework.geometry.IntAffineMatrix;
import org.eclipse.swt.graphics.Point;

public class Shape {
    int[] data;
    int used = 0;

    public Shape(int[] data) {
        this.data = data;
        this.used = data.length;
    }

    public Shape(int size) {
        this.data = new int[size * 2];
    }

    public Shape() {
        this(8);
    }

    public void add(IntAffineMatrix transform, Shape toAppend) {
        int idx = 0;
        while (idx < toAppend.used) {
            int x = toAppend.data[idx++];
            int y = toAppend.data[idx++];
            this.add(transform.getx(x, y), transform.gety(x, y));
        }
    }

    public void add(Shape toAppend) {
        int idx = 0;
        while (idx < toAppend.used) {
            int x = toAppend.data[idx++];
            int y = toAppend.data[idx++];
            this.add(x, y);
        }
    }

    public Shape reverse() {
        int[] result = new int[this.used];
        int idx = 0;
        int srcIdx = this.used - 2;
        while (idx < this.used) {
            result[idx++] = this.data[srcIdx];
            result[idx++] = this.data[srcIdx + 1];
            srcIdx -= 2;
        }
        return new Shape(result);
    }

    public void add(int x, int y) {
        if (this.used >= this.data.length - 1) {
            this.resizeArray(Math.max(this.data.length * 2, 8));
        }
        this.data[this.used++] = x;
        this.data[this.used++] = y;
    }

    public void add(Point toAdd) {
        this.add(toAdd.x, toAdd.y);
    }

    public Point[] asPointArray() {
        Point[] result = new Point[this.used / 2];
        int idx = 0;
        int i = 0;
        while (i < result.length) {
            int x = this.data[idx++];
            int y = this.data[idx++];
            result[i] = new Point(x, y);
            ++i;
        }
        return result;
    }

    private void resizeArray(int newSize) {
        int[] newData = new int[newSize];
        System.arraycopy(this.data, 0, newData, 0, this.used);
        this.data = newData;
    }

    public int[] getData() {
        if (this.used < this.data.length) {
            this.resizeArray(this.used);
        }
        return this.data;
    }
}

