/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.framework.geometry;

import com.ibm.team.filesystem.ui.framework.geometry.IntAffineMatrix;
import com.ibm.team.filesystem.ui.framework.geometry.Rational;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Point;

public class RationalAffineMatrix {
    int m11;
    int m12;
    int m13;
    int m21;
    int m22;
    int m23;
    int q11;
    int q12;
    int q13;
    int q21;
    int q22;
    int q23;

    public RationalAffineMatrix(int m11, int q11, int m12, int q12, int m13, int q13, int m21, int q21, int m22, int q22, int m23, int q23) {
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.q11 = q11;
        this.q12 = q12;
        this.q13 = q13;
        this.q21 = q21;
        this.q22 = q22;
        this.q23 = q23;
        Assert.isTrue((q11 > 0 ? 1 : 0) != 0);
        Assert.isTrue((q12 > 0 ? 1 : 0) != 0);
        Assert.isTrue((q13 > 0 ? 1 : 0) != 0);
        Assert.isTrue((q21 > 0 ? 1 : 0) != 0);
        Assert.isTrue((q22 > 0 ? 1 : 0) != 0);
        Assert.isTrue((q23 > 0 ? 1 : 0) != 0);
    }

    public RationalAffineMatrix(int m11, int m12, int m13, int m21, int m22, int m23) {
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.q11 = 1;
        this.q12 = 1;
        this.q13 = 1;
        this.q21 = 1;
        this.q22 = 1;
        this.q23 = 1;
    }

    public RationalAffineMatrix reduce() {
        int gcd = Rational.gcd(this.m11, this.q11);
        this.m11 /= gcd;
        this.q11 /= gcd;
        gcd = Rational.gcd(this.m12, this.q12);
        this.m12 /= gcd;
        this.q12 /= gcd;
        gcd = Rational.gcd(this.m13, this.q13);
        this.m13 /= gcd;
        this.q13 /= gcd;
        gcd = Rational.gcd(this.m21, this.q21);
        this.m21 /= gcd;
        this.q21 /= gcd;
        gcd = Rational.gcd(this.m22, this.q22);
        this.m22 /= gcd;
        this.q22 /= gcd;
        gcd = Rational.gcd(this.m23, this.q23);
        this.m23 /= gcd;
        this.q23 /= gcd;
        return this;
    }

    public Rational det() {
        int q12_q21 = this.q12 * this.q21;
        int q11_q22 = this.q11 * this.q22;
        return new Rational(this.m11 * this.m22 * q12_q21 - this.m12 * this.m21 * q11_q22, q12_q21 * q11_q22);
    }

    public RationalAffineMatrix(IntAffineMatrix m) {
        this(m.m11, 1, m.m12, 1, m.m13, 1, m.m21, 1, m.m22, 1, m.m23, 1);
    }

    public static RationalAffineMatrix scale(int xScale, int yScale) {
        return new RationalAffineMatrix(xScale, 0, 0, 0, yScale, 0);
    }

    public static RationalAffineMatrix scale(Point scaleFactor) {
        return new RationalAffineMatrix(scaleFactor.x, 0, 0, 0, scaleFactor.y, 0);
    }

    public static RationalAffineMatrix shrink(Point scaleFactor) {
        return RationalAffineMatrix.shrink(scaleFactor.x, scaleFactor.y);
    }

    public static RationalAffineMatrix shrink(int x, int y) {
        return new RationalAffineMatrix(1, x, 0, 1, 0, 1, 0, 1, 1, y, 0, 1);
    }

    public int detNumerator() {
        return this.m11 * this.m22 * this.q12 * this.q21 - this.m12 * this.m21 * this.q11 * this.q22;
    }

    public int detDenominator() {
        return this.q12 * this.q21 * this.q11 * this.q22;
    }

    public RationalAffineMatrix inverse() {
        int detNumerator = this.detNumerator();
        int detDenominator = this.detDenominator();
        return new RationalAffineMatrix(this.m22 * detDenominator, detNumerator, -this.m12 * detDenominator, detNumerator, (this.m12 * this.m23 - this.m22 * this.m13) * detDenominator, detNumerator, -this.m21 * detDenominator, detNumerator, this.m11 * detDenominator, detNumerator, (this.m21 * this.m13 - this.m11 * this.m23) * detDenominator, detNumerator);
    }

    public Point multiply(Point toTransform) {
        return new Point(toTransform.x * this.m11 / this.q11 + toTransform.y * this.m12 / this.q12 + this.m13 / this.q13, toTransform.x * this.m21 / this.q21 + toTransform.y * this.m22 / this.q22 + this.m23 / this.q23);
    }

    public RationalAffineMatrix multiply(RationalAffineMatrix m) {
        int q11_mq11 = this.q11 * m.q11;
        int q12_mq21 = this.q12 * m.q21;
        int q11_mq12 = this.q11 * m.q12;
        int q12_mq22 = this.q12 * m.q22;
        int q11_mq13 = this.q11 * m.q13;
        int q12_mq23 = this.q12 * m.q23;
        int q21_mq11 = this.q21 * m.q11;
        int q22_mq21 = this.q22 * m.q21;
        int q21_mq12 = this.q21 * m.q12;
        int q22_mq22 = this.q22 * m.q22;
        int q21_mq13 = this.q21 * m.q13;
        int q22_mq23 = this.q22 * m.q23;
        RationalAffineMatrix result = new RationalAffineMatrix(this.m11 * m.m11 * q12_mq21 + this.m12 * m.m21 * q11_mq11, q11_mq11 * q12_mq21, this.m11 * m.m12 * q12_mq22 + this.m12 * m.m22 * q11_mq12, q11_mq12 * q12_mq22, this.m11 * m.m13 * q12_mq23 * this.q13 + this.m12 * m.m23 * q11_mq13 * this.q13 + this.m13 * q12_mq23 * q11_mq13, this.q13 * q12_mq23 * q11_mq13, this.m21 * m.m11 * q22_mq21 + this.m22 * m.m21 * q21_mq11, q22_mq21 * q21_mq11, this.m21 * m.m12 * q22_mq22 + this.m22 * m.m22 * q21_mq12, q22_mq22 * q21_mq12, this.m21 * m.m13 * q22_mq23 * this.q23 + this.m22 * m.m23 * q21_mq13 * this.q23 + this.m23 * q22_mq23 * q21_mq13, q22_mq23 * q21_mq13 * this.q23);
        result.reduce();
        return result;
    }
}

