/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.framework.geometry;

public final class Rational
extends Number {
    public int numerator;
    public int denominator;

    public Rational(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    @Override
    public float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    @Override
    public int intValue() {
        return this.numerator / this.denominator;
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    public int remainder() {
        return this.numerator % this.denominator;
    }

    public void reduce() {
        int gcd = Rational.gcd(this.numerator, this.denominator);
        this.numerator /= gcd;
        this.denominator /= gcd;
    }

    public static int gcd(int a, int b) {
        if (a == 0) {
            a = 1;
        }
        while (b > 0) {
            int r = a % b;
            a = b;
            b = r;
        }
        return a;
    }
}

