/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.editor;

import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.streams.InputStreamStorage;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.repository.rcp.streams.ByteArrayInputStreamProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import com.ibm.team.scm.common.VersionedContentDeleted;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class RemoteFileEditorInput
implements IWorkbenchAdapter,
IStorageEditorInput {
    private InputStreamStorage storage;
    private String workspaceName;
    private FileState fileState;
    private IInputStreamProvider cachedInputStream;
    private static TempFileTracker tempFileTracker = new TempFileTracker();

    public static RemoteFileEditorInput createInput(ITeamRepository repository, StateId<? extends IVersionable> item, String workspaceName, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IVersionable fetchedItem = (IVersionable)RepoFetcher.fetchItem((ITeamRepository)repository, item, (IProgressMonitor)progress.newChild(5));
        if (!(fetchedItem instanceof ISymbolicLink) && !(fetchedItem instanceof IFileItem)) {
            throw new IllegalArgumentException("Cannot create input for item other than file or symbolic link");
        }
        RemoteFileEditorInput result = RemoteFileEditorInput.createInput(ClientFileStateFactory.create((ITeamRepository)repository, (IItemType)fetchedItem.getItemType(), (IVersionable)fetchedItem), (IProgressMonitor)progress.newChild(95));
        result.setWorkspaceName(workspaceName);
        return result;
    }

    private RemoteFileEditorInput(FileState fileState, IInputStreamProvider cachedInputStream, String encoding) {
        Assert.isNotNull((Object)fileState);
        this.fileState = fileState;
        this.cachedInputStream = cachedInputStream;
        this.storage = new InputStreamStorage(cachedInputStream, encoding, fileState.getPath().getName());
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return this.getImageDescriptor();
    }

    public String getLabel(Object o) {
        return this.fileState.getPath().getName();
    }

    public Object getParent(Object o) {
        return null;
    }

    public IInputStreamProvider getInputStreamProvider() {
        return this.cachedInputStream;
    }

    public IStorage getStorage() throws CoreException {
        return this.storage;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
    }

    public String getName() {
        return this.fileState.getPath().getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        if (this.workspaceName != null) {
            return NLS.bind((String)Messages.RemoteFileEditorInput_0, (Object)this.workspaceName, (Object)this.fileState.getPath());
        }
        return this.fileState.getPath().toString();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileState == null ? 0 : this.fileState.hashCode());
        result = 31 * result + (this.workspaceName == null ? 0 : this.workspaceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteFileEditorInput other = (RemoteFileEditorInput)obj;
        if (this.fileState == null ? other.fileState != null : !this.fileState.equals((Object)other.fileState)) {
            return false;
        }
        return !(this.workspaceName == null ? other.workspaceName != null : !this.workspaceName.equals(other.workspaceName));
    }

    public static RemoteFileEditorInput createInput(FileState fileState, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            DisposableInputStreamProvider buffer;
            String encoding;
            block22: {
                String extension = fileState.getPath().getFileExtension();
                IInputStreamProvider provider = fileState.getContents();
                encoding = fileState.getCharacterEncoding();
                InputStream in = provider.getInputStream((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progress, 50));
                try {
                    try {
                        buffer = TemporaryOutputStream.createLocalBuffer((InputStream)in, (String)extension, (boolean)false, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progress, 50));
                    }
                    catch (IOException e) {
                        if (!(e.getCause() instanceof VersionedContentDeleted)) {
                            throw e;
                        }
                        String msg = Messages.RemoteFileEditorInput_1;
                        byte[] bytes = null;
                        if (encoding != "") {
                            try {
                                Charset c = Charset.forName(encoding);
                                if (c.canEncode()) {
                                    CharsetEncoder ce = c.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                                    ByteBuffer result = ce.encode(CharBuffer.wrap(msg));
                                    bytes = new byte[result.limit()];
                                    result.get(bytes);
                                }
                            }
                            catch (UnsupportedCharsetException unsupportedCharsetException) {
                            }
                            catch (IllegalCharsetNameException illegalCharsetNameException) {
                            }
                            catch (MalformedInputException malformedInputException) {
                            }
                            catch (UnmappableCharacterException unmappableCharacterException) {
                                // empty catch block
                            }
                        }
                        if (bytes == null) {
                            encoding = "UTF-8";
                            bytes = msg.getBytes(encoding);
                        }
                        buffer = new ByteArrayInputStreamProvider(bytes);
                        in.close();
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    in.close();
                    throw throwable;
                }
                in.close();
            }
            RemoteFileEditorInput remoteFileEditorInput = RemoteFileEditorInput.createEditorInput(fileState, buffer, encoding);
            return remoteFileEditorInput;
        }
        catch (IOException e) {
            if (e.getCause() instanceof VersionablePermissionDeniedException) {
                VersionablePermissionDeniedException cause = (VersionablePermissionDeniedException)e.getCause();
                if (cause.getLocalizedMessage() != null) {
                    throw new TeamRepositoryException(cause.getLocalizedMessage(), (Throwable)cause);
                }
                throw new TeamRepositoryException((Throwable)cause);
            }
            throw new TeamRepositoryException(Messages.RemoteFileEditorInput_IOException_Messge, (Throwable)e);
        }
        finally {
            progress.done();
        }
    }

    private static RemoteFileEditorInput createEditorInput(FileState fileState, DisposableInputStreamProvider buffer, String encoding) {
        IPath path = RemoteFileEditorInput.getPath(buffer);
        if (path != null) {
            return new RemoteFileEditorInputWithPath(fileState, (IInputStreamProvider)buffer, encoding, path);
        }
        return new RemoteFileEditorInput(fileState, (IInputStreamProvider)buffer, encoding);
    }

    private static IPath getPath(DisposableInputStreamProvider buffer) {
        IAdaptable adaptable;
        Object o;
        if (buffer instanceof IAdaptable && (o = (adaptable = (IAdaptable)buffer).getAdapter(File.class)) instanceof File) {
            File file = (File)o;
            return new Path(file.getAbsolutePath());
        }
        return null;
    }

    public RemoteFileEditorInput asPathEditorInput(IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        DisposableInputStreamProvider diskBuffer = TemporaryOutputStream.createLocalBuffer((InputStream)this.cachedInputStream.getInputStream((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progress, 50)), (String)this.fileState.getPath().getFileExtension(), (boolean)true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progress, 50));
        tempFileTracker.track(diskBuffer);
        this.dispose(this.cachedInputStream);
        return RemoteFileEditorInput.createEditorInput(this.fileState, diskBuffer, this.storage.getCharset());
    }

    private void dispose(IInputStreamProvider provider) {
        if (provider instanceof DisposableInputStreamProvider) {
            DisposableInputStreamProvider disp = (DisposableInputStreamProvider)provider;
            try {
                disp.dispose();
            }
            catch (IOException e) {
                StatusUtil.log((Object)this, (Throwable)e);
            }
        }
    }

    /* synthetic */ RemoteFileEditorInput(FileState fileState, IInputStreamProvider iInputStreamProvider, String string, RemoteFileEditorInput remoteFileEditorInput) {
        this(fileState, iInputStreamProvider, string);
    }

    public static class RemoteFileEditorInputWithPath
    extends RemoteFileEditorInput
    implements IPathEditorInput {
        private final IPath path;

        private RemoteFileEditorInputWithPath(FileState fileState, IInputStreamProvider cachedInputStream, String encoding, IPath path) {
            super(fileState, cachedInputStream, encoding, null);
            Assert.isNotNull((Object)path);
            this.path = path;
        }

        public IPath getPath() {
            return this.path;
        }

        @Override
        public RemoteFileEditorInput asPathEditorInput(IProgressMonitor monitor) throws IOException {
            return this;
        }
    }

    private static class TempFileTracker {
        private static long MIN_TEMP_FILE_KEEP_PEROID = 300000L;
        private final List<DisposableInputStreamCreationRecord> tempFiles = NewCollection.arrayList();
        private final Timer timer = new Timer();
        private boolean timerScheduled = false;

        private TempFileTracker() {
        }

        public synchronized void track(DisposableInputStreamProvider disposableInputStream) {
            this.tempFiles.add(new DisposableInputStreamCreationRecord(disposableInputStream));
            this.scheduleTempFileCleanUpTask();
        }

        private synchronized void cleanupTempFiles() {
            long expireAt = System.currentTimeMillis() - MIN_TEMP_FILE_KEEP_PEROID;
            Iterator<DisposableInputStreamCreationRecord> itr = this.tempFiles.iterator();
            while (itr.hasNext()) {
                DisposableInputStreamCreationRecord tempFile = itr.next();
                if (tempFile.createTime > expireAt) continue;
                itr.remove();
            }
            this.scheduleTempFileCleanUpTask();
        }

        private synchronized void scheduleTempFileCleanUpTask() {
            if (!this.timerScheduled && !this.tempFiles.isEmpty()) {
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        timerScheduled = false;
                        this.cleanupTempFiles();
                    }
                }, MIN_TEMP_FILE_KEEP_PEROID);
                this.timerScheduled = true;
            }
        }

        private static class DisposableInputStreamCreationRecord {
            private final DisposableInputStreamProvider disposableInputStream;
            private final long createTime;

            private DisposableInputStreamCreationRecord(DisposableInputStreamProvider disposableInputStream) {
                this.disposableInputStream = disposableInputStream;
                assert (this.disposableInputStream != null);
                this.createTime = System.currentTimeMillis();
            }
        }
    }
}

