/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.editor;

import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.ui.editor.RemoteFileEditorInput;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationManager;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PartUtil {
    public static CompareEditorInput createCompareEditorInput(ITeamRepository server, StateId item1, StateId item2, IPath path1, IPath path2, String leftLabel, String rightLabel) {
        FileChangeEditorInput input = FileChangeEditorInput.createFrom((ITeamRepository)server, (StateId)item2, (IPath)path2, (StateId)item1, (IPath)path1);
        input.setLabels(leftLabel, rightLabel);
        return input;
    }

    public static CompareEditorInput createCompareEditorInput(AbstractFileSystemItemWrapper w1, AbstractFileSystemItemWrapper w2, String leftLabel, String rightLabel) {
        return PartUtil.createCompareEditorInput(w1.getRepository(), w1.getFileItem(), w2.getFileItem(), (IPath)new Path(w1.getFQName()), (IPath)new Path(w2.getFQName()), leftLabel, rightLabel);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IEditorInput input, String realName, IContentType content, boolean activate, boolean allowExternal) throws PartInitException {
        RemoteFileEditorInput rfei;
        String name;
        if (!PlatformUI.isWorkbenchRunning()) {
            throw new PartInitException(StatusUtil.newStatus(PartUtil.class, (String)Messages.PartUtil_0));
        }
        IWorkbench workbench = page.getWorkbenchWindow().getWorkbench();
        IEditorRegistry registry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(name = realName == null ? input.getName() : realName, content);
        if (descriptor == null && allowExternal && registry.isSystemExternalEditorAvailable(name)) {
            descriptor = registry.findEditor("org.eclipse.ui.systemExternalEditor");
            if (descriptor != null && input instanceof RemoteFileEditorInput) {
                rfei = (RemoteFileEditorInput)input;
                try {
                    input = rfei.asPathEditorInput(null);
                }
                catch (IOException e) {
                    throw new PartInitException(StatusUtil.newStatus((Object)rfei, (Throwable)e));
                }
            }
        } else if (descriptor != null && descriptor.isOpenExternal() && input instanceof RemoteFileEditorInput) {
            rfei = (RemoteFileEditorInput)input;
            try {
                input = rfei.asPathEditorInput(null);
            }
            catch (IOException e) {
                throw new PartInitException(StatusUtil.newStatus((Object)rfei, (Throwable)e));
            }
        }
        String id = descriptor == null || !allowExternal && !descriptor.isInternal() ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
        try {
            return page.openEditor(input, id, activate);
        }
        catch (PartInitException e) {
            if (id.equals("org.eclipse.ui.DefaultTextEditor")) {
                throw e;
            }
            return page.openEditor(input, "org.eclipse.ui.DefaultTextEditor");
        }
    }

    public static void openEditor(UIContext context, FileItemWrapper fileWrapper) {
        PartUtil.openEditor(context, fileWrapper, null, true);
    }

    public static void openEditor(final UIContext context, final FileItemWrapper fileWrapper, final String realName, final boolean allowExternal) {
        OperationManager.runOperation((String)Messages.PartUtil_4, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                try {
                    RemoteFileEditorInput editorInput = RemoteFileEditorInput.createInput(fileWrapper.getRepository(), (StateId<? extends IVersionable>)fileWrapper.getFileItem(), fileWrapper.getWorkspace().getContext(null).getName(), monitor);
                    PartUtil.openEditor(context, editorInput, realName, allowExternal);
                }
                catch (ItemNotFoundException e) {
                    context.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialogFactory.showMessage((Shell)context.getShell(), (String)Messages.PartUtil_5, (IStatus)StatusUtil.newStatus((Object)"com.ibm.team.filesystem.ide.ui", (String)Messages.PartUtil_itemNotAccessibleMessage, (Throwable)e));
                        }
                    });
                }
            }
        }, (boolean)true);
    }

    public static void openEditor(final UIContext context, final RemoteFileEditorInput editorInput, final String realName, final boolean allowExternal) {
        IContentType contentType = null;
        try {
            contentType = ResourceUtil.getContentTypeFor((InputStream)editorInput.getStorage().getContents(), (String)(realName != null ? realName : editorInput.getName()));
        }
        catch (CoreException e1) {
            StatusUtil.log(PartUtil.class, (Throwable)e1);
        }
        final IContentType finalContentType = contentType;
        context.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PartUtil.openEditor(context.getPage(), (IEditorInput)editorInput, realName, finalContentType, false, allowExternal);
                }
                catch (PartInitException e) {
                    MessageDialogFactory.showMessage((Shell)context.getShell(), (String)Messages.PartUtil_5, (IStatus)StatusUtil.newStatus((Object)"com.ibm.team.filesystem.ide.ui", (String)Messages.PartUtil_6, (Throwable)e));
                    StatusUtil.log(this.getClass(), (Throwable)e);
                }
            }
        });
    }
}

