/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.editor;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.StandardControlLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class FileSystemEditorToolkit
extends FormToolkit {
    private static final int MAX_VISIBLE_ITEMS_PER_COMBO = 15;
    private Font fFont;

    public FileSystemEditorToolkit(FormColors colors) {
        super(colors);
        this.getHyperlinkGroup().setBackground(null);
    }

    public Label createLabel(Composite parent, String text, int style) {
        Label label = super.createLabel(parent, text, style);
        Color labelForeground = this.getColors().getColor("com.ibm.team.workitem.ide.ui.internal.editor.LABEL_FOREGROUND");
        if (labelForeground != null) {
            label.setForeground(labelForeground);
        }
        return label;
    }

    public Label createTitle(Composite parent, String text, int style) {
        Label label = super.createLabel(parent, text, style);
        label.setForeground(this.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setFont(JFaceResources.getHeaderFont());
        return label;
    }

    public void adapt(Control control, boolean trackFocus, boolean trackKeyboard) {
        super.adapt(control, trackFocus, trackKeyboard);
        if (this.fFont != null) {
            control.setFont(this.fFont);
        }
        if (control instanceof Combo) {
            ((Combo)control).setVisibleItemCount(15);
        }
        if (control instanceof Composite) {
            this.adaptComposite((Composite)control);
        }
    }

    public void adapt(Composite composite) {
        super.adapt(composite);
        this.adaptComposite(composite);
    }

    private void adaptComposite(Composite composite) {
        if (composite instanceof StyledText) {
            composite.setBackground(null);
        } else if (composite instanceof CCombo) {
            composite.setBackground(null);
        }
    }

    public Text createText(Composite parent, String value, int style) {
        Text text = super.createText(parent, value, style);
        if (this.fFont != null) {
            text.setFont(this.fFont);
        }
        return text;
    }

    public Text createReadOnlyText(Composite parent, String value, int style) {
        Text text = this.createText(parent, value, style | 8);
        text.setBackground(this.getColors().getBackground());
        text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        return text;
    }

    public Composite createBorder(Composite parent) {
        Composite textParent = this.createComposite(parent, 0);
        textParent.setLayout((Layout)new FillLayout());
        textParent.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        ((FillLayout)textParent.getLayout()).marginHeight = 2;
        ((FillLayout)textParent.getLayout()).marginWidth = 1;
        this.paintBordersFor(textParent);
        return textParent;
    }

    public ImageHyperlink createCustomImageHyperlink(Composite parent, int style) {
        ImageHyperlink hyperlink = new ImageHyperlink(parent, style | this.getOrientation());
        this.adapt((Control)hyperlink, true, true);
        return hyperlink;
    }

    public Hyperlink createCustomHyperlink(Composite parent, String text, int style) {
        Hyperlink hyperlink = new Hyperlink(parent, style | this.getOrientation());
        if (text != null) {
            hyperlink.setText(text);
        }
        this.adapt((Control)hyperlink, true, true);
        return hyperlink;
    }

    public void setFont(Font font) {
        this.fFont = font;
    }

    public Font getFont() {
        return this.fFont;
    }

    private static StandardControlLabelProvider createControl(ImageHyperlink hyperlink, IWorkbenchPartSite site, String menuId) {
        final StandardControlLabelProvider hyperlinkLabelProvider = new StandardControlLabelProvider((Control)hyperlink);
        hyperlinkLabelProvider.setForegroundAware(true);
        hyperlinkLabelProvider.setTextAware(true);
        hyperlinkLabelProvider.setImageAware(true);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Job job = new Job(Messages.FileSystemEditorToolkit_0){

                    protected IStatus run(IProgressMonitor monitor) {
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
                        try {
                            Object element = hyperlinkLabelProvider.getElement();
                            if (element == null) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            URIReference reference = Hyperlinks.create((Object)element, (IProgressMonitor)subMonitor.newChild(100));
                            if (reference == null) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            Hyperlinks.open((URI)reference.getURI(), null, (IProgressMonitor)subMonitor.newChild(100));
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        finally {
                            subMonitor.done();
                        }
                    }
                };
                job.schedule();
            }
        });
        new TooltipSupport((Control)hyperlink, true, false){

            protected Object mapElement(int x, int y) {
                return hyperlinkLabelProvider.getElement();
            }
        };
        if (site != null) {
            SelectionProvider selectionProvider = new SelectionProvider(){

                public ISelection getSelection() {
                    Object data = hyperlinkLabelProvider.getElement();
                    return data == null ? StructuredSelection.EMPTY : new StructuredSelection(data);
                }
            };
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)manager);
                    ContextMenuHelper.addNewSubmenu((IMenuManager)manager, (boolean)false);
                }
            });
            site.registerContextMenu(menuId, menuMgr, (ISelectionProvider)selectionProvider);
            Menu menu = menuMgr.createContextMenu((Control)hyperlink);
            hyperlink.setMenu(menu);
        }
        return hyperlinkLabelProvider;
    }

    public static StandardControlLabelProvider createDecoratedImageHyperlink(Composite parent, FormToolkit toolkit, IWorkbenchPartSite site, String menuId) {
        ImageHyperlink hyperlink = toolkit.createImageHyperlink(parent, 0);
        return FileSystemEditorToolkit.createControl(hyperlink, site, menuId);
    }

    public StandardControlLabelProvider createDecoratedImageHyperlink(Composite parent, IWorkbenchPartSite site, String menuId) {
        ImageHyperlink hyperlink = this.createImageHyperlink(parent, 0);
        return FileSystemEditorToolkit.createControl(hyperlink, site, menuId);
    }
}

