/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.domain;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.MoreQueryResultsWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceQueryWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.PlaceSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.PlaceSearchQuery;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class WorkspaceQueryItemQuery
extends RepositoryQuery {
    private PlaceSearchQuery query;
    private ConnectedProjectAreaRegistry registry;
    private WorkspaceQueryWrapper wrapper;
    private ISharedItemChangeListener itemChangeListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            boolean shouldRefresh = false;
            for (Object o : events) {
                if (!(o instanceof ISharedItemChangeEvent)) continue;
                ISharedItemChangeEvent event = (ISharedItemChangeEvent)o;
                IItem beforeItem = event.getBeforeState();
                IItem afterItem = event.getAfterState();
                if (!(beforeItem instanceof IQueryItem) || !(afterItem instanceof IQueryItem) || ((IQueryItem)beforeItem).sameCriteriaAs((IQueryItem)afterItem)) continue;
                shouldRefresh = true;
                break;
            }
            if (shouldRefresh) {
                Realm realm = WorkspaceQueryItemQuery.this.getRealm();
                realm.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkspaceQueryItemQuery.this.computeQuery();
                        WorkspaceQueryItemQuery.this.refresh();
                    }
                });
            }
        }
    };
    private ISharedItemChangeListener itemDeleteListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            ArrayList<AbstractPlaceWrapper> toRemove = new ArrayList<AbstractPlaceWrapper>(events.size());
            for (Object obj : events) {
                IItem deletedItem;
                ISharedItemChangeEvent event;
                if (!(obj instanceof ISharedItemChangeEvent) || (event = (ISharedItemChangeEvent)obj).getAfterState() != null || !((deletedItem = event.getSharedItem()) instanceof IWorkspace)) continue;
                AbstractPlaceWrapper wrapper = AbstractPlaceWrapper.newWrapper((IWorkspace)deletedItem);
                wrapper.setAllowFolderActions(true);
                toRemove.add(wrapper);
            }
            WorkspaceQueryItemQuery.this.asyncRemoveElements(toRemove);
        }
    };

    public WorkspaceQueryItemQuery(WorkspaceQueryWrapper wrapper, ConnectedProjectAreaRegistry registry, IOperationRunner runner) {
        super(wrapper.getRepository(), runner);
        this.wrapper = wrapper;
        this.registry = registry;
        this.computeQuery();
    }

    private void computeQuery() {
        IWorkspaceSearchCriteria searchCriteria = (IWorkspaceSearchCriteria)this.wrapper.getQueryItem().getSearchCriteria();
        this.query = (PlaceSearchQuery)PlaceSearchCriteria.createFromSearchCriteriaDTO(this.getRepository(), (IConnectedProjectAreaRegistry)this.registry, searchCriteria).getQuery(this.getOperationRunner());
        this.query.setAllowFolderActions(true);
    }

    public void refresh() {
        this.computeQuery();
        super.refresh();
    }

    protected List fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (needsRefresh) {
                ITeamRepository repo = this.wrapper.getRepository();
                repo.itemManager().fetchCompleteItemsPermissionAware(Arrays.asList(this.wrapper.getQueryItem()), 1, (IProgressMonitor)progress.newChild(10));
            }
            progress.setWorkRemaining(90);
            List result = this.query.computeResult((IProgressMonitor)progress.newChild(90));
            if (result.size() == 1024) {
                MoreQueryResultsWrapper moreWrapper = new MoreQueryResultsWrapper(this.wrapper.getRepository(), (IItem)this.wrapper.getQueryItem());
                result.add(moreWrapper);
            }
            List list = result;
            return list;
        }
        catch (InvocationTargetException e) {
            FileSystemStatusUtil.getStatusFor((int)4, (String)"com.ibm.team.filesystem.ide.ui", (String)Messages.QueryItemQuery_fetchErrorMessage, (Throwable)e);
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            progress.done();
        }
    }

    protected void attachListeners() {
        this.getRepository().itemManager().addItemChangeListener(IQueryItem.ITEM_TYPE, this.itemChangeListener);
        this.getRepository().itemManager().addItemChangeListener(IWorkspace.ITEM_TYPE, this.itemDeleteListener);
        this.computeQuery();
    }

    protected void detachListeners() {
        this.getRepository().itemManager().removeItemChangeListener(IQueryItem.ITEM_TYPE, this.itemChangeListener);
        this.getRepository().itemManager().removeItemChangeListener(IWorkspace.ITEM_TYPE, this.itemDeleteListener);
    }

    public String getName() {
        return Messages.QueryItemQuery_queryName;
    }
}

