/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.domain;

import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.ui.queries.ComponentsDomainNode;
import com.ibm.team.filesystem.ui.queries.FolderNode;
import com.ibm.team.filesystem.ui.queries.HierarchicalRootBaselineQuery;
import com.ibm.team.filesystem.ui.queries.HierarchicalRootComponentQuery;
import com.ibm.team.filesystem.ui.queries.HierarchicalSubBaselineQuery;
import com.ibm.team.filesystem.ui.queries.HierarchicalSubComponentQuery;
import com.ibm.team.filesystem.ui.queries.ItemContainerQuery;
import com.ibm.team.filesystem.ui.queries.KnownTeamRepositoryQuery;
import com.ibm.team.filesystem.ui.queries.ScmQueryItemsNode;
import com.ibm.team.filesystem.ui.queries.StreamsDomainNode;
import com.ibm.team.filesystem.ui.views.AbstractRepositoryTreeProvider;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.HierarchyData;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.query.ScmQueryItemSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.PlaceSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.PlaceSearchQuery;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IBaselineHierarchyNode;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StreamsDomainTreeProvider
extends AbstractRepositoryTreeProvider {
    private IOperationRunner runner;
    private DomainSubtreeRoot root;

    public StreamsDomainTreeProvider(IOperationRunner runner) {
        this.runner = runner;
    }

    public ISetWithListeners getChildren(Object parent) {
        BaselineWrapper baselineWrapper;
        WorkspaceComponentWrapper componentNode;
        HierarchyData data;
        AbstractSearchInput criteria;
        Object node;
        if (parent instanceof ITeamRepositoryService) {
            return new KnownTeamRepositoryQuery();
        }
        if (parent instanceof DomainSubtreeRoot) {
            this.root = (DomainSubtreeRoot)parent;
            Object categoryElement = this.root.getCategoryElement();
            if (categoryElement instanceof ITeamArea) {
                ITeamArea teamArea = (ITeamArea)categoryElement;
                categoryElement = teamArea.getProjectArea();
            }
            if (categoryElement instanceof IProjectAreaHandle) {
                IProjectAreaHandle projectHandle = (IProjectAreaHandle)categoryElement;
                ITeamRepository repo = (ITeamRepository)projectHandle.getOrigin();
                ItemContainerQuery query = new ItemContainerQuery(repo, (IItemHandle)projectHandle, null, this.runner, this.getRootContent(repo, projectHandle), false);
                return query;
            }
        }
        if (parent instanceof ComponentsDomainNode && ((ComponentsDomainNode)parent).getProcessArea() != null) {
            node = (ComponentsDomainNode)parent;
            criteria = new ComponentSearchCriteria(ClientRepositoryUtil.getRepository((IItemHandle)((ComponentsDomainNode)node).getProcessArea()), this.root.getDomain().getConnectedProjectAreaRegistry()).withOwnedBy((ItemId<? extends IAuditable>)new ItemId((IItemHandle)((ComponentsDomainNode)node).getProcessArea()));
            criteria.setMaxResults(Integer.MAX_VALUE);
            return ((ComponentSearchCriteria)criteria).getQuery(this.runner, false);
        }
        if (parent instanceof ScmQueryItemsNode && ((ScmQueryItemsNode)parent).getProcessArea() != null) {
            node = (ScmQueryItemsNode)parent;
            criteria = new ScmQueryItemSearchCriteria(ClientRepositoryUtil.getRepository((IItemHandle)((ScmQueryItemsNode)node).getProcessArea()), this.root.getDomain().getConnectedProjectAreaRegistry()).withOwner((ItemId<? extends IAuditable>)new ItemId((IItemHandle)((ScmQueryItemsNode)node).getProcessArea()));
            criteria.setMaxResults(Integer.MAX_VALUE);
            return ((ScmQueryItemSearchCriteria)criteria).getQuery(this.runner);
        }
        if (parent instanceof StreamsDomainNode && ((StreamsDomainNode)(node = (StreamsDomainNode)parent)).getProjectArea() != null) {
            ITeamRepository repository = ClientRepositoryUtil.getRepository((IItemHandle)((StreamsDomainNode)node).getProjectArea());
            IConnectedProjectAreaRegistry registry = this.root.getDomain().getConnectedProjectAreaRegistry();
            PlaceSearchCriteria searchCriteria = new PlaceSearchCriteria(repository, registry);
            searchCriteria = searchCriteria.withOwnedBy((ItemId<? extends IAuditable>)new ItemId((IItemHandle)((StreamsDomainNode)node).getProjectArea()));
            searchCriteria = searchCriteria.withType(PlaceSearchCriteria.TYPE_STREAM);
            searchCriteria.setMaxResults(Integer.MAX_VALUE);
            PlaceSearchQuery query = new PlaceSearchQuery(repository, this.runner, searchCriteria, registry);
            query.setSupportDynamicUpdate(true);
            query.setAllowFolderActions(true);
            return query;
        }
        if (parent instanceof FolderNode) {
            node = (FolderNode)parent;
            return new ItemContainerQuery(((FolderNode)node).getRepo(), ((FolderNode)node).getOwner(), (IItemContainerHandle)((FolderNode)node).getItem(), this.runner, Collections.emptyList(), false);
        }
        if (parent instanceof AbstractPlaceWrapper) {
            AbstractPlaceWrapper workspaceNode = (AbstractPlaceWrapper)((Object)parent);
            ITeamRepository repo = workspaceNode.getRepository();
            return new HierarchicalRootComponentQuery(repo, workspaceNode.getWorkspace(), this.runner);
        }
        if (parent instanceof WorkspaceComponentWrapper && (data = (componentNode = (WorkspaceComponentWrapper)parent).getHierarchyData()) != null) {
            return new HierarchicalSubComponentQuery(componentNode, this.runner);
        }
        if (parent instanceof QueryItemWrapper) {
            return ((QueryItemWrapper)((Object)parent)).getQuery(null, this.runner);
        }
        if (parent instanceof RawSnapshotWrapper) {
            RawSnapshotWrapper wrapper = (RawSnapshotWrapper)((Object)parent);
            return new HierarchicalRootBaselineQuery(wrapper.getRepository(), wrapper.getSnapshot(), this.runner);
        }
        if (parent instanceof BaselineWrapper && (data = (baselineWrapper = (BaselineWrapper)parent).getHierarchyData()) != null && !((IBaselineHierarchyNode)data.getHierarchyNode()).getChildren().isEmpty()) {
            return new HierarchicalSubBaselineQuery(baselineWrapper, this.runner);
        }
        return null;
    }

    private List<Object> getRootContent(ITeamRepository repo, IProjectAreaHandle projectArea) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(new StreamsDomainNode(Messages.CombinedWorkspacesAndOwnedComponentsQuery_ALL_STREAMS, repo, projectArea));
        result.add(new ComponentsDomainNode(Messages.CombinedWorkspacesAndOwnedComponentsQuery_0, (IProcessAreaHandle)projectArea));
        result.add(new ScmQueryItemsNode(Messages.CombinedWorkspacesAndOwnedComponentsQuery_ALL_QUERIES, repo, (IProcessAreaHandle)projectArea));
        return result;
    }
}

