/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.domain;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.ui.wrapper.MoreQueryResultsWrapper;
import com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotQueryWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.snapshot.SnapshotSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.snapshot.SnapshotSearchQuery;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class SnapshotQueryItemQuery
extends RepositoryQuery {
    private SnapshotSearchQuery fQuery;
    private SnapshotQueryWrapper fWrapper;
    private ISharedItemChangeListener itemChangeListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            boolean shouldRefresh = false;
            for (Object o : events) {
                if (!(o instanceof ISharedItemChangeEvent)) continue;
                ISharedItemChangeEvent event = (ISharedItemChangeEvent)o;
                IItem beforeItem = event.getBeforeState();
                IItem afterItem = event.getAfterState();
                if (!(beforeItem instanceof IQueryItem) || !(afterItem instanceof IQueryItem) || ((IQueryItem)beforeItem).sameCriteriaAs((IQueryItem)afterItem)) continue;
                shouldRefresh = true;
                break;
            }
            if (shouldRefresh) {
                Realm realm = SnapshotQueryItemQuery.this.getRealm();
                realm.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SnapshotQueryItemQuery.this.computeQuery();
                        SnapshotQueryItemQuery.this.refresh();
                    }
                });
            }
        }
    };
    private ISharedItemChangeListener itemDeleteListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            ArrayList<RawSnapshotWrapper> toRemove = new ArrayList<RawSnapshotWrapper>(events.size());
            for (Object obj : events) {
                IItem deletedItem;
                ISharedItemChangeEvent event;
                if (!(obj instanceof ISharedItemChangeEvent) || (event = (ISharedItemChangeEvent)obj).getAfterState() != null || !((deletedItem = event.getSharedItem()) instanceof IBaselineSet)) continue;
                RawSnapshotWrapper wrapper = new RawSnapshotWrapper((IBaselineSet)deletedItem);
                wrapper.setAllowFolderActions(true);
                toRemove.add(wrapper);
            }
            SnapshotQueryItemQuery.this.asyncRemoveElements(toRemove);
        }
    };

    public SnapshotQueryItemQuery(SnapshotQueryWrapper wrapper, IOperationRunner runner) {
        super(wrapper.getRepository(), runner);
        this.fWrapper = wrapper;
        this.computeQuery();
    }

    private void computeQuery() {
        IBaselineSetSearchCriteria searchCriteriaDTO = (IBaselineSetSearchCriteria)this.fWrapper.getQueryItem().getSearchCriteria();
        this.fQuery = (SnapshotSearchQuery)SnapshotSearchCriteria.createFromSearchCriteriaDTO(this.getRepository(), searchCriteriaDTO).getQuery(this.getOperationRunner(), true);
        this.fQuery.setShouldFetchOwners(false);
        this.fQuery.setAllowFolderActions(true);
    }

    public void refresh() {
        this.computeQuery();
        super.refresh();
    }

    protected List fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (needsRefresh) {
                ITeamRepository repo = this.fWrapper.getRepository();
                repo.itemManager().fetchCompleteItemsPermissionAware(Arrays.asList(this.fWrapper.getQueryItem()), 1, (IProgressMonitor)progress.newChild(10));
            }
            progress.setWorkRemaining(90);
            List result = this.fQuery.computeResult((IProgressMonitor)progress.newChild(90));
            if (result.size() == 1024) {
                MoreQueryResultsWrapper moreWrapper = new MoreQueryResultsWrapper(this.fWrapper.getRepository(), (IItem)this.fWrapper.getQueryItem());
                result.add(moreWrapper);
            }
            List list = result;
            return list;
        }
        catch (InvocationTargetException e) {
            FileSystemStatusUtil.getStatusFor((int)4, (String)"com.ibm.team.filesystem.ide.ui", (String)Messages.QueryItemQuery_fetchErrorMessage, (Throwable)e);
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            progress.done();
        }
    }

    protected void attachListeners() {
        this.getRepository().itemManager().addItemChangeListener(IQueryItem.ITEM_TYPE, this.itemChangeListener);
        this.getRepository().itemManager().addItemChangeListener(IBaselineSet.ITEM_TYPE, this.itemDeleteListener);
        this.computeQuery();
    }

    protected void detachListeners() {
        this.getRepository().itemManager().removeItemChangeListener(IQueryItem.ITEM_TYPE, this.itemChangeListener);
        this.getRepository().itemManager().removeItemChangeListener(IBaselineSet.ITEM_TYPE, this.itemDeleteListener);
    }

    public String getName() {
        return Messages.QueryItemQuery_queryName;
    }
}

