/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.domain;

import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeSetNode;
import com.ibm.team.filesystem.ui.domain.MyWorkspacesDomain;
import com.ibm.team.filesystem.ui.queries.FolderNode;
import com.ibm.team.filesystem.ui.queries.RepositoryNode;
import com.ibm.team.filesystem.ui.queries.ScmAllDomainNode;
import com.ibm.team.filesystem.ui.queries.ScmQueryItemsNode;
import com.ibm.team.filesystem.ui.queries.StreamsDomainNode;
import com.ibm.team.filesystem.ui.queries.SuspendedChangeSetsNode;
import com.ibm.team.filesystem.ui.queries.WorkspacesDomainNode;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceChangeSetWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.TeamPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.views.history.entries.VersionableHistoryEntry;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.internal.rcp.ui.DomainSelection;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IChangeSet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;

public class SelectionValidator {
    private List<ItemWrapper> items = new ArrayList<ItemWrapper>();

    public static TreeSelection getTreeSelection(ISelection selection) {
        TreeSelection treeSelection = null;
        if (selection instanceof DomainSelection) {
            IStructuredSelection original = ((DomainSelection)selection).getOriginal();
            if (original instanceof TreeSelection) {
                treeSelection = (TreeSelection)original;
            }
        } else if (selection instanceof TreeSelection) {
            treeSelection = (TreeSelection)selection;
        }
        return treeSelection;
    }

    public static boolean isSelectionInFolder(ISelection selection) {
        TreeSelection treeSelection = SelectionValidator.getTreeSelection(selection);
        if (treeSelection != null) {
            TreePath[] treePathArray = treeSelection.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object parent;
                TreePath path = treePathArray[n2];
                TreePath parentPath = path.getParentPath();
                if (parentPath != null && (parent = parentPath.getLastSegment()) instanceof FolderNode) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static Object getParentNode(ISelection selection) {
        TreeSelection treeSelection = SelectionValidator.getTreeSelection(selection);
        if (treeSelection != null) {
            TreePath[] treePathArray = treeSelection.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                TreePath parentPath = path.getParentPath();
                if (parentPath != null) {
                    return parentPath.getLastSegment();
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isSelectionInAllNode(ISelection selection) {
        TreeSelection treeSelection = SelectionValidator.getTreeSelection(selection);
        if (treeSelection != null) {
            TreePath[] treePathArray = treeSelection.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                TreePath parentPath = path.getParentPath();
                if (parentPath != null) {
                    Object parent = parentPath.getLastSegment();
                    if (parent instanceof ComponentWrapper && (parentPath = parentPath.getParentPath()) != null) {
                        parent = parentPath.getLastSegment();
                    }
                    return parent instanceof ScmAllDomainNode;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isSelectionOnlyInAllSuspendedNode(ISelection selection) {
        TreeSelection treeSelection = SelectionValidator.getTreeSelection(selection);
        if (treeSelection != null) {
            TreePath[] treePathArray = treeSelection.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                TreePath parentPath = path.getParentPath();
                if (parentPath != null) {
                    Object parent = parentPath.getLastSegment();
                    if (parent instanceof ComponentWrapper && (parentPath = parentPath.getParentPath()) != null) {
                        parent = parentPath.getLastSegment();
                    }
                    if (!(parent instanceof SuspendedChangeSetsNode)) {
                        return false;
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    public static boolean isSelectionInExpandedQueryNode(ISelection selection) {
        TreeSelection treeSelection = SelectionValidator.getTreeSelection(selection);
        if (treeSelection != null) {
            TreePath[] treePathArray = treeSelection.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object parent;
                TreePath path = treePathArray[n2];
                TreePath parentPath = path.getParentPath();
                if (parentPath != null && (parent = parentPath.getLastSegment()) instanceof QueryItemWrapper) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public SelectionValidator(ISelection selection) {
        this.processSelection(selection);
    }

    private void processSelection(ISelection selection) {
        if (selection instanceof DomainSelection) {
            selection = ((DomainSelection)selection).getOriginal();
        }
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (selection instanceof ITreeSelection) {
            this.processTreeSelection((ITreeSelection)selection);
        } else if (selection instanceof IStructuredSelection) {
            this.processStructuredSelection((IStructuredSelection)selection);
        } else {
            return;
        }
    }

    private void processTreeSelection(ITreeSelection treeSelection) {
        TreePath[] paths;
        ArrayList<ItemWrapper> items = new ArrayList<ItemWrapper>(treeSelection.size());
        TreePath[] treePathArray = paths = treeSelection.getPaths();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            ItemWrapper itemWrapper = null;
            Object obj = treePath.getLastSegment();
            if (obj == null) {
                return;
            }
            Object parent = treePath.getParentPath().getLastSegment();
            Object owner = treePath.getFirstSegment();
            if (obj instanceof FolderNode) {
                itemWrapper = new ItemWrapper((FolderNode)obj, parent);
            } else if (obj instanceof ContributorPlaceWrapper) {
                itemWrapper = new ItemWrapper((ContributorPlaceWrapper)((Object)obj), parent);
            } else if (obj instanceof TeamPlaceWrapper) {
                itemWrapper = new ItemWrapper((TeamPlaceWrapper)((Object)obj), parent, owner);
            } else if (obj instanceof QueryItemWrapper) {
                itemWrapper = new ItemWrapper((QueryItemWrapper)((Object)obj), parent, owner);
            } else if (obj instanceof RawSnapshotWrapper) {
                itemWrapper = new ItemWrapper((RawSnapshotWrapper)((Object)obj), parent, owner);
            } else if (obj instanceof ContributorPlaceChangeSetWrapper) {
                if (parent instanceof ComponentWrapper) {
                    parent = treePath.getParentPath().getParentPath().getLastSegment();
                }
                itemWrapper = new ItemWrapper((ContributorPlaceChangeSetWrapper)((Object)obj), parent, owner);
            } else if (obj instanceof ChangeSetNode) {
                ITeamRepository repo;
                ChangeSetNode node = (ChangeSetNode)obj;
                IChangeSet changeSet = node.getChangeSet();
                if (changeSet != null && (repo = (ITeamRepository)changeSet.getOrigin()) != null) {
                    ContributorPlaceChangeSetWrapper contributorPlaceChangeSetWrapper = new ContributorPlaceChangeSetWrapper(repo, changeSet);
                    itemWrapper = new ItemWrapper(contributorPlaceChangeSetWrapper, null, (Object)repo.loggedInContributor());
                }
                if (itemWrapper == null) {
                    return;
                }
            } else {
                return;
            }
            items.add(itemWrapper);
            ++n2;
        }
        this.items = items;
    }

    private void processStructuredSelection(IStructuredSelection structureSelection) {
        if (structureSelection == null) {
            return;
        }
        if (structureSelection.isEmpty()) {
            return;
        }
        ArrayList<ItemWrapper> items = new ArrayList<ItemWrapper>(structureSelection.size());
        Object[] objectArray = structureSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repo;
            IChangeSet changeSet;
            Object obj = objectArray[n2];
            if (obj instanceof RawSnapshotWrapper) {
                items.add(new ItemWrapper((RawSnapshotWrapper)((Object)obj)));
            } else if (obj instanceof VersionableHistoryEntry) {
                ITeamRepository repo2;
                VersionableHistoryEntry historyEntry = (VersionableHistoryEntry)obj;
                ChangeSetWrapper changeSetWrapper = historyEntry.getChangeSet();
                if (changeSetWrapper != null && (repo2 = (ITeamRepository)(changeSet = changeSetWrapper.getChangeSet()).getOrigin()) != null) {
                    items.add(new ItemWrapper(new ContributorPlaceChangeSetWrapper(repo2, changeSet), null, (Object)repo2.loggedInContributor()));
                }
            } else if (obj instanceof ChangeSetInContextWrapper) {
                ChangeSetInContextWrapper contextWrapper = (ChangeSetInContextWrapper)((Object)obj);
                repo = contextWrapper.getRepository();
                changeSet = contextWrapper.getChangeSet();
                ContributorPlaceChangeSetWrapper wrapper = new ContributorPlaceChangeSetWrapper(repo, changeSet);
                ItemWrapper itemWrapper = new ItemWrapper(wrapper, null, (Object)repo.loggedInContributor());
                itemWrapper.setCanBeMoved(false);
                items.add(itemWrapper);
            } else if (obj instanceof ChangeSetNode) {
                ChangeSetNode wrapper = (ChangeSetNode)obj;
                repo = wrapper.getActivitySource().getTeamRepository();
                ContributorPlaceChangeSetWrapper contributorPlaceChangeSetWrapper = new ContributorPlaceChangeSetWrapper(repo, wrapper.getChangeSet());
                ItemWrapper itemWrapper = new ItemWrapper(contributorPlaceChangeSetWrapper, null, (Object)repo.loggedInContributor());
                itemWrapper.setCanBeMoved(false);
                items.add(itemWrapper);
            }
            ++n2;
        }
        this.items = items;
    }

    public boolean isValid() {
        return this.isValid(true);
    }

    public boolean isValid(boolean requireSameOwner) {
        return this.isValid(null, requireSameOwner);
    }

    public boolean isValid(DropTargetWrapper dropTarget, boolean enforceSameOwner) {
        if (this.items.isEmpty()) {
            return false;
        }
        ITeamRepository repo = null;
        IItemHandle owner = null;
        for (ItemWrapper itemWrapper : this.items) {
            if (repo == null) {
                repo = itemWrapper.repo;
                owner = itemWrapper.getOwner();
                continue;
            }
            if (!repo.equals(itemWrapper.repo)) {
                return false;
            }
            if (!enforceSameOwner || !(owner == null ? itemWrapper.getOwner() != null : !owner.sameItemId(itemWrapper.getOwner()))) continue;
            return false;
        }
        if (dropTarget != null) {
            return this.validateTarget(dropTarget);
        }
        return true;
    }

    private boolean validateTarget(DropTargetWrapper dropTarget) {
        if (dropTarget.getRepository() == null || !dropTarget.getRepository().equals(this.getRepository())) {
            return false;
        }
        if (dropTarget.getItem() instanceof DomainSubtreeRoot && TeamPlatform.getTeamRepositoryService().getTeamRepositories().length > 1) {
            return false;
        }
        for (ItemWrapper itemWrapper : this.items) {
            if (!dropTarget.getItem().equals(itemWrapper.parent) && !dropTarget.getItem().equals(itemWrapper.item)) continue;
            return false;
        }
        if (dropTarget.hasProjectAreaParent() && this.hasContributorOwner()) {
            return false;
        }
        return dropTarget.hasProjectAreaParent || !this.hasFolder() || !this.hasProjectAreaOwner();
    }

    public boolean hasAllNodeParent() {
        for (ItemWrapper itemWrapper : this.items) {
            if (!(itemWrapper.parent instanceof ScmAllDomainNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWorkspacesDomainNodeParent() {
        for (ItemWrapper itemWrapper : this.items) {
            if (!(itemWrapper.parent instanceof WorkspacesDomainNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasContributorOwner() {
        for (ItemWrapper itemWrapper : this.items) {
            if (!(itemWrapper.owner instanceof IContributorHandle)) continue;
            return true;
        }
        return false;
    }

    public boolean canBeMoved() {
        for (ItemWrapper itemWrapper : this.items) {
            if (itemWrapper.canBeMoved()) continue;
            return false;
        }
        return true;
    }

    public boolean hasProjectAreaOwner() {
        return !this.hasContributorOwner();
    }

    public boolean hasStreamsDomainNodeParent() {
        for (ItemWrapper itemWrapper : this.items) {
            if (!(itemWrapper.parent instanceof StreamsDomainNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasQueriesDomainNodeParent() {
        for (ItemWrapper itemWrapper : this.items) {
            if (!(itemWrapper.parent instanceof ScmQueryItemsNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasQueryItemWrapperParent() {
        for (ItemWrapper itemWrapper : this.items) {
            if (!(itemWrapper.parent instanceof QueryItemWrapper)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFolder() {
        for (ItemWrapper itemWrapper : this.items) {
            if (!(itemWrapper.item instanceof IItemContainerHandle)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSnapshot() {
        for (ItemWrapper itemWrapper : this.items) {
            if (!(itemWrapper.item instanceof IBaselineSet)) continue;
            return true;
        }
        return false;
    }

    public List<ItemWrapper> getItems() {
        return this.items;
    }

    public ITeamRepository getRepository() {
        if (this.items.isEmpty()) {
            return null;
        }
        return this.items.get(0).getRepository();
    }

    public IItemHandle getOwner() {
        if (this.items.isEmpty()) {
            return null;
        }
        return this.items.get(0).getOwner();
    }

    public static class DropTargetWrapper {
        Object target;
        private ITeamRepository repository;
        private IItemHandle owner;
        private boolean hasProjectAreaParent;

        public DropTargetWrapper(Object target) {
            this.target = target;
            this.initialize();
        }

        private void initialize() {
            if (this.target instanceof FolderNode) {
                FolderNode folderNode = (FolderNode)this.target;
                this.repository = folderNode.getRepo();
                this.owner = folderNode.getOwner();
                this.hasProjectAreaParent = folderNode.inProjectAreaContext();
            } else if (this.target instanceof DomainSubtreeRoot) {
                ITeamRepository[] repos;
                DomainSubtreeRoot rootNode = (DomainSubtreeRoot)this.target;
                if (rootNode.getCategoryElement() instanceof IProjectArea) {
                    IProjectArea projectArea = (IProjectArea)rootNode.getCategoryElement();
                    this.repository = (ITeamRepository)projectArea.getOrigin();
                    this.owner = projectArea;
                    this.hasProjectAreaParent = true;
                } else if (rootNode.getDomain() instanceof MyWorkspacesDomain && (repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories()).length == 1) {
                    this.repository = repos[0];
                    this.owner = repos[0].loggedInContributor();
                    this.hasProjectAreaParent = false;
                }
            } else if (this.target instanceof RepositoryNode) {
                RepositoryNode repositoryNode = (RepositoryNode)this.target;
                this.repository = repositoryNode.getRepository();
                this.owner = this.repository.loggedInContributor();
                this.hasProjectAreaParent = false;
            }
        }

        public IItemHandle getOwner() {
            return this.owner;
        }

        public ITeamRepository getRepository() {
            return this.repository;
        }

        public boolean hasProjectAreaParent() {
            return this.hasProjectAreaParent;
        }

        public Object getItem() {
            return this.target;
        }

        public IItemContainerHandle getParentFolder() {
            if (this.target instanceof FolderNode) {
                return ((FolderNode)this.target).getItem();
            }
            return null;
        }

        public IItemContainerHandle getItemContainer() {
            if (this.target instanceof FolderNode) {
                return ((FolderNode)this.target).getItem();
            }
            return null;
        }
    }

    public class ItemWrapper {
        private Object parent;
        private IItem item;
        private IItemHandle owner;
        private ITeamRepository repo;
        private boolean canBeMoved = true;

        public ItemWrapper(FolderNode folder, Object parent) {
            this.repo = folder.getRepo();
            this.owner = folder.getOwner();
            this.item = folder.getItem();
            this.parent = parent;
        }

        public ItemWrapper(RawSnapshotWrapper snapshot) {
            this.repo = snapshot.getRepository();
            this.item = snapshot.getItem();
        }

        public ItemWrapper(RawSnapshotWrapper snapshot, Object parent, Object ownerObj) {
            this.repo = snapshot.getRepository();
            this.item = snapshot.getItem();
            this.owner = ownerObj instanceof DomainSubtreeRoot ? this.repo.loggedInContributor() : (IItemHandle)ownerObj;
            this.parent = parent;
        }

        public ItemWrapper(ContributorPlaceWrapper contributorPlaceWrapper, Object parent) {
            this.repo = contributorPlaceWrapper.getRepository();
            this.owner = this.repo.loggedInContributor();
            this.item = contributorPlaceWrapper.getItem();
            this.parent = parent;
        }

        public ItemWrapper(TeamPlaceWrapper teamPlaceWrapper, Object parent, Object ownerObj) {
            this.repo = teamPlaceWrapper.getRepository();
            this.owner = ownerObj instanceof DomainSubtreeRoot ? this.repo.loggedInContributor() : (IItemHandle)ownerObj;
            this.parent = parent;
            this.item = teamPlaceWrapper.getItem();
        }

        public ItemWrapper(QueryItemWrapper queryItemWrapper, Object parent, Object ownerObj) {
            this.repo = queryItemWrapper.getRepository();
            this.owner = ownerObj instanceof DomainSubtreeRoot ? this.repo.loggedInContributor() : (IItemHandle)ownerObj;
            this.parent = parent;
            this.item = queryItemWrapper.getQueryItem();
        }

        public ItemWrapper(ContributorPlaceChangeSetWrapper wrapper, Object parent, Object ownerObj) {
            this.repo = wrapper.getRepository();
            this.owner = ownerObj instanceof DomainSubtreeRoot ? this.repo.loggedInContributor() : (IItemHandle)ownerObj;
            this.parent = parent;
            this.item = wrapper.getChangeSet();
        }

        public IItem getItem() {
            return this.item;
        }

        public IItemContainerHandle getParentFolder() {
            if (this.parent instanceof FolderNode) {
                return ((FolderNode)this.parent).getItem();
            }
            return null;
        }

        public IItemHandle getOwner() {
            return this.owner;
        }

        public ITeamRepository getRepository() {
            return this.repo;
        }

        public void setCanBeMoved(boolean value) {
            this.canBeMoved = value;
        }

        public boolean canBeMoved() {
            return this.canBeMoved;
        }
    }
}

