/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.domain;

import com.ibm.team.filesystem.ui.domain.SelectionValidator;
import com.ibm.team.internal.filesystem.ui.ItemContainerManager;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.operations.AddToFolderOperation;
import com.ibm.team.internal.filesystem.ui.operations.MoveToFolderOperation;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.TreeProviderDomain;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConcurrentTreeContentProvider;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;

public abstract class ScmDomain
extends TreeProviderDomain {
    private IOperationRunner dndOperationRunner;
    ItemContainerManager.IItemContainerListener containerChangeListener = new ItemContainerManager.IItemContainerListener(){

        @Override
        public void contentChanged() {
            new UIJob(Messages.ScmDomain_setTreeSelectionJobName){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ConcurrentTreeContentProvider contentProvider = ScmDomain.this.internalGetContentProvider();
                    if (contentProvider != null && contentProvider.getViewer() != null) {
                        contentProvider.getViewer().setSelection((ISelection)new StructuredSelection(), false);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    };

    public boolean validateDrop(Object target, ISelection selection, int operation) {
        SelectionValidator.DropTargetWrapper dropTarget = new SelectionValidator.DropTargetWrapper(target);
        SelectionValidator selectionValidator = new SelectionValidator(selection);
        return selectionValidator.isValid(dropTarget, false);
    }

    protected abstract boolean areSourcesInDomain(IItemHandle var1);

    public int getSupportedOperationsForSelection(ISelection selection) {
        int result = 1;
        SelectionValidator validator = new SelectionValidator(selection);
        if (!validator.canBeMoved()) {
            return result;
        }
        if (this.areSourcesInDomain(validator.getOwner()) && !validator.hasAllNodeParent() && !validator.hasQueryItemWrapperParent()) {
            result |= 4;
        }
        return result;
    }

    public boolean performDrop(Object target, ISelection selection, int dndOperation) {
        switch (dndOperation) {
            case 1: {
                this.doAdd(new SelectionValidator.DropTargetWrapper(target), selection);
                return true;
            }
            case 4: {
                this.doMove(new SelectionValidator.DropTargetWrapper(target), selection);
                return true;
            }
        }
        return false;
    }

    private void doAdd(SelectionValidator.DropTargetWrapper target, ISelection selection) {
        final AddToFolderOperation operation = new AddToFolderOperation();
        SelectionValidator validator = new SelectionValidator(selection);
        if (target.getOwner() != null) {
            for (SelectionValidator.ItemWrapper wrapper : validator.getItems()) {
                operation.add(target.getOwner(), target.getParentFolder(), wrapper.getItem());
            }
        }
        this.getDnDOperationRunner().enqueue(Messages.AddToFolderAction_OperationName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                operation.run(monitor, problems);
            }
        });
        ItemContainerManager.getInstance().fireChangeEvents();
    }

    private void doMove(SelectionValidator.DropTargetWrapper target, ISelection selection) {
        final MoveToFolderOperation operation = new MoveToFolderOperation();
        SelectionValidator validator = new SelectionValidator(selection);
        if (target.getOwner() != null) {
            operation.setTarget(target.getItemContainer());
            for (SelectionValidator.ItemWrapper wrapper : validator.getItems()) {
                operation.move(wrapper.getOwner(), wrapper.getParentFolder(), wrapper.getItem());
            }
        }
        this.getDnDOperationRunner().enqueue(Messages.MoveToFolderAction_OperationName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                operation.run(monitor, problems);
            }
        });
        ItemContainerManager.getInstance().fireChangeEvents();
    }

    protected IOperationRunner getDnDOperationRunner() {
        if (this.dndOperationRunner == null) {
            IWorkbenchPart workbenchPart = this.getWorkbenchPart();
            this.dndOperationRunner = workbenchPart == null ? new JobRunner(this.getName(), true) : new PartSiteJobRunner(workbenchPart.getSite(), true);
        }
        return this.dndOperationRunner;
    }

    protected void attachContainerChangeListener() {
        ItemContainerManager.getInstance().addListener(this.containerChangeListener);
    }

    protected void detachContainerChangeListener() {
        ItemContainerManager.getInstance().removeListener(this.containerChangeListener);
    }

    public void dispose() {
        this.detachContainerChangeListener();
        super.dispose();
    }
}

