/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.domain;

import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.filesystem.ui.domain.MyWorkspacesDomain;
import com.ibm.team.filesystem.ui.queries.ComponentsDomainNode;
import com.ibm.team.filesystem.ui.queries.FolderNode;
import com.ibm.team.filesystem.ui.queries.HierarchicalRootBaselineQuery;
import com.ibm.team.filesystem.ui.queries.HierarchicalRootComponentQuery;
import com.ibm.team.filesystem.ui.queries.HierarchicalSubBaselineQuery;
import com.ibm.team.filesystem.ui.queries.HierarchicalSubComponentQuery;
import com.ibm.team.filesystem.ui.queries.ItemContainerQuery;
import com.ibm.team.filesystem.ui.queries.RepositoryNode;
import com.ibm.team.filesystem.ui.queries.RepositorySpanningQuery;
import com.ibm.team.filesystem.ui.queries.ScmAllDomainNode;
import com.ibm.team.filesystem.ui.queries.ScmQueryItemsNode;
import com.ibm.team.filesystem.ui.queries.SuspendedChangeSetsNode;
import com.ibm.team.filesystem.ui.queries.WorkspacesDomainNode;
import com.ibm.team.filesystem.ui.views.AbstractRepositoryTreeProvider;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.HierarchyData;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ComponentsWithSuspendedChangeSetsQuery;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.SuspendedChangeSetsQuery;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.query.ScmQueryItemSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.OwnerSearchQuery;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.PlaceSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.PlaceSearchQuery;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.CachingSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IBaselineHierarchyNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.runtime.AssertionFailedException;

public class MyWorkspacesDomainTreeProvider
extends AbstractRepositoryTreeProvider {
    private MyWorkspacesDomain workspacesDomain;
    private IOperationRunner runner;
    private RootNodeQuery rootNode;
    private Map<ITeamRepository, ItemContainerQuery> repoNodeQueries;
    private Map<ITeamRepository, PlaceSearchQuery> workspaceNodeQueries;

    public MyWorkspacesDomainTreeProvider(MyWorkspacesDomain workspacesDomain, IOperationRunner runner) {
        this.workspacesDomain = workspacesDomain;
        this.runner = runner;
        this.repoNodeQueries = new HashMap<ITeamRepository, ItemContainerQuery>();
        this.workspaceNodeQueries = new HashMap<ITeamRepository, PlaceSearchQuery>();
    }

    public void dispose() {
        this.rootNode.dispose();
        for (ItemContainerQuery itemContainerQuery : this.repoNodeQueries.values()) {
            itemContainerQuery.dispose();
        }
        for (PlaceSearchQuery placeSearchQuery : this.workspaceNodeQueries.values()) {
            placeSearchQuery.dispose();
        }
        this.repoNodeQueries.clear();
    }

    public static ISetWithListeners<AbstractPlaceWrapper> getAllMyWorkspacesQuery(IOperationRunner runner) {
        return MyWorkspacesDomainTreeProvider.getAllMyWorkspacesQuery(runner, null);
    }

    public static ISetWithListeners<AbstractPlaceWrapper> getAllMyWorkspacesQuery(final IOperationRunner runner, Object rootNode) {
        return new RepositorySpanningQuery<AbstractPlaceWrapper>(new IConversion<ITeamRepository, ISetWithListeners<AbstractPlaceWrapper>>(){

            public ISetWithListeners<AbstractPlaceWrapper> createAdapter(ITeamRepository repo) {
                PlaceSearchCriteria criteria = new PlaceSearchCriteria(repo).withOwnedBy(OwnerSearchQuery.CURRENT_CONTRIBUTOR).withType(PlaceSearchCriteria.TYPE_WORKSPACE);
                criteria.setMaxResults(Integer.MAX_VALUE);
                PlaceSearchQuery query = new PlaceSearchQuery(repo, runner, criteria);
                query.setSupportDynamicUpdate(true);
                query.setAutoUpdate(true);
                query.setAllowFolderActions(true);
                return query;
            }
        }, rootNode);
    }

    public ISetWithListeners<ComponentWrapper> getComponentsFor(IOperationRunner runner, ITeamRepository repository) {
        if (repository == null) {
            return this.getComponentsFor(runner);
        }
        ComponentSearchCriteria criteria = new ComponentSearchCriteria(repository).withOwnedBy(OwnerSearchQuery.CURRENT_CONTRIBUTOR);
        criteria.setMaxResults(Integer.MAX_VALUE);
        return criteria.getQuery(runner);
    }

    public ISetWithListeners<ComponentWrapper> getComponentsFor(final IOperationRunner runner) {
        return new RepositorySpanningQuery<ComponentWrapper>(new IConversion<ITeamRepository, ISetWithListeners<ComponentWrapper>>(){

            public ISetWithListeners<ComponentWrapper> createAdapter(ITeamRepository source) {
                ComponentSearchCriteria criteria = new ComponentSearchCriteria(source).withOwnedBy(OwnerSearchQuery.CURRENT_CONTRIBUTOR);
                criteria.setMaxResults(Integer.MAX_VALUE);
                return criteria.getQuery(runner);
            }
        }, null);
    }

    public ISetWithListeners getChildren(Object parent) {
        BaselineWrapper baselineWrapper;
        WorkspaceComponentWrapper componentNode;
        HierarchyData data;
        Object node;
        if (parent instanceof DomainSubtreeRoot) {
            if (this.rootNode == null) {
                this.rootNode = new RootNodeQuery(this.workspacesDomain, this.runner);
            }
            return this.rootNode;
        }
        if (parent instanceof RepositoryNode) {
            RepositoryNode repoNode = (RepositoryNode)parent;
            ITeamRepository repo = repoNode.getRepository();
            ItemContainerQuery query = this.repoNodeQueries.get(repo);
            if (query == null) {
                query = new ItemContainerQuery(repo, (IItemHandle)repo.loggedInContributor(), null, this.runner, MyWorkspacesDomainTreeProvider.getRootContent(repo, this.workspacesDomain), false);
                this.repoNodeQueries.put(repo, query);
            }
            return query;
        }
        if (parent instanceof FolderNode) {
            FolderNode node2 = (FolderNode)parent;
            ItemContainerQuery query = new ItemContainerQuery(node2.getRepo(), node2.getOwner(), (IItemContainerHandle)node2.getItem(), this.runner, Collections.emptyList(), false);
            return query;
        }
        if (parent instanceof WorkspacesDomainNode) {
            WorkspacesDomainNode node3 = (WorkspacesDomainNode)parent;
            ITeamRepository repo = node3.getRepository();
            PlaceSearchQuery query = this.workspaceNodeQueries.get(repo);
            if (query == null) {
                PlaceSearchCriteria searchCriteria = new PlaceSearchCriteria(repo);
                searchCriteria = searchCriteria.withOwnedBy(OwnerSearchQuery.CURRENT_CONTRIBUTOR);
                searchCriteria = searchCriteria.withType(PlaceSearchCriteria.TYPE_WORKSPACE);
                searchCriteria.setMaxResults(Integer.MAX_VALUE);
                query = new PlaceSearchQuery(repo, this.runner, searchCriteria);
                query.setSupportDynamicUpdate(true);
                query.setAllowFolderActions(true);
                this.workspaceNodeQueries.put(repo, query);
            }
            return query;
        }
        if (parent instanceof SuspendedChangeSetsNode) {
            SuspendedChangeSetsNode node4 = (SuspendedChangeSetsNode)parent;
            ComponentsWithSuspendedChangeSetsQuery query = new ComponentsWithSuspendedChangeSetsQuery(node4.getRepository(), this.runner);
            return query;
        }
        if (parent instanceof ComponentWrapper && ((ComponentWrapper)((Object)(node = (ComponentWrapper)((Object)parent)))).shouldAllowSuspendedChangeSetChildren()) {
            ITeamRepository repo = ((ComponentWrapper)((Object)node)).getRepository();
            SuspendedChangeSetsQuery query = new SuspendedChangeSetsQuery(repo, ((ComponentWrapper)((Object)node)).getComponent(), this.runner);
            return query;
        }
        if (parent instanceof ScmQueryItemsNode) {
            node = (ScmQueryItemsNode)parent;
            ScmQueryItemSearchCriteria criteria = new ScmQueryItemSearchCriteria(((ScmAllDomainNode)node).getRepository(), null).withOwner(OwnerSearchQuery.CURRENT_CONTRIBUTOR);
            criteria.setMaxResults(Integer.MAX_VALUE);
            return criteria.getQuery(this.runner);
        }
        if (parent instanceof ComponentsDomainNode) {
            ComponentsDomainNode componentsFolderNode = (ComponentsDomainNode)parent;
            return this.getComponentsFor(this.runner, componentsFolderNode.getRepo());
        }
        if (parent instanceof AbstractPlaceWrapper) {
            AbstractPlaceWrapper workspaceNode = (AbstractPlaceWrapper)((Object)parent);
            ITeamRepository repo = workspaceNode.getRepository();
            return new HierarchicalRootComponentQuery(repo, workspaceNode.getWorkspace(), this.runner);
        }
        if (parent instanceof WorkspaceComponentWrapper && (data = (componentNode = (WorkspaceComponentWrapper)parent).getHierarchyData()) != null) {
            return new HierarchicalSubComponentQuery(componentNode, this.runner);
        }
        if (parent instanceof QueryItemWrapper) {
            return ((QueryItemWrapper)((Object)parent)).getQuery(null, this.runner);
        }
        if (parent instanceof RawSnapshotWrapper) {
            RawSnapshotWrapper wrapper = (RawSnapshotWrapper)((Object)parent);
            return new HierarchicalRootBaselineQuery(wrapper.getRepository(), wrapper.getSnapshot(), this.runner);
        }
        if (parent instanceof BaselineWrapper && (data = (baselineWrapper = (BaselineWrapper)parent).getHierarchyData()) != null && !((IBaselineHierarchyNode)data.getHierarchyNode()).getChildren().isEmpty()) {
            return new HierarchicalSubBaselineQuery(baselineWrapper, this.runner);
        }
        return null;
    }

    public void refresh() {
        this.rootNode.refresh();
    }

    private static List<Object> getRootContent(ITeamRepository repo, MyWorkspacesDomain domain) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(new WorkspacesDomainNode(Messages.MyWorkspacesDomainTreeProvider_MyWorkspacesNodeTitle, repo, domain));
        result.add(new ComponentsDomainNode(Messages.MyWorkspacesDomainTreeProvider_MyComponentsNodeTitle, repo));
        result.add(new ScmQueryItemsNode(Messages.MyWorkspacesDomainTreeProvider_MyQueriesNodeTitle, repo));
        result.add(new SuspendedChangeSetsNode(Messages.MyWorkspacesDomainTreeProvider_MySuspendedChangeSets, repo));
        return result;
    }

    private static class KnownWrappedTeamRepositoryQuery
    extends CachingSet<RepositoryNode> {
        private MyWorkspacesDomain workspacesDomain;
        private ITeamRepositoryService.IRepositoryServiceListener repoAddRemoveListener = new ITeamRepositoryService.IRepositoryServiceListener(){

            public void addedRepository(ITeamRepository repositiory) {
                repositiory.addGenericListener((Object)"com.ibm.team.repository.PropertySet", repoRenameListener);
            }

            public void removedRepository(ITeamRepository repository) {
                repository.removeGenericListener((Object)"com.ibm.team.repository.PropertySet", repoRenameListener);
            }
        };
        private IListener repoRenameListener = new IListener(){

            public void handleEvents(List events) {
                for (Object event : events) {
                    PropertyChangeEvent propertyChangeEvent;
                    if (!(event instanceof PropertyChangeEvent) || !(propertyChangeEvent = (PropertyChangeEvent)event).getProperty().equals("name") || workspacesDomain == null || workspacesDomain.isDisposed()) continue;
                    workspacesDomain.refresh();
                }
            }
        };

        public KnownWrappedTeamRepositoryQuery(MyWorkspacesDomain workspacesDomain) {
            this.workspacesDomain = workspacesDomain;
            TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(this.repoAddRemoveListener);
            Set<RepositoryNode> initialRepos = this.getElements();
            for (RepositoryNode repoNode : initialRepos) {
                repoNode.getRepository().addGenericListener((Object)"com.ibm.team.repository.PropertySet", this.repoRenameListener);
            }
            this.setContents(this.getElements());
        }

        protected void update() {
            this.asyncSetContents(this.getElements());
        }

        public Set<RepositoryNode> getElements() {
            ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            HashSet<RepositoryNode> result = new HashSet<RepositoryNode>();
            int i = 0;
            while (i < repositories.length) {
                result.add(new RepositoryNode(repositories[i]));
                ++i;
            }
            return result;
        }

        public void dispose() {
            ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener(this.repoAddRemoveListener);
            int i = 0;
            while (i < repositories.length) {
                repositories[i].removeGenericListener((Object)"com.ibm.team.repository.PropertySet", this.repoRenameListener);
                ++i;
            }
        }
    }

    private static final class RootNodeQuery
    extends AbstractSetWithListeners<Object>
    implements IRefreshable {
        private MyWorkspacesDomain workspacesDomain;
        private ITeamRepository singleRepo;
        private ItemContainerQuery singleRepositoryQuery;
        private KnownWrappedTeamRepositoryQuery multipleRepositoryQuery;
        private IOperationRunner runner;
        private boolean isShowingSingleRepo = false;
        private RootNodeQuerySetChangeListener singleRepoSetChangeListener;
        private RootNodeQuerySetChangeListener multipleRepoSetChangeListener;

        public RootNodeQuery(MyWorkspacesDomain workspacesDomain, IOperationRunner runner) {
            this.workspacesDomain = workspacesDomain;
            this.runner = runner;
            this.multipleRepositoryQuery = new KnownWrappedTeamRepositoryQuery(workspacesDomain);
            this.multipleRepoSetChangeListener = new RootNodeQuerySetChangeListener(this);
            this.multipleRepositoryQuery.addSetChangeListener(this.multipleRepoSetChangeListener);
        }

        private void clearSingleRepositoryQuery() {
            if (this.singleRepositoryQuery != null && !this.singleRepositoryQuery.isDisposed() && this.singleRepoSetChangeListener != null) {
                this.singleRepositoryQuery.removeSetChangeListener(this.singleRepoSetChangeListener);
                this.singleRepoSetChangeListener = null;
                this.singleRepositoryQuery.dispose();
                this.singleRepositoryQuery = null;
            }
        }

        protected Collection<Object> computeElements() {
            if (this.shouldUseSingleRepositoryQuery()) {
                this.isShowingSingleRepo = true;
                ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
                ITeamRepository repo = repositories[0];
                if (this.singleRepo == null || !repo.getRepositoryURI().equals(this.singleRepo.getRepositoryURI())) {
                    this.singleRepo = repo;
                    this.clearSingleRepositoryQuery();
                }
                if (this.singleRepositoryQuery == null) {
                    this.singleRepositoryQuery = new ItemContainerQuery(repo, (IItemHandle)repo.loggedInContributor(), null, this.runner, MyWorkspacesDomainTreeProvider.getRootContent(repo, this.workspacesDomain), false);
                    if (this.singleRepoSetChangeListener == null) {
                        this.singleRepoSetChangeListener = new RootNodeQuerySetChangeListener(this);
                    }
                    this.singleRepositoryQuery.addSetChangeListener(this.singleRepoSetChangeListener);
                }
                return this.singleRepositoryQuery;
            }
            this.clearSingleRepositoryQuery();
            if (this.isShowingSingleRepo) {
                this.multipleRepositoryQuery.update();
            }
            this.isShowingSingleRepo = false;
            return this.multipleRepositoryQuery;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh() {
            Realm realm;
            Realm realm2 = realm = this.getRealm();
            synchronized (realm2) {
                realm.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        block10: {
                            try {
                                if (this.shouldUseSingleRepositoryQuery()) {
                                    if (!multipleRepositoryQuery.isDisposed()) {
                                        for (RepositoryNode o : multipleRepositoryQuery.getElements()) {
                                            this.fireRemoved(o);
                                        }
                                    }
                                } else if (singleRepositoryQuery != null && !singleRepositoryQuery.isDisposed()) {
                                    Iterator iterator = singleRepositoryQuery.iterator();
                                    while (iterator.hasNext()) {
                                        Object o = iterator.next();
                                        this.fireRemoved(o);
                                    }
                                }
                                this.computeElements();
                                if (singleRepositoryQuery != null && !singleRepositoryQuery.isDisposed()) {
                                    singleRepositoryQuery.update();
                                }
                                if (multipleRepositoryQuery != null && !multipleRepositoryQuery.isDisposed()) {
                                    multipleRepositoryQuery.update();
                                }
                            }
                            catch (AssertionFailedException e) {
                                if (e.getMessage().contains("Getter called on disposed observable")) break block10;
                                throw e;
                            }
                        }
                    }
                });
            }
        }

        public synchronized void dispose() {
            this.singleRepo = null;
            this.clearSingleRepositoryQuery();
            if (this.multipleRepositoryQuery != null && !this.multipleRepositoryQuery.isDisposed() && this.multipleRepoSetChangeListener != null) {
                this.multipleRepositoryQuery.removeSetChangeListener(this.multipleRepoSetChangeListener);
                this.multipleRepoSetChangeListener = null;
                this.multipleRepositoryQuery.dispose();
                this.multipleRepositoryQuery = null;
            }
            super.dispose();
        }

        public boolean canRefresh() {
            return true;
        }

        private void fireSetChange(SetChangeEvent event) {
            this.fireSetChange(event.diff);
        }

        private boolean shouldUseSingleRepositoryQuery() {
            ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            return repositories.length == 1;
        }
    }

    private static final class RootNodeQuerySetChangeListener
    implements ISetChangeListener {
        private RootNodeQuery query;

        public RootNodeQuerySetChangeListener(RootNodeQuery query) {
            this.query = query;
        }

        public void handleSetChange(SetChangeEvent event) {
            this.query.fireSetChange(event);
        }
    }
}

