/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.domain;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.ui.wrapper.BaselineQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.MoreQueryResultsWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.baseline.BaselineSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.baseline.BaselineSearchQuery;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.dto.IBaselineSearchCriteria;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class BaselineQueryItemQuery
extends RepositoryQuery {
    private BaselineSearchQuery fQuery;
    private BaselineQueryWrapper fWrapper;
    private ISharedItemChangeListener itemChangeListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            boolean shouldRefresh = false;
            for (Object o : events) {
                if (!(o instanceof ISharedItemChangeEvent)) continue;
                ISharedItemChangeEvent event = (ISharedItemChangeEvent)o;
                IItem beforeItem = event.getBeforeState();
                IItem afterItem = event.getAfterState();
                if (!(beforeItem instanceof IQueryItem) || !(afterItem instanceof IQueryItem) || ((IQueryItem)beforeItem).sameCriteriaAs((IQueryItem)afterItem)) continue;
                shouldRefresh = true;
                break;
            }
            if (shouldRefresh) {
                Realm realm = BaselineQueryItemQuery.this.getRealm();
                realm.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BaselineQueryItemQuery.this.computeQuery();
                        BaselineQueryItemQuery.this.refresh();
                    }
                });
            }
        }
    };

    public BaselineQueryItemQuery(BaselineQueryWrapper wrapper, IOperationRunner runner) {
        super(wrapper.getRepository(), runner);
        this.fWrapper = wrapper;
        this.computeQuery();
    }

    private void computeQuery() {
        IBaselineSearchCriteria searchCriteriaDTO = (IBaselineSearchCriteria)this.fWrapper.getQueryItem().getSearchCriteria();
        this.fQuery = (BaselineSearchQuery)BaselineSearchCriteria.createFromSearchCriteriaDTO(this.getRepository(), searchCriteriaDTO).getQuery(this.getOperationRunner(), true);
        this.fQuery.setAllowFolderActions(true);
        this.fQuery.setCalculateBaselineHierarchy(true);
    }

    public void refresh() {
        this.computeQuery();
        super.refresh();
    }

    protected List fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (needsRefresh) {
                ITeamRepository repo = this.fWrapper.getRepository();
                repo.itemManager().fetchCompleteItemsPermissionAware(Arrays.asList(this.fWrapper.getQueryItem()), 1, (IProgressMonitor)progress.newChild(10));
            }
            progress.setWorkRemaining(90);
            List result = this.fQuery.computeResult((IProgressMonitor)progress.newChild(90));
            for (Object o : result) {
                if (!(o instanceof BaselineWrapper)) continue;
                BaselineWrapper wrapper = (BaselineWrapper)o;
                wrapper.setParentQuery(this.fWrapper.getQueryItem());
            }
            if (result.size() == 1024) {
                MoreQueryResultsWrapper moreWrapper = new MoreQueryResultsWrapper(this.fWrapper.getRepository(), (IItem)this.fWrapper.getQueryItem());
                result.add(moreWrapper);
            }
            List list = result;
            return list;
        }
        catch (InvocationTargetException e) {
            FileSystemStatusUtil.getStatusFor((int)4, (String)"com.ibm.team.filesystem.ide.ui", (String)Messages.QueryItemQuery_fetchErrorMessage, (Throwable)e);
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            progress.done();
        }
    }

    protected void attachListeners() {
        this.getRepository().itemManager().addItemChangeListener(IQueryItem.ITEM_TYPE, this.itemChangeListener);
        this.computeQuery();
    }

    protected void detachListeners() {
        this.getRepository().itemManager().removeItemChangeListener(IQueryItem.ITEM_TYPE, this.itemChangeListener);
    }

    public String getName() {
        return Messages.QueryItemQuery_queryName;
    }
}

