/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.configuration;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.internal.util.FetchProfile;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class AuditableFetcher {
    private ITeamRepository server;
    private ArrayList auditableHandles = new ArrayList();
    private HashMap mapItemIdOntoRec = new HashMap();
    private int blocksize = 64;

    public AuditableFetcher(ITeamRepository server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ItemId toAdd, FetchProfile profile) {
        AuditableFetcher auditableFetcher = this;
        synchronized (auditableFetcher) {
            AuditableRec rec = (AuditableRec)this.mapItemIdOntoRec.get(toAdd);
            if (rec == null) {
                rec = new AuditableRec(toAdd, this.auditableHandles.size(), profile);
                this.auditableHandles.add(rec);
                this.mapItemIdOntoRec.put(toAdd, rec);
            } else {
                rec.expandProfile(profile);
            }
        }
    }

    public void add(IAuditableHandle toAdd, FetchProfile profile) {
        this.add(new ItemId((IItemHandle)toAdd), profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        AuditableFetcher auditableFetcher = this;
        synchronized (auditableFetcher) {
            return this.auditableHandles.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAuditable fetch(int index, FetchProfile profile, IProgressMonitor rep) throws TeamRepositoryException {
        ItemId handle;
        AuditableFetcher auditableFetcher = this;
        synchronized (auditableFetcher) {
            AuditableRec rec = this.getRec(index);
            handle = rec.handle;
        }
        return this.fetch(handle, profile, rep);
    }

    private AuditableRec getRec(ItemId handle) {
        return (AuditableRec)this.mapItemIdOntoRec.get(handle);
    }

    private AuditableRec getRec(int index) {
        return (AuditableRec)this.auditableHandles.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IAuditable> T getFetched(ItemId<T> handle) {
        AuditableFetcher auditableFetcher = this;
        synchronized (auditableFetcher) {
            AuditableRec rec = this.getRec(handle);
            if (rec != null) {
                return (T)rec.auditable;
            }
        }
        return null;
    }

    public IAuditable getFetched(IAuditableHandle handle) {
        return this.getFetched(new ItemId((IItemHandle)handle));
    }

    public IAuditable fetch(IAuditableHandle handle, FetchProfile profile, IProgressMonitor mon) throws TeamRepositoryException {
        return this.fetch(new ItemId((IItemHandle)handle), profile, mon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAuditable fetch(ItemId handle, FetchProfile profile, IProgressMonitor rep) throws TeamRepositoryException {
        int blockStart;
        AuditableRec rec;
        AuditableFetcher auditableFetcher = this;
        synchronized (auditableFetcher) {
            this.add(handle, profile);
            rec = this.getRec(handle);
            if (rec.getFetchedProfile().contains(profile)) {
                return rec.auditable;
            }
            int blockNum = rec.index / this.blocksize;
            blockStart = blockNum * this.blocksize;
        }
        this.prefetchRange(blockStart, Math.min(this.blocksize, this.auditableHandles.size() - blockStart), rep);
        return rec.auditable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prefetchRange(int blockStart, int size, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<FetchProfile, ArrayList<ItemId>> mapFetchProfileToListOfHandles = new HashMap<FetchProfile, ArrayList<ItemId>>();
        int count = 0;
        AuditableFetcher auditableFetcher = this;
        synchronized (auditableFetcher) {
            int i = 0;
            while (i < size) {
                AuditableRec rec = this.getRec(blockStart + i);
                if (!rec.isFetched()) {
                    ArrayList<ItemId> profile = (ArrayList<ItemId>)mapFetchProfileToListOfHandles.get(rec.getRequestedProfile());
                    if (profile == null) {
                        profile = new ArrayList<ItemId>();
                        mapFetchProfileToListOfHandles.put(rec.getRequestedProfile(), profile);
                    }
                    ++count;
                    profile.add(rec.handle);
                }
                ++i;
            }
        }
        HashMap fetched = NewCollection.hashMap();
        ArrayList allHandles = new ArrayList();
        progress.setWorkRemaining(count);
        for (Map.Entry entry : mapFetchProfileToListOfHandles.entrySet()) {
            FetchProfile profile = (FetchProfile)entry.getKey();
            List handles = (List)entry.getValue();
            allHandles.addAll(handles);
            fetched.putAll(RepoFetcher.fetchCurrents((ITeamRepository)this.server, (Collection)handles, (FetchProfile)profile, (IProgressMonitor)progress.newChild(handles.size())));
        }
        AuditableFetcher auditableFetcher2 = this;
        synchronized (auditableFetcher2) {
            for (Map.Entry entry : mapFetchProfileToListOfHandles.entrySet()) {
                FetchProfile profile = (FetchProfile)entry.getKey();
                List handles = (List)entry.getValue();
                for (ItemId next : handles) {
                    AuditableRec rec = this.getRec(next);
                    if (rec.getFetchedProfile().contains(profile)) continue;
                    rec.auditable = (IAuditable)fetched.get(next);
                    rec.fetchedProfile = profile;
                }
            }
        }
    }

    public void prefetch(IProgressMonitor rep) throws TeamRepositoryException {
        this.prefetchRange(0, this.auditableHandles.size(), rep);
    }

    public void addAll(List<ItemId> toFetch, FetchProfile profile) {
        for (ItemId next : toFetch) {
            this.add(next, profile);
        }
    }

    public void addAll(List<ItemId> list) {
        this.addAll(list, FetchProfile.createFullProfile());
    }

    public void add(IAuditableHandle handle) {
        this.add(handle, FetchProfile.createFullProfile());
    }

    public void add(ItemId nextItem) {
        this.add(nextItem, FetchProfile.createFullProfile());
    }

    private static final class AuditableRec {
        int index;
        ItemId handle = null;
        IAuditable auditable = null;
        FetchProfile requestedProfile;
        FetchProfile fetchedProfile = FetchProfile.createEmptyProfile();

        public AuditableRec(ItemId toAdd, int i, FetchProfile profile) {
            this.index = i;
            this.handle = toAdd;
            this.requestedProfile = profile;
        }

        public FetchProfile getFetchedProfile() {
            return this.fetchedProfile;
        }

        public FetchProfile getRequestedProfile() {
            return this.requestedProfile;
        }

        public void expandProfile(FetchProfile toInclude) {
            this.requestedProfile = this.requestedProfile.merge(toInclude);
        }

        public boolean isFetched() {
            return this.fetchedProfile.contains(this.requestedProfile);
        }
    }
}

