/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views.zoom.workitems;

import com.ibm.team.filesystem.rcp.core.internal.changes.locks.LockQuery;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedWorkItem;
import com.ibm.team.filesystem.ui.changes.views.zoom.IZoomRoot;
import com.ibm.team.filesystem.ui.changes.views.zoom.ZoomRootUtil;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.IZoomWorkItemRoot;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.WorkItemsZoomContext;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IChangeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ZoomWorkItemUtil {
    public static Collection<IComponentSyncContext> getContexts(IZoomWorkItemRoot root) {
        if (!root.getElements().isEmpty()) {
            return ComponentSyncUtil.getContexts((Collection)root.getElements());
        }
        return ComponentSyncUtil.getContexts(Arrays.asList(root.getContext().getChildren(root)));
    }

    public static Collection<IComponentSyncContext> getContexts(IZoomRoot root) {
        if (root instanceof IZoomWorkItemRoot) {
            return ZoomWorkItemUtil.getContexts((IZoomWorkItemRoot)root);
        }
        return ComponentSyncUtil.getContexts((Collection)root.getElements());
    }

    public static BitSet getDecorationFlags(IZoomWorkItemRoot root) {
        boolean incoming = false;
        boolean outgoing = false;
        boolean active = false;
        for (Object element : root.getElements()) {
            if (element instanceof IIncomingWorkItem) {
                incoming = true;
            }
            if (!(element instanceof IOutgoingWorkItem) && !(element instanceof ISuspendedWorkItem)) continue;
            outgoing = true;
            IFileSystemWorkItem node = (IFileSystemWorkItem)element;
            IRemoteActivity activity = node.getActivity();
            if (!ComponentSyncUtil.getContext((Object)activity).isActive(activity)) continue;
            active = true;
        }
        BitSet flags = new BitSet();
        if (outgoing && incoming) {
            flags.set(14);
        } else if (outgoing) {
            flags.set(13);
        } else if (incoming) {
            flags.set(12);
        }
        if (!active && !root.getElements().isEmpty()) {
            flags.set(3);
        }
        return flags;
    }

    public static BitSet getDecorationFlags(IRemoteActivity activity) {
        IComponentSyncContext context = activity.getActivitySource().getModel();
        BitSet flags = new BitSet();
        if (context.hasConflict(activity)) {
            flags.set(10);
        }
        if (context.isCurrent(activity)) {
            flags.set(2);
        }
        if (!context.isActive(activity)) {
            flags.set(3);
        } else if (context.isCheckinIn(activity)) {
            flags.set(15);
        }
        int nDefects = activity.getWorkItems().size();
        if (nDefects == 1) {
            flags.set(16);
        } else if (nDefects > 1) {
            flags.set(17);
        }
        LockQuery.LockCount lockCount = LockQuery.countLocks((Object)activity);
        if (lockCount.locksBlocking > 0) {
            flags.set(19);
        } else if (lockCount.locksOwned > 0) {
            flags.set(20);
        }
        if (activity instanceof IOutgoingRemoteActivity) {
            flags.set(13);
        } else if (activity instanceof IIncomingRemoteActivity) {
            flags.set(12);
        }
        return flags;
    }

    public static String getComponentsDecoration(Collection<IComponentSyncContext> contexts) {
        String result = null;
        if (contexts.size() == 1) {
            IComponentSyncContext context = (IComponentSyncContext)ZoomRootUtil.getAny(contexts);
            result = NLS.bind((String)Messages.ZoomWorkItemUtil_0, (Object)context.getComponent().getName());
        } else if (contexts.size() == 2) {
            String name2;
            IComponentSyncContext[] cscs = contexts.toArray(new IComponentSyncContext[contexts.size()]);
            String name1 = cscs[0].getComponent().getName();
            if (name1.compareTo(name2 = cscs[1].getComponent().getName()) > 0) {
                String name = name1;
                name1 = name2;
                name2 = name;
            }
            result = NLS.bind((String)Messages.ZoomWorkItemUtil_1, (Object)name1, (Object)name2);
        } else {
            result = NLS.bind((String)Messages.ZoomWorkItemUtil_2, (Object)contexts.size());
        }
        return result;
    }

    public static String decorateText(IRemoteActivity activity) {
        IComponentSyncContext context = ComponentSyncUtil.getContext((Object)activity);
        return NLS.bind((String)Messages.ZoomWorkItemUtil_0, (Object)context.getComponent().getName());
    }

    public static List<IZoomWorkItemRoot> getParents(IRemoteActivity activity, WorkItemsZoomContext context) {
        List workItems = activity.getWorkItems();
        ArrayList<IZoomWorkItemRoot> result = new ArrayList<IZoomWorkItemRoot>();
        Object[] objectArray = context.getChildren(context);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof IZoomWorkItemRoot) {
                IZoomWorkItemRoot root = (IZoomWorkItemRoot)child;
                for (IFileSystemWorkItem workItem : workItems) {
                    if (!root.getElements().contains(workItem)) continue;
                    result.add(root);
                    break;
                }
            }
            ++n2;
        }
        return result;
    }

    public static boolean isActive(IZoomWorkItemRoot root) {
        for (Object element : root.getElements()) {
            IFileSystemWorkItem node = (IFileSystemWorkItem)element;
            IRemoteActivity activity = node.getActivity();
            if (!ComponentSyncUtil.getContext((Object)activity).isActive(activity)) continue;
            return true;
        }
        return false;
    }

    public static boolean belongsToLoggedInUser(IZoomWorkItemRoot root) {
        for (Object element : root.getElements()) {
            IFileSystemWorkItem node = (IFileSystemWorkItem)element;
            if (!ZoomWorkItemUtil.belongsToLoggedInUser(node.getActivity())) continue;
            return true;
        }
        return false;
    }

    public static boolean belongsToLoggedInUser(IRemoteActivity activity) {
        ITeamRepository repo = ComponentSyncUtil.getTeamRepository((Object)activity);
        IChangeSet changeSet = activity.getChangeSet();
        return changeSet != null && changeSet.getAuthor().sameItemId((IItemHandle)repo.loggedInContributor());
    }

    public static boolean isEarliestLastChangeDate(IZoomWorkItemRoot root, IZoomWorkItemRoot other) {
        Date date1 = ZoomWorkItemUtil.getEarliestLastChangeDate(root);
        Date date2 = ZoomWorkItemUtil.getEarliestLastChangeDate(other);
        return date1 != null && date2 != null ? date1.compareTo(date2) < 0 : false;
    }

    public static Date getEarliestLastChangeDate(IZoomWorkItemRoot root) {
        Date result = null;
        for (Object element : root.getElements()) {
            IFileSystemWorkItem node = (IFileSystemWorkItem)element;
            IRemoteActivity activity = node.getActivity();
            IChangeSet changeSet = activity.getChangeSet();
            if (changeSet == null) continue;
            if (result == null) {
                result = changeSet.getLastChangeDate();
                continue;
            }
            if (changeSet.getLastChangeDate().compareTo(result) >= 0) continue;
            result = changeSet.getLastChangeDate();
        }
        return result;
    }
}

