/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views.zoom.workitems;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.ActivityIterator;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.ui.changes.views.zoom.IZoomContext;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.IZoomWorkItemRoot;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.ZoomIncomingWorkItemRoot;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.ZoomOutgoingWorkItemRoot;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.ZoomSuspendedWorkItemRoot;
import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import java.util.Collection;
import java.util.HashSet;

public class ZoomWorkItemRoot
implements IZoomWorkItemRoot,
IModelAccessor {
    IZoomContext context;
    HashSet<IFileSystemWorkItem> workItems;
    IAuditableHandle workItem;
    HashSet<IRemoteActivity> activities;

    public ZoomWorkItemRoot() {
    }

    public ZoomWorkItemRoot(IAuditableHandle workItem, HashSet<IFileSystemWorkItem> workItems, IZoomContext context) {
        this.workItem = workItem;
        this.workItems = workItems;
        this.context = context;
    }

    public ZoomWorkItemRoot(HashSet<IRemoteActivity> activities, IZoomContext context) {
        this(null, new HashSet<IFileSystemWorkItem>(), context);
        this.activities = activities;
    }

    @Override
    public IZoomContext getContext() {
        return this.context;
    }

    @Override
    public Collection getElements() {
        return this.workItems;
    }

    @Override
    public IAuditableHandle getWorkItem() {
        return this.workItem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.workItem == null ? 0 : this.workItem.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZoomWorkItemRoot other = (ZoomWorkItemRoot)obj;
        return !(this.workItem == null ? other.workItem != null : !this.workItem.sameItemId((IItemHandle)other.workItem));
    }

    public static ZoomWorkItemRoot create(IAuditableHandle workItem, HashSet<IFileSystemWorkItem> workItems, IZoomContext context, ActivityIterator.Flow flow) {
        if (flow == ActivityIterator.Flow.INCOMING) {
            return new ZoomIncomingWorkItemRoot(workItem, workItems, context);
        }
        if (flow == ActivityIterator.Flow.OUTGOING_ACTIVE) {
            return new ZoomOutgoingWorkItemRoot(workItem, workItems, context);
        }
        if (flow == ActivityIterator.Flow.OUTGOING) {
            return new ZoomOutgoingWorkItemRoot(workItem, workItems, context);
        }
        if (flow == ActivityIterator.Flow.SUSPENDED) {
            return new ZoomSuspendedWorkItemRoot(workItem, workItems, context);
        }
        return null;
    }

    public static ZoomWorkItemRoot create(HashSet<IRemoteActivity> activities, IZoomContext context, ActivityIterator.Flow flow) {
        ZoomWorkItemRoot result = ZoomWorkItemRoot.create(null, new HashSet<IFileSystemWorkItem>(), context, flow);
        result.activities = activities;
        return result;
    }

    public Object getModelInstance() {
        return this.getWorkItem() == null ? this : this.getWorkItem();
    }
}

