/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views.zoom.workitems;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.ui.changes.configuration.ChangesSorter;
import com.ibm.team.filesystem.ui.changes.views.zoom.ZoomRootUtil;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.IZoomBaselinesRoot;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.IZoomOutgoingWorkItemRoot;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.IZoomSuspendedWorkItemRoot;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.IZoomWorkItemRoot;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.ZoomWorkItemUtil;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IChangeSet;
import org.eclipse.jface.viewers.Viewer;

public class WorkItemsZoomSorter
extends ChangesSorter {
    @Override
    public int category(Object element) {
        if (element instanceof IUnresolvedFolder) {
            return 1;
        }
        if (element instanceof IZoomOutgoingWorkItemRoot || element instanceof IZoomSuspendedWorkItemRoot) {
            IZoomWorkItemRoot root = (IZoomWorkItemRoot)element;
            if (root.getWorkItem() != null) {
                return ZoomWorkItemUtil.belongsToLoggedInUser(root) ? (ZoomWorkItemUtil.isActive(root) ? 2 : 3) : 4;
            }
            return 5;
        }
        if (element instanceof IZoomWorkItemRoot) {
            return ((IZoomWorkItemRoot)element).getWorkItem() != null ? 4 : 5;
        }
        if (element instanceof IZoomBaselinesRoot) {
            return 6;
        }
        if (element instanceof IOutgoingRemoteActivity || element instanceof ISuspendedRemoteActivity) {
            IRemoteActivity activity = (IRemoteActivity)element;
            return ZoomWorkItemUtil.belongsToLoggedInUser(activity) ? (ComponentSyncUtil.getContext((Object)activity).isActive(activity) ? 7 : 8) : 9;
        }
        return super.category(element);
    }

    @Override
    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (e1 instanceof IZoomOutgoingWorkItemRoot && e2 instanceof IZoomOutgoingWorkItemRoot || e1 instanceof IZoomSuspendedWorkItemRoot && e2 instanceof IZoomSuspendedWorkItemRoot) {
            IZoomWorkItemRoot r1 = (IZoomWorkItemRoot)e1;
            IZoomWorkItemRoot r2 = (IZoomWorkItemRoot)e2;
            return ZoomWorkItemUtil.isEarliestLastChangeDate(r1, r2) ? -1 : 1;
        }
        if (e1 instanceof IZoomWorkItemRoot && e2 instanceof IZoomWorkItemRoot) {
            IZoomWorkItemRoot r1 = (IZoomWorkItemRoot)e1;
            IZoomWorkItemRoot r2 = (IZoomWorkItemRoot)e2;
            if (r1.getElements().isEmpty() || r2.getElements().isEmpty()) {
                return 0;
            }
            IFileSystemWorkItem w1 = (IFileSystemWorkItem)ZoomRootUtil.getAny(r1.getElements());
            IFileSystemWorkItem w2 = (IFileSystemWorkItem)ZoomRootUtil.getAny(r2.getElements());
            return super.compare(viewer, w1, w2);
        }
        if (e1 instanceof IOutgoingRemoteActivity && e2 instanceof IOutgoingRemoteActivity || e1 instanceof IOutgoingRemoteActivity && e2 instanceof IOutgoingRemoteActivity) {
            IRemoteActivity a1 = (IRemoteActivity)e1;
            IRemoteActivity a2 = (IRemoteActivity)e2;
            IChangeSet cs1 = a1.getChangeSet();
            IChangeSet cs2 = a2.getChangeSet();
            if (cs1 == null || cs2 == null) {
                return 0;
            }
            return cs2.getLastChangeDate().compareTo(cs1.getLastChangeDate());
        }
        if (e1 instanceof IRemoteActivity && e2 instanceof IRemoteActivity) {
            IRemoteActivity a1 = (IRemoteActivity)e1;
            IRemoteActivity a2 = (IRemoteActivity)e2;
            IComponentSyncContext c1 = ComponentSyncUtil.getContext((Object)a1);
            IComponentSyncContext c2 = ComponentSyncUtil.getContext((Object)a2);
            if (!c1.getComponent().sameItemId((IItemHandle)c2.getComponent())) {
                return c1.getComponent().getName().compareTo(c2.getComponent().getName());
            }
            IChangeSet cs1 = a1.getChangeSet();
            IChangeSet cs2 = a2.getChangeSet();
            return cs1 != null && cs2 != null ? cs1.getComment().compareTo(cs2.getComment()) : 0;
        }
        return super.compare(viewer, e1, e2);
    }
}

