/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views.zoom.workitems;

import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ActivityIterator;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISubcomponentChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.ui.changes.views.zoom.IZoomContext;
import com.ibm.team.filesystem.ui.changes.views.zoom.IZoomContextListener;
import com.ibm.team.filesystem.ui.changes.views.zoom.IZoomManager;
import com.ibm.team.filesystem.ui.changes.views.zoom.IZoomRoot;
import com.ibm.team.filesystem.ui.changes.views.zoom.ZoomRootUtil;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.IZoomBaselinesRoot;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.IZoomWorkItemRoot;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.ZoomBaselinesRoot;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.ZoomWorkItemRoot;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.ZoomWorkItemUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class WorkItemsZoomContext
implements IZoomContext,
IZoomManager {
    private static final int MINIMUM_WAIT_TIME = 1000;
    private static final int MAXIMUM_WAIT_TIME = 300000;
    private static final Log log;
    private static final UUID ZoomBaselinesRootIdentity;
    private static final UUID ZoomWorkItemRootIdentity;
    IComponentSyncModel model;
    volatile List<IUnresolvedFolder> folderRoots = new ArrayList<IUnresolvedFolder>();
    volatile List<IZoomRoot> roots = new ArrayList<IZoomRoot>();
    ActivityIterator.Flow flow;
    WorkItemsZoomContextUpdateJob updateJob;

    static {
        ZoomBaselinesRootIdentity = UUID.generate();
        ZoomWorkItemRootIdentity = UUID.generate();
        log = LoggingHelper.getLog(WorkItemsZoomContext.class);
    }

    public WorkItemsZoomContext(IComponentSyncModel model, IZoomContextListener listener, ActivityIterator.Flow flow) {
        this.model = model;
        this.updateJob = new WorkItemsZoomContextUpdateJob(listener);
        this.flow = flow;
    }

    @Override
    public Object[] getChildren(Object element) {
        if (element == this) {
            ArrayList<Object> children = new ArrayList<Object>();
            children.addAll(this.folderRoots);
            children.addAll(this.roots);
            return children.toArray();
        }
        if (element instanceof IZoomWorkItemRoot) {
            IZoomWorkItemRoot root = (IZoomWorkItemRoot)element;
            HashSet<IRemoteActivity> children = new HashSet<IRemoteActivity>();
            if (root.getElements().isEmpty()) {
                children.addAll(((ZoomWorkItemRoot)root).activities);
            } else {
                for (Object object : root.getElements()) {
                    IFileSystemWorkItem wi = (IFileSystemWorkItem)object;
                    children.add(wi.getActivity());
                }
            }
            return children.toArray();
        }
        if (element instanceof IRemoteActivity) {
            IRemoteActivity activity = (IRemoteActivity)element;
            HashSet children = new HashSet();
            children.addAll(activity.getSubcomponentChanges());
            children.addAll(activity.getFolders());
            return children.toArray();
        }
        if (element instanceof IZoomBaselinesRoot) {
            IZoomBaselinesRoot baselinesRoot = (IZoomBaselinesRoot)element;
            return baselinesRoot.getElements().toArray();
        }
        return null;
    }

    @Override
    public Object getParent(Object element) {
        if (element instanceof IRemoteActivity) {
            IRemoteActivity activity = (IRemoteActivity)element;
            List<IZoomWorkItemRoot> parents = ZoomWorkItemUtil.getParents(activity, this);
            return !parents.isEmpty() ? parents.get(0) : null;
        }
        if (element instanceof IUnresolvedFolder) {
            return this;
        }
        if (element instanceof IZoomWorkItemRoot) {
            return this;
        }
        if (element instanceof IZoomBaselinesRoot) {
            return this;
        }
        if (element instanceof ISubcomponentChange) {
            ISubcomponentChange node = (ISubcomponentChange)element;
            return node.getRemoteActivity();
        }
        return null;
    }

    @Override
    public void modelUpdate() {
        if (WorkItemsZoomContext.isTraceEnabled()) {
            WorkItemsZoomContext.trace("WorkItemsZoomContext received request to update model");
        }
        this.updateJob.scheduleNow();
    }

    private void internalUpdateModel() {
        ArrayList<IUnresolvedFolder> folderRoots = new ArrayList<IUnresolvedFolder>();
        List<IComponentSyncContext> contexts = ZoomRootUtil.getFilteredContexts(this.model);
        ArrayList<IBaselineGroup> baselineGroups = new ArrayList<IBaselineGroup>();
        for (IComponentSyncContext context : contexts) {
            if (this.flow == ActivityIterator.Flow.OUTGOING_ACTIVE) {
                folderRoots.addAll(context.getUnresolvedSource().getFolders());
            }
            if (this.flow == ActivityIterator.Flow.OUTGOING) {
                folderRoots.addAll(context.getUnresolvedSource().getFolders());
                for (IIncomingBaselineGroup bg : context.getOutgoingActivitySource().getBaselines()) {
                    if (bg.isResolved()) continue;
                    baselineGroups.add((IBaselineGroup)bg);
                }
            }
            if (this.flow != ActivityIterator.Flow.INCOMING) continue;
            for (IIncomingBaselineGroup bg : context.getIncomingActivitySource().getBaselines()) {
                if (bg.isResolved()) continue;
                baselineGroups.add((IBaselineGroup)bg);
            }
        }
        final HashMap tempMap = new HashMap();
        final HashSet<IRemoteActivity> noWorkItemActivities = new HashSet<IRemoteActivity>();
        new ActivityIterator(){

            public void visit(IRemoteActivity activity) {
                List workItems;
                if (WorkItemsZoomContext.this.flow == ActivityIterator.Flow.OUTGOING_ACTIVE) {
                    IChangeSet changeSet = activity.getChangeSet();
                    IComponentSyncContext context = ComponentSyncUtil.getContext((Object)activity);
                    if (changeSet == null || !changeSet.getAuthor().sameItemId((IItemHandle)context.localTeamRepository().loggedInContributor())) {
                        return;
                    }
                }
                if ((workItems = activity.getWorkItems()).isEmpty()) {
                    noWorkItemActivities.add(activity);
                } else {
                    for (IFileSystemWorkItem wi : workItems) {
                        UUID uuid = wi.getWorkItemHandle().getItemId();
                        HashSet<IFileSystemWorkItem> items = (HashSet<IFileSystemWorkItem>)tempMap.get(uuid);
                        if (items == null) {
                            items = new HashSet<IFileSystemWorkItem>();
                            tempMap.put(uuid, items);
                        }
                        items.add(wi);
                    }
                }
            }
        }.iterate(contexts, this.flow);
        ArrayList<IZoomRoot> newRoots = new ArrayList<IZoomRoot>();
        for (Map.Entry entry : tempMap.entrySet()) {
            HashSet value = (HashSet)entry.getValue();
            IAuditableHandle workItem = ((IFileSystemWorkItem)ZoomRootUtil.getAny(value)).getWorkItemHandle();
            ZoomWorkItemRoot newRoot = ZoomWorkItemRoot.create(workItem, value, this, this.flow);
            newRoots.add(newRoot);
        }
        if (!noWorkItemActivities.isEmpty()) {
            ZoomWorkItemRoot newNoWorkItemRoot = ZoomWorkItemRoot.create(noWorkItemActivities, this, this.flow);
            newRoots.add(newNoWorkItemRoot);
        }
        if (!baselineGroups.isEmpty()) {
            ZoomBaselinesRoot newBaselinesRoot = new ZoomBaselinesRoot(baselineGroups, this);
            newRoots.add(newBaselinesRoot);
        }
        ArrayList<IZoomRoot> roots = new ArrayList<IZoomRoot>(this.roots);
        ComponentConflictUtil.update(roots, newRoots, (ComponentConflictUtil.UpdateItem)new ComponentConflictUtil.UpdateItem<IZoomRoot>(){

            public void updateSameItem(IZoomRoot object, IZoomRoot other) {
                IZoomRoot root2;
                IZoomRoot root1;
                if (object instanceof ZoomWorkItemRoot && other instanceof ZoomWorkItemRoot) {
                    root1 = (ZoomWorkItemRoot)object;
                    root2 = (ZoomWorkItemRoot)other;
                    root1.workItems = root2.workItems;
                    root1.activities = root2.activities;
                }
                if (object instanceof ZoomBaselinesRoot && other instanceof ZoomBaselinesRoot) {
                    root1 = (ZoomBaselinesRoot)object;
                    root2 = (ZoomBaselinesRoot)other;
                    ((ZoomBaselinesRoot)root1).baselines = ((ZoomBaselinesRoot)root2).baselines;
                }
            }

            public Function<IZoomRoot, Object> getKeyMapper() {
                return z -> {
                    if (z instanceof ZoomWorkItemRoot) {
                        ZoomWorkItemRoot root = (ZoomWorkItemRoot)z;
                        if (root.workItem != null) {
                            return root.workItem.getItemId();
                        }
                        return ZoomWorkItemRootIdentity;
                    }
                    if (z instanceof ZoomBaselinesRoot) {
                        return ZoomBaselinesRootIdentity;
                    }
                    return z;
                };
            }
        });
        this.folderRoots = folderRoots;
        this.roots = roots;
    }

    @Override
    public void init() {
        if (WorkItemsZoomContext.isTraceEnabled()) {
            WorkItemsZoomContext.trace("WorkItemsZoomContext is initializing");
        }
        this.model.addGenericListener((IListener)this.updateJob);
        this.modelUpdate();
    }

    @Override
    public void dispose() {
        if (WorkItemsZoomContext.isTraceEnabled()) {
            WorkItemsZoomContext.trace("WorkItemsZoomContext is being disposed");
        }
        this.model.removeGenericListener((IListener)this.updateJob);
    }

    private static boolean isTraceEnabled() {
        return log != null && log.isTraceEnabled();
    }

    private static void trace(String message) {
        if (log != null) {
            log.trace((Object)message);
        }
    }

    private final class WorkItemsZoomContextUpdateJob
    extends Job
    implements IListener {
        private IZoomContextListener listener;
        private long timeOfLastRequest;
        private long timeOfLastUpdate;

        private WorkItemsZoomContextUpdateJob(IZoomContextListener listener) {
            super(Messages.WorkItemsZoomContext_0);
            this.listener = listener;
        }

        protected IStatus run(IProgressMonitor monitor) {
            long timeWaited = System.currentTimeMillis() - this.timeOfLastRequest;
            long timeSinceLastUpdate = System.currentTimeMillis() - this.timeOfLastUpdate;
            if (timeWaited < 1000L && timeSinceLastUpdate < 300000L) {
                if (WorkItemsZoomContext.isTraceEnabled()) {
                    WorkItemsZoomContext.trace("WorkItemsZoomContextUpdateJob rescheduling since it hs only been " + timeWaited + " ms since the last request");
                }
                this.schedule(1000L);
                return Status.OK_STATUS;
            }
            this.timeOfLastUpdate = System.currentTimeMillis();
            if (WorkItemsZoomContext.isTraceEnabled()) {
                WorkItemsZoomContext.trace("WorkItemsZoomContextUpdateJob is starting a model update");
            }
            WorkItemsZoomContext.this.internalUpdateModel();
            if (WorkItemsZoomContext.isTraceEnabled()) {
                WorkItemsZoomContext.trace("WorkItemsZoomContextUpdateJob is finished a model update");
            }
            this.listener.contextUpdate();
            return Status.OK_STATUS;
        }

        public void handleEvents(List events) {
            if (WorkItemsZoomContext.isTraceEnabled()) {
                WorkItemsZoomContext.trace("WorkItemsZoomContextUpdateJob scheduled to run in 1000");
            }
            this.timeOfLastRequest = System.currentTimeMillis();
            this.schedule(1000L);
        }

        public void scheduleNow() {
            if (WorkItemsZoomContext.isTraceEnabled()) {
                WorkItemsZoomContext.trace("WorkItemsZoomContextUpdateJob scheduled to run now");
            }
            this.timeOfLastRequest = System.currentTimeMillis() - 1000L;
            this.schedule();
        }

        public boolean shouldRun() {
            return !this.isShuttingDown();
        }

        protected boolean isShuttingDown() {
            return FileSystemResourcesPlugin.getDefault() == null;
        }

        public boolean shouldSchedule() {
            return !this.isShuttingDown();
        }
    }
}

