/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ActivityIterator;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.configuration.LocalConfiguration;
import com.ibm.team.filesystem.ui.changes.views.ChangesViewPage;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewContentProvider;
import com.ibm.team.filesystem.ui.changes.views.ZoomBookmark;
import com.ibm.team.filesystem.ui.changes.views.zoom.IZoomContext;
import com.ibm.team.filesystem.ui.changes.views.zoom.IZoomContextListener;
import com.ibm.team.filesystem.ui.changes.views.zoom.ZoomTreeContentProvider;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.WorkItemsZoomContext;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.WorkItemsZoomDecorator;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.WorkItemsZoomLabelProvider;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.WorkItemsZoomSorter;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewPart;

public class ZoomChangesViewPage
extends ChangesViewPage {
    IZoomContext context;
    Display display;
    ZoomBookmark bookmark;
    IPropertyChangeListener propertyChangeListener;
    Map<ZoomBookmark, Object[]> expandedElements = new HashMap<ZoomBookmark, Object[]>();

    public ZoomChangesViewPage(Composite parent, LocalWorkspaceChangesView viewPart) {
        super(parent, viewPart);
        this.display = parent.getDisplay();
        this.setBookmark(ZoomBookmark.PENDING_WORKITEM, false);
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (UiPlugin.isChangeProperty(event.getProperty())) {
                    ZoomChangesViewPage.this.context.modelUpdate();
                }
            }
        };
        UiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    public boolean hasContent() {
        Object[] children;
        Object[] objectArray = children = this.context != null ? this.context.getChildren(this.context) : null;
        return children != null && children.length > 0;
    }

    public ZoomBookmark getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(ZoomBookmark bookmark, boolean activate) {
        Object[] elements;
        if (bookmark == this.bookmark) {
            if (activate) {
                this.viewPart.setFlatMode(true);
            }
            this.layout();
            return;
        }
        IStructuredSelection activeSelection = this.viewPart.getActiveSelection();
        this.clearBookmark();
        this.bookmark = bookmark;
        if (bookmark == ZoomBookmark.PENDING_WORKITEM) {
            this.setBookmarkWorkItems(ActivityIterator.Flow.OUTGOING_ACTIVE);
        }
        if (bookmark == ZoomBookmark.OUTGOING_WORKITEM) {
            this.setBookmarkWorkItems(ActivityIterator.Flow.OUTGOING);
        }
        if (bookmark == ZoomBookmark.INCOMING_WORKITEM) {
            this.setBookmarkWorkItems(ActivityIterator.Flow.INCOMING);
        }
        if (bookmark == ZoomBookmark.SUSPENDED_CHANGESETS) {
            this.setBookmarkWorkItems(ActivityIterator.Flow.SUSPENDED);
        }
        if (activate) {
            this.init();
            this.viewPart.setFlatMode(true);
            this.layout();
        }
        if ((elements = this.expandedElements.get((Object)bookmark)) != null) {
            this.viewer.setExpandedElements(elements);
        }
        if (activeSelection != null) {
            this.setSelection(activeSelection);
        }
    }

    @Override
    protected void initViewer() {
    }

    @Override
    public void hookInput() {
    }

    private void clearBookmark() {
        if (this.context != null) {
            this.context.dispose();
        }
        if (this.viewer != null) {
            this.expandedElements.put(this.bookmark, this.viewer.getExpandedElements());
        }
        if (this.tree != null) {
            this.tree.dispose();
        }
        if (this.localConfiguration != null) {
            this.localConfiguration.dispose();
        }
    }

    private void setBookmarkWorkItems(ActivityIterator.Flow flow) {
        this.tree = new Tree((Composite)this, 66306);
        this.context = new WorkItemsZoomContext(FileSystemResourcesPlugin.getComponentSyncModel(), new IZoomContextListener(){

            @Override
            public void contextUpdate() {
                if (ZoomChangesViewPage.this.display.isDisposed()) {
                    return;
                }
                ZoomChangesViewPage.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ZoomChangesViewPage.this.tree.isDisposed()) {
                            return;
                        }
                        Object[] elements = (this).ZoomChangesViewPage.this.viewer.getExpandedElements();
                        (this).ZoomChangesViewPage.this.viewer.refresh();
                        (this).ZoomChangesViewPage.this.viewer.setExpandedElements(elements);
                    }
                });
            }
        }, flow);
        this.context.init();
        this.labelProvider = new WorkItemsZoomLabelProvider();
        this.labelDecorator = new WorkItemsZoomDecorator(this.context);
        this.viewer = new CustomTreeViewer(this.tree);
        ((CustomTreeViewer)this.viewer).init(new DecoratingLabelProvider((ILabelProvider)this.labelProvider, (ILabelDecorator)this.labelDecorator));
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new ZoomTreeContentProvider(new LocalWorkspaceChangesViewContentProvider()));
        this.localConfiguration = new LocalConfiguration((IViewPart)this.viewPart, this.viewer);
        ((CustomTreeViewer)this.viewer).setLocalConfiguration(this.localConfiguration);
        this.viewPart.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setSorter((ViewerSorter)new WorkItemsZoomSorter());
        this.viewer.setInput((Object)this.context);
    }

    @Override
    public void dispose() {
        UiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        if (this.context != null) {
            this.context.dispose();
        }
        this.context = null;
        super.dispose();
    }
}

