/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.ide.ui.internal.actions.load.LoadAction;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.ui.changes.dialogs.AllMyWorkspacesDialog;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.filesystem.ui.changes.views.SetupPageDropTargetAdapter;
import com.ibm.team.filesystem.ui.changes.views.ZoomBookmark;
import com.ibm.team.filesystem.ui.wizards.newworkspace.NewWorkspaceWizard;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class SetupPendingViewPage
extends Composite {
    private Link mainLink;
    private LocalWorkspaceChangesView viewPart;

    public SetupPendingViewPage(Composite parent, LocalWorkspaceChangesView viewPart) {
        super(parent, 0);
        this.viewPart = viewPart;
        this.hookDropTarget(parent);
    }

    public void updateBookmark(ZoomBookmark bookmark) {
        if (bookmark == ZoomBookmark.FULL) {
            this.fullViewMessage(this);
        } else {
            this.zoomModeMessage(this, bookmark);
        }
    }

    private void cleanup() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    private void fullViewMessage(Composite parent) {
        this.cleanup();
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(parent);
        this.setBackground(this.getDisplay().getSystemColor(1));
        final IViewSite site = this.viewPart.getViewSite();
        Label label = new Label(parent, 16576);
        label.setText(Messages.SetupPendingViewPage_0);
        label.setBackground(this.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        this.mainLink = new Link(parent, 0);
        this.mainLink.setText(Messages.SetupPendingViewPage_1);
        this.mainLink.setBackground(this.getBackground());
        this.mainLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SetupPendingViewPage.loadRepositoryWorkspace(SetupPendingViewPage.this.getShell(), site.getPage().getActivePart());
            }
        });
        Link newWorkspaceLink = new Link(parent, 0);
        newWorkspaceLink.setText(Messages.SetupPendingViewPage_2);
        newWorkspaceLink.setBackground(this.getBackground());
        newWorkspaceLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SetupPendingViewPage.newRepositoryWorkspace(SetupPendingViewPage.this.getShell(), site.getPage());
            }
        });
        parent.layout();
    }

    private void hookDropTarget(Composite parent) {
        DropTarget dropTarget = new DropTarget((Control)parent, 23);
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        dropTarget.addDropListener((DropTargetListener)new SetupPageDropTargetAdapter());
    }

    private void zoomModeMessage(Composite parent, ZoomBookmark bookmark) {
        this.cleanup();
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(parent);
        this.setBackground(this.getDisplay().getSystemColor(1));
        Label label = new Label(parent, 16576);
        label.setText(this.getZoomMessage(bookmark));
        label.setBackground(this.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        this.mainLink = new Link(parent, 0);
        this.mainLink.setText(Messages.SetupPendingViewPage_4);
        this.mainLink.setBackground(this.getBackground());
        this.mainLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SetupPendingViewPage.this.returnToFullView();
            }
        });
        parent.layout();
    }

    private String getZoomMessage(ZoomBookmark bookmark) {
        switch (bookmark) {
            case OUTGOING_WORKITEM: {
                return Messages.SetupPendingViewPage_5;
            }
            case INCOMING_WORKITEM: {
                return Messages.SetupPendingViewPage_6;
            }
            case SUSPENDED_CHANGESETS: {
                return Messages.SetupPendingViewPage_7;
            }
        }
        throw new IllegalStateException();
    }

    public boolean setFocus() {
        return this.mainLink.setFocus();
    }

    public static void newRepositoryWorkspace(Shell shell, IWorkbenchPage page) {
        UIContext pageContext = UIContext.createPageContext((Shell)shell, (IWorkbenchPage)page);
        NewWorkspaceWizard wizard = new NewWorkspaceWizard(pageContext);
        new WizardDialog(shell, (IWizard)wizard).open();
    }

    public static void loadRepositoryWorkspace(final Shell shell, IWorkbenchPart part) {
        final UIContext pageContext = UIContext.createPageContext((Shell)shell, (IWorkbenchPage)part.getSite().getPage());
        AllMyWorkspacesDialog dialog = new AllMyWorkspacesDialog(part);
        dialog.open();
        final ContributorPlaceWrapper workspace = dialog.getWorkspace();
        if (workspace == null) {
            return;
        }
        FileSystemResourcesPlugin.getActiveWorkspaceManager().activate((IWorkspaceHandle)workspace.getWorkspace());
        Job job = new Job(Messages.SetupPendingViewPage_3){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    LoadAction.checkout(shell, workspace, pageContext.getUserOperationRunner(), monitor);
                }
                catch (TeamRepositoryException e) {
                    return FileSystemStatusUtil.getStatusFor((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public void returnToFullView() {
        this.viewPart.setFlatMode(false);
        this.viewPart.setFocus();
    }
}

