/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.patches.Patch;
import com.ibm.team.filesystem.rcp.core.patches.PatchFile;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;

public class PatchedDirectory {
    private final VersionablePath path;
    private final Patch patch;

    public static PatchedDirectory[] getDirectoriesFor(Patch patch) {
        HashSet dirs = NewCollection.hashSet();
        for (PatchFile file : patch.getPatchedFiles()) {
            dirs.add(new PatchedDirectory(patch, file.getVersionablePath().removeLastSegment()));
        }
        return dirs.toArray(new PatchedDirectory[dirs.size()]);
    }

    public static PatchedDirectory forFile(PatchFile file) {
        return new PatchedDirectory(file.getPatch(), file.getVersionablePath().removeLastSegment());
    }

    public Patch getPatch() {
        return this.patch;
    }

    public PatchedDirectory(Patch patch, VersionablePath directory) {
        Assert.isNotNull((Object)patch);
        Assert.isNotNull((Object)directory);
        this.patch = patch;
        this.path = directory;
    }

    public VersionablePath getPath() {
        return this.path;
    }

    public Collection<PatchFile> getFiles() {
        return this.patch.getFilesForDirectory(this.path);
    }

    public boolean isEmpty() {
        return this.getFiles().isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.patch.getId().hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatchedDirectory other = (PatchedDirectory)obj;
        if (!this.patch.getId().equals((Object)other.patch.getId())) {
            return false;
        }
        return this.path.equals((Object)other.path);
    }
}

