/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizard;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizardInput;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.outofsync.OutOfSyncCache;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.widgets.InformationBar;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OutOfSyncInformationBarUtil {
    static final String RELOAD_ACTION = "reload";
    static final String HELP_ACTION = "help";

    static void updateBar(LocalWorkspaceChangesView view) {
        int count = OutOfSyncInformationBarUtil.getOutOfSyncCount();
        if (count == 0) {
            view.clearInformationMessage();
            return;
        }
        InformationBar.IInformationBarListener listener = new InformationBar.IInformationBarListener(){

            @Override
            public void closed() {
            }

            @Override
            public void clicked(String ref) {
                if (ref.equals(OutOfSyncInformationBarUtil.HELP_ACTION)) {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.team.filesystem.ide.ui.view_pendingchanges");
                }
                if (ref.equals(OutOfSyncInformationBarUtil.RELOAD_ACTION)) {
                    OutOfSyncInformationBarUtil.reloadOutOfSync(Display.getCurrent(), Display.getCurrent().getActiveShell());
                }
            }
        };
        view.setInformationMessage(NLS.bind((String)Messages.OutOfSyncInformationBarUtil_0, (Object)RELOAD_ACTION, (Object)HELP_ACTION), 3, listener);
    }

    static int getOutOfSyncCount() {
        int result = 0;
        OutOfSyncCache cache = OutOfSyncCache.get();
        IWorkspaceSyncContext[] iWorkspaceSyncContextArray = FileSystemResourcesPlugin.getComponentSyncModel().getWorkspaceSyncContexts();
        int n = iWorkspaceSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkspaceSyncContext wsc = iWorkspaceSyncContextArray[n2];
            result += cache.getOutOfSyncCount((IWorkspaceHandle)wsc.getLocal().getResolvedWorkspace());
            ++n2;
        }
        return result;
    }

    static void reloadOutOfSync(final Display display, final Shell shell) {
        final JobRunner job = new JobRunner(true);
        job.enqueue(Messages.OutOfSyncInformationBarUtil_1, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                IWorkspaceSyncContext[] wscs = FileSystemResourcesPlugin.getComponentSyncModel().getWorkspaceSyncContexts();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)wscs.length);
                IWorkspaceSyncContext[] iWorkspaceSyncContextArray = wscs;
                int n = wscs.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkspaceSyncContext wsc = iWorkspaceSyncContextArray[n2];
                    if (OutOfSyncCache.get().getOutOfSyncCount((IWorkspaceHandle)wsc.getLocal().getResolvedWorkspace()) != 0) {
                        ArrayList<IComponent> components = new ArrayList<IComponent>();
                        IComponentSyncContext[] iComponentSyncContextArray = wsc.getComponentSyncContexts();
                        int n3 = iComponentSyncContextArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IComponentSyncContext context = iComponentSyncContextArray[n4];
                            if (context.isLocal()) {
                                components.add(context.getComponent());
                            }
                            ++n4;
                        }
                        if (!components.isEmpty()) {
                            OutOfSyncInformationBarUtil.checkout(display, shell, wsc.getLocal(), components, (IOperationRunner)job, (IProgressMonitor)progress.newChild(1));
                        }
                    }
                    ++n2;
                }
            }
        });
    }

    private static void checkout(Display display, Shell shell, IWorkspaceConnection workspace, List<? extends IComponentHandle> components, IOperationRunner operationRunner, IProgressMonitor monitor) throws TeamRepositoryException {
        LoadWizardInput loadOp = new LoadWizardInput((IConnection)workspace, components, null, monitor);
        OutOfSyncInformationBarUtil.checkout(display, shell, workspace.getResolvedWorkspace(), loadOp, operationRunner);
    }

    private static void checkout(Display display, final Shell shell, IWorkspace workspace, final LoadWizardInput loadOp, final IOperationRunner operationRunner) {
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (shell.isDisposed()) {
                    return;
                }
                loadOp.initialize();
                loadOp.setLoadType(5);
                LoadWizard loadWizard = new LoadWizard(loadOp);
                WizardDialog dialog = new WizardDialog(shell, (IWizard)loadWizard);
                dialog.addPageChangingListener((IPageChangingListener)loadWizard);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    loadOp.doLoad(operationRunner);
                }
            }
        });
    }
}

