/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ILocalSynchronizationManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalChangeSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISourceChangeSet;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISubcomponentChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISyncFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.OfflineManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.PortsCacheManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.AbstractChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ContentChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ContentTypeChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortContainerNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.EncodingChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ExecutableBitChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.LineDelimiterChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.MoveChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PendingPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PendingPortsContainerNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortChangesContainerNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortNodesUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortsNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PropertyChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.SymbolicLinkChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeParentNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ConflictItemNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.internal.oslc.OslcLinkWrapper;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.ImageUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer;
import com.ibm.team.internal.filesystem.ui.util.PendingChangesUtil;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.utils.ImageDataImageDescriptor;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IMoveChangeDetail;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.links.ChangeSetLocationFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class LocalWorkspaceChangesViewLabelProvider
extends LabelProvider {
    private ImageUtil imageUtil;
    private boolean customMarkup;
    private StandardLabelProvider defaultLabels;
    private IRemoteActivity[] activites;
    private String editText;
    private ILabelProviderListener standardLabelProviderListener = new ILabelProviderListener(){
        LabelProviderChangedEvent lastEvent = null;
        long lastEventTime = 0L;

        private boolean sameEvent(LabelProviderChangedEvent newEvent, LabelProviderChangedEvent lastEvent) {
            if (lastEvent == null) {
                return false;
            }
            Object[] newElements = newEvent.getElements();
            Object[] lastElements = lastEvent.getElements();
            if (newElements == null || lastElements == null) {
                return newElements == lastElements;
            }
            if (newElements.length != lastElements.length) {
                return false;
            }
            boolean allElementsTheSame = true;
            int i = 0;
            while (i < newElements.length) {
                if (newElements[i] == null && lastElements[i] != null || newElements[i] != null && !newElements[i].equals(lastElements[i])) {
                    allElementsTheSame = false;
                    break;
                }
                ++i;
            }
            return allElementsTheSame;
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.log((String)String.format("%nLocalWorkspaceChangesViewLabelProvider:standardLabelProviderListener.labelProviderChanged()", new Object[0]));
                ModelUtil.log((String)String.format("Source: %s", event.getSource().getClass().getName()));
                ModelUtil.log((String)String.format("Event: %s", event));
            }
            if (System.currentTimeMillis() - this.lastEventTime < 1000L && this.sameEvent(event, this.lastEvent)) {
                if (ModelUtil.TRACE_REFRESH) {
                    ModelUtil.log((String)"Duplicate LabelProviderChangedEvent detected. Skipping update.");
                }
                this.lastEventTime = System.currentTimeMillis();
                return;
            }
            this.lastEvent = event;
            this.lastEventTime = System.currentTimeMillis();
            if (event.getElements() == null) {
                LocalWorkspaceChangesViewLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)LocalWorkspaceChangesViewLabelProvider.this));
                return;
            }
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.log((String)String.format("Event has %d elements", event.getElements().length));
            }
            ArrayList<Object> elements = new ArrayList<Object>();
            int i = 0;
            while (i < event.getElements().length) {
                Object element = event.getElements()[i];
                if (element instanceof IFileSystemWorkItem) {
                    elements.add(((IFileSystemWorkItem)element).getActivity());
                }
                elements.add(element);
                ++i;
            }
            LocalWorkspaceChangesViewLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)LocalWorkspaceChangesViewLabelProvider.this, elements.toArray(new Object[elements.size()])));
        }
    };
    private static ILabelProvider domainLabels = new LabelProvider(){

        public String getText(Object element) {
            IDomainAdapter itemAdapter;
            if (element instanceof IModelAccessor) {
                element = ((IModelAccessor)element).getModelInstance();
            }
            if ((itemAdapter = DomainAdapterUtils.getDomainAdapter((Object)element)) != null) {
                return itemAdapter.generateTitle(element);
            }
            return Messages.LocalWorkspaceChangesViewLabelProvider_0;
        }
    };

    public LocalWorkspaceChangesViewLabelProvider(boolean customMarkup) {
        this.imageUtil = new ImageUtil();
        this.customMarkup = customMarkup;
        this.defaultLabels = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        this.defaultLabels.addListener(this.standardLabelProviderListener);
    }

    public LocalWorkspaceChangesViewLabelProvider() {
        this(false);
    }

    public void dispose() {
        this.defaultLabels.removeListener(this.standardLabelProviderListener);
        this.defaultLabels.dispose();
        this.imageUtil.dispose();
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = this.getRegularImageDescriptor(element);
        return descriptor != null ? this.imageUtil.getWideImage(descriptor) : null;
    }

    public Image getRegularImage(Object element) {
        ImageDescriptor descriptor = this.getRegularImageDescriptor(element);
        return descriptor != null ? this.imageUtil.getImage(descriptor) : null;
    }

    public ImageDescriptor getRegularImageDescriptor(Object element) {
        Image theImage;
        if (element instanceof IWorkspaceSyncContext) {
            IWorkspaceSyncContext wsc = (IWorkspaceSyncContext)element;
            return wsc.getLocal().isStream() ? ImagePool.STREAM : ImagePool.WORKSPACE;
        }
        if (element instanceof OfflineManager.UnreachableWorkspace) {
            return ImagePool.WORKSPACE;
        }
        if (element instanceof LoadedConfigurationDescriptor) {
            return ImagePool.COMPONENT;
        }
        if (element instanceof IComponentSyncContext) {
            IComponentSyncContext context = (IComponentSyncContext)element;
            if (PendingChangesUtil.isLoaded(context)) {
                return ImagePool.COMPONENT;
            }
            return ImagePool.COMPONENT_UNLOADED;
        }
        if (element instanceof IIncomingActivitySource) {
            return ImagePool.INCOMING_FOLDER_ICON;
        }
        if (element instanceof IOutgoingActivitySource) {
            if (!RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)((IOutgoingActivitySource)element).getModel().getRemoteOutgoingTeamRepository())) {
                return ImagePool.OUTGOING_FOLDER_DISABLED_ICON;
            }
            return ImagePool.OUTGOING_FOLDER_ICON;
        }
        if (element instanceof ISuspendedActivitySource) {
            return ImagePool.SUSPEND_FOLDER_ICON;
        }
        if (element instanceof ILocalChangeSource) {
            return ImagePool.PENDING_FOLDER_ICON;
        }
        if (element instanceof IActivitySource) {
            return UiPlugin.getFileSystemImageDescriptor(null);
        }
        if (element instanceof ILocalChangeSource) {
            return UiPlugin.getFileSystemImageDescriptor(null);
        }
        if (element instanceof ISyncFolder) {
            return UiPlugin.getFileSystemImageDescriptor(null);
        }
        if (element instanceof IRemoteActivity) {
            IRemoteActivity activity = (IRemoteActivity)element;
            IComponentSyncContext context = activity.getActivitySource().getModel();
            return context.isActive(activity) ? ImagePool.CHANGE : ImagePool.CHANGE_COMPLETED;
        }
        if (element instanceof IBaselineGroup) {
            return ImagePool.BASELINE;
        }
        if (element instanceof IRemoteChangeSummary) {
            IRemoteChangeSummary summary = (IRemoteChangeSummary)element;
            return this.getImageDescriptor(summary.getChangeSummary().item(), summary.getResourceName());
        }
        if (element instanceof ISubcomponentChange) {
            ISubcomponentChange change = (ISubcomponentChange)element;
            ILocalSynchronizationManager mgr = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
            IWorkspaceConnection wc = change.getContainingWorkspaceConnection();
            if (wc != null && mgr.isShared((IWorkspaceHandle)wc.getResolvedWorkspace(), change.getComponentHandle())) {
                return ImagePool.COMPONENT;
            }
            return ImagePool.COMPONENT_UNLOADED;
        }
        if (element instanceof IShareable) {
            IShareable shareable = (IShareable)element;
            IResource resource = (IResource)shareable.getAdapter(IResource.class);
            boolean isFolderChange = resource instanceof IFolder;
            return UiPlugin.getFileSystemImageDescriptor(isFolderChange ? null : resource.getName());
        }
        if (element instanceof ILocalChange) {
            ILocalChange change = (ILocalChange)element;
            return this.getImageDescriptor(change.getTarget(), change.getPath().toString());
        }
        if (element instanceof IUnresolvedSource) {
            return ImagePool.PENDING_FOLDER_ICON;
        }
        if (element instanceof IFileSystemWorkItem) {
            IFileSystemWorkItem wi = (IFileSystemWorkItem)element;
            if (wi.getWorkItem() == null) {
                return ImagePool.TASK;
            }
        } else {
            if (element instanceof IConflictItem) {
                IConflictItem conflict = (IConflictItem)element;
                return this.getImageDescriptor(conflict.getItem(), conflict.getName(false));
            }
            if (element instanceof ILocalConflictItem) {
                ILocalConflictItem conflict = (ILocalConflictItem)element;
                return this.getImageDescriptor(conflict.getItem(), conflict.getLocalPath().getName());
            }
            if (element instanceof ILogicalChange) {
                ILogicalChange change = (ILogicalChange)element;
                String simpleName = null;
                if (!(change.item() instanceof IFolderHandle)) {
                    String[] path = change.getPathHint();
                    simpleName = path.length > 0 ? path[path.length - 1] : IChangeSummary.UNKNOWN_PATH;
                }
                return UiPlugin.getFileSystemImageDescriptor(simpleName);
            }
            if (element instanceof OslcLinkWrapper) {
                OslcLinkWrapper wrapper = (OslcLinkWrapper)element;
                Object value = LocalWorkspaceChangesViewLabelProvider.adaptOslcLinkWrapper(wrapper);
                Image theImage2 = null;
                if (value != null) {
                    theImage2 = this.defaultLabels.getImage(value);
                }
                return theImage2 != null ? ImageDataImageDescriptor.createFromImage(theImage2) : ImagePool.TASK;
            }
            if (element instanceof PortsNode) {
                return ImagePool.PORTS_FOLDER_ICON;
            }
            if (element instanceof CurrentPortContainerNode) {
                return UiPlugin.getFileSystemImageDescriptor(null);
            }
            if (element instanceof PortChangesContainerNode) {
                return UiPlugin.getFileSystemImageDescriptor(null);
            }
            if (element instanceof VersionableChangeParentNode) {
                return UiPlugin.getFileSystemImageDescriptor(null);
            }
            if (element instanceof VersionableChangeNode) {
                VersionableChangeNode node = (VersionableChangeNode)element;
                return this.getImageDescriptor(node.getVersionable(), node.getName());
            }
            if (element instanceof MoveChangeDetailNode) {
                ImageDescriptor image = null;
                MoveChangeDetailNode node = (MoveChangeDetailNode)element;
                boolean isFolder = false;
                boolean isSymbolicLink = false;
                if (node.getParentNode() != null) {
                    VersionableChangeNode parentNode = node.getParentNode();
                    IVersionableHandle versionableHandle = parentNode.getVersionable();
                    if (versionableHandle instanceof ISymbolicLinkHandle) {
                        isSymbolicLink = true;
                    }
                    if (versionableHandle instanceof IFolderHandle) {
                        isFolder = true;
                    }
                }
                IMoveChangeDetail change = node.getMoveChangeDetail();
                image = isSymbolicLink ? ImagePool.SYM_LINK_MOVE_CHANGE_DETAIL_ICON : (isFolder ? ImagePool.FOLDER_MOVE_CHANGE_DETAIL_ICON : ImagePool.FILE_MOVE_CHANGE_DETAIL_ICON);
                if (change.isRename() && !change.isMove()) {
                    image = isSymbolicLink ? ImagePool.SYM_LINK_RENAME_CHANGE_DETAIL_ICON : (isFolder ? ImagePool.FOLDER_RENAME_CHANGE_DETAIL_ICON : ImagePool.FILE_RENAME_CHANGE_DETAIL_ICON);
                }
                return image;
            }
            if (element instanceof PropertyChangeDetailNode) {
                ImageDescriptor image = ImagePool.PROPERTY_MOD_CHANGE_DETAIL_ICON;
                PropertyChangeDetailNode node = (PropertyChangeDetailNode)element;
                if (node.isModified()) {
                    image = ImagePool.PROPERTY_MOD_CHANGE_DETAIL_ICON;
                } else if (node.isAdded()) {
                    image = ImagePool.PROPERTY_ADD_CHANGE_DETAIL_ICON;
                } else if (node.isDeleted()) {
                    image = ImagePool.PROPERTY_REMOVAL_CHANGE_DETAIL_ICON;
                }
                return image;
            }
            if (element instanceof ContentChangeDetailNode) {
                return ImagePool.CONTENT_CHANGE_DETAIL_ICON;
            }
            if (element instanceof SymbolicLinkChangeDetailNode) {
                return ImagePool.SYMBOLIC_LINK_CHANGE_DETAIL_ICON;
            }
            if (element instanceof EncodingChangeDetailNode) {
                return ImagePool.ENCODING_CHANGE_DETAIL_ICON;
            }
            if (element instanceof LineDelimiterChangeDetailNode) {
                return ImagePool.LINE_DELIMITER_CHANGE_DETAIL_ICON;
            }
            if (element instanceof ContentTypeChangeDetailNode) {
                return ImagePool.CONTENT_TYPE_CHANGE_DETAIL_ICON;
            }
            if (element instanceof ExecutableBitChangeDetailNode) {
                return ImagePool.EXECUTABLE_BIT_CHANGE_DETAIL_ICON;
            }
            if (element instanceof PendingPortsContainerNode) {
                return UiPlugin.getFileSystemImageDescriptor(null);
            }
        }
        if ((theImage = this.defaultLabels.getImage(element)) != null) {
            return ImageDataImageDescriptor.createFromImage((Image)theImage);
        }
        return null;
    }

    private ImageDescriptor getImageDescriptor(IVersionableHandle item, String name) {
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = item instanceof IFolderHandle ? UiPlugin.getFileSystemImageDescriptor(null) : (item instanceof ISymbolicLinkHandle ? ImagePool.SYMBOLIC_LINK : UiPlugin.getFileSystemImageDescriptor(name));
        return imageDescriptor;
    }

    public void beginEditChangeSet(IRemoteActivity[] activites, String editText) {
        this.activites = activites;
        this.editText = editText;
    }

    public void editChangeSet(String editText) {
        this.editText = editText;
    }

    public void endEditChangeSet() {
        this.activites = null;
        this.editText = null;
    }

    public String getText(Object element) {
        VersionableChangeParentNode node;
        String text;
        ConflictItemNode conflict;
        ISyncFolder folder;
        IFileSystemWorkItem change;
        if (element instanceof IWorkspaceSyncContext) {
            IWorkspaceSyncContext context = (IWorkspaceSyncContext)element;
            return context.getLocal().getName();
        }
        if (element instanceof OfflineManager.UnreachableWorkspace) {
            OfflineManager.UnreachableWorkspace workspace = (OfflineManager.UnreachableWorkspace)element;
            return workspace.getName();
        }
        if (element instanceof LoadedConfigurationDescriptor) {
            LoadedConfigurationDescriptor cd = (LoadedConfigurationDescriptor)element;
            return cd.componentName;
        }
        if (element instanceof IComponentSyncContext) {
            IComponentSyncContext context = (IComponentSyncContext)element;
            String text2 = context.getComponent().getName();
            if (context.isRefreshing()) {
                text2 = CustomTreeViewer.markupBusy(text2, this.customMarkup);
            }
            return text2;
        }
        if (element instanceof IActivitySource) {
            if (element instanceof IOutgoingActivitySource) {
                return Messages.LocalWorkspaceChangesViewLabelProvider_2;
            }
            if (element instanceof IIncomingActivitySource) {
                return Messages.LocalWorkspaceChangesViewLabelProvider_3;
            }
            if (element instanceof ISuspendedActivitySource) {
                return Messages.LocalWorkspaceChangesViewLabelProvider_4;
            }
        }
        if (element instanceof IRemoteActivity) {
            IRemoteActivity activity;
            if (this.activites != null) {
                IRemoteActivity[] iRemoteActivityArray = this.activites;
                int n = this.activites.length;
                int text2 = 0;
                while (text2 < n) {
                    activity = iRemoteActivityArray[text2];
                    if (element == activity) {
                        return this.editText;
                    }
                    ++text2;
                }
            }
            activity = (IRemoteActivity)element;
            return LocalWorkspaceChangesViewLabelProvider.getLabel(this.defaultLabels, activity);
        }
        if (element instanceof ISourceChangeSet) {
            return LocalWorkspaceChangesViewLabelProvider.getLabel((ILabelProvider)this.defaultLabels, (ISourceChangeSet)element);
        }
        if (element instanceof IBaselineGroup) {
            IBaselineGroup group = (IBaselineGroup)element;
            return BaselineWrapper.getLabel(group.getBaseline());
        }
        if (element instanceof IRemoteChangeSummary) {
            boolean ghost;
            IRemoteChangeSummary rcs = (IRemoteChangeSummary)element;
            IChangeSummary changeSummary = rcs.getChangeSummary();
            String text3 = rcs.getResourceName();
            boolean bl = ghost = changeSummary != null && changeSummary.isChangeType(16);
            if (ghost) {
                text3 = CustomTreeViewer.markupInaccessible(text3, this.customMarkup);
            }
            return text3;
        }
        if (element instanceof IShareable) {
            IShareable shareable = (IShareable)element;
            return shareable.getLocalPath().getName();
        }
        if (element instanceof ILocalChange) {
            ILocalChange change2 = (ILocalChange)element;
            return change2.getPath().getName();
        }
        if (element instanceof IFileSystemWorkItem && (change = (IFileSystemWorkItem)element).getWorkItem() == null) {
            return change.getSummary();
        }
        if (element instanceof ISyncFolder) {
            folder = (ISyncFolder)element;
            return folder.getPath();
        }
        if (element instanceof ConflictItemNode) {
            conflict = (ConflictItemNode)element;
            return conflict.getResourceName(false);
        }
        if (element instanceof ILocalConflictItem) {
            conflict = (ILocalConflictItem)element;
            return conflict.getLocalPath().getName();
        }
        if (element instanceof ILogicalChange) {
            change = (ILogicalChange)element;
            String[] path = change.getPathHint();
            if (path.length > 0) {
                return path[path.length - 1];
            }
            return ILogicalChange.UNKNOWN_PATH;
        }
        if (element instanceof IUnresolvedSource) {
            return Messages.LocalWorkspaceChangesViewLabelProvider_5;
        }
        if (element instanceof IUnresolvedFolder) {
            folder = (IUnresolvedFolder)element;
            return folder.getPath();
        }
        if (element instanceof OslcLinkWrapper) {
            IURIReference ref;
            text = null;
            OslcLinkWrapper wrapper = (OslcLinkWrapper)element;
            Object value = LocalWorkspaceChangesViewLabelProvider.adaptOslcLinkWrapper(wrapper);
            if (value != null) {
                text = this.defaultLabels.getText(value);
            }
            if (text == null || text.equals(value.toString())) {
                text = wrapper.getLocalDescription();
            }
            if (text == null && (ref = wrapper.getTargetRef()) != null) {
                URI uri = ref.getURI();
                text = uri.toString();
            }
            return text != null ? text : Messages.LocalWorkspaceChangesViewLabelProvider_7;
        }
        if (element instanceof PortsNode) {
            text = Messages.LocalWorkspaceChangesViewLabelProvider_PORTS_FOLDER_NODE_LABEL;
            if (PortsCacheManager.getInstance().isUpdatingCache()) {
                text = CustomTreeViewer.markupBusy(text, this.customMarkup);
            }
            return text;
        }
        if (element instanceof CurrentPortContainerNode) {
            text = Messages.LocalWorkspaceChangesViewLabelProvider_CURRENT_PORT_FOLDER_NODE_LABEL;
            if (PortsCacheManager.getInstance().isUpdatingCache()) {
                text = CustomTreeViewer.markupBusy(text, this.customMarkup);
            }
            return text;
        }
        if (element instanceof CurrentPortNode) {
            return this.defaultLabels.getText(element);
        }
        if (element instanceof PortChangesContainerNode) {
            text = Messages.LocalWorkspaceChangesViewLabelProvider_PORT_CHANGES_FOLDER_NODE_LABEL;
            if (PortsCacheManager.getInstance().isUpdatingCache()) {
                text = CustomTreeViewer.markupBusy(text, this.customMarkup);
            }
            return text;
        }
        if (element instanceof VersionableChangeParentNode) {
            node = (VersionableChangeParentNode)element;
            String[] pathHint = node.getPathHint();
            return pathHint == null ? PortNodesUtil.MISSING_FOLDER_LABEL : PortNodesUtil.getPathString((String[])pathHint, (boolean)true);
        }
        if (element instanceof VersionableChangeNode) {
            node = (VersionableChangeNode)element;
            return node.getName();
        }
        if (element instanceof AbstractChangeDetailNode) {
            return ((AbstractChangeDetailNode)element).getChangeDetailSummary();
        }
        if (element instanceof PendingPortsContainerNode) {
            text = Messages.LocalWorkspaceChangesViewLabelProvider_PENDING_PORTS_CONTAINER_NODE_LABEL;
            if (PortsCacheManager.getInstance().isUpdatingCache()) {
                text = CustomTreeViewer.markupBusy(text, this.customMarkup);
            }
            return text;
        }
        if (element instanceof PendingPortNode) {
            return this.defaultLabels.getText(element);
        }
        if (element instanceof ISubcomponentChange) {
            String text4;
            ISubcomponentChange componentNode = (ISubcomponentChange)element;
            IComponent component = componentNode.getComponent();
            if (component != null) {
                text4 = component.getName();
                if (componentNode.isComponentMissingFromWorkspace()) {
                    text4 = componentNode.isInStream() ? String.valueOf(text4) + Messages.LocalWorkspaceChangesViewLabelProvider_NotInStreamDecorator : String.valueOf(text4) + Messages.LocalWorkspaceChangesViewLabelProvider_NotInWorkspaceDecorator;
                }
            } else {
                text4 = NLS.bind((String)Messages.LocalWorkspaceChangesViewLabelProvider_InaccessibleSubcomponent, (Object)componentNode.getComponentHandle().getItemId().getUuidValue());
            }
            if (componentNode.getChangeType() == ISubcomponentChange.ChangeType.Addition) {
                text4 = String.valueOf(text4) + Messages.LocalWorkspaceChangesViewLabelProvider_SubcomponentAddedDecorator;
            } else if (componentNode.getChangeType() == ISubcomponentChange.ChangeType.Removal) {
                text4 = String.valueOf(text4) + Messages.LocalWorkspaceChangesViewLabelProvider_SubcomponentRemovedDecorator;
            }
            return text4;
        }
        return this.defaultLabels.getText(element);
    }

    public static String getLabel(IRemoteActivity activity) {
        return LocalWorkspaceChangesViewLabelProvider.getLabel(domainLabels, activity.getChangeSet(), activity.getWorkItems(), activity.getOslcLinks(), LocalWorkspaceChangesViewLabelProvider.ownerOf(activity), false);
    }

    public static String getLabel(StandardLabelProvider defaultLabels, IRemoteActivity activity) {
        boolean modifiable = activity instanceof IOutgoingRemoteActivity || activity instanceof ISuspendedRemoteActivity;
        return LocalWorkspaceChangesViewLabelProvider.getLabel((ILabelProvider)defaultLabels, activity.getChangeSet(), activity.getWorkItems(), activity.getOslcLinks(), LocalWorkspaceChangesViewLabelProvider.ownerOf(activity), modifiable);
    }

    public static String getLabel(ILabelProvider defaultLabels, ISourceChangeSet sourceChangeSet) {
        return LocalWorkspaceChangesViewLabelProvider.getLabel(domainLabels, sourceChangeSet.getChangeSet(), sourceChangeSet.getWorkItems(), sourceChangeSet.getOslcLinks(), LocalWorkspaceChangesViewLabelProvider.ownerOf(sourceChangeSet), false);
    }

    static Object adaptOslcLinkWrapper(OslcLinkWrapper wrapper) {
        if (wrapper.getResolvedTarget() == null) {
            return null;
        }
        return wrapper.getResolvedTargetRef();
    }

    public static String getLabel(ILabelProvider defaultLabels, IChangeSet changeSet, List<IFileSystemWorkItem> links, List<OslcLinkWrapper> wrappers, boolean ownerOf, boolean modifiable) {
        String enterACommentString;
        if (changeSet == null) {
            return Messages.LocalWorkspaceChangesViewLabelProvider_6;
        }
        String comment = changeSet.getComment();
        boolean commentIsEmpty = comment.length() == 0;
        comment = comment.trim();
        String string = enterACommentString = commentIsEmpty ? Messages.LocalWorkspaceChangesViewLabelProvider_8 : comment;
        if (!UiPlugin.getBooleanPreference("ACTIVITY_LINK_DECORATION") && modifiable && ownerOf) {
            return enterACommentString;
        }
        if (defaultLabels != null && (links.size() > 0 || wrappers.size() > 0)) {
            Object resolved = null;
            String defaultLabel = null;
            if (links.size() > 0) {
                resolved = links.get(0).getWorkItem();
            } else if (wrappers.size() > 0) {
                OslcLinkWrapper wrapper = wrappers.get(0);
                resolved = LocalWorkspaceChangesViewLabelProvider.adaptOslcLinkWrapper(wrapper);
                defaultLabel = wrapper.getLocalDescription();
            }
            StringBuffer label = new StringBuffer();
            if (resolved != null || defaultLabel != null) {
                String resolvedText;
                String text = defaultLabel;
                if (resolved != null && (resolvedText = defaultLabels.getText(resolved)) != null && !resolvedText.equals(resolved.toString())) {
                    text = resolvedText;
                }
                if (text != null) {
                    label.append(text);
                }
                if (!commentIsEmpty) {
                    if (text != null) {
                        label.append(" - ");
                    }
                    label.append(comment);
                }
            } else if (!commentIsEmpty) {
                label.append(comment);
            } else {
                return enterACommentString;
            }
            return label.toString();
        }
        if (modifiable && ownerOf) {
            return enterACommentString;
        }
        return ChangeSetLocationFactory.getFullContextLabel((IChangeSet)changeSet);
    }

    public static String getLabel(IChangeSet changeSet, List<IAuditable> links) {
        if (changeSet == null) {
            return Messages.LocalWorkspaceChangesViewLabelProvider_9;
        }
        String comment = ChangeSetLocationFactory.getFullContextLabel((IChangeSet)changeSet);
        if (domainLabels != null && links.size() > 0) {
            return String.valueOf(domainLabels.getText((Object)links.get(0))) + (comment.equals("") ? "" : " - " + comment);
        }
        return comment;
    }

    private static boolean ownerOf(IRemoteActivity activity) {
        IContributor loggedInContributor = activity.getActivitySource().getModel().localTeamRepository().loggedInContributor();
        IContributor contributor = activity.getModifiedBy();
        return contributor != null && contributor.sameItemId((IItemHandle)loggedInContributor);
    }

    private static boolean ownerOf(ISourceChangeSet sourceChangeSet) {
        IContributor loggedInContributor = sourceChangeSet.getRemoteActivity().getActivitySource().getModel().localTeamRepository().loggedInContributor();
        IContributor contributor = sourceChangeSet.getModifiedBy();
        return contributor != null && contributor.sameItemId((IItemHandle)loggedInContributor);
    }
}

