/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalChangeSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISourceChangeSet;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISubcomponentChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.OfflineManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.PortsCacheManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.AbstractChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.AbstractPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortContainerNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PendingPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PendingPortsContainerNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortChangesContainerNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortsNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeParentNode;
import com.ibm.team.filesystem.rcp.core.internal.oslc.OslcLinkWrapper;
import com.ibm.team.filesystem.rcp.core.patches.Patch;
import com.ibm.team.filesystem.rcp.core.patches.PatchFile;
import com.ibm.team.filesystem.rcp.core.patches.PatchModel;
import com.ibm.team.filesystem.rcp.core.patches.PatchOpHandle;
import com.ibm.team.filesystem.ui.changes.configuration.LocalConfiguration;
import com.ibm.team.filesystem.ui.changes.views.PatchedDirectory;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class LocalWorkspaceChangesViewContentProvider
implements ITreeContentProvider {
    TreeViewer viewer;
    IComponentSyncModel model;
    LocalConfiguration localConfiguration;

    public LocalWorkspaceChangesViewContentProvider() {
        this(null);
    }

    public LocalWorkspaceChangesViewContentProvider(LocalConfiguration localConfiguration) {
        this.localConfiguration = localConfiguration;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Collection) {
            Collection collection = (Collection)parentElement;
            return collection.toArray(new Object[collection.size()]);
        }
        if (parentElement instanceof IComponentSyncModel) {
            IComponentSyncModel model = (IComponentSyncModel)parentElement;
            ArrayList<Object> children = new ArrayList<Object>();
            children.addAll(OfflineManager.getInstance().getUnreachableWorkspaces(true));
            IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
            List<IWorkspaceSyncContext> workspaceSyncContexts = Arrays.asList(model.getWorkspaceSyncContexts());
            if (LocalConfiguration.excludeUntrackedWorkspaces()) {
                for (IWorkspaceSyncContext wsc : workspaceSyncContexts) {
                    if (!manager.isWorkspaceTracked((IWorkspaceHandle)wsc.getLocal().getResolvedWorkspace())) continue;
                    children.add(wsc);
                }
            } else {
                children.addAll(workspaceSyncContexts);
            }
            if (!PatchModel.getDefault().isEmpty()) {
                children.add(PatchModel.getDefault());
            }
            return children.toArray();
        }
        if (parentElement instanceof OfflineManager.UnreachableWorkspace) {
            OfflineManager.UnreachableWorkspace workspace = (OfflineManager.UnreachableWorkspace)parentElement;
            return OfflineManager.getInstance().getUnreachableDescriptors(workspace).toArray();
        }
        if (parentElement instanceof IWorkspaceSyncContext) {
            IWorkspaceSyncContext context = (IWorkspaceSyncContext)parentElement;
            return LocalConfiguration.getVisibleComponentSyncContexts(context);
        }
        if (parentElement instanceof IComponentSyncContext) {
            List activitySources;
            IComponentSyncContext componentSyncContext = (IComponentSyncContext)parentElement;
            ArrayList<PortsNode> children = new ArrayList<PortsNode>();
            List subComponents = componentSyncContext.getChildren();
            List filterComponentSyncContexts = ComponentSyncUtil.filterComponentSyncContexts((List)subComponents, (boolean)LocalConfiguration.excludeDisconnectedComponents(), (boolean)LocalConfiguration.excludeComponentsWithNoChanges(), (int)LocalConfiguration.getSourcesFlag(), (boolean)LocalConfiguration.excludeAddedRemovedComponents());
            children.addAll(filterComponentSyncContexts);
            try {
                String showPortNodes = System.getProperty("com.ibm.team.filesystem.ide.ui.allowGapResolutionInPendingChangesView");
                if (Boolean.parseBoolean(showPortNodes)) {
                    ComponentSyncInfo info = componentSyncContext.getComponentSyncInfo();
                    IWorkspaceConnection wc = info.getLocalWorkspaceConnection();
                    ITeamRepository repo = wc.teamRepository();
                    IWorkspace workspace = wc.getResolvedWorkspace();
                    IComponent component = info.getComponent();
                    PortsNode node = PortsCacheManager.getInstance().getPortNode(repo, (IWorkspaceHandle)workspace, (IComponentHandle)component);
                    if (PortsCacheManager.getInstance().hasPortData(repo, (IWorkspaceHandle)workspace, (IComponentHandle)component)) {
                        children.add(node);
                    }
                }
            }
            catch (SecurityException showPortNodes) {
                // empty catch block
            }
            List list = activitySources = this.localConfiguration != null ? LocalConfiguration.getVisibleActivitySources(componentSyncContext) : componentSyncContext.getActivitySources();
            if (activitySources != null) {
                children.addAll(activitySources);
            }
            return children.toArray();
        }
        if (parentElement instanceof PortsNode) {
            PendingPortsContainerNode pendingPortsContainerNode;
            PortsNode portNode = (PortsNode)parentElement;
            ArrayList<Object> children = new ArrayList<Object>();
            CurrentPortContainerNode currentPortContainerNode = portNode.getChildCurrentPortContainerNode();
            if (currentPortContainerNode.getChildCurrentPortNode() != null) {
                children.add(currentPortContainerNode);
            }
            if ((pendingPortsContainerNode = portNode.getChildPendingPortsContainerNode()).getChildPendingPorts().size() > 0) {
                children.add(pendingPortsContainerNode);
            }
            return children.toArray();
        }
        if (parentElement instanceof CurrentPortContainerNode) {
            CurrentPortContainerNode currentPortContainerNode = (CurrentPortContainerNode)parentElement;
            ArrayList<CurrentPortNode> children = new ArrayList<CurrentPortNode>();
            if (currentPortContainerNode.getChildCurrentPortNode() != null) {
                children.add(currentPortContainerNode.getChildCurrentPortNode());
            }
            return children.toArray();
        }
        if (parentElement instanceof CurrentPortNode) {
            CurrentPortNode currentPortNode = (CurrentPortNode)parentElement;
            ArrayList children = new ArrayList();
            children.addAll(currentPortNode.getPortChanges().getChildNodes());
            return children.toArray();
        }
        if (parentElement instanceof VersionableChangeParentNode) {
            VersionableChangeParentNode versionableParentNode = (VersionableChangeParentNode)parentElement;
            ArrayList children = new ArrayList();
            children.addAll(versionableParentNode.getChildNodes());
            return children.toArray();
        }
        if (parentElement instanceof VersionableChangeNode) {
            VersionableChangeNode versionableNode = (VersionableChangeNode)parentElement;
            ArrayList children = new ArrayList();
            children.addAll(versionableNode.getChildVersionableChangeNodes());
            children.addAll(versionableNode.getChildChangeDetailNodes());
            return children.toArray();
        }
        if (parentElement instanceof PendingPortsContainerNode) {
            PendingPortsContainerNode node = (PendingPortsContainerNode)parentElement;
            ArrayList children = new ArrayList();
            children.addAll(node.getChildPendingPorts());
            return children.toArray();
        }
        if (parentElement instanceof IActivitySource) {
            IActivitySource source = (IActivitySource)parentElement;
            ArrayList children = new ArrayList();
            children.addAll(source.getActivities());
            children.addAll(source.getBaselines());
            return children.toArray();
        }
        if (parentElement instanceof IRemoteActivity) {
            IRemoteActivity activity = (IRemoteActivity)parentElement;
            List subcomponentChanges = activity.getSubcomponentChanges();
            List folders = new ArrayList();
            folders = activity.getChangeSet() != null && activity.getChangeSet().isActive() ? activity.getFolders() : ComponentSyncUtil.removeFoldersWithAllInaccessibleFile((IRemoteActivity)activity);
            List workItems = activity.getWorkItems();
            List calmLinks = activity.getOslcLinks();
            ISourceChangeSet sourceChangeSet = activity.getSourceChangeSet();
            ISourceChangeSet originalSourceChangeSet = activity.getOriginalSourceChangeSet();
            ArrayList children = new ArrayList();
            children.addAll(subcomponentChanges);
            children.addAll(folders);
            children.addAll(workItems);
            children.addAll(calmLinks);
            if (sourceChangeSet != null) {
                children.add(sourceChangeSet);
            }
            if (originalSourceChangeSet != null) {
                children.add(originalSourceChangeSet);
            }
            return children.toArray();
        }
        if (parentElement instanceof IBaselineGroup) {
            IBaselineGroup group = (IBaselineGroup)parentElement;
            if (!group.getResolve()) {
                ComponentBaselineUtil.resolve((IBaselineGroup)group);
            }
            if (!group.isResolved()) {
                return new String[]{Messages.LocalWorkspaceChangesViewContentProvider_0};
            }
            return group.getActivities().toArray();
        }
        if (parentElement instanceof ILocalChangeSource) {
            ILocalChangeSource source = (ILocalChangeSource)parentElement;
            return source.getFolders().toArray();
        }
        if (parentElement instanceof ILocalFolder) {
            ILocalFolder localFolder = (ILocalFolder)parentElement;
            ILocalChangeSource source = localFolder.getLocalChangeSource();
            return source.getLocalChanges(localFolder).toArray();
        }
        if (parentElement instanceof IActivityFolder) {
            IActivityFolder folder = (IActivityFolder)parentElement;
            return folder.getChanges().toArray();
        }
        if (parentElement instanceof IUnresolvedSource) {
            IUnresolvedSource source = (IUnresolvedSource)parentElement;
            return source.getChildren().toArray();
        }
        if (parentElement instanceof IUnresolvedFolder) {
            IUnresolvedFolder folder = (IUnresolvedFolder)parentElement;
            return folder.getChildren().toArray();
        }
        if (parentElement instanceof PatchModel) {
            PatchModel patchModel = (PatchModel)parentElement;
            Collection patches = patchModel.getPatches();
            return patches.toArray(new Patch[patches.size()]);
        }
        if (parentElement instanceof Patch) {
            Patch patch = (Patch)parentElement;
            return PatchedDirectory.getDirectoriesFor(patch);
        }
        if (parentElement instanceof PatchedDirectory) {
            PatchedDirectory dir = (PatchedDirectory)parentElement;
            Collection<PatchFile> files = dir.getFiles();
            ArrayList result = NewCollection.arrayList();
            for (PatchFile file : files) {
                result.addAll(file.getOpHandles());
            }
            return result.toArray(new PatchOpHandle[result.size()]);
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        PatchFile file;
        PatchOpHandle op;
        Patch patch;
        if (element instanceof IWorkspaceSyncContext) {
            return ((IWorkspaceSyncContext)element).getComponentSyncModel();
        }
        if (element instanceof IComponentSyncContext) {
            return ((IComponentSyncContext)element).getWorkspaceSyncContext();
        }
        if (element instanceof CurrentPortNode) {
            CurrentPortNode node = (CurrentPortNode)element;
            return node.getParentNode();
        }
        if (element instanceof PendingPortsContainerNode) {
            PendingPortsContainerNode node = (PendingPortsContainerNode)element;
            return node.getParentNode();
        }
        if (element instanceof VersionableChangeParentNode) {
            VersionableChangeParentNode versionableParentNode = (VersionableChangeParentNode)element;
            AbstractPortNode parentNode = versionableParentNode.getParentNode();
            if (parentNode instanceof PortChangesContainerNode) {
                return ((PortChangesContainerNode)parentNode).getParentNode();
            }
            return parentNode;
        }
        if (element instanceof VersionableChangeNode) {
            VersionableChangeNode versionableNode = (VersionableChangeNode)element;
            return versionableNode.getParentNode();
        }
        if (element instanceof AbstractChangeDetailNode) {
            AbstractChangeDetailNode changeDetailNode = (AbstractChangeDetailNode)element;
            return changeDetailNode.getParentNode();
        }
        if (element instanceof PendingPortNode) {
            PendingPortNode pendingPortNode = (PendingPortNode)element;
            return pendingPortNode.getParentNode();
        }
        if (element instanceof ILocalChangeSource) {
            return ((ILocalChangeSource)element).getModel();
        }
        if (element instanceof IActivitySource) {
            return ((IActivitySource)element).getModel();
        }
        if (element instanceof IRemoteActivity) {
            IRemoteActivity activity = (IRemoteActivity)element;
            if (activity.getActivitySource().getActivities().contains(activity)) {
                return activity.getActivitySource();
            }
            return ComponentSyncUtil.getBaselineGroup((IRemoteActivity)activity);
        }
        if (element instanceof IBaselineGroup) {
            return ((IBaselineGroup)element).getActivitySource();
        }
        if (element instanceof IRemoteChangeSummary) {
            IRemoteChangeSummary change = (IRemoteChangeSummary)element;
            return ComponentSyncUtil.findFolder((IRemoteChangeSummary)change);
        }
        if (element instanceof IFileSystemWorkItem) {
            IFileSystemWorkItem item = (IFileSystemWorkItem)element;
            return item.getActivity();
        }
        if (element instanceof OslcLinkWrapper) {
            OslcLinkWrapper wrapper = (OslcLinkWrapper)element;
            return wrapper.getParent();
        }
        if (element instanceof ISourceChangeSet) {
            ISourceChangeSet node = (ISourceChangeSet)element;
            return node.getRemoteActivity();
        }
        if (element instanceof ISubcomponentChange) {
            ISubcomponentChange node = (ISubcomponentChange)element;
            return node.getRemoteActivity();
        }
        if (element instanceof IActivityFolder) {
            IActivityFolder folder = (IActivityFolder)element;
            return folder.getParent();
        }
        if (element instanceof ILocalFolder) {
            ILocalFolder folder = (ILocalFolder)element;
            return folder.getParent();
        }
        if (element instanceof IUnresolvedSource) {
            IUnresolvedSource source = (IUnresolvedSource)element;
            return source.getModel();
        }
        if (element instanceof IUnresolvedFolder) {
            IUnresolvedFolder folder = (IUnresolvedFolder)element;
            return folder.getParent();
        }
        if (element instanceof ILocalChange) {
            ILocalChange localChange = (ILocalChange)element;
            return ComponentSyncUtil.findParent((ILocalChange)localChange);
        }
        if (element instanceof IConflictItem) {
            IConflictItem conflictItem = (IConflictItem)element;
            return ComponentSyncUtil.findParent((IConflictItem)conflictItem);
        }
        if (element instanceof ILocalConflictItem) {
            ILocalConflictItem conflictItem = (ILocalConflictItem)element;
            return conflictItem.getParent();
        }
        if (element instanceof PatchModel) {
            return this.model;
        }
        if (element instanceof Patch) {
            Patch patch2 = (Patch)element;
            return patch2.getModel();
        }
        if (element instanceof PatchedDirectory) {
            PatchedDirectory dir = (PatchedDirectory)element;
            return dir.getPath();
        }
        if (element instanceof PatchFile) {
            PatchFile file2 = (PatchFile)element;
            return PatchedDirectory.forFile(file2);
        }
        if (element instanceof PatchOpHandle && (patch = (op = (PatchOpHandle)element).getPatch()) != null && (file = patch.getFile(op.getFilePath())) != null) {
            return PatchedDirectory.forFile(file);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IWorkspaceSyncContext) {
            return LocalConfiguration.getVisibleComponentSyncContexts((IWorkspaceSyncContext)element).length > 0;
        }
        if (element instanceof OfflineManager.UnreachableWorkspace) {
            return true;
        }
        if (element instanceof IComponentSyncContext) {
            List activitySources;
            IComponentSyncContext componentSyncContext = (IComponentSyncContext)element;
            ComponentSyncInfo info = componentSyncContext.getComponentSyncInfo();
            IWorkspaceConnection wc = info.getLocalWorkspaceConnection();
            ITeamRepository repo = wc.teamRepository();
            IWorkspace workspace = wc.getResolvedWorkspace();
            IComponent component = info.getComponent();
            if (PortsCacheManager.getInstance().hasPendingPorts(repo, (IWorkspaceHandle)workspace, (IComponentHandle)component)) {
                return true;
            }
            List list = activitySources = this.localConfiguration != null ? LocalConfiguration.getVisibleActivitySources(componentSyncContext) : componentSyncContext.getActivitySources();
            if (activitySources != null && activitySources.size() > 0) {
                return true;
            }
            return !componentSyncContext.getChildren().isEmpty();
        }
        if (element instanceof PortsNode) {
            PortsNode portNode = (PortsNode)element;
            CurrentPortContainerNode currentPortContainerNode = portNode.getChildCurrentPortContainerNode();
            if (currentPortContainerNode.getChildCurrentPortNode() != null) {
                return true;
            }
            PendingPortsContainerNode pendingPortsContainerNode = portNode.getChildPendingPortsContainerNode();
            return pendingPortsContainerNode.getChildPendingPorts().size() > 0;
        }
        if (element instanceof CurrentPortContainerNode) {
            CurrentPortContainerNode currentPortContainerNode = (CurrentPortContainerNode)element;
            return currentPortContainerNode.getChildCurrentPortNode() != null;
        }
        if (element instanceof CurrentPortNode) {
            CurrentPortNode currentPortNode = (CurrentPortNode)element;
            return currentPortNode.getPortChanges().getChildNodes().size() > 0;
        }
        if (element instanceof PendingPortsContainerNode) {
            PendingPortsContainerNode node = (PendingPortsContainerNode)element;
            return node.getChildPendingPorts().size() > 0;
        }
        if (element instanceof VersionableChangeParentNode) {
            VersionableChangeParentNode versionableParentNode = (VersionableChangeParentNode)element;
            return versionableParentNode.getChildNodes().size() > 0;
        }
        if (element instanceof VersionableChangeNode) {
            VersionableChangeNode versionableNode = (VersionableChangeNode)element;
            return versionableNode.getChildVersionableChangeNodes().size() > 0 || versionableNode.getChildChangeDetailNodes().size() > 0;
        }
        if (element instanceof AbstractChangeDetailNode) {
            return false;
        }
        if (element instanceof PendingPortNode) {
            return false;
        }
        if (element instanceof IActivitySource) {
            IActivitySource source = (IActivitySource)element;
            return source.size() > 0;
        }
        if (element instanceof IRemoteActivity) {
            IRemoteActivity activity = (IRemoteActivity)element;
            return activity.getSubcomponentChanges().size() > 0 || activity.getOslcLinks().size() > 0 || activity.getWorkItems().size() > 0 || activity.getSourceChangeSet() != null || activity.getOriginalSourceChangeSet() != null || ComponentSyncUtil.getAccessibleFolders((IRemoteActivity)activity).size() != 0 || activity.getActivitySource().getModel().isActive(activity);
        }
        if (element instanceof IBaselineGroup) {
            IBaselineGroup group = (IBaselineGroup)element;
            return group.isResolved() ? !group.getActivities().isEmpty() : true;
        }
        if (element instanceof ILocalChangeSource) {
            ILocalChangeSource source = (ILocalChangeSource)element;
            return !LocalConfiguration.getPending(source.getModel()).isEmpty();
        }
        if (element instanceof IActivityFolder) {
            return true;
        }
        if (element instanceof ILocalFolder) {
            return true;
        }
        if (element instanceof PatchedDirectory) {
            return true;
        }
        if (element instanceof IUnresolvedSource) {
            return true;
        }
        if (element instanceof IUnresolvedFolder) {
            return true;
        }
        if (element instanceof PatchModel) {
            return !PatchModel.getDefault().isEmpty();
        }
        if (element instanceof Patch) {
            Patch patch = (Patch)element;
            return !patch.isEmpty();
        }
        if (element instanceof PatchedDirectory) {
            PatchedDirectory dir = (PatchedDirectory)element;
            return !dir.isEmpty();
        }
        if (element instanceof PatchFile) {
            PatchFile file = (PatchFile)element;
            return !file.isEmpty();
        }
        if (element instanceof PatchOpHandle) {
            return false;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        this.model = newInput instanceof IComponentSyncModel ? (IComponentSyncModel)newInput : null;
    }

    public void dispose() {
    }
}

