/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.views.Actions;
import com.ibm.team.filesystem.ui.changes.views.ChangesViewPage;
import com.ibm.team.filesystem.ui.changes.views.FullChangesViewPage;
import com.ibm.team.filesystem.ui.changes.views.OutOfSyncInformationBarUtil;
import com.ibm.team.filesystem.ui.changes.views.SetupPendingViewPage;
import com.ibm.team.filesystem.ui.changes.views.ZoomBookmark;
import com.ibm.team.filesystem.ui.changes.views.ZoomChangesViewPage;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.widgets.InformationBar;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;

public class LocalWorkspaceChangesView
extends ViewPart {
    public static final String ID = "com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView";
    public static final String VIEW_CONTEXT_ID = "com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView.context";
    public static final String VIEW_NAME = Messages.LocalWorkspaceChangesView_PENDING_CHANGES_VIEW_NAME;
    private Composite pages;
    private StackLayout stackLayout;
    private SetupPendingViewPage setupPage;
    private ZoomChangesViewPage zoomChangesPage;
    private FullChangesViewPage fullChangesPage;
    private boolean activePageCheckScheduled = false;
    private InformationBar informationBar;
    private InformationBar.IInformationBarListener informationBarListener;
    private ListenerList bookmarkListeners = new ListenerList(1);
    private String currentMessage;
    private int currentMessageType;
    private Actions actions;
    private boolean flatMode = false;
    private IStructuredSelection activeSelection = null;
    private TextActionHandler textActionHandler;
    private IHandler handler;
    private List<IHandlerActivation> handlerActivations = new ArrayList<IHandlerActivation>();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    protected void scheduleWithProgress(Job job) {
        job.setUser(true);
        IWorkbenchSiteProgressService ps = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        ps.schedule(job, 0L, true);
    }

    protected void markHasInterestingChanges() {
        IWorkbenchSiteProgressService ps = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        ps.warnOfContentChange();
    }

    public void createPartControl(Composite parent) {
        this.actions = new Actions();
        GridLayoutFactory.swtDefaults().margins(0, 0).spacing(0, 0).applyTo(parent);
        this.stackLayout = new StackLayout();
        this.informationBar = new InformationBar(parent, 2048);
        this.informationBar.setLayoutData(new GridData(4, 128, true, false));
        if (this.currentMessage != null) {
            this.informationBar.setMessage(this.currentMessage, this.currentMessageType);
        }
        if (this.informationBarListener != null) {
            this.informationBar.addLinkListener(this.informationBarListener);
        }
        this.pages = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.pages);
        this.pages.setLayout((Layout)this.stackLayout);
        this.setupPage = new SetupPendingViewPage(this.pages, this);
        this.fullChangesPage = new FullChangesViewPage(this.pages, this);
        this.zoomChangesPage = new ZoomChangesViewPage(this.pages, this);
        this.actions.init(parent.getShell(), this, this.fullChangesPage.getLabelProvider(), this.fullChangesPage.getLabelDecorator());
        this.textActionHandler = new TextActionHandler(this.getViewSite().getActionBars());
        this.textActionHandler.setCopyAction((IAction)this.actions.copyAction);
        this.fullChangesPage.init();
        this.zoomChangesPage.init();
        this.handler = this.actions.createHandler(this);
        this.activateHandlers();
        this.updateActivePage();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.pages, "com.ibm.team.filesystem.ide.ui.view_pendingchanges");
        this.activateContext();
    }

    public void activateHandlers() {
        IHandlerService handlerService = (IHandlerService)this.getViewSite().getService(IHandlerService.class);
        if (this.handlerActivations.isEmpty()) {
            String[] stringArray = Actions.COMMAND_IDS;
            int n = Actions.COMMAND_IDS.length;
            int n2 = 0;
            while (n2 < n) {
                String commandId = stringArray[n2];
                this.handlerActivations.add(handlerService.activateHandler(commandId, this.handler));
                ++n2;
            }
        } else {
            for (IHandlerActivation handlerActivation : this.handlerActivations) {
                handlerService.activateHandler(handlerActivation);
            }
        }
    }

    public void deactivateHandlers() {
        IHandlerService handlerService = (IHandlerService)this.getViewSite().getService(IHandlerService.class);
        for (IHandlerActivation handlerActivation : this.handlerActivations) {
            handlerService.deactivateHandler(handlerActivation);
        }
    }

    public ZoomBookmark getBookmark() {
        if (!this.flatMode) {
            return ZoomBookmark.FULL;
        }
        return this.zoomChangesPage.getBookmark();
    }

    public void addBookmarkListener(IBookmarkListener listener) {
        this.bookmarkListeners.add((Object)listener);
    }

    public void removeBookmarkListener(IBookmarkListener listener) {
        this.bookmarkListeners.remove((Object)listener);
    }

    private void sendBookmarkEvent(ZoomBookmark newBookmark) {
        Object[] listeners = this.bookmarkListeners.getListeners();
        BookmarkEvent event = new BookmarkEvent(newBookmark);
        Object[] objectArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IBookmarkListener)listener).changed(event);
            ++n2;
        }
    }

    public FullChangesViewPage getFullChangesViewPage() {
        return this.fullChangesPage;
    }

    public ZoomChangesViewPage getZoomChangesViewPage() {
        return this.zoomChangesPage;
    }

    public ChangesViewPage getActiveChangesViewPage() {
        return this.isFlatMode() ? this.zoomChangesPage : this.fullChangesPage;
    }

    public TreeViewer getActiveViewer() {
        return this.isFlatMode() ? this.zoomChangesPage.getViewer() : this.fullChangesPage.getViewer();
    }

    public void dispose() {
        super.dispose();
        this.actions.dispose();
        if (this.textActionHandler != null) {
            this.textActionHandler.dispose();
        }
        this.textActionHandler = null;
        if (this.handler != null) {
            this.handler.dispose();
        }
        this.handler = null;
        if (this.setupPage != null) {
            this.setupPage.dispose();
        }
        this.setupPage = null;
    }

    public void setFocus() {
        this.getActiveChangesViewPage().setFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkActivePage() {
        LocalWorkspaceChangesView localWorkspaceChangesView = this;
        synchronized (localWorkspaceChangesView) {
            if (this.activePageCheckScheduled) {
                return;
            }
            this.activePageCheckScheduled = true;
        }
        this.pages.getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LocalWorkspaceChangesView localWorkspaceChangesView = LocalWorkspaceChangesView.this;
                synchronized (localWorkspaceChangesView) {
                    LocalWorkspaceChangesView.this.activePageCheckScheduled = false;
                }
                if (LocalWorkspaceChangesView.this.pages != null && !LocalWorkspaceChangesView.this.pages.isDisposed()) {
                    LocalWorkspaceChangesView.this.updateActivePage();
                }
            }
        });
    }

    public boolean isFlatMode() {
        return this.flatMode;
    }

    public void setFlatMode(boolean flatMode) {
        this.flatMode = flatMode;
        this.updateActivePage();
    }

    public IStructuredSelection getActiveSelection() {
        return this.activeSelection;
    }

    public void setActiveSelection(IStructuredSelection activeSelection) {
        this.activeSelection = activeSelection;
    }

    private void updateActivePage() {
        ZoomBookmark bookmark = this.getBookmark();
        Composite newActivePage = bookmark == ZoomBookmark.FULL ? (this.fullChangesPage.showChangesPage() ? this.fullChangesPage : this.setupPage) : (this.zoomChangesPage.hasContent() ? this.zoomChangesPage : this.setupPage);
        this.setupPage.updateBookmark(bookmark);
        if (newActivePage != this.stackLayout.topControl) {
            if (newActivePage instanceof ChangesViewPage) {
                OutOfSyncInformationBarUtil.updateBar(this);
                if (newActivePage == this.fullChangesPage) {
                    this.fullChangesPage.setSelection(this.activeSelection);
                }
            }
            this.stackLayout.topControl = newActivePage;
            this.pages.layout();
        }
        this.sendBookmarkEvent(bookmark);
    }

    protected void setContentDescription(String description) {
        super.setContentDescription(description);
    }

    protected void setTitleImage(Image titleImage) {
        super.setTitleImage(titleImage);
    }

    public static void requestShowPendingView() {
        if (!UiPlugin.getDefault().getPreferenceStore().getBoolean("com.ibm.team.filesystem.ide.ui.prefs_show_pending_view_on_changes")) {
            return;
        }
        new UIJob(Messages.LocalWorkspaceChangesView_42){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page != null) {
                    try {
                        page.showView(LocalWorkspaceChangesView.ID, null, 2);
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void setInformationMessage(String message, int type, InformationBar.IInformationBarListener linkListener) {
        if (this.informationBarListener != null) {
            if (this.informationBar != null) {
                this.informationBar.removeLinkListener(this.informationBarListener);
            }
            this.informationBarListener = null;
        }
        if (linkListener != null) {
            this.informationBarListener = linkListener;
            if (this.informationBar != null) {
                this.informationBar.addLinkListener(linkListener);
            }
        }
        this.currentMessage = message;
        this.currentMessageType = type;
        if (this.informationBar != null) {
            this.informationBar.setMessage(message, type);
        }
    }

    public void clearInformationMessage() {
        if (this.informationBarListener != null) {
            if (this.informationBar != null) {
                this.informationBar.removeLinkListener(this.informationBarListener);
            }
            this.informationBarListener = null;
        }
        this.currentMessage = null;
        this.currentMessageType = 0;
        if (this.informationBar != null) {
            this.informationBar.setMessage(null, 0);
        }
    }

    public Actions getActions() {
        return this.actions;
    }

    public TextActionHandler getTextActionHandler() {
        return this.textActionHandler;
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext(VIEW_CONTEXT_ID);
    }

    public class BookmarkEvent {
        public ZoomBookmark newBookmark;

        public BookmarkEvent(ZoomBookmark newBookmark) {
            this.newBookmark = newBookmark;
        }
    }

    public static interface IBookmarkListener {
        public void changed(BookmarkEvent var1);
    }
}

