/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.icu.text.Bidi;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.internal.localchanges.LocalConflictManager;
import com.ibm.team.filesystem.client.internal.utils.ConnectionFacade;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.rest.client.sync.LocalConflictSyncDTO;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.LockQuery;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.UserLockCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentHierarchyVisitor;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalChangeSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISourceChangeSet;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISubcomponentChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.OfflineManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.outofsync.OutOfSyncCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.PortsCacheManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.AbstractChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.AbstractPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.MoveChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortNodesUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeParentNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OriginalSourceChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.SourceChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.oslc.OslcLinkWrapper;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.LabelsUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncViewDTOUtil;
import com.ibm.team.filesystem.rcp.core.patches.PatchOpHandle;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.configuration.LocalConfiguration;
import com.ibm.team.filesystem.ui.changes.views.DecorationImageDescriptor;
import com.ibm.team.filesystem.ui.changes.views.FlowDecoratorUtil;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.TeamPlaceComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.foundation.rcp.core.HistoryBin;
import com.ibm.team.internal.filesystem.ui.ImageUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer;
import com.ibm.team.internal.filesystem.ui.views.repositoryfiles.RepositoryFilesComponentNode;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.utils.ImageDataImageDescriptor;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeDetail;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IMoveChangeDetail;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Image;

public class LocalSynchronizeDecorator
implements ILabelDecorator {
    private ImageUtil imageUtil = new ImageUtil();
    public static final boolean NO_DECORATION = Boolean.getBoolean("com.ibm.team.filesystem.ui.changes.views.noDecorators");
    public static boolean TEXT_ARROWS = "macosx".equals(Platform.getOS());
    static final boolean componentLoggedOutDecoration = true;
    static final boolean progressDecoration = true;
    static final boolean changeMoveDecoration = true;
    static final boolean componentSharedDecoration = false;
    static final boolean outgoingChangeMergeDecoration = true;
    static final boolean locks = true;
    static final boolean ports = true;
    static final boolean outOfSyncShares = true;
    static final boolean versionablePropertyChangeDecorator = true;
    boolean customMarkup;

    static {
        if (Boolean.getBoolean("com.ibm.team.filesystem.ui.changes.views.textArrows")) {
            TEXT_ARROWS = true;
        }
        if (Boolean.getBoolean("com.ibm.team.filesystem.ui.changes.views.iconArrows")) {
            TEXT_ARROWS = false;
        }
    }

    public LocalSynchronizeDecorator() {
        this(false);
    }

    public LocalSynchronizeDecorator(boolean customMarkup) {
        this.customMarkup = customMarkup;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public Image decorateImage(Image image, Object element) {
        if (NO_DECORATION) {
            return image;
        }
        if (image == null) {
            return null;
        }
        ImageDescriptor result = this.decorateImageDescriptor(ImageDataImageDescriptor.createFromImage((Image)image), element);
        if (result == null) {
            return null;
        }
        return this.imageUtil.getImage(result);
    }

    public ImageDescriptor decorateImageDescriptor(ImageDescriptor image, Object element) {
        BitSet flags;
        IRemoteChangeSummary change;
        BitSet flags2;
        IActivityFolder folder;
        IComponentSyncContext context;
        ILocalChangeSource source;
        FileItemWrapper wrapper;
        AbstractFileSystemItemWrapper.LockInfo lockInfo;
        IWorkspaceSyncContext workspaceContext;
        BitSet flags3;
        if (image == null) {
            return null;
        }
        if (element instanceof IWorkspaceSyncContext && !(flags3 = LocalConfiguration.getDecorationFlags(workspaceContext = (IWorkspaceSyncContext)element)).isEmpty()) {
            return new DecorationImageDescriptor(image, flags3, 2);
        }
        if (element instanceof OfflineManager.UnreachableWorkspace) {
            return new DecorationImageDescriptor(image, 18, 2);
        }
        if (element instanceof LoadedConfigurationDescriptor) {
            return new DecorationImageDescriptor(image, 18, 2);
        }
        if (element instanceof FileItemWrapper && (lockInfo = (wrapper = (FileItemWrapper)((Object)element)).getLockInfo()).isLocked()) {
            if (lockInfo.isLockedByMe()) {
                return new DecorationImageDescriptor(image, 20, 2);
            }
            return new DecorationImageDescriptor(image, 19, 2);
        }
        DecorationImageDescriptor lockImage = this.computeRepositoryFilesViewFlags(element, image);
        if (lockImage != null) {
            return lockImage;
        }
        if (element instanceof IComponentSyncContext) {
            IComponentSyncContext context2 = (IComponentSyncContext)element;
            BitSet flags4 = this.computeFlags(context2);
            if (ComponentSyncUtil.shouldShowComponentHierarchies() && context2.detectCycle()) {
                flags4.set(35);
            }
            if (flags4.isEmpty()) {
                return null;
            }
            return new DecorationImageDescriptor(image, flags4, 2);
        }
        if (element instanceof ILocalChangeSource && ComponentConflictUtil.hasConflictItems((IComponentSyncContext)(source = (ILocalChangeSource)element).getModel())) {
            return new DecorationImageDescriptor(image, 11, 2);
        }
        if (element instanceof IBaselineGroup) {
            IBaselineGroup group = (IBaselineGroup)element;
            context = group.getActivitySource().getModel();
            List activities = group.getActivities();
            boolean hasConflict = false;
            for (IRemoteActivity activity : activities) {
                if (!context.hasConflict(activity)) continue;
                hasConflict = true;
                break;
            }
            if (hasConflict) {
                return new DecorationImageDescriptor(image, 10, 2);
            }
        }
        if (element instanceof IActivitySource) {
            flags3 = new BitSet();
            IActivitySource source2 = (IActivitySource)element;
            IComponentSyncContext context3 = source2.getModel();
            if (context3.hasConflict(source2)) {
                flags3.set(10);
            }
            LockQuery.LockCount lockCount = LockQuery.countLocks((Object)element);
            if (lockCount.locksBlocking > 0) {
                flags3.set(19);
            } else if (lockCount.locksOwned > 0) {
                flags3.set(20);
            }
            return new DecorationImageDescriptor(image, flags3, 2);
        }
        if (element instanceof IActivityFolder) {
            folder = (IActivityFolder)element;
            IComponentSyncContext model = folder.getModel();
            flags2 = new BitSet();
            if (model.hasConflict(folder)) {
                flags2.set(10);
            }
            if (model.isCheckinIn(folder)) {
                flags2.set(15);
            }
            LockQuery.LockCount lockCount = LockQuery.countLocks((Object)element);
            if (lockCount.locksBlocking > 0) {
                flags2.set(19);
            } else if (lockCount.locksOwned > 0) {
                flags2.set(20);
            }
            return new DecorationImageDescriptor(image, flags2, 2);
        }
        if (element instanceof IRemoteActivity) {
            IChangeSet changeSet;
            IRemoteActivity activity = (IRemoteActivity)element;
            IComponentSyncContext compareChanges = activity.getActivitySource().getModel();
            flags2 = new BitSet();
            if (compareChanges.hasConflict(activity)) {
                flags2.set(10);
            }
            if (compareChanges.isCurrent(activity)) {
                flags2.set(2);
            }
            if (!compareChanges.isActive(activity)) {
                flags2.set(3);
            } else if (compareChanges.isCheckinIn(activity)) {
                flags2.set(15);
            }
            int nDefects = activity.getWorkItems().size();
            if (nDefects == 1) {
                flags2.set(16);
            } else if (nDefects > 1) {
                flags2.set(17);
            }
            LockQuery.LockCount lockCount = LockQuery.countLocks((Object)element);
            if (lockCount.locksBlocking > 0) {
                flags2.set(19);
            } else if (lockCount.locksOwned > 0) {
                flags2.set(20);
            }
            if (compareChanges.hasCorrespondingActivity(activity)) {
                flags2.set(25);
            }
            if ((changeSet = activity.getChangeSet()) != null) {
                IChangeSetHandle original = changeSet.getOriginalChangeSet();
                if (original != null) {
                    if (original.sameItemId((IItemHandle)changeSet)) {
                        flags2.set(26);
                    } else {
                        flags2.set(28);
                    }
                }
                if (activity instanceof IOutgoingRemoteActivity && activity.getActivitySource().getWorkspace() != null && PortsCacheManager.getInstance().isPortTargetOfCurrentPort((IChangeSetHandle)activity.getChangeSet(), activity.getActivitySource().getTeamRepository(), (IWorkspaceHandle)activity.getActivitySource().getWorkspace(), activity.getChangeSet().getComponent())) {
                    flags2.set(29);
                }
            }
            return new DecorationImageDescriptor(image, flags2, 2);
        }
        if (element instanceof IRemoteChangeSummary) {
            IContributor lock;
            IWorkspaceConnection stream;
            IChangeSummary summary;
            change = (IRemoteChangeSummary)element;
            context = change.getActivity().getActivitySource().getModel();
            flags2 = new BitSet();
            boolean isIncomingTargetOnline = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)context.getRemoteIncomingTeamRepository());
            boolean isOutgoingTargetOnline = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)context.getRemoteOutgoingTeamRepository());
            if (!isIncomingTargetOnline && !isOutgoingTargetOnline) {
                flags2.set(24);
            }
            if (context.hasConflict(change)) {
                flags2.set(9);
            }
            if (context.isCheckinIn(change)) {
                flags2.set(15);
            }
            if ((summary = change.getChangeSummary()).isChangeType(1)) {
                flags2.set(7);
            } else if (summary.isChangeType(2)) {
                flags2.set(8);
            }
            flags2.set(change.getActivity().getActivitySource() instanceof IOutgoingActivitySource ? 6 : 5);
            IVersionableHandle versionable = change.getItem();
            if (versionable != null && (stream = context.getRemoteOutgoingTeamPlace()) != null && (lock = UserLockCache.get().getLock(versionable, stream, (IComponentHandle)context.getComponent())) != null) {
                if (lock.sameItemId((IItemHandle)stream.teamRepository().loggedInContributor())) {
                    flags2.set(20);
                } else {
                    flags2.set(19);
                }
            }
            return new DecorationImageDescriptor(image, flags2, 2);
        }
        if (element instanceof ISubcomponentChange) {
            change = (ISubcomponentChange)element;
            flags = new BitSet();
            boolean isOutgoing = change.getRemoteActivity().getActivitySource() instanceof IOutgoingActivitySource;
            if (isOutgoing) {
                if (change.getChangeType().equals((Object)ISubcomponentChange.ChangeType.Addition)) {
                    flags.set(33);
                } else if (change.getChangeType().equals((Object)ISubcomponentChange.ChangeType.Removal)) {
                    flags.set(34);
                }
            } else if (change.getChangeType().equals((Object)ISubcomponentChange.ChangeType.Addition)) {
                flags.set(31);
            } else if (change.getChangeType().equals((Object)ISubcomponentChange.ChangeType.Removal)) {
                flags.set(32);
            }
            return new DecorationImageDescriptor(image, flags, 2);
        }
        if (element instanceof ILocalChange) {
            ILocalChange localChange = (ILocalChange)element;
            context = ComponentSyncUtil.getContext((IComponentSyncModel)FileSystemResourcesPlugin.getComponentSyncModel(), (ILocalChange)localChange);
            if (context != null && localChange != null) {
                IContributor lock;
                int type = localChange.getType();
                BitSet flags5 = new BitSet();
                flags5.set(6);
                flags5.set(15);
                if (LocalConflictManager.getInstance().hasConflict(localChange)) {
                    flags5.set(10);
                }
                boolean isIncomingTargetOnline = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)context.getRemoteIncomingTeamRepository());
                boolean isOutgoingTargetOnline = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)context.getRemoteOutgoingTeamRepository());
                if (!isIncomingTargetOnline && !isOutgoingTargetOnline) {
                    flags5.set(24);
                }
                if (type == 2) {
                    flags5.set(7);
                } else if (type == 4) {
                    flags5.set(8);
                }
                IVersionableHandle versionable = localChange.getTarget();
                IWorkspaceConnection stream = context.getRemoteOutgoingTeamPlace();
                if (stream != null && (lock = UserLockCache.get().getLock(versionable, stream, (IComponentHandle)context.getComponent())) != null) {
                    if (lock.sameItemId((IItemHandle)stream.teamRepository().loggedInContributor())) {
                        flags5.set(20);
                    } else {
                        flags5.set(19);
                    }
                }
                return new DecorationImageDescriptor(image, flags5, 2);
            }
        }
        if (element instanceof PatchOpHandle) {
            PatchOpHandle lfo = (PatchOpHandle)element;
            IStatus status = lfo.getModel().getResult(lfo);
            flags2 = new BitSet();
            flags2.set(5);
            if (status != null && status.getSeverity() > 0) {
                flags2.set(9);
            }
            if (lfo.getOp().isCreate()) {
                flags2.set(7);
            }
            if (lfo.getOp().isDelete()) {
                flags2.set(8);
            }
            return new DecorationImageDescriptor(image, flags2, 2);
        }
        if (element instanceof IConflictItem) {
            return new DecorationImageDescriptor(image, 11, 2);
        }
        if (element instanceof ILocalConflictItem) {
            flags3 = new BitSet();
            flags3.set(11);
            flags3.set(15);
            return new DecorationImageDescriptor(image, flags3, 2);
        }
        if (element instanceof ILogicalChange) {
            return new DecorationImageDescriptor(image, 11, 2);
        }
        if (element instanceof IUnresolvedSource) {
            source = (IUnresolvedSource)element;
            flags = new BitSet();
            if (source.containsConflict()) {
                flags.set(11);
            }
            LockQuery.LockCount lockCount = LockQuery.countLocks((Object)element);
            if (lockCount.locksBlocking > 0) {
                flags.set(19);
            } else if (lockCount.locksOwned > 0) {
                flags.set(20);
            }
            return new DecorationImageDescriptor(image, flags, 2);
        }
        if (element instanceof IUnresolvedFolder) {
            folder = (IUnresolvedFolder)element;
            flags = LocalConfiguration.getDecorationFlags((IUnresolvedFolder)folder);
            return new DecorationImageDescriptor(image, flags, 2);
        }
        if (element instanceof VersionableChangeNode) {
            VersionableChangeNode node = (VersionableChangeNode)element;
            flags = new BitSet();
            if (node.hasGap()) {
                flags.set(30);
            }
            if (node.isInConflict() && (node.isIncidental() || !node.isResolved())) {
                flags.set(9);
            }
            if (node.isAdded()) {
                flags.set(7);
            }
            if (node.isDeleted()) {
                flags.set(8);
            }
            if (node.isResolved()) {
                flags.set(3);
            }
            return new DecorationImageDescriptor(image, flags, 2);
        }
        if (element instanceof AbstractChangeDetailNode) {
            AbstractChangeDetailNode changeDetailNode = (AbstractChangeDetailNode)element;
            IChangeDetail changeDetail = changeDetailNode.getChangeDetail();
            flags2 = new BitSet();
            switch (changeDetail.kind()) {
                case 2: {
                    break;
                }
                case 1: {
                    if (changeDetail.isResolved()) break;
                    flags2.set(10);
                }
            }
            return new DecorationImageDescriptor(image, flags2, 2);
        }
        return null;
    }

    private BitSet computeFlags(IComponentSyncContext context) {
        final BitSet result = new BitSet();
        context.visitComponentHierarchy(new IComponentHierarchyVisitor(){

            public void visit(IComponentSyncContext context) {
                result.or(LocalSynchronizeDecorator.this.basicComputeFlags(context));
            }
        });
        return result;
    }

    private BitSet basicComputeFlags(IComponentSyncContext context) {
        BitSet flags = new BitSet();
        if (!context.getLoggedIn()) {
            flags.set(18);
        } else {
            if (context.isLocal() && context.getLocalChangeSource().size() > 0) {
                flags.set(15);
            }
            if (context.getUnresolvedSource().containsConflict()) {
                flags.set(11);
            }
            if (context.isOfType(16)) {
                flags.set(33);
            } else if (context.isOfType(32)) {
                flags.set(34);
            }
            if (context.isOfType(64)) {
                flags.set(31);
            } else if (context.isOfType(128)) {
                flags.set(32);
            }
            if (context.isOfType(4) || context.isOfType(8)) {
                if (context.isOfType(2)) {
                    IOutgoingActivitySource outgoingSource = context.getOutgoingActivitySource();
                    if (context.hasConflict((IActivitySource)outgoingSource)) {
                        flags.set(10);
                    } else {
                        boolean incoming;
                        IIncomingActivitySource incomingSource = context.getIncomingActivitySource();
                        boolean outgoing = !context.getComponentSyncInfo().isPrivateOutgoingCollaboration() && (outgoingSource.size() != 0 || ComponentSyncUtil.isReplaceOutgoing((IComponentSyncContext)context));
                        boolean bl = incoming = !context.getComponentSyncInfo().isPrivateIncomingCollaboration() && (incomingSource.size() != 0 || ComponentSyncUtil.isReplaceIncoming((IComponentSyncContext)context));
                        if (incoming && outgoing) {
                            flags.set(14);
                        } else if (incoming) {
                            flags.set(12);
                        } else if (outgoing) {
                            flags.set(13);
                        }
                    }
                }
            } else if (context.isOfType(1)) {
                if (context.getOutgoingActivitySource().size() != 0) {
                    flags.set(13);
                }
                boolean isIncomingTargetOnline = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)context.getRemoteIncomingTeamRepository());
                boolean isOutgoingTargetOnline = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)context.getRemoteOutgoingTeamRepository());
                if (!isIncomingTargetOnline && !isOutgoingTargetOnline) {
                    flags.set(24);
                }
            }
        }
        LockQuery.LockCount lockCount = LockQuery.countLocks((Object)context);
        IWorkspaceConnection stream = context.getRemoteOutgoingTeamPlace();
        if (stream != null && context.getComponent() != null) {
            IComponent component = context.getComponent();
            if (stream.isLocked((IComponentHandle)component)) {
                if (stream.isLockedByMe((IComponentHandle)component)) {
                    if (lockCount.locksBlocking > 0) {
                        flags.set(19);
                    } else {
                        flags.set(20);
                    }
                } else {
                    flags.set(19);
                }
            } else if (lockCount.locksBlocking > 0) {
                flags.set(19);
            } else if (lockCount.locksOwned > 0) {
                flags.set(20);
            }
        }
        ComponentSyncInfo info = context.getComponentSyncInfo();
        IWorkspaceConnection wc = info.getLocalWorkspaceConnection();
        IComponent component = info.getComponent();
        try {
            if (wc != null && (wc.getCurrentPatch((IComponentHandle)component) != null || wc.getAcceptQueueSize((IComponentHandle)component) > 0L)) {
                flags.set(27);
            }
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            // empty catch block
        }
        return flags;
    }

    public String decorateText(String text, Object element) {
        return TextProcessor.process((String)this.decorateTextUnprocessed(text, element), (String)"/\\()");
    }

    private String decorateTextUnprocessedWorkspace(String text, IWorkspaceSyncContext workspaceContext) {
        IWorkspaceConnection local = workspaceContext.getLocal();
        IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
        boolean isTracked = manager.isWorkspaceTracked((IWorkspaceHandle)local.getResolvedWorkspace());
        if (UiPlugin.getBooleanPreference("COMPONENT_TEAM_PLACES_DECORATION_PREFERENCE") && isTracked) {
            FlowInfo flowInfo = this.getFlowInfo(workspaceContext, text);
            ConnectionFacade remoteIncoming = workspaceContext.getRemoteIncomingConnectionDescriptor();
            ConnectionFacade remoteOutgoing = workspaceContext.getRemoteOutgoingConnectionDescriptor();
            if (!flowInfo.isIncomingTargetSameAsSource || !flowInfo.isOutgoingTargetSameAsSource) {
                FlowDecoratorUtil.FlowDecoratorInfo flowDecoratorInfo = FlowDecoratorUtil.getFlowDecoratorInfo(workspaceContext, TEXT_ARROWS, this.customMarkup);
                flowInfo.flowTargetArrows = FlowDecoratorUtil.getFlowDecorator(flowDecoratorInfo);
                flowInfo.isBothTargetSame = remoteIncoming.connectionHandle.sameItemId((IItemHandle)remoteOutgoing.connectionHandle);
                text = this.formatFlowInfo(flowInfo);
            }
        } else {
            boolean isLoggedIn = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)local.teamRepository());
            if (!isLoggedIn || !isTracked) {
                if (!isLoggedIn) {
                    text = String.valueOf(text) + Messages.LocalSynchronizeDecorator_1;
                }
                if (!isTracked) {
                    text = String.valueOf(text) + Messages.LocalSynchronizeDecorator_NOT_TRACKED;
                }
                text = CustomTreeViewer.markupInaccessible(text, this.customMarkup);
            }
        }
        return text;
    }

    private String decorateTextUnprocessed(String text, Object element) {
        IRemoteActivity activity;
        IComponentSyncContext compareChanges;
        IReference ref;
        OslcLinkWrapper wrapper;
        ILink link;
        IChangeSummary changeSummary;
        ILocalChange localChange;
        boolean hasModifiedProperties;
        IIncomingActivitySource source;
        IComponentSyncContext context;
        IOutgoingRemoteActivity activity2;
        IOutgoingActivityFolder folder;
        int count;
        IBaselineGroup group;
        Date date;
        String proposedLabel;
        ILogicalChange change;
        String currentLabel;
        String decorator;
        ILocalConflictItem conflict;
        LocalConflictSyncDTO dto;
        String decorator2;
        ISubcomponentChange componentNode;
        IChangeSummary change2;
        Object decorator3;
        IChangeSummary summary;
        Object decorator4;
        if (NO_DECORATION) {
            return text;
        }
        if (element instanceof IWorkspaceSyncContext) {
            text = this.decorateTextUnprocessedWorkspace(text, (IWorkspaceSyncContext)element);
        } else if (element instanceof IComponentSyncContext) {
            IComponentSyncContext context2 = (IComponentSyncContext)element;
            if (UiPlugin.getBooleanPreference("COMPONENT_TEAM_PLACES_DECORATION_PREFERENCE")) {
                IBaseline localBaseline = context2.getLocalBaseline();
                boolean isLocalAtLocalBaseline = context2.isAtLocalBaseline();
                IBaseline remoteBaseline = context2.getRemoteIncomingBaseline();
                boolean isRemoteAtRemoteBaseline = context2.isIncomingTargetAtIncomingBaseline();
                String[] baselineDecoration = this.formatBaselineDecoration(localBaseline, isLocalAtLocalBaseline, remoteBaseline, isRemoteAtRemoteBaseline);
                text = String.valueOf(text) + baselineDecoration[0];
                FlowDecoratorUtil.FlowDecoratorInfo flowInfo = FlowDecoratorUtil.getFlowDecoratorInfo(context2, TEXT_ARROWS, this.customMarkup);
                text = String.valueOf(text) + this.formatComponentFlowInfo(context2, flowInfo, baselineDecoration[1]);
            }
        }
        if (UiPlugin.getBooleanPreference("ACTIVITY_MODIFIED_BY_DECORATION")) {
            IContributor contributor;
            if (element instanceof IRemoteActivity) {
                boolean doit;
                IRemoteActivity activity3 = (IRemoteActivity)element;
                boolean bl = doit = activity3.getChangeSet() != null;
                if (doit && (activity3 instanceof IOutgoingRemoteActivity || activity3 instanceof ISuspendedRemoteActivity)) {
                    IContributor loggedInContributor = activity3.getActivitySource().getModel().localTeamRepository().loggedInContributor();
                    contributor = activity3.getModifiedBy();
                    if (contributor != null && contributor.sameItemId((IItemHandle)loggedInContributor)) {
                        doit = false;
                    }
                }
                if (doit) {
                    IContributor contributor2 = activity3.getModifiedBy();
                    String value = contributor2 != null ? contributor2.getName() : Messages.LocalSynchronizeDecorator_3;
                    Bidi bidi = new Bidi(value, 126);
                    if (bidi.isRightToLeft()) {
                        value = "\u202a" + value + "\u202c";
                    }
                    if (value.length() != 0) {
                        decorator4 = value;
                        decorator4 = CustomTreeViewer.markupName((String)decorator4, this.customMarkup);
                        text = String.valueOf(decorator4) + "  " + text;
                    }
                }
            }
            if (element instanceof ISourceChangeSet) {
                boolean hideContributorName = false;
                ISourceChangeSet sourceChangeSet = (ISourceChangeSet)element;
                IContributor loggedInContributor = sourceChangeSet.getRemoteActivity().getActivitySource().getModel().localTeamRepository().loggedInContributor();
                contributor = sourceChangeSet.getModifiedBy();
                boolean doit = true;
                if (contributor != null && contributor.sameItemId((IItemHandle)loggedInContributor)) {
                    doit = false;
                }
                if (!hideContributorName || doit) {
                    String value = contributor != null ? contributor.getName() : Messages.LocalSynchronizeDecorator_3;
                    Bidi bidi = new Bidi(value, 126);
                    if (bidi.isRightToLeft()) {
                        value = "\u202a" + value + "\u202c";
                    }
                    if (value.length() != 0) {
                        String decorator5 = value;
                        decorator5 = CustomTreeViewer.markupName(decorator5, this.customMarkup);
                        text = String.valueOf(decorator5) + "  " + text;
                    }
                }
            }
        }
        if (UiPlugin.getBooleanPreference("ACTIVITY_MODIFIED_DECORATION")) {
            ISourceChangeSet sourceChangeSet;
            String formattedDate;
            IRemoteActivity activity4;
            if (element instanceof IRemoteActivity && (activity4 = (IRemoteActivity)element).getChangeSet() != null) {
                formattedDate = LocalSynchronizeDecorator.format(activity4.getModified());
                String decorator6 = CustomTreeViewer.markupDate("  " + formattedDate, this.customMarkup);
                text = String.valueOf(text) + decorator6;
            }
            if (element instanceof ISourceChangeSet && (sourceChangeSet = (ISourceChangeSet)element).getChangeSet() != null) {
                formattedDate = LocalSynchronizeDecorator.format(sourceChangeSet.getModifiedDate());
                String decorator7 = CustomTreeViewer.markupDate("  " + formattedDate, this.customMarkup);
                text = String.valueOf(text) + decorator7;
            }
        }
        if (element instanceof IRemoteChangeSummary && (summary = ((IRemoteChangeSummary)element).getChangeSummary()).isChangeType(8)) {
            String[] pathHint = summary.getPathHint();
            String[] newPathHint = summary.getNewPathHint();
            text = String.valueOf(text) + LabelsUtil.getTextDecoration((String[])pathHint, (String[])newPathHint);
        }
        if (UiPlugin.getBooleanPreference("CHANGE_SUMMARY_TYPE_DECORATION") && element instanceof IRemoteChangeSummary && (decorator3 = (change2 = ((IRemoteChangeSummary)element).getChangeSummary()).isChangeType(1) ? Messages.LocalSynchronizeDecorator_7 : (change2.isChangeType(2) ? Messages.LocalSynchronizeDecorator_8 : (change2.isChangeType(8) ? null : (change2.isChangeType(4) ? Messages.LocalSynchronizeDecorator_9 : (change2.isChangeType(16) ? Messages.LocalSynchronizeDecorator_10 : Messages.LocalSynchronizeDecorator_11))))) != null) {
            text = String.valueOf(text) + (String)decorator3;
        }
        if (element instanceof ISubcomponentChange && ((componentNode = (ISubcomponentChange)element).isComponentInaccessible() || componentNode.isComponentMissingFromWorkspace())) {
            text = CustomTreeViewer.markupInaccessible(text, true);
        }
        if (element instanceof ILocalChange) {
            ILocalChange change3 = (ILocalChange)element;
            IRelativeLocation originalPath = change3.getOriginalPath();
            IRelativeLocation newPath = change3.getPath();
            if ((change3.getType() & 8) == 8) {
                String[] pathHint = originalPath.segments();
                String[] newPathHint = newPath.segments();
                text = String.valueOf(text) + LabelsUtil.getTextDecoration((String[])pathHint, (String[])newPathHint);
            }
        }
        if (UiPlugin.getBooleanPreference("CHANGE_SUMMARY_CONFLICT_TYPE_DECORATION")) {
            IComponentSyncContext model;
            String decorator8;
            IRemoteActivity activity5;
            if (element instanceof IRemoteActivity && (activity5 = (IRemoteActivity)element).getChangeSet() != null && activity5.getActivitySource().getModel().isUnresolved(activity5)) {
                decorator8 = Messages.LocalSynchronizeDecorator_13;
                text = String.valueOf(text) + decorator8;
            }
            if (element instanceof IRemoteChangeSummary) {
                IRemoteChangeSummary change4 = (IRemoteChangeSummary)element;
                model = change4.getActivity().getActivitySource().getModel();
                Collection conflicts = model.getMergeConflict(change4);
                for (ILogicalChange conflict2 : conflicts) {
                    decorator4 = NLS.bind((String)Messages.LocalSynchronizeDecorator_14, (Object)model.getConflictType(change4, conflict2));
                    text = String.valueOf(text) + (String)decorator4;
                }
            }
            if (element instanceof IRemoteActivity && (activity = (IRemoteActivity)element).getChangeSet() != null && activity.getActivitySource().getModel().hasConflict(activity)) {
                decorator8 = Messages.LocalSynchronizeDecorator_15;
                text = String.valueOf(text) + decorator8;
            }
            if (element instanceof IRemoteChangeSummary) {
                IRemoteChangeSummary change5 = (IRemoteChangeSummary)element;
                model = change5.getActivity().getActivitySource().getModel();
                Collection conflicts = model.getConflicts(change5);
                for (ILogicalChange conflict2 : conflicts) {
                    decorator4 = NLS.bind((String)Messages.LocalSynchronizeDecorator_16, (Object)model.getConflictType(change5, conflict2));
                    text = String.valueOf(text) + (String)decorator4;
                }
            }
        }
        if (element instanceof IConflictItem) {
            IConflictItem conflict3 = (IConflictItem)element;
            change2 = conflict3.getLogicalChange();
            String currentLabel2 = LabelsUtil.getConflictInformation((ILogicalChange)change2, (boolean)true);
            String proposedLabel2 = LabelsUtil.getConflictInformation((ILogicalChange)change2, (boolean)false);
            String decorator9 = NLS.bind((String)Messages.LocalSynchronizeDecorator_17, (Object)currentLabel2, (Object)proposedLabel2);
            if (conflict3.getType() == 3) {
                decorator9 = String.valueOf(decorator9) + Messages.LocalSynchronizeDecorator_18;
            }
            if (conflict3.getType() == 2) {
                decorator9 = String.valueOf(decorator9) + Messages.LocalSynchronizeDecorator_19;
            }
            if (decorator9 != null) {
                text = String.valueOf(text) + CustomTreeViewer.markupConflict(decorator9, this.customMarkup);
            }
        }
        if (element instanceof ILocalConflictItem && (decorator2 = NLS.bind((String)Messages.LocalSynchronizeDecorator_17, (Object)(dto = SyncViewDTOUtil.getLocalConflictSyncDTO((ILocalConflictItem)(conflict = (ILocalConflictItem)element))).getConflictTypeOutgoing(), (Object)dto.getConflictTypeProposed())) != null) {
            text = String.valueOf(text) + CustomTreeViewer.markupConflict(decorator2, this.customMarkup);
        }
        if (element instanceof ILogicalChange && (decorator = NLS.bind((String)Messages.LocalSynchronizeDecorator_20, (Object)(currentLabel = LabelsUtil.getConflictInformation((ILogicalChange)(change = (ILogicalChange)element), (boolean)true)), (Object)(proposedLabel = LabelsUtil.getConflictInformation((ILogicalChange)change, (boolean)false)))) != null) {
            text = String.valueOf(text) + CustomTreeViewer.markupConflict(decorator, this.customMarkup);
        }
        if (element instanceof IBaselineGroup && (date = (group = (IBaselineGroup)element).getBaseline().getCreationDate()) != null) {
            String formattedDate = LocalSynchronizeDecorator.format(date);
            text = String.valueOf(text) + CustomTreeViewer.markupDate("  " + formattedDate, this.customMarkup);
        }
        if (element instanceof IOutgoingRemoteChangeSummary && ComponentSyncUtil.hasMergeStates((IChange)(change = (IOutgoingRemoteChangeSummary)element).getChange())) {
            text = String.valueOf(text) + CustomTreeViewer.markupConflict(Messages.LocalSynchronizeDecorator_21, this.customMarkup);
        }
        if (element instanceof IOutgoingActivityFolder && (count = ComponentSyncUtil.countItemsMerged((IActivityFolder)(folder = (IOutgoingActivityFolder)element))) > 0) {
            text = String.valueOf(text) + CustomTreeViewer.markupConflict(NLS.bind((String)Messages.LocalSynchronizeDecorator_22, (Object)count), this.customMarkup);
        }
        if (element instanceof IOutgoingRemoteActivity && (count = ComponentSyncUtil.countItemsMerged((IRemoteActivity)(activity2 = (IOutgoingRemoteActivity)element))) > 0) {
            text = String.valueOf(text) + CustomTreeViewer.markupConflict(NLS.bind((String)Messages.LocalSynchronizeDecorator_23, (Object)count), this.customMarkup);
        }
        if (element instanceof IOutgoingActivitySource) {
            IOutgoingActivitySource source2 = (IOutgoingActivitySource)element;
            count = ComponentSyncUtil.countItemsMerged((Collection)ComponentSyncUtil.getActivities((IActivitySource)source2));
            if (count > 0) {
                text = String.valueOf(text) + CustomTreeViewer.markupConflict(NLS.bind((String)Messages.LocalSynchronizeDecorator_24, (Object)count), this.customMarkup);
            }
            if (!((IOutgoingActivitySource)element).getModel().getLoggedIn()) {
                text = CustomTreeViewer.removeMarkup(text);
                text = CustomTreeViewer.markupInaccessible(text, this.customMarkup);
            }
        }
        if (element instanceof IComponentSyncContext && (count = ComponentSyncUtil.countItemsMerged((Collection)ComponentSyncUtil.getActivities((IActivitySource)(context = (IComponentSyncContext)element).getOutgoingActivitySource()))) > 0) {
            text = String.valueOf(text) + CustomTreeViewer.markupConflict(NLS.bind((String)Messages.LocalSynchronizeDecorator_25, (Object)count), this.customMarkup);
        }
        if (element instanceof OfflineManager.UnreachableWorkspace) {
            OfflineManager.UnreachableWorkspace uw = (OfflineManager.UnreachableWorkspace)element;
            if (uw.getState() == OfflineManager.UnreachableWorkspace.WorkspaceState.UNREACHABLE) {
                text = String.valueOf(text) + Messages.LocalSynchronizeDecorator_27;
                text = CustomTreeViewer.markupInaccessible(text, this.customMarkup);
            } else if (uw.getState() == OfflineManager.UnreachableWorkspace.WorkspaceState.LOGGING_IN) {
                text = String.valueOf(text) + CustomTreeViewer.markupDate(Messages.LocalSynchronizeDecorator_40, this.customMarkup);
            } else if (uw.getState() == OfflineManager.UnreachableWorkspace.WorkspaceState.FETCHING) {
                text = String.valueOf(text) + CustomTreeViewer.markupDate(Messages.LocalSynchronizeDecorator_26, this.customMarkup);
            }
        }
        if (element instanceof LoadedConfigurationDescriptor) {
            text = String.valueOf(text) + Messages.LocalSynchronizeDecorator_27;
            text = CustomTreeViewer.markupInaccessible(text, this.customMarkup);
        }
        if (element instanceof IComponentSyncContext) {
            context = (IComponentSyncContext)element;
            if (!context.getLoggedIn()) {
                text = CustomTreeViewer.removeMarkup(text);
                text = String.valueOf(text) + Messages.LocalSynchronizeDecorator_1;
                text = CustomTreeViewer.markupInaccessible(text, this.customMarkup);
            }
            if (ComponentSyncUtil.isReplaceIncoming((IComponentSyncContext)context)) {
                text = String.valueOf(text) + CustomTreeViewer.markupDate(Messages.LocalSynchronizeDecorator_28, this.customMarkup);
            } else if (ComponentSyncUtil.isReplaceOutgoing((IComponentSyncContext)context)) {
                text = String.valueOf(text) + CustomTreeViewer.markupDate(Messages.LocalSynchronizeDecorator_28_1, this.customMarkup);
            }
        }
        if (element instanceof IIncomingActivitySource && ComponentSyncUtil.isReplaceIncoming((IComponentSyncContext)(source = (IIncomingActivitySource)element).getModel())) {
            text = String.valueOf(text) + CustomTreeViewer.markupDate(Messages.LocalSynchronizeDecorator_28, this.customMarkup);
        }
        if (element instanceof IOutgoingActivitySource && ComponentSyncUtil.isReplaceOutgoing((IComponentSyncContext)(source = (IOutgoingActivitySource)element).getModel())) {
            text = String.valueOf(text) + CustomTreeViewer.markupDate(Messages.LocalSynchronizeDecorator_28_1, this.customMarkup);
        }
        if (element instanceof IRemoteActivity && (activity = (IRemoteActivity)element).errorChanges()) {
            IChangeSet changeSet = activity.getChangeSet();
            IRemoteActivity.ErrorType errorType = activity.errorType();
            if (errorType == IRemoteActivity.ErrorType.UNRESOLVED && changeSet == null) {
                text = String.valueOf(text) + CustomTreeViewer.markupConflict(Messages.LocalSynchronizeDecorator_29, this.customMarkup);
            } else if (errorType == IRemoteActivity.ErrorType.HIDDEN) {
                int nChanges = changeSet.changes().size();
                text = String.valueOf(text) + CustomTreeViewer.markupConflict(nChanges > 1 ? NLS.bind((String)Messages.LocalSynchronizeDecorator_30, (Object)nChanges) : Messages.LocalSynchronizeDecorator_31, this.customMarkup);
            }
        }
        if (element instanceof IRemoteActivity) {
            IRemoteActivity activity6 = (IRemoteActivity)element;
            List changes = activity6.getChanges();
            int missingChanges = 0;
            for (IRemoteChangeSummary summary2 : changes) {
                if (!summary2.getChangeSummary().isChangeType(32)) continue;
                ++missingChanges;
            }
            if (missingChanges > 0) {
                decorator = missingChanges == 1 ? Messages.LocalSynchronizeDecorator_47 : NLS.bind((String)Messages.LocalSynchronizeDecorator_46, (Object)missingChanges);
                decorator = CustomTreeViewer.markupConflict(decorator, this.customMarkup);
                text = String.valueOf(text) + decorator;
            }
        }
        if (element instanceof ILocalChange && (hasModifiedProperties = (localChange = (ILocalChange)element).isType(32))) {
            text = String.valueOf(text) + Messages.LocalSynchronizeDecorator_44;
        }
        if (element instanceof IRemoteChangeSummary) {
            boolean hasModifiedProperties2;
            IRemoteChangeSummary rcs = (IRemoteChangeSummary)element;
            IChangeSummary summary3 = rcs.getChangeSummary();
            boolean bl = hasModifiedProperties2 = summary3.isModificationChange(16) || summary3.isModificationChange(1) || summary3.isModificationChange(8) || summary3.isModificationChange(2);
            if (hasModifiedProperties2) {
                text = String.valueOf(text) + Messages.LocalSynchronizeDecorator_44;
            }
        }
        text = this.computeLockText(text, element);
        if (element instanceof IRemoteChangeSummary && (changeSummary = (summary = (IRemoteChangeSummary)element).getChangeSummary()).isChangeType(32)) {
            text = String.valueOf(text) + CustomTreeViewer.markupConflict(Messages.LocalSynchronizeDecorator_45, this.customMarkup);
        }
        if (element instanceof IComponentSyncContext) {
            context = (IComponentSyncContext)element;
            Collection shares = OutOfSyncCache.get().getOutOfSync((IWorkspaceHandle)context.getOutgoingTeamPlace().getResolvedWorkspace(), (IComponentHandle)context.getComponent());
            int count2 = shares.size();
            if (count2 == 1) {
                IShare share = (IShare)shares.toArray()[0];
                text = String.valueOf(text) + CustomTreeViewer.markupConflict(NLS.bind((String)Messages.LocalSynchronizeDecorator_36, (Object)share.getPath().getName()), this.customMarkup);
            }
            if (count2 > 1) {
                text = String.valueOf(text) + CustomTreeViewer.markupConflict(NLS.bind((String)Messages.LocalSynchronizeDecorator_37, (Object)count2), this.customMarkup);
            }
        }
        if (element instanceof IWorkspaceSyncContext) {
            IWorkspaceSyncContext wsc = (IWorkspaceSyncContext)element;
            count = OutOfSyncCache.get().getOutOfSyncCount((IWorkspaceHandle)wsc.getLocal().getResolvedWorkspace());
            if (count == 1) {
                text = String.valueOf(text) + CustomTreeViewer.markupConflict(Messages.LocalSynchronizeDecorator_39, this.customMarkup);
            }
            if (count > 1) {
                text = String.valueOf(text) + CustomTreeViewer.markupConflict(NLS.bind((String)Messages.LocalSynchronizeDecorator_38, (Object)count), this.customMarkup);
            }
        }
        if (element instanceof IActivitySource && !(source = (IActivitySource)element).getModel().isInitialized()) {
            String decorator10 = Messages.LocalSynchronizeDecorator_26;
            text = String.valueOf(text) + decorator10;
        }
        if (UiPlugin.getBooleanPreference("SOURCE_CONNECTION_STATUS_DECORATION_PREFERENCE") && element instanceof OslcLinkWrapper && (link = (wrapper = (OslcLinkWrapper)element).getLink()).getLinkTypeId().equals("com.ibm.team.filesystem.oslc_cm.change_request.change_set") && (ref = link.getTargetRef()).isURIReference()) {
            IURIReference uriRef = (IURIReference)ref;
            String host = uriRef.createURI().getHost();
            text = wrapper.getResolvedTarget() == null ? (wrapper.isResolved() ? String.valueOf(text) + CustomTreeViewer.markupConflict(NLS.bind((String)Messages.LocalSynchronizeDecorator_41, (Object)host), this.customMarkup) : String.valueOf(text) + CustomTreeViewer.markupConflict(NLS.bind((String)Messages.LocalSynchronizeDecorator_42, (Object)host), this.customMarkup)) : String.valueOf(text) + CustomTreeViewer.markupConflict(NLS.bind((String)Messages.LocalSynchronizeDecorator_43, (Object)host), this.customMarkup);
        }
        if (element instanceof AbstractFileSystemItemWrapper && (wrapper = (AbstractFileSystemItemWrapper)((Object)element)).getScope() != null) {
            text = String.valueOf(text) + CustomTreeViewer.markupConflict(NLS.bind((String)Messages.LocalSynchronizeDecorator_AbstractFileSystemItemWrapperDecoration, (Object)wrapper.getScope()), this.customMarkup);
        }
        if (element instanceof IComponentSyncContext) {
            context = (IComponentSyncContext)element;
            ComponentSyncInfo info = context.getComponentSyncInfo();
            IWorkspaceConnection wc = info.getLocalWorkspaceConnection();
            IComponent component = info.getComponent();
            try {
                if (wc != null && (wc.getCurrentPatch((IComponentHandle)component) != null || wc.getAcceptQueueSize((IComponentHandle)component) > 0L)) {
                    String renamedToDecorator = Messages.LocalSynchronizeDecorator_PENDING_GAP_RESOLUTION_DECORATOR;
                    text = String.valueOf(text) + CustomTreeViewer.markupConflict(renamedToDecorator, this.customMarkup);
                }
            }
            catch (ComponentNotInWorkspaceException renamedToDecorator) {
                // empty catch block
            }
        }
        if (element instanceof IRemoteActivity && (compareChanges = (activity = (IRemoteActivity)element).getActivitySource().getModel()).hasCorrespondingActivity(activity)) {
            if (activity instanceof IIncomingRemoteActivity) {
                String correspondingDecorator = Messages.LocalSynchronizeDecorator_LINKED_TO_OUTGOING_DECORATOR;
                text = String.valueOf(text) + CustomTreeViewer.markupConflict(correspondingDecorator, this.customMarkup);
            } else if (element instanceof IOutgoingRemoteActivity) {
                String correspondingDecorator = Messages.LocalSynchronizeDecorator_LINKED_TO_INCOMING_DECORATOR;
                text = String.valueOf(text) + CustomTreeViewer.markupConflict(correspondingDecorator, this.customMarkup);
            }
        }
        if (element instanceof OriginalSourceChangeSetNode) {
            String originalSourceDecorator = Messages.LocalSynchronizeDecorator_ORIGINAL_SOURCE_DECORATOR;
            text = String.valueOf(text) + CustomTreeViewer.markupConflict(originalSourceDecorator, this.customMarkup);
        } else if (element instanceof SourceChangeSetNode) {
            String sourceDecorator = Messages.LocalSynchronizeDecorator_SOURCE_DECORATOR;
            text = String.valueOf(text) + CustomTreeViewer.markupConflict(sourceDecorator, this.customMarkup);
        }
        if (element instanceof VersionableChangeParentNode) {
            boolean showResolvedDecorator = true;
            VersionableChangeParentNode node = (VersionableChangeParentNode)element;
            boolean isResolved = false;
            if (node.getChildNodes().size() > 0) {
                boolean allChildrenResolved = true;
                for (VersionableChangeNode child : node.getChildNodes()) {
                    if (child.isResolved()) continue;
                    allChildrenResolved = false;
                    break;
                }
                isResolved = allChildrenResolved;
            }
            if (isResolved) {
                if (showResolvedDecorator) {
                    text = String.valueOf(text) + Messages.LocalSynchronizeDecorator_RESOLVED_DECORATOR;
                }
                text = CustomTreeViewer.markupGrayStrikeout(text, this.customMarkup);
            }
        }
        if (element instanceof VersionableChangeNode) {
            boolean showStructuralChangesDecorator = true;
            boolean showChangeTypeDecorator = true;
            boolean showConflictOrGapDetailsDecorator = true;
            boolean showConflictLabelDecorator = false;
            boolean showIncidentalConflictLabelDecorator = false;
            boolean showGapLabelDecorator = false;
            boolean showIncidentalGapDecorator = false;
            boolean showResolvedDecorator = true;
            VersionableChangeNode versionableChangeNode = (VersionableChangeNode)element;
            String name = versionableChangeNode.getName();
            for (AbstractChangeDetailNode child : versionableChangeNode.getChildChangeDetailNodes()) {
                if (!(child instanceof MoveChangeDetailNode)) continue;
                MoveChangeDetailNode moveChangeDetailNode = (MoveChangeDetailNode)child;
                IMoveChangeDetail change6 = moveChangeDetailNode.getMoveChangeDetail();
                if (change6.isRename() && showStructuralChangesDecorator) {
                    String renamedFromDecorator;
                    String beforeName = change6.getBeforeName();
                    String afterName = change6.getAfterName();
                    if (!beforeName.equals(name) && !afterName.equals(name)) {
                        renamedFromDecorator = NLS.bind((String)Messages.LocalSynchronizeDecorator_RENAMED_DECORATOR, (Object)beforeName, (Object)afterName);
                        text = String.valueOf(text) + renamedFromDecorator;
                    } else if (!beforeName.equals(name)) {
                        renamedFromDecorator = NLS.bind((String)Messages.LocalSynchronizeDecorator_RENAMED_FROM_DECORATOR, (Object)beforeName);
                        text = String.valueOf(text) + renamedFromDecorator;
                    } else if (!afterName.equals(name)) {
                        String renamedToDecorator = NLS.bind((String)Messages.LocalSynchronizeDecorator_RENAMED_TO_DECORATOR, (Object)afterName);
                        text = String.valueOf(text) + renamedToDecorator;
                    }
                }
                if (!change6.isMove() || !showStructuralChangesDecorator) break;
                String beforePath = moveChangeDetailNode.getBeforePath(false);
                String afterPath = moveChangeDetailNode.getAfterPath(false);
                String parentPath = null;
                AbstractPortNode node = versionableChangeNode.getParentNode();
                if (node != null && node instanceof VersionableChangeParentNode) {
                    parentPath = PortNodesUtil.getPathString((String[])((VersionableChangeParentNode)node).getPathHint(), (boolean)false);
                }
                if (beforePath.equals(parentPath)) {
                    String movedToDecorator = NLS.bind((String)Messages.LocalSynchronizeDecorator_MOVED_TO_DECORATOR, (Object)afterPath);
                    text = String.valueOf(text) + movedToDecorator;
                    break;
                }
                if (afterPath.equals(parentPath)) {
                    String movedFromDecorator = NLS.bind((String)Messages.LocalSynchronizeDecorator_MOVED_FROM_DECORATOR, (Object)beforePath);
                    text = String.valueOf(text) + movedFromDecorator;
                    break;
                }
                String movedFromDecorator = NLS.bind((String)Messages.LocalSynchronizeDecorator_MOVED_FROM_AND_TO_DECORATOR, (Object)beforePath, (Object)afterPath);
                text = String.valueOf(text) + movedFromDecorator;
                break;
            }
            if (showChangeTypeDecorator) {
                if (versionableChangeNode.isAdded()) {
                    String addedDecorator = Messages.LocalSynchronizeDecorator_ADDED_DECORATOR;
                    text = String.valueOf(text) + CustomTreeViewer.markupConflict(addedDecorator, this.customMarkup && !versionableChangeNode.isResolved());
                }
                if (versionableChangeNode.isDeleted()) {
                    String deletedDecorator = Messages.LocalSynchronizeDecorator_DELETED_DECORATOR;
                    text = String.valueOf(text) + CustomTreeViewer.markupConflict(deletedDecorator, this.customMarkup && !versionableChangeNode.isResolved());
                }
                versionableChangeNode.isModified();
            }
            if (showConflictOrGapDetailsDecorator) {
                if (versionableChangeNode.isItemMissing()) {
                    IVersionableHandle versionable = versionableChangeNode.getVersionable();
                    if (versionable instanceof IFolderHandle) {
                        String missingFolderDecorator = Messages.LocalSynchronizeDecorator_FOLDER_MISSING_DECORATOR;
                        text = String.valueOf(text) + CustomTreeViewer.markupConflict(missingFolderDecorator, this.customMarkup && !versionableChangeNode.isResolved());
                    } else if (versionable instanceof ISymbolicLinkHandle) {
                        String missingSymbolicLinkDecorator = Messages.LocalSynchronizeDecorator_SYMBOLIC_LINK_MISSING_DECORATOR;
                        text = String.valueOf(text) + CustomTreeViewer.markupConflict(missingSymbolicLinkDecorator, this.customMarkup && !versionableChangeNode.isResolved());
                    } else {
                        String missingFileDecorator = Messages.LocalSynchronizeDecorator_FILE_MISSING_DECORATOR;
                        text = String.valueOf(text) + CustomTreeViewer.markupConflict(missingFileDecorator, this.customMarkup && !versionableChangeNode.isResolved());
                    }
                }
                if (versionableChangeNode.isDependentOnChange()) {
                    String depdendsOnDecorator = Messages.LocalSynchronizeDecorator_DEPENDS_ON_PARENT_DECORATOR;
                    text = String.valueOf(text) + CustomTreeViewer.markupConflict(depdendsOnDecorator, this.customMarkup && !versionableChangeNode.isResolved());
                } else if (versionableChangeNode.isMissingParent()) {
                    String parentMissingDecorator = Messages.LocalSynchronizeDecorator_PARENT_MISSING_DECORATOR;
                    text = String.valueOf(text) + CustomTreeViewer.markupConflict(parentMissingDecorator, this.customMarkup && !versionableChangeNode.isResolved());
                }
                if (versionableChangeNode.hasNameCollision()) {
                    String nameConflictDecorator = Messages.LocalSynchronizeDecorator_NAME_CONFLICT_DECORATOR;
                    text = String.valueOf(text) + CustomTreeViewer.markupConflict(nameConflictDecorator, this.customMarkup && !versionableChangeNode.isResolved());
                }
                if (versionableChangeNode.hasDescendants()) {
                    String folderNotEmptyDecorator = Messages.LocalSynchronizeDecorator_FOLDER_NOT_EMPTY_DECORATOR;
                    text = String.valueOf(text) + CustomTreeViewer.markupConflict(folderNotEmptyDecorator, this.customMarkup && !versionableChangeNode.isResolved());
                }
            }
            versionableChangeNode.isAutoResolvable();
            if (versionableChangeNode.isInConflict()) {
                if (versionableChangeNode.isIncidental() && showIncidentalConflictLabelDecorator) {
                    String incidentalConflictDecorator = Messages.LocalSynchronizeDecorator_INCIDENTAL_CONFLICT_DECORATOR;
                    text = String.valueOf(text) + CustomTreeViewer.markupConflict(incidentalConflictDecorator, this.customMarkup && !versionableChangeNode.isResolved());
                } else if (showConflictLabelDecorator) {
                    String conflictDecorator = Messages.LocalSynchronizeDecorator_CONFLICT_DECORATOR;
                    text = String.valueOf(text) + CustomTreeViewer.markupConflict(conflictDecorator, this.customMarkup && !versionableChangeNode.isResolved());
                }
            }
            if (versionableChangeNode.hasGap()) {
                if (versionableChangeNode.isIncidental() && showIncidentalGapDecorator) {
                    String incidentalGapDecorator = Messages.LocalSynchronizeDecorator_INCIDENTAL_GAP_DEORATOR;
                    text = String.valueOf(text) + CustomTreeViewer.markupConflict(incidentalGapDecorator, this.customMarkup && !versionableChangeNode.isResolved());
                } else if (showGapLabelDecorator) {
                    String gapDecorator = Messages.LocalSynchronizeDecorator_GAP_DECORATOR;
                    text = String.valueOf(text) + CustomTreeViewer.markupConflict(gapDecorator, this.customMarkup && !versionableChangeNode.isResolved());
                }
            }
            if (versionableChangeNode.isResolved()) {
                if (showResolvedDecorator) {
                    text = String.valueOf(text) + Messages.LocalSynchronizeDecorator_RESOLVED_DECORATOR;
                }
                text = CustomTreeViewer.markupGrayStrikeout(text, this.customMarkup);
            }
        }
        if (element instanceof MoveChangeDetailNode) {
            MoveChangeDetailNode moveChangeNode = (MoveChangeDetailNode)element;
            boolean showConflictOrGapDetailsDecorator = true;
            if (showConflictOrGapDetailsDecorator) {
                if (moveChangeNode.isDependentOnMoveTargetResolution()) {
                    String depdendsOnDecorator = Messages.LocalSynchronizeDecorator_DEPENDS_ON_MOVE_DESTINATION_DECORATOR;
                    text = String.valueOf(text) + CustomTreeViewer.markupConflict(depdendsOnDecorator, this.customMarkup && !moveChangeNode.isResolved());
                } else if (moveChangeNode.isAfterMissing()) {
                    String moveDestinationMissingDecorator = Messages.LocalSynchronizeDecorator_MOVE_DESTINATION_MISSING_DECORATOR;
                    text = String.valueOf(text) + CustomTreeViewer.markupConflict(moveDestinationMissingDecorator, this.customMarkup && !moveChangeNode.isResolved());
                }
                if (moveChangeNode.hasTargetNameCollision()) {
                    String nameConflictDecorator = Messages.LocalSynchronizeDecorator_NAME_CONFLICT_DECORATOR;
                    text = String.valueOf(text) + CustomTreeViewer.markupConflict(nameConflictDecorator, this.customMarkup && !moveChangeNode.isResolved());
                }
            }
        }
        if (element instanceof AbstractChangeDetailNode) {
            boolean showResolvedDecorator = true;
            AbstractChangeDetailNode changeDetailNode = (AbstractChangeDetailNode)element;
            if (changeDetailNode.isResolved()) {
                if (showResolvedDecorator) {
                    text = String.valueOf(text) + Messages.LocalSynchronizeDecorator_RESOLVED_DECORATOR;
                }
                text = CustomTreeViewer.markupGrayStrikeout(text, this.customMarkup);
            }
        }
        return text;
    }

    private String computeLockText(String inputText, Object element) {
        String text = inputText;
        if (element instanceof ILocalChange || element instanceof IRemoteChangeSummary || element instanceof FileItemWrapper) {
            IContributor lock;
            IWorkspaceConnection stream;
            IVersionableHandle versionable = null;
            IComponentSyncContext context = null;
            if (element instanceof ILocalChange) {
                ILocalChange localChange = (ILocalChange)element;
                context = ComponentSyncUtil.getContext((IComponentSyncModel)FileSystemResourcesPlugin.getComponentSyncModel(), (ILocalChange)localChange);
                versionable = localChange.getTarget();
            }
            if (element instanceof IRemoteChangeSummary) {
                IRemoteChangeSummary rcs = (IRemoteChangeSummary)element;
                context = ComponentSyncUtil.getContext((Object)rcs);
                versionable = rcs.getItem();
            }
            if (element instanceof FileItemWrapper) {
                text = this.computeFileLockText(text, (FileItemWrapper)((Object)element));
            }
            if (context != null && versionable != null && (stream = context.getRemoteOutgoingTeamPlace()) != null && (lock = UserLockCache.get().getLock(versionable, stream, (IComponentHandle)context.getComponent())) != null) {
                text = lock.sameItemId((IItemHandle)stream.teamRepository().loggedInContributor()) ? String.valueOf(text) + CustomTreeViewer.markupLockedByMe(NLS.bind((String)Messages.LocalSynchronizeDecorator_35, (Object)stream.getName()), this.customMarkup) : String.valueOf(text) + CustomTreeViewer.markupLockedByOther(NLS.bind((String)Messages.LocalSynchronizeDecorator_32, (Object)lock.getName(), (Object)stream.getName()), this.customMarkup);
            }
        }
        text = this.computeRepositoryFilesViewText(element, text);
        LockResult lockResult = element instanceof IComponentSyncContext ? new ComponentHierarchyLockResult((IComponentSyncContext)element) : new LockResult(element);
        if (element instanceof IActivityFolder || element instanceof IRemoteActivity || element instanceof IComponentSyncContext && !lockResult.hasComponentLock() && !lockResult.hasSubcomponentLocks() || element instanceof IActivitySource || element instanceof IUnresolvedSource || element instanceof IUnresolvedFolder) {
            if (lockResult.fileLockCount() == 1) {
                text = lockResult.hasBlockingFileLocks() ? String.valueOf(text) + CustomTreeViewer.markupLockedByOther(Messages.LocalSynchronizeDecorator_33, this.customMarkup) : String.valueOf(text) + CustomTreeViewer.markupLockedByMe(Messages.LocalSynchronizeDecorator_33, this.customMarkup);
            }
            if (lockResult.fileLockCount() > 1) {
                text = lockResult.hasBlockingFileLocks() ? String.valueOf(text) + CustomTreeViewer.markupLockedByOther(NLS.bind((String)Messages.LocalSynchronizeDecorator_34, (Object)lockResult.fileLockCount()), this.customMarkup) : String.valueOf(text) + CustomTreeViewer.markupLockedByMe(NLS.bind((String)Messages.LocalSynchronizeDecorator_34, (Object)lockResult.fileLockCount()), this.customMarkup);
            }
        }
        if (element instanceof IComponentSyncContext) {
            if (lockResult.hasComponentLock()) {
                if (lockResult.isComponentLockedByMe()) {
                    String message;
                    if (lockResult.fileLockCount() == 0) {
                        text = String.valueOf(text) + CustomTreeViewer.markupLockedByMe(NLS.bind((String)Messages.LocalSynchronizeDecorator_COMPONENT_LOCKED_BY_ME_NO_FILES, (Object)lockResult.getStreamName()), this.customMarkup);
                    } else if (lockResult.fileLockCount() == 1) {
                        message = NLS.bind((String)Messages.LocalSynchronizeDecorator_COMPONENT_LOCKED_BY_ME_ONE_FILE, (Object)lockResult.getStreamName());
                        text = lockResult.hasBlockingFileLocks() ? String.valueOf(text) + CustomTreeViewer.markupLockedByOther(message, this.customMarkup) : String.valueOf(text) + CustomTreeViewer.markupLockedByMe(message, this.customMarkup);
                    } else {
                        message = NLS.bind((String)Messages.LocalSynchronizeDecorator_COMPONENT_LOCKED_BY_ME_MANY_FILES, (Object)lockResult.fileLockCount(), (Object)lockResult.getStreamName());
                        text = lockResult.hasBlockingFileLocks() ? String.valueOf(text) + CustomTreeViewer.markupLockedByOther(message, this.customMarkup) : String.valueOf(text) + CustomTreeViewer.markupLockedByMe(message, this.customMarkup);
                    }
                } else {
                    String lockOwner = lockResult.getComponentLockOwnerName();
                    text = lockResult.fileLockCount() == 0 ? String.valueOf(text) + CustomTreeViewer.markupLockedByOther(NLS.bind((String)Messages.LocalSynchronizeDecorator_COMPONENT_LOCKED_BY_OTHER_NO_FILES, (Object)lockOwner, (Object)lockResult.getStreamName()), this.customMarkup) : (lockResult.fileLockCount() == 1 ? String.valueOf(text) + CustomTreeViewer.markupLockedByOther(NLS.bind((String)Messages.LocalSynchronizeDecorator_COMPONENT_LOCKED_BY_OTHER_ONE_FILE, (Object)lockOwner, (Object)lockResult.getStreamName()), this.customMarkup) : String.valueOf(text) + CustomTreeViewer.markupLockedByOther(NLS.bind((String)Messages.LocalSynchronizeDecorator_COMPONENT_LOCKED_BY_OTHER_MANY_FILES, (Object[])new Object[]{lockOwner, lockResult.fileLockCount(), lockResult.getStreamName()}), this.customMarkup));
                }
            }
            if (lockResult.hasSubcomponentLocks()) {
                text = lockResult.hasBlockingLocks() ? (lockResult.hasFileLocks() ? String.valueOf(text) + CustomTreeViewer.markupLockedByOther(NLS.bind((String)Messages.LocalSynchronizeDecorator_SUB_COMPONENTS_LOCKED_AND_FILE_LOCKS, (Object)lockResult.fileLockCount()), this.customMarkup) : String.valueOf(text) + CustomTreeViewer.markupLockedByOther(Messages.LocalSynchronizeDecorator_SUB_COMPONENTS_LOCKED_NO_FILE_LOCKS, this.customMarkup)) : (lockResult.hasFileLocks() ? String.valueOf(text) + CustomTreeViewer.markupLockedByMe(NLS.bind((String)Messages.LocalSynchronizeDecorator_SUB_COMPONENTS_LOCKED_AND_FILE_LOCKS, (Object)lockResult.fileLockCount()), this.customMarkup) : String.valueOf(text) + CustomTreeViewer.markupLockedByMe(Messages.LocalSynchronizeDecorator_SUB_COMPONENTS_LOCKED_NO_FILE_LOCKS, this.customMarkup));
            }
        }
        return text;
    }

    IWorkspaceConnection getLockContextStream(RepositoryFilesComponentNode node) {
        IWorkspaceConnection stream = null;
        if (node.getWrapper() instanceof WorkspaceComponentWrapper) {
            WorkspaceComponentWrapper wrapper = (WorkspaceComponentWrapper)node.getWrapper();
            if (wrapper instanceof ContributorPlaceComponentWrapper) {
                IWorkspaceManager workspaceManager;
                IFlowEntry flowEntry = wrapper.getWorkspaceConnection().getFlowTable().getCurrentDeliverFlow();
                if (flowEntry != null && (workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)wrapper.getRepository())) != null) {
                    stream = workspaceManager.getKnownWorkspaceConnection((IItemHandle)flowEntry.getFlowNode());
                }
            } else if (wrapper instanceof TeamPlaceComponentWrapper) {
                stream = wrapper.getWorkspaceConnection();
            }
        }
        return stream;
    }

    private String computeRepositoryFilesViewText(Object element, String inputText) {
        WorkspaceComponentWrapper workspaceComponentWrapper;
        IComponent component;
        RepositoryFilesComponentNode node;
        IWorkspaceConnection stream;
        String text = inputText;
        if (element instanceof RepositoryFilesComponentNode && (stream = this.getLockContextStream(node = (RepositoryFilesComponentNode)element)) != null && node.getWrapper() instanceof WorkspaceComponentWrapper && stream.isLocked((IComponentHandle)(component = (workspaceComponentWrapper = (WorkspaceComponentWrapper)node.getWrapper()).getComponent()))) {
            text = stream.isLockedByMe((IComponentHandle)component) ? String.valueOf(text) + CustomTreeViewer.markupLockedByMe(NLS.bind((String)Messages.LocalSynchronizeDecorator_35, (Object)stream.getName()), this.customMarkup) : String.valueOf(text) + CustomTreeViewer.markupLockedByOther(NLS.bind((String)Messages.LocalSynchronizeDecorator_32, (Object)stream.getLockOwnerName((IComponentHandle)component), (Object)stream.getName()), this.customMarkup);
        }
        return text;
    }

    private DecorationImageDescriptor computeRepositoryFilesViewFlags(Object element, ImageDescriptor image) {
        WorkspaceComponentWrapper workspaceComponentWrapper;
        IComponent component;
        RepositoryFilesComponentNode node;
        IWorkspaceConnection stream;
        if (element instanceof RepositoryFilesComponentNode && (stream = this.getLockContextStream(node = (RepositoryFilesComponentNode)element)) != null && node.getWrapper() instanceof WorkspaceComponentWrapper && stream.isLocked((IComponentHandle)(component = (workspaceComponentWrapper = (WorkspaceComponentWrapper)node.getWrapper()).getComponent()))) {
            if (stream.isLockedByMe((IComponentHandle)component)) {
                return new DecorationImageDescriptor(image, 20, 2);
            }
            return new DecorationImageDescriptor(image, 19, 2);
        }
        return null;
    }

    private String computeFileLockText(String inputText, FileItemWrapper wrapper) {
        String text = inputText;
        AbstractFileSystemItemWrapper.LockInfo lockInfo = wrapper.getLockInfo();
        if (lockInfo.isLocked()) {
            text = lockInfo.isLockedByMe() ? String.valueOf(text) + CustomTreeViewer.markupLockedByMe(NLS.bind((String)Messages.LocalSynchronizeDecorator_35, (Object)lockInfo.getLockContextConnetion().getName()), this.customMarkup) : String.valueOf(text) + CustomTreeViewer.markupLockedByOther(NLS.bind((String)Messages.LocalSynchronizeDecorator_32, (Object)lockInfo.getLockOwner().getName(), (Object)lockInfo.getLockContextConnetion().getName()), this.customMarkup);
        }
        return text;
    }

    private FlowInfo getFlowInfo(IWorkspaceSyncContext workspaceContext, String sourceName) {
        IWorkspaceConnection local = workspaceContext.getLocal();
        ConnectionFacade remoteIncoming = workspaceContext.getRemoteIncomingConnectionDescriptor();
        ConnectionFacade remoteOutgoing = workspaceContext.getRemoteOutgoingConnectionDescriptor();
        IFlowNodeHandle defaultIncomingCollaboration = local.getFlowTable().getDefaultAcceptFlow() == null ? null : local.getFlowTable().getDefaultAcceptFlow().getFlowNode();
        IFlowNodeHandle defaultOutgoingCollaboration = local.getFlowTable().getDefaultDeliverFlow() == null ? null : local.getFlowTable().getDefaultDeliverFlow().getFlowNode();
        boolean allFlows = FileSystemResourcesPlugin.getDefault().getPluginPreferences().getBoolean("show_all_flow_targets");
        FlowInfo flowInfo = new FlowInfo();
        flowInfo.sourceName = sourceName;
        flowInfo.sourceRepoName = com.ibm.team.internal.filesystem.ui.util.RepositoryUtils.getLabel(workspaceContext.getLocal().teamRepository());
        flowInfo.incomingTargetName = remoteIncoming.getName();
        if (remoteOutgoing.getCachedConnection() instanceof IWorkspaceConnection) {
            IWorkspaceConnection connection = (IWorkspaceConnection)remoteOutgoing.getCachedConnection();
            flowInfo.outgoingTargetLockOwnerName = connection.getLockOwnerName();
            flowInfo.outgoingTargetLockedByMe = connection.isLockedByMe();
        }
        flowInfo.outgoingTargetName = remoteOutgoing.getName();
        ITeamRepository incomingTeamRepository = null;
        try {
            incomingTeamRepository = remoteIncoming.getTeamRepository();
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        flowInfo.incomingTargetRepoName = com.ibm.team.internal.filesystem.ui.util.RepositoryUtils.getLabel(incomingTeamRepository);
        ITeamRepository outgoingTeamRepository = null;
        try {
            outgoingTeamRepository = remoteOutgoing.getTeamRepository();
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        flowInfo.outgoingTargetRepoName = com.ibm.team.internal.filesystem.ui.util.RepositoryUtils.getLabel(outgoingTeamRepository);
        flowInfo.isIncomingDistributed = FlowDecoratorUtil.isIncomingDistributed(workspaceContext);
        flowInfo.isOutgoingDistributed = FlowDecoratorUtil.isOutgoingDistributed(workspaceContext);
        flowInfo.isSourceOnline = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)local.teamRepository());
        flowInfo.isIncomingTargetOnline = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)incomingTeamRepository);
        flowInfo.isOutgoingTargetOnline = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)outgoingTeamRepository);
        flowInfo.isAllFlows = allFlows;
        flowInfo.targets = workspaceContext.getRemoteConnectionDescriptorsSplitByFlowDirection();
        flowInfo.isDefaultIncomingCollaboration = remoteIncoming.getContextHandle().sameItemId((IItemHandle)defaultIncomingCollaboration);
        flowInfo.isDefaultOutgoingCollaboration = remoteOutgoing.getContextHandle().sameItemId((IItemHandle)defaultOutgoingCollaboration);
        flowInfo.defaultIncomingCollaboration = defaultIncomingCollaboration;
        flowInfo.defaultOutgoingCollaboration = defaultOutgoingCollaboration;
        IWorkspaceHandle localWorkspaceHandle = (IWorkspaceHandle)local.getResolvedWorkspace().getItemHandle();
        flowInfo.isIncomingTargetSameAsSource = localWorkspaceHandle.sameItemId((IItemHandle)remoteIncoming.connectionHandle);
        flowInfo.isOutgoingTargetSameAsSource = localWorkspaceHandle.sameItemId((IItemHandle)remoteOutgoing.connectionHandle);
        return flowInfo;
    }

    private String formatFlowInfo(FlowInfo info) {
        String text = null;
        String source = info.sourceName;
        if (!info.isSourceOnline) {
            source = String.valueOf(source) + Messages.LocalSynchronizeDecorator_1;
            source = CustomTreeViewer.markupInaccessible(source, this.customMarkup);
        }
        String sourceRepoName = " [" + info.sourceRepoName + "]";
        if ((info.isIncomingDistributed || info.isOutgoingDistributed) && !info.isAllFlows) {
            if (info.isSourceOnline) {
                sourceRepoName = CustomTreeViewer.markupConflict(sourceRepoName, this.customMarkup);
            }
        } else {
            sourceRepoName = "";
        }
        source = String.valueOf(source) + sourceRepoName;
        String incomingAndOutgoingTargetNames = null;
        String incomingTargetNames = null;
        String outgoingTargetNames = null;
        if (info.isAllFlows) {
            if (info.targets != null && info.targets.length > 0 && (info.targets[0].length > 0 || info.targets[1].length > 0 || info.targets[2].length > 0)) {
                incomingAndOutgoingTargetNames = this.getTargetNames(info.targets[0], info.defaultIncomingCollaboration, info.defaultOutgoingCollaboration);
                incomingTargetNames = this.getTargetNames(info.targets[1], info.defaultIncomingCollaboration, info.defaultIncomingCollaboration);
                outgoingTargetNames = this.getTargetNames(info.targets[2], info.defaultOutgoingCollaboration, info.defaultOutgoingCollaboration);
            }
        } else if (info.isBothTargetSame) {
            if (info.incomingTargetName != null) {
                incomingAndOutgoingTargetNames = this.formatTargetName(info.isIncomingTargetOnline, info.incomingTargetName, info.isDefaultIncomingCollaboration, info.isIncomingDistributed, info.incomingTargetRepoName);
                incomingAndOutgoingTargetNames = String.valueOf(incomingAndOutgoingTargetNames) + this.getFormattedStreamLockText(info);
            }
        } else {
            if (info.incomingTargetName != null && !info.isIncomingTargetSameAsSource) {
                incomingTargetNames = this.formatTargetName(info.isIncomingTargetOnline, info.incomingTargetName, info.isDefaultIncomingCollaboration, info.isIncomingDistributed, info.incomingTargetRepoName);
            }
            if (info.outgoingTargetName != null && !info.isOutgoingTargetSameAsSource) {
                outgoingTargetNames = this.formatTargetName(info.isOutgoingTargetOnline, info.outgoingTargetName, info.isDefaultOutgoingCollaboration, info.isOutgoingDistributed, info.outgoingTargetRepoName);
                outgoingTargetNames = String.valueOf(outgoingTargetNames) + this.getFormattedStreamLockText(info);
            }
        }
        text = incomingTargetNames != null && !incomingTargetNames.isEmpty() ? String.valueOf(source) + info.flowTargetArrows[1] + incomingTargetNames : source;
        if (incomingAndOutgoingTargetNames != null && !incomingAndOutgoingTargetNames.isEmpty()) {
            text = text == null || text.isEmpty() ? String.valueOf(source) + info.flowTargetArrows[0] + incomingAndOutgoingTargetNames : String.valueOf(text) + " " + info.flowTargetArrows[0] + incomingAndOutgoingTargetNames;
        }
        if (outgoingTargetNames != null && !outgoingTargetNames.isEmpty()) {
            text = text == null || text.isEmpty() ? String.valueOf(source) + info.flowTargetArrows[2] + outgoingTargetNames : String.valueOf(text) + " " + info.flowTargetArrows[2] + outgoingTargetNames;
        }
        return text;
    }

    private String getFormattedStreamLockText(FlowInfo info) {
        String result = "";
        if (!info.outgoingTargetLockOwnerName.isEmpty()) {
            result = info.outgoingTargetLockedByMe ? CustomTreeViewer.markupLockedByMe(Messages.LocalSynchronizeDecorator_STREAM_LOCKED_BY_ME, this.customMarkup) : CustomTreeViewer.markupLockedByOther(NLS.bind((String)Messages.LocalSynchronizeDecorator_STREAM_LOCKED_BY_OTHER, (Object)info.outgoingTargetLockOwnerName), this.customMarkup);
        }
        return result;
    }

    private String formatTargetName(boolean isTargetOnline, String targetName, boolean isDefaultCollaboration, boolean isDistributed, String targetRepoName) {
        if (!isDefaultCollaboration) {
            targetName = isTargetOnline ? CustomTreeViewer.markupBusy(targetName, this.customMarkup) : CustomTreeViewer.markupSpecial(targetName, this.customMarkup);
        } else if (!isTargetOnline) {
            targetName = CustomTreeViewer.markupInaccessible(targetName, this.customMarkup);
        }
        if (isDistributed) {
            targetRepoName = " [" + targetRepoName + "]";
            targetRepoName = isTargetOnline ? CustomTreeViewer.markupConflict(targetRepoName, this.customMarkup) : CustomTreeViewer.markupInaccessible(targetRepoName, this.customMarkup);
            targetName = String.valueOf(targetName) + targetRepoName;
        }
        if (!isTargetOnline) {
            targetName = String.valueOf(targetName) + CustomTreeViewer.markupInaccessible(Messages.LocalSynchronizeDecorator_1, this.customMarkup);
        }
        return targetName;
    }

    private String getTargetNames(ConnectionFacade[] targets, IFlowNodeHandle defaultIncomingCollaboration, IFlowNodeHandle defaultOutgoingCollaboration) {
        String targetName = "";
        int i = 0;
        while (i < targets.length) {
            ConnectionFacade target = targets[i];
            String name = target.getName();
            ITeamRepository teamRepository = null;
            try {
                teamRepository = target.getTeamRepository();
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
            boolean isDefaultCollaboration = defaultIncomingCollaboration != null && target.connectionHandle.sameItemId((IItemHandle)defaultIncomingCollaboration) && defaultIncomingCollaboration != null && target.connectionHandle.sameItemId((IItemHandle)defaultOutgoingCollaboration);
            name = this.formatTargetName(RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)teamRepository), name, isDefaultCollaboration, false, com.ibm.team.internal.filesystem.ui.util.RepositoryUtils.getLabel(teamRepository));
            if (i < targets.length - 1) {
                name = String.valueOf(name) + ", ";
            }
            targetName = String.valueOf(targetName) + name;
            ++i;
        }
        return targetName;
    }

    private String formatComponentFlowInfo(IComponentSyncContext context, FlowDecoratorUtil.FlowDecoratorInfo flowInfo, String baselineDecoration) {
        String[] flowTargetArrows = FlowDecoratorUtil.getFlowDecorator(flowInfo);
        ComponentSyncInfo info = context.getComponentSyncInfo();
        String text = "";
        String incomingTargetName = null;
        String outgoingTargetName = null;
        if (!ComponentSyncUtil.isComponentTargetSameAsWorkspaceTarget((IComponentSyncContext)context)) {
            incomingTargetName = this.getComponentTargetName(info, context, true);
            outgoingTargetName = this.getComponentTargetName(info, context, false);
        }
        if (incomingTargetName != null || outgoingTargetName != null) {
            boolean isBothTargetSame = info.getRemoteIncoming().connectionHandle.sameItemId((IItemHandle)info.getRemoteOutgoing().connectionHandle);
            if (isBothTargetSame) {
                text = incomingTargetName != null ? String.valueOf(text) + flowTargetArrows[0] + incomingTargetName : String.valueOf(text) + flowTargetArrows[0] + outgoingTargetName;
                text = String.valueOf(text) + baselineDecoration;
            } else {
                if (incomingTargetName != null) {
                    text = String.valueOf(text) + flowTargetArrows[1] + incomingTargetName;
                    text = String.valueOf(text) + baselineDecoration;
                }
                if (outgoingTargetName != null) {
                    text = String.valueOf(text) + flowTargetArrows[2] + outgoingTargetName;
                }
            }
        }
        return text;
    }

    private String getComponentTargetName(ComponentSyncInfo info, IComponentSyncContext context, boolean incoming) {
        ConnectionFacade targetConnection = incoming ? info.getRemoteIncoming() : info.getRemoteOutgoing();
        ITeamRepository teamRepository = null;
        try {
            teamRepository = targetConnection.getTeamRepository();
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        boolean isTargetOnline = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)teamRepository);
        boolean isDefaultCollaboration = incoming ? context.isDefaultIncomingCollaboration() : context.isDefaultOutgoingCollaboration();
        boolean isDistributed = incoming ? this.isIncomingDistributed(info) : this.isOutgoingDistributed(info);
        String targetName = targetConnection.getName();
        String targetRepoName = com.ibm.team.internal.filesystem.ui.util.RepositoryUtils.getLabel(teamRepository);
        return this.formatTargetName(isTargetOnline, targetName, isDefaultCollaboration, isDistributed, targetRepoName);
    }

    private String[] formatBaselineDecoration(IBaseline localBaseline, boolean isLocalAtLocalBaseline, IBaseline incomingTargetBaseline, boolean isIncomingTargetAtIncomingBaseline) {
        String[] text = new String[]{"", ""};
        if (!UiPlugin.getBooleanPreference("BASIS_COMPONENT_DECORATION")) {
            return text;
        }
        if (localBaseline != null) {
            String localBaselineName = BaselineWrapper.getLabel(localBaseline);
            if (!isLocalAtLocalBaseline) {
                localBaselineName = NLS.bind((String)Messages.LocalSynchronizeDecorator_NOT_AT_BASELINE_DECORATOR, (Object)localBaselineName);
            }
            if (incomingTargetBaseline != null && !localBaseline.sameItemId(incomingTargetBaseline.getItemHandle())) {
                String incomingTargetBaselineName = BaselineWrapper.getLabel(incomingTargetBaseline);
                if (!isIncomingTargetAtIncomingBaseline) {
                    incomingTargetBaselineName = NLS.bind((String)Messages.LocalSynchronizeDecorator_NOT_AT_BASELINE_DECORATOR, (Object)incomingTargetBaselineName);
                }
                text[0] = NLS.bind((String)Messages.LocalSynchronizeDecorator_LOCAL_AND_TARGET_BASELINE_DECORATOR, (Object)localBaselineName, (Object)incomingTargetBaselineName);
            } else {
                text[0] = NLS.bind((String)Messages.LocalSynchronizeDecorator_LOCAL_BASELINE_DECORATOR, (Object)localBaselineName);
            }
        } else if (incomingTargetBaseline != null) {
            String incomingTargetBaselineName = BaselineWrapper.getLabel(incomingTargetBaseline);
            if (!isIncomingTargetAtIncomingBaseline) {
                incomingTargetBaselineName = NLS.bind((String)Messages.LocalSynchronizeDecorator_NOT_AT_BASELINE_DECORATOR, (Object)incomingTargetBaselineName);
            }
            text[1] = NLS.bind((String)Messages.LocalSynchronizeDecorator_LOCAL_BASELINE_DECORATOR, (Object)incomingTargetBaselineName);
        }
        return text;
    }

    private boolean isIncomingDistributed(ComponentSyncInfo info) {
        try {
            return info.getLocal().teamRepository() != info.getRemoteIncoming().getTeamRepository();
        }
        catch (TeamRepositoryException teamRepositoryException) {
            return false;
        }
    }

    private boolean isOutgoingDistributed(ComponentSyncInfo info) {
        try {
            return info.getLocal().teamRepository() != info.getRemoteOutgoing().getTeamRepository();
        }
        catch (TeamRepositoryException teamRepositoryException) {
            return false;
        }
    }

    public void dispose() {
        this.imageUtil.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public static String format(Date date) {
        return HistoryBin.formatDif((Date)date, (boolean)true, (boolean)true);
    }

    private class ComponentHierarchyLockResult
    extends LockResult {
        private boolean hasComponentLock;
        private boolean hasSubcomponentLocks;
        private boolean hasBlockingSubcomponentLocks;

        public ComponentHierarchyLockResult(IComponentSyncContext element) {
            super(element);
        }

        @Override
        public boolean hasComponentLock() {
            return this.hasComponentLock;
        }

        @Override
        public boolean hasSubcomponentLocks() {
            return this.hasSubcomponentLocks;
        }

        @Override
        public boolean isComponentLockedByMe() {
            return this.isComponentLockedByMe(this.getContext());
        }

        public boolean isComponentLockedByMe(IComponentSyncContext context) {
            if (this.getStream() != null && context.getComponent() != null) {
                return this.getStream().isLockedByMe((IComponentHandle)context.getComponent());
            }
            return false;
        }

        @Override
        public String getStreamName() {
            if (this.getStream() != null) {
                return this.getStream().getName();
            }
            return super.getStreamName();
        }

        @Override
        protected void initialize() {
            final IComponentSyncContext parentContext = (IComponentSyncContext)this.element;
            this.nonBlockingFileLocks = 0;
            this.blockingFileLocks = 0;
            parentContext.visitComponentHierarchy(new IComponentHierarchyVisitor(){

                public void visit(IComponentSyncContext context) {
                    LockQuery.LockCount fileLockCount = LockQuery.countLocks((Object)ComponentHierarchyLockResult.this.element);
                    if (fileLockCount != null) {
                        ComponentHierarchyLockResult.this.nonBlockingFileLocks += fileLockCount.locksOwned;
                        ComponentHierarchyLockResult.this.blockingFileLocks += fileLockCount.locksBlocking;
                    }
                    if (ComponentHierarchyLockResult.this.isLocked(context)) {
                        if (parentContext.getComponent().sameItemId((IItemHandle)context.getComponent())) {
                            ComponentHierarchyLockResult.this.hasComponentLock = true;
                        } else {
                            ComponentHierarchyLockResult.this.hasSubcomponentLocks = true;
                            ComponentHierarchyLockResult componentHierarchyLockResult = ComponentHierarchyLockResult.this;
                            componentHierarchyLockResult.hasBlockingSubcomponentLocks = componentHierarchyLockResult.hasBlockingSubcomponentLocks | !ComponentHierarchyLockResult.this.isComponentLockedByMe(context);
                        }
                    }
                }
            });
        }

        private boolean isLocked(IComponentSyncContext context) {
            IWorkspaceConnection stream = this.getStream();
            if (stream != null && context.getComponent() != null) {
                return stream.isLocked((IComponentHandle)context.getComponent());
            }
            return false;
        }

        private IWorkspaceConnection getStream() {
            return this.getContext().getRemoteOutgoingTeamPlace();
        }

        private IComponentSyncContext getContext() {
            return (IComponentSyncContext)this.element;
        }

        @Override
        public String getComponentLockOwnerName() {
            IWorkspaceConnection stream = this.getStream();
            if (stream != null && this.getContext().getComponent() != null) {
                return stream.getLockOwnerName((IComponentHandle)this.getContext().getComponent());
            }
            return super.getComponentLockOwnerName();
        }

        @Override
        public boolean hasBlockingLocks() {
            return super.hasBlockingLocks() || this.hasBlockingSubcomponentLocks || this.hasBlockingComponentLock();
        }

        private boolean hasBlockingComponentLock() {
            IWorkspaceConnection stream = this.getStream();
            if (stream != null && this.getContext() != null && this.getContext().getComponent() != null) {
                return stream.isLocked((IComponentHandle)this.getContext().getComponent()) && !this.isComponentLockedByMe();
            }
            return false;
        }
    }

    private class FlowInfo {
        public String sourceName;
        public String incomingTargetName;
        public String outgoingTargetName;
        public String sourceRepoName;
        public String incomingTargetRepoName;
        public String outgoingTargetRepoName;
        public boolean isIncomingDistributed;
        public boolean isOutgoingDistributed;
        public boolean isSourceOnline;
        public boolean isIncomingTargetOnline;
        public boolean isOutgoingTargetOnline;
        public boolean isAllFlows;
        public boolean isDefaultIncomingCollaboration;
        public boolean isDefaultOutgoingCollaboration;
        public ConnectionFacade[][] targets;
        public IFlowNodeHandle defaultIncomingCollaboration;
        public IFlowNodeHandle defaultOutgoingCollaboration;
        public String[] flowTargetArrows;
        public boolean isBothTargetSame;
        public boolean isIncomingTargetSameAsSource;
        public boolean isOutgoingTargetSameAsSource;
        public String outgoingTargetLockOwnerName = "";
        public boolean outgoingTargetLockedByMe = false;

        private FlowInfo() {
        }
    }

    private class LockResult {
        Object element;
        int blockingFileLocks;
        int nonBlockingFileLocks;

        public LockResult(Object element) {
            this.element = element;
            this.initialize();
        }

        protected void initialize() {
            LockQuery.LockCount fileLockCount = LockQuery.countLocks((Object)this.element);
            if (fileLockCount != null) {
                this.nonBlockingFileLocks = fileLockCount.locksOwned;
                this.blockingFileLocks = fileLockCount.locksBlocking;
            }
        }

        public int fileLockCount() {
            return this.blockingFileLocks + this.nonBlockingFileLocks;
        }

        boolean hasBlockingFileLocks() {
            return this.blockingFileLocks > 0;
        }

        public boolean hasFileLocks() {
            return this.fileLockCount() > 0;
        }

        public boolean hasComponentLock() {
            return false;
        }

        public boolean hasSubcomponentLocks() {
            return false;
        }

        public boolean isComponentLockedByMe() {
            return false;
        }

        public String getComponentLockOwnerName() {
            return "";
        }

        public boolean hasBlockingLocks() {
            return this.hasBlockingFileLocks();
        }

        public String getStreamName() {
            return "";
        }
    }
}

