/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISourceChangeSet;
import com.ibm.team.filesystem.rcp.core.internal.oslc.OslcLinkWrapper;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.IZoomWorkItemRoot;
import com.ibm.team.internal.filesystem.ui.adapters.SourceChangeSetAdapter;
import com.ibm.team.jface.util.ConvertingSelectionProvider;
import com.ibm.team.links.common.IReference;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class InternalConvertingSelectionProvider
extends ConvertingSelectionProvider {
    public InternalConvertingSelectionProvider(ISelectionProvider provider) {
        super(provider);
    }

    protected ISelection convertFrom(ISelection viewerSelection) {
        if (!(viewerSelection instanceof IStructuredSelection)) {
            return viewerSelection;
        }
        IStructuredSelection selection = (IStructuredSelection)viewerSelection;
        ArrayList<Object> result = new ArrayList<Object>(selection.size());
        for (Object element : selection) {
            IZoomWorkItemRoot root;
            if (element instanceof IZoomWorkItemRoot && (root = (IZoomWorkItemRoot)element).getWorkItem() != null) {
                result.add(root.getWorkItem());
            }
            if (element instanceof IFileSystemWorkItem) {
                IFileSystemWorkItem reference = (IFileSystemWorkItem)element;
                result.add(reference.getWorkItemHandle());
            }
            if (element instanceof OslcLinkWrapper) {
                Object resolve;
                OslcLinkWrapper wrapper = (OslcLinkWrapper)element;
                IReference ref = wrapper.getResolvedTargetRef();
                Object object = resolve = ref != null ? ref.resolve() : null;
                if (resolve != null) {
                    result.add(resolve);
                }
            }
            if (!(element instanceof ISourceChangeSet)) continue;
            ISourceChangeSet sourceChangeSet = (ISourceChangeSet)element;
            result.add((Object)SourceChangeSetAdapter.convertToChangeSetInContextWrapper(sourceChangeSet));
        }
        return new StructuredSelection(result);
    }
}

