/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.widgets.InformationBar;
import com.ibm.team.process.internal.rcp.ui.ImagePool;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class InaccessibleWorkspaceInformationBarUtil {
    static final String LOGIN_ACTION = "login";
    static final String CHANGE_TARGET_ACTION = "target";

    static void updateBar(final LocalWorkspaceChangesView view) {
        if (InaccessibleWorkspaceInformationBarUtil.getInaccessibleWorkspaces().size() == 0) {
            view.clearInformationMessage();
            return;
        }
        InformationBar.IInformationBarListener listener = new InformationBar.IInformationBarListener(){

            @Override
            public void closed() {
            }

            @Override
            public void clicked(String ref) {
                Collection workspaces = InaccessibleWorkspaceInformationBarUtil.getInaccessibleWorkspaces();
                HashSet<ITeamRepository> repositories = new HashSet<ITeamRepository>();
                UIContext context = UIContext.createShellContext((Shell)view.getSite().getShell());
                if (ref.equals(InaccessibleWorkspaceInformationBarUtil.LOGIN_ACTION)) {
                    for (IWorkspaceSyncContext workspace : workspaces) {
                        ITeamRepository repo = null;
                        try {
                            repo = workspace.getRemoteIncomingConnectionDescriptor().getTeamRepository();
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            // empty catch block
                        }
                        if (repo != null) {
                            repositories.add(repo);
                        }
                        if (workspace.getRemoteOutgoingConnectionDescriptor().equals((Object)workspace.getRemoteIncomingConnectionDescriptor())) continue;
                        repo = null;
                        try {
                            repo = workspace.getRemoteOutgoingConnectionDescriptor().getTeamRepository();
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            // empty catch block
                        }
                        if (repo == null) continue;
                        repositories.add(repo);
                    }
                    if (repositories.size() == 1) {
                        ITeamRepository repo = (ITeamRepository)repositories.toArray()[0];
                        this.repoLogin(context, repo);
                    } else {
                        SelectionDialog dialog = InaccessibleWorkspaceInformationBarUtil.createDialog(view.getSite().getShell(), repositories.toArray());
                        dialog.setBlockOnOpen(true);
                        dialog.open();
                        Object[] result = dialog.getResult();
                        if (result != null && result.length > 0) {
                            Object[] objectArray = result;
                            int n = result.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object obj = objectArray[n2];
                                ITeamRepository repo = (ITeamRepository)obj;
                                this.repoLogin(context, repo);
                                ++n2;
                            }
                        }
                    }
                }
            }

            private void repoLogin(UIContext context, final ITeamRepository repo) {
                RepositoryUtils.loggedInDo(context, repo, new Runnable(){

                    @Override
                    public void run() {
                        TeamPlatform.getTeamRepositoryService().addTeamRepository(repo);
                    }
                });
            }
        };
        String message = Messages.InaccessibleWorkspaceInformationBarUtil_0;
        view.setInformationMessage(NLS.bind((String)message, (Object)LOGIN_ACTION, (Object)CHANGE_TARGET_ACTION), 1, listener);
    }

    private static Collection<IWorkspaceSyncContext> getInaccessibleWorkspaces() {
        IWorkspaceSyncContext[] componentSyncContexts = FileSystemResourcesPlugin.getComponentSyncModel().getWorkspaceSyncContexts();
        ArrayList<IWorkspaceSyncContext> workspaces = new ArrayList<IWorkspaceSyncContext>();
        IWorkspaceSyncContext[] iWorkspaceSyncContextArray = componentSyncContexts;
        int n = componentSyncContexts.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkspaceSyncContext syncContext = iWorkspaceSyncContextArray[n2];
            ITeamRepository repo = null;
            try {
                repo = syncContext.getRemoteIncomingConnectionDescriptor().getTeamRepository();
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
            if (repo != null && !repo.loggedIn() && !InaccessibleWorkspaceInformationBarUtil.isRepositoryKnown(repo)) {
                workspaces.add(syncContext);
            }
            if (!syncContext.getRemoteOutgoingConnectionDescriptor().equals((Object)syncContext.getRemoteIncomingConnectionDescriptor())) {
                repo = null;
                try {
                    repo = syncContext.getRemoteOutgoingConnectionDescriptor().getTeamRepository();
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
                if (repo != null && !repo.loggedIn() && !InaccessibleWorkspaceInformationBarUtil.isRepositoryKnown(repo)) {
                    workspaces.add(syncContext);
                }
            }
            ++n2;
        }
        return workspaces;
    }

    private static boolean isRepositoryKnown(ITeamRepository repo) {
        ITeamRepository[] repositories;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository other = iTeamRepositoryArray[n2];
            if (repo.equals(other)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static SelectionDialog createDialog(Shell shell, Object input) {
        LabelProvider labelProvider = new LabelProvider(){
            private Image repositoryImage = ImagePool.LOGGEDIN_REPOSITORY.createImage();

            public Image getImage(Object element) {
                return this.repositoryImage;
            }

            public String getText(Object element) {
                ITeamRepository repo = (ITeamRepository)element;
                return RepositoryUtils.getLabel(repo);
            }

            public void dispose() {
                this.repositoryImage.dispose();
                super.dispose();
            }
        };
        ListSelectionDialog dialog = new ListSelectionDialog(shell, input, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)labelProvider, Messages.InaccessibleWorkspaceInformationBarUtil_1){

            public void create() {
                super.create();
                final CheckboxTableViewer viewer = this.getViewer();
                final Button okButton = this.getOkButton();
                viewer.addCheckStateListener(new ICheckStateListener(){

                    public void checkStateChanged(CheckStateChangedEvent event) {
                        okButton.setEnabled(viewer.getCheckedElements().length > 0);
                    }
                });
                SelectionAdapter listener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        okButton.setEnabled(viewer.getCheckedElements().length > 0);
                    }
                };
                this.getButton(18).addSelectionListener((SelectionListener)listener);
                this.getButton(19).addSelectionListener((SelectionListener)listener);
            }
        };
        return dialog;
    }
}

