/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.filesystem.client.internal.utils.ConnectionFacade;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;

public class FlowDecoratorUtil {
    private static String FLOW_DECORATOR_LOCAL = " <-> ";
    private static String FLOW_DECORATOR_LOCAL_INCOMING = " <- ";
    private static String FLOW_DECORATOR_LOCAL_OUTGOING = " -> ";
    private static String FLOW_DECORATOR_DISTRIBUTED = " <~> ";
    private static String FLOW_DECORATOR_DISTRIBUTED_INCOMING = " <~ ";
    private static String FLOW_DECORATOR_DISTRIBUTED_OUTGOING = " ~> ";
    private static String FLOW_DECORATOR_ALL = " <=> ";
    private static String FLOW_DECORATOR_ALL_INCOMING = " <= ";
    private static String FLOW_DECORATOR_ALL_OUTGOING = " => ";

    public static String[] getFlowDecorator(FlowDecoratorInfo info) {
        if (info.useTextArrows || !info.customMarkup) {
            if (info.distributedIncomingFlow && info.distributedOutgoingFlow) {
                return new String[]{FLOW_DECORATOR_DISTRIBUTED, FLOW_DECORATOR_DISTRIBUTED_INCOMING, FLOW_DECORATOR_DISTRIBUTED_OUTGOING};
            }
            if (info.allFlowTargets) {
                return new String[]{FLOW_DECORATOR_ALL, FLOW_DECORATOR_ALL_INCOMING, FLOW_DECORATOR_ALL_OUTGOING};
            }
            String[] decorators = new String[]{FLOW_DECORATOR_LOCAL, FLOW_DECORATOR_LOCAL_INCOMING, FLOW_DECORATOR_LOCAL_OUTGOING};
            if (info.distributedIncomingFlow) {
                decorators[1] = FLOW_DECORATOR_DISTRIBUTED_INCOMING;
            }
            if (info.distributedOutgoingFlow) {
                decorators[2] = FLOW_DECORATOR_DISTRIBUTED_OUTGOING;
            }
            return decorators;
        }
        String markup1 = CustomTreeViewer.markupIconOutgoingChange(true);
        String markup2 = CustomTreeViewer.markupIconIncomingChange(true);
        if (!info.hasOutgoingChanges) {
            markup1 = CustomTreeViewer.markupIconOutgoingChangeNone(true);
        }
        if (!info.hasIncomingChanges) {
            markup2 = CustomTreeViewer.markupIconIncomingChangeNone(true);
        }
        if (info.disabledFlow) {
            markup1 = CustomTreeViewer.markupIconOutgoingChangeDisabled(true);
            markup2 = CustomTreeViewer.markupIconIncomingChangeDisabled(true);
        }
        return new String[]{" " + markup1 + markup2 + " ", " " + markup2 + " ", " " + markup1 + " "};
    }

    public static FlowDecoratorInfo getFlowDecoratorInfo(IComponentSyncContext context, boolean useTextArrows, boolean customMarkup) {
        FlowDecoratorInfo result = new FlowDecoratorInfo();
        result.useTextArrows = useTextArrows;
        result.customMarkup = customMarkup;
        result.allFlowTargets = false;
        ComponentSyncInfo info = context.getComponentSyncInfo();
        ConnectionFacade remoteIncoming = info.getRemoteIncoming();
        ConnectionFacade remoteOutgoing = info.getRemoteOutgoing();
        IWorkspaceSyncContext workspaceContext = context.getWorkspaceSyncContext();
        ITeamRepository teamRepository = null;
        try {
            teamRepository = remoteIncoming.getTeamRepository();
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        if (teamRepository != null && teamRepository != workspaceContext.getLocal().teamRepository()) {
            result.distributedIncomingFlow = true;
        }
        boolean isIncomingTargetOnline = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)teamRepository);
        teamRepository = null;
        try {
            teamRepository = remoteOutgoing.getTeamRepository();
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        if (teamRepository != null && teamRepository != workspaceContext.getLocal().teamRepository()) {
            result.distributedOutgoingFlow = true;
        }
        boolean isOutgoingTargetOnline = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)teamRepository);
        if (!isIncomingTargetOnline && !isOutgoingTargetOnline) {
            result.disabledFlow = true;
        }
        result.hasOutgoingChanges = FlowDecoratorUtil.hasOutgoing(context);
        result.hasIncomingChanges = FlowDecoratorUtil.hasIncoming(context);
        return result;
    }

    public static boolean isDistributed(IWorkspaceSyncContext context) {
        return FlowDecoratorUtil.isIncomingDistributed(context) || FlowDecoratorUtil.isOutgoingDistributed(context);
    }

    public static boolean isIncomingDistributed(IWorkspaceSyncContext context) {
        return !context.getRemoteIncomingConnectionDescriptor().sameRepository(context.getLocal());
    }

    public static boolean isOutgoingDistributed(IWorkspaceSyncContext context) {
        return !context.getRemoteOutgoingConnectionDescriptor().sameRepository(context.getLocal());
    }

    public static FlowDecoratorInfo getFlowDecoratorInfo(IWorkspaceSyncContext context, boolean useTextArrows, boolean customMarkup) {
        FlowDecoratorInfo result = new FlowDecoratorInfo();
        result.useTextArrows = useTextArrows;
        result.customMarkup = customMarkup;
        result.allFlowTargets = FileSystemResourcesPlugin.getDefault().getPluginPreferences().getBoolean("show_all_flow_targets");
        result.distributedIncomingFlow = FlowDecoratorUtil.isIncomingDistributed(context);
        result.distributedOutgoingFlow = FlowDecoratorUtil.isOutgoingDistributed(context);
        boolean isSourceOnline = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)context.getLocal().teamRepository());
        boolean isIncomingTargetOnline = false;
        try {
            isIncomingTargetOnline = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)context.getRemoteIncomingConnectionDescriptor().getTeamRepository());
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        boolean isOutgoingTargetOnline = false;
        try {
            isOutgoingTargetOnline = RepositoryUtils.isRepositoryLoggedIn((ITeamRepository)context.getRemoteOutgoingConnectionDescriptor().getTeamRepository());
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        result.disabledFlow = !isSourceOnline || !isIncomingTargetOnline && !isOutgoingTargetOnline;
        result.hasOutgoingChanges = FlowDecoratorUtil.hasOutgoing(context);
        result.hasIncomingChanges = FlowDecoratorUtil.hasIncoming(context);
        return result;
    }

    public static boolean hasIncoming(IWorkspaceSyncContext context) {
        IComponentSyncContext[] iComponentSyncContextArray = context.getComponentSyncContexts();
        int n = iComponentSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext csc = iComponentSyncContextArray[n2];
            if (FlowDecoratorUtil.hasIncoming(csc)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasOutgoing(IWorkspaceSyncContext context) {
        IComponentSyncContext[] iComponentSyncContextArray = context.getComponentSyncContexts();
        int n = iComponentSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext csc = iComponentSyncContextArray[n2];
            if (FlowDecoratorUtil.hasOutgoing(csc)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasIncoming(IComponentSyncContext context) {
        if (context.isOfType(64) || context.isOfType(128)) {
            return true;
        }
        return context.getIncomingActivitySource().size() > 0 || ComponentSyncUtil.isReplaceIncoming((IComponentSyncContext)context);
    }

    public static boolean hasOutgoing(IComponentSyncContext context) {
        if (context.isOfType(16) || context.isOfType(32)) {
            return true;
        }
        return context.getOutgoingActivitySource().size() > 0 || ComponentSyncUtil.isReplaceOutgoing((IComponentSyncContext)context);
    }

    public static class FlowDecoratorInfo {
        boolean useTextArrows;
        boolean hasOutgoingChanges;
        boolean hasIncomingChanges;
        boolean disabledFlow;
        boolean distributedIncomingFlow;
        boolean distributedOutgoingFlow;
        boolean allFlowTargets;
        boolean customMarkup;
    }
}

