/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.views;

import com.ibm.team.internal.filesystem.ui.ImagePool;
import java.util.BitSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class DecorationImageDescriptor
extends CompositeImageDescriptor {
    public static final int ACTIVE = 2;
    public static final int CLOSED = 3;
    public static final int UNRESOLVED = 4;
    public static final int INCOMING = 5;
    public static final int OUTGOING = 6;
    public static final int ADDED = 7;
    public static final int DELETED = 8;
    public static final int TEAM_CONFLICT = 9;
    public static final int TEAM_CONFLICT_SMALL = 10;
    public static final int UNRESOLVED_SMALL = 11;
    public static final int INCOMING_SMALL = 12;
    public static final int OUTGOING_SMALL = 13;
    public static final int INOUT_SMALL = 14;
    public static final int PENDING_LOCAL = 15;
    public static final int CHANGE_DEFECT = 16;
    public static final int CHANGE_DEFECTS = 17;
    public static final int PRESENCE_OFFLINE = 18;
    public static final int LOCKED_BY_OTHER = 19;
    public static final int LOCKED_BY_ME = 20;
    public static final int VIEW_PENDING_LOCAL = 21;
    public static final int VIEW_INCOMING = 22;
    public static final int VIEW_CONFLICTS = 23;
    public static final int DISABLED = 24;
    public static final int HAS_CORRESPONDING_ACTIVITY = 25;
    public static final int CHANGE_SET_HAS_PORTS = 26;
    public static final int COMPONENT_HAS_PORTS = 27;
    public static final int IS_A_PORT = 28;
    public static final int OUTGOING_PORT_TARGET = 29;
    public static final int HAS_GAP = 30;
    public static final int COMPONENT_INCOMING_ADDED = 31;
    public static final int COMPONENT_INCOMING_DELETED = 32;
    public static final int COMPONENT_OUTGOING_ADDED = 33;
    public static final int COMPONENT_OUTGOING_DELETED = 34;
    public static final int CYCLE_DETECTED = 35;
    public static final int SUSPENDED = 36;
    public static final int DEFAULT_WIDTH = 16;
    public static final int EXTRA_NODE_WIDTH = 9;
    public static final int STYLE_WIDE = 2;
    public static final int STYLE_NODE = 2;
    public static final int STYLE_VIEW = 4;
    private ImageDescriptor fBaseImage;
    private int fImageHash;
    private BitSet fFlags;
    private Point fSize;
    private int extraWidth = 0;
    private int style;

    public DecorationImageDescriptor(ImageDescriptor baseImage, int flag, int style) {
        this(baseImage, DecorationImageDescriptor.convert(flag), style);
    }

    public DecorationImageDescriptor(ImageDescriptor baseImage, BitSet flags, int style) {
        Assert.isNotNull((Object)baseImage);
        this.style = style;
        if ((style & 2) != 0) {
            this.extraWidth = 9;
        }
        if ((style & 4) != 0) {
            BitSet styleSet = new BitSet();
            styleSet.set(23);
            styleSet.set(22);
            styleSet.set(21);
            flags.and(styleSet);
        }
        this.fBaseImage = baseImage;
        this.fImageHash = baseImage.hashCode();
        this.fFlags = flags;
        this.fSize = new Point(16 + this.extraWidth, 16);
    }

    public void addAdornment(int adornment) {
        this.fFlags.set(adornment);
    }

    public BitSet getAdronments() {
        return this.fFlags;
    }

    private static BitSet convert(int flag) {
        BitSet bitFlag = new BitSet();
        if (flag != 0) {
            bitFlag.set(flag);
        }
        return bitFlag;
    }

    public void setImageSize(Point size) {
        Assert.isNotNull((Object)size);
        Assert.isTrue((size.x >= 0 && size.y >= 0 ? 1 : 0) != 0);
        this.fSize = size;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DecorationImageDescriptor)) {
            return false;
        }
        DecorationImageDescriptor other = (DecorationImageDescriptor)((Object)object);
        return this.fBaseImage.equals(other.fBaseImage) && this.fFlags.equals(other.fFlags) && this.style == other.style && this.fSize.equals((Object)other.fSize);
    }

    public int hashCode() {
        int hash = this.fImageHash;
        hash = hash * 17 + this.fFlags.hashCode();
        hash = hash * 17 + this.style;
        hash = hash * 17 + this.fSize.hashCode();
        return hash;
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawUnder();
        this.drawImage(this.getImageData(this.fBaseImage), 0, 0);
        this.drawBottomLeft();
        this.drawTopRight();
        this.drawBottomRight();
        this.drawTopLeft();
        this.draw9Right();
    }

    private void drawUnder() {
        ImageData data;
        int x = this.getSize().x;
        if (this.fFlags.get(15)) {
            data = this.getImageData(ImagePool.PENDING_LOCAL_OVRL);
            this.drawImage(data, (x -= data.width) - this.extraWidth, 0);
        }
        if (this.fFlags.get(21)) {
            data = this.getImageData(ImagePool.PENDING_LOCAL_OVRL);
            this.drawImage(data, (x -= data.width) - this.extraWidth, 0);
        }
    }

    private void drawTopRight() {
        Point size = this.getSize();
        int x = size.x;
        if (this.fFlags.get(28)) {
            ImageData data = this.getImageData(ImagePool.IS_A_PORT_OVERLAY);
            this.drawImage(data, (x -= data.width) - this.extraWidth, 0);
            return;
        }
        if (this.fFlags.get(29)) {
            ImageData data = this.getImageData(ImagePool.PORT_TARGET_OVERLAY);
            this.drawImage(data, (x -= data.width) - this.extraWidth, 0);
            return;
        }
        if (this.fFlags.get(27)) {
            ImageData data = this.getImageData(ImagePool.IS_A_PORT_OVERLAY);
            this.drawImage(data, (x -= data.width) - this.extraWidth, 0);
            return;
        }
    }

    private void drawTopLeft() {
        if (this.fFlags.get(35)) {
            ImageData data = this.getImageData(ImagePool.COMPONENT_HIERARCHY_CYCLE_OVRL);
            this.drawImage(data, 0, 0);
            return;
        }
        if (this.fFlags.get(19)) {
            ImageData data = this.getImageData(ImagePool.LOCKED_BY_OTHER_OVRL);
            this.drawImage(data, 0, 0);
        } else if (this.fFlags.get(20)) {
            ImageData data = this.getImageData(ImagePool.LOCKED_BY_ME_OVRL);
            this.drawImage(data, 0, 0);
        }
    }

    private void drawBottomLeft() {
        Point size = this.getSize();
        if (this.fFlags.get(11)) {
            ImageData data = this.getImageData(ImagePool.UNRESOLVED_SMALL_OVRL);
            this.drawImage(data, 0, size.y - data.height);
            return;
        }
        if (this.fFlags.get(2)) {
            ImageData data = this.getImageData(ImagePool.ACTIVE_OVRL);
            this.drawImage(data, 0, size.y - data.height);
            return;
        }
        if (this.fFlags.get(3)) {
            ImageData data = this.getImageData(ImagePool.CLOSED_OVRL);
            this.drawImage(data, 0, size.y - data.height);
            return;
        }
        if (this.fFlags.get(36)) {
            ImageData data = this.getImageData(ImagePool.SUSPENDED_OVRL);
            this.drawImage(data, 0, size.y - data.height);
            return;
        }
        if (this.fFlags.get(31) && this.fFlags.get(34)) {
            ImageData data = this.getImageData(ImagePool.INCOMING_ADD_OVRL);
            this.drawImage(data, -1, size.y - data.height);
            return;
        }
        if (this.fFlags.get(32) && this.fFlags.get(33)) {
            ImageData data = this.getImageData(ImagePool.INCOMING_DEL_OVRL);
            this.drawImage(data, -1, size.y - data.height);
            return;
        }
    }

    private void drawBottomRight() {
        Point size = this.getSize();
        int x = size.x;
        if (this.fFlags.get(25)) {
            ImageData data = this.getImageData(ImagePool.INOUT_SMALL_OVRL);
            this.drawImage(data, (x -= data.width) - this.extraWidth, size.y - data.height);
            return;
        }
        if (this.fFlags.get(10)) {
            ImageData data = this.getImageData(ImagePool.TEAM_CONFLICT_SMALL_OVRL);
            this.drawImage(data, (x -= data.width) - this.extraWidth, size.y - data.height);
            return;
        }
        if (this.fFlags.get(14) || this.fFlags.get(12) && this.fFlags.get(13)) {
            ImageData data = this.fFlags.get(24) ? this.getImageData(ImagePool.INOUT_SMALL_DIS_OVRL) : this.getImageData(ImagePool.INOUT_SMALL_OVRL);
            this.drawImage(data, (x -= data.width) - this.extraWidth, size.y - data.height);
            return;
        }
        if (this.fFlags.get(12)) {
            ImageData data = this.getImageData(ImagePool.INCOMING_SMALL_OVRL);
            this.drawImage(data, (x -= data.width) - this.extraWidth, size.y - data.height);
            return;
        }
        if (this.fFlags.get(13)) {
            ImageData data = this.fFlags.get(24) ? this.getImageData(ImagePool.OUTGOING_SMALL_DIS_OVRL) : this.getImageData(ImagePool.OUTGOING_SMALL_OVRL);
            this.drawImage(data, (x -= data.width) - this.extraWidth, size.y - data.height);
            return;
        }
        if (this.fFlags.get(26) && (this.fFlags.get(16) || this.fFlags.get(17))) {
            ImageData data = this.getImageData(ImagePool.HAS_PORTS_AND_WORK_ITEMS_OVERLAY);
            this.drawImage(data, (x -= data.width) - this.extraWidth, size.y - data.height);
            return;
        }
        if (this.fFlags.get(26)) {
            ImageData data = this.getImageData(ImagePool.HAS_PORTS_OVERLAY);
            this.drawImage(data, (x -= data.width) - this.extraWidth, size.y - data.height);
            return;
        }
        if (this.fFlags.get(16)) {
            ImageData data = this.getImageData(ImagePool.CHANGE_DEFECT_OVRL);
            this.drawImage(data, (x -= data.width) - this.extraWidth, size.y - data.height);
            return;
        }
        if (this.fFlags.get(17)) {
            ImageData data = this.getImageData(ImagePool.CHANGE_DEFECTS_OVRL);
            this.drawImage(data, (x -= data.width) - this.extraWidth, size.y - data.height);
            return;
        }
        if (this.fFlags.get(18)) {
            ImageData data = this.getImageData(ImagePool.PRESENCE_OFFLINE_OVRL);
            this.drawImage(data, (x -= data.width) - this.extraWidth, size.y - data.height);
            return;
        }
        if (this.fFlags.get(23)) {
            ImageData data = this.getImageData(ImagePool.TEAM_CONFLICT_SMALL_OVRL);
            this.drawImage(data, (x -= data.width) - this.extraWidth, size.y - data.height);
            return;
        }
        if (this.fFlags.get(22)) {
            ImageData data = this.getImageData(ImagePool.INCOMING_SMALL_OVRL);
            this.drawImage(data, (x -= data.width) - this.extraWidth, size.y - data.height);
            return;
        }
    }

    private void draw9Right() {
        int x = 9;
        if (this.fFlags.get(30)) {
            ImageData data = this.getImageData(ImagePool.AGGREGATE_CHANGE_DISJOINT_OVR);
            this.drawImage(data, x, 0);
            return;
        }
        if (this.fFlags.get(9)) {
            ImageData data = null;
            data = this.fFlags.get(7) ? this.getImageData(ImagePool.TEAM_CONFLICT_ADD_OVRL) : (this.fFlags.get(8) ? this.getImageData(ImagePool.TEAM_CONFLICT_DEL_OVRL) : this.getImageData(ImagePool.TEAM_CONFLICT_OVRL));
            this.drawImage(data, x, 0);
            return;
        }
        if (this.fFlags.get(31) && !this.fFlags.get(34)) {
            ImageData data = this.getImageData(ImagePool.INCOMING_ADD_OVRL);
            this.drawImage(data, x, 0);
            return;
        }
        if (this.fFlags.get(32) && !this.fFlags.get(33)) {
            ImageData data = this.getImageData(ImagePool.INCOMING_DEL_OVRL);
            this.drawImage(data, x, 0);
            return;
        }
        if (this.fFlags.get(5)) {
            ImageData data = null;
            data = this.fFlags.get(7) ? this.getImageData(ImagePool.INCOMING_ADD_OVRL) : (this.fFlags.get(8) ? this.getImageData(ImagePool.INCOMING_DEL_OVRL) : this.getImageData(ImagePool.INCOMING_OVRL));
            this.drawImage(data, x, 0);
            return;
        }
        if (this.fFlags.get(33)) {
            ImageData data = this.fFlags.get(24) ? this.getImageData(ImagePool.OUTGOING_ADD_DISABLED_OVRL) : this.getImageData(ImagePool.OUTGOING_ADD_OVRL);
            this.drawImage(data, x, 0);
            return;
        }
        if (this.fFlags.get(34)) {
            ImageData data = this.fFlags.get(24) ? this.getImageData(ImagePool.OUTGOING_DEL_DISABLED_OVRL) : this.getImageData(ImagePool.OUTGOING_DEL_OVRL);
            this.drawImage(data, x, 0);
            return;
        }
        if (this.fFlags.get(6)) {
            ImageData data = null;
            data = this.fFlags.get(7) ? (this.fFlags.get(24) ? this.getImageData(ImagePool.OUTGOING_ADD_DISABLED_OVRL) : this.getImageData(ImagePool.OUTGOING_ADD_OVRL)) : (this.fFlags.get(8) ? (this.fFlags.get(24) ? this.getImageData(ImagePool.OUTGOING_DEL_DISABLED_OVRL) : this.getImageData(ImagePool.OUTGOING_DEL_OVRL)) : (this.fFlags.get(24) ? this.getImageData(ImagePool.OUTGOING_DISABLED_OVRL) : this.getImageData(ImagePool.OUTGOING_OVRL)));
            this.drawImage(data, x, 0);
            return;
        }
    }

    private ImageData getImageData(ImageDescriptor imageDescriptor) {
        ImageData data = imageDescriptor.getImageData();
        return data == null ? DEFAULT_IMAGE_DATA : data;
    }
}

